use crate::ArrayMthd;
use crate::Mthd;

// parsed class NVA040

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;

        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.type_ as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerWfi {
    pub v: u32,
}

impl Mthd for PmTriggerWfi {
    const ADDR: u16 = 0x0144;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x0180;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0184;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.value < (1 << 8));
        val |= self.value << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x018c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0190;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0194;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0198;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x019c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x01a0;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x01a4;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 20));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
    pub reduction_enable: bool,
    pub reduction_op: LaunchDmaReductionOp,
    pub reduction_format: LaunchDmaReductionFormat,
    pub sysmembar_disable: bool,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x01b0;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 0;

        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 4;

        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 8;

        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 12;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 1;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 13;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 2;

        assert!((self.sysmembar_disable as u32) < (1 << 1));
        val |= (self.sysmembar_disable as u32) << 6;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x01b4;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetI2MSemaphoreA {
    const ADDR: u16 = 0x01dc;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetI2MSemaphoreB {
    const ADDR: u16 = 0x01e0;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetI2MSemaphoreC {
    const ADDR: u16 = 0x01e4;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop00 {
    const ADDR: u16 = 0x01f0;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop01 {
    const ADDR: u16 = 0x01f4;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop02 {
    const ADDR: u16 = 0x01f8;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop03 {
    const ADDR: u16 = 0x01fc;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0240;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0278;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0xa040;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0xa040;

    fn addr(i: usize) -> u16 {
        (0x3400 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}
