use crate::ArrayMthd;
use crate::Mthd;

// parsed class NV90C0

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;

        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.type_ as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryLowSize {
    pub v: u32,
}

impl Mthd for SetShaderLocalMemoryLowSize {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 24));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryHighSize {
    pub v: u32,
}

impl Mthd for SetShaderLocalMemoryHighSize {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 24));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryCrsSize {
    pub v: u32,
}

impl Mthd for SetShaderLocalMemoryCrsSize {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 21));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBindingControlTextureMaxActiveSamplers {
    _1 = 0x00000000,
    _2 = 0x00000001,
    _4 = 0x00000002,
    _8 = 0x00000003,
    _16 = 0x00000004,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBindingControlTextureMaxActiveHeaders {
    _1 = 0x00000000,
    _2 = 0x00000001,
    _4 = 0x00000002,
    _8 = 0x00000003,
    _16 = 0x00000004,
    _32 = 0x00000005,
    _64 = 0x00000006,
    _128 = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindingControlTexture {
    pub max_active_samplers: SetBindingControlTextureMaxActiveSamplers,
    pub max_active_headers: SetBindingControlTextureMaxActiveHeaders,
}

impl Mthd for SetBindingControlTexture {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.max_active_samplers as u32) < (1 << 4));
        val |= (self.max_active_samplers as u32) << 0;

        assert!((self.max_active_headers as u32) < (1 << 4));
        val |= (self.max_active_headers as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemoryWindow {
    pub base_address: u32,
}

impl Mthd for SetShaderSharedMemoryWindow {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.base_address;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub uniform: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;

        assert!((self.uniform as u32) < (1 << 1));
        val |= (self.uniform as u32) << 8;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;

        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindTextureSampler {
    pub valid: bool,
    pub sampler_slot: u32,
    pub index: u32,
}

impl Mthd for BindTextureSampler {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.sampler_slot < (1 << 8));
        val |= self.sampler_slot << 4;

        assert!(self.index < (1 << 13));
        val |= self.index << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindTextureHeader {
    pub valid: bool,
    pub texture_slot: u32,
    pub index: u32,
}

impl Mthd for BindTextureHeader {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.texture_slot < (1 << 8));
        val |= self.texture_slot << 1;

        assert!(self.index < (1 << 22));
        val |= self.index << 9;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindExtraTextureSampler {
    pub valid: bool,
    pub sampler_slot: u32,
    pub index: u32,
}

impl Mthd for BindExtraTextureSampler {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.sampler_slot < (1 << 8));
        val |= self.sampler_slot << 4;

        assert!(self.index < (1 << 13));
        val |= self.index << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindExtraTextureHeader {
    pub valid: bool,
    pub texture_slot: u32,
    pub index: u32,
}

impl Mthd for BindExtraTextureHeader {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.texture_slot < (1 << 8));
        val |= self.texture_slot << 1;

        assert!(self.index < (1 << 22));
        val |= self.index << 9;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaRasterSizeA {
    pub width: u32,
    pub height: u32,
}

impl Mthd for SetCtaRasterSizeA {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.width < (1 << 16));
        val |= self.width << 0;

        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaRasterSizeB {
    pub depth: u32,
}

impl Mthd for SetCtaRasterSizeB {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.depth < (1 << 16));
        val |= self.depth << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheNoWfi {
    pub lines: InvalidateTextureHeaderCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCacheNoWfi {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemorySize {
    pub v: u32,
}

impl Mthd for SetShaderSharedMemorySize {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 18));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaThreadCount {
    pub v: u32,
}

impl Mthd for SetCtaThreadCount {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaBarrierCount {
    pub v: u32,
}

impl Mthd for SetCtaBarrierCount {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct TestForCompute {
    pub v: u32,
}

impl Mthd for TestForCompute {
    const ADDR: u16 = 0x028c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BeginGrid {
    pub v: u32,
}

impl Mthd for BeginGrid {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWorkDistribution {
    pub max_batch_size: u32,
    pub fixed_mode: bool,
    pub max_standby_ctas: u32,
}

impl Mthd for SetWorkDistribution {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.max_batch_size < (1 << 4));
        val |= self.max_batch_size << 13;

        assert!((self.fixed_mode as u32) < (1 << 1));
        val |= (self.fixed_mode as u32) << 4;

        assert!(self.max_standby_ctas < (1 << 8));
        val |= self.max_standby_ctas << 5;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaRegisterCount {
    pub v: u32,
}

impl Mthd for SetCtaRegisterCount {
    const ADDR: u16 = 0x02c0;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGaToVaMappingModeV {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGaToVaMappingMode {
    pub v: SetGaToVaMappingModeV,
}

impl Mthd for SetGaToVaMappingMode {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadGaToVaMappingEntry {
    pub virtual_address_upper: u32,
    pub generic_address_upper: u32,
    pub read_enable: bool,
    pub write_enable: bool,
}

impl Mthd for LoadGaToVaMappingEntry {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.virtual_address_upper < (1 << 8));
        val |= self.virtual_address_upper << 0;

        assert!(self.generic_address_upper < (1 << 8));
        val |= self.generic_address_upper << 16;

        assert!((self.read_enable as u32) < (1 << 1));
        val |= (self.read_enable as u32) << 30;

        assert!((self.write_enable as u32) < (1 << 1));
        val |= (self.write_enable as u32) << 31;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL1ConfigurationDirectlyAddressableMemory {
    Size16Kb = 0x00000001,
    Size48Kb = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL1Configuration {
    pub directly_addressable_memory: SetL1ConfigurationDirectlyAddressableMemory,
}

impl Mthd for SetL1Configuration {
    const ADDR: u16 = 0x0308;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.directly_addressable_memory as u32) < (1 << 3));
        val |= (self.directly_addressable_memory as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableControl {
    pub conditional_load_constant_buffer: bool,
}

impl Mthd for SetRenderEnableControl {
    const ADDR: u16 = 0x030c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.conditional_load_constant_buffer as u32) < (1 << 1));
        val |= (self.conditional_load_constant_buffer as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitRefCount {
    pub ref_cnt: u32,
    pub flush_sys_mem: bool,
}

impl Mthd for WaitRefCount {
    const ADDR: u16 = 0x0360;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ref_cnt < (1 << 2));
        val |= self.ref_cnt << 8;

        assert!((self.flush_sys_mem as u32) < (1 << 1));
        val |= (self.flush_sys_mem as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLaunchId {
    pub ref_cnt: u32,
}

impl Mthd for SetLaunchId {
    const ADDR: u16 = 0x036c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ref_cnt < (1 << 2));
        val |= self.ref_cnt << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaThreadDimensionA {
    pub d0: u32,
    pub d1: u32,
}

impl Mthd for SetCtaThreadDimensionA {
    const ADDR: u16 = 0x03ac;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.d0 < (1 << 16));
        val |= self.d0 << 0;

        assert!(self.d1 < (1 << 16));
        val |= self.d1 << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaThreadDimensionB {
    pub d2: u32,
}

impl Mthd for SetCtaThreadDimensionB {
    const ADDR: u16 = 0x03b0;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.d2 < (1 << 16));
        val |= self.d2 << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaProgramStart {
    pub offset: u32,
}

impl Mthd for SetCtaProgramStart {
    const ADDR: u16 = 0x03b4;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x0500;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x0504;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x0508;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x050c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x0510;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x0514;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x0518;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x051c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0520;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0524;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0528;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x052c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0530;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0534;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0538;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x053c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0540;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0544;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0548;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x054c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0578;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x057c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxSmCount {
    pub v: u32,
}

impl Mthd for SetMaxSmCount {
    const ADDR: u16 = 0x0758;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 9));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindow {
    pub base_address: u32,
}

impl Mthd for SetShaderLocalMemoryWindow {
    const ADDR: u16 = 0x077c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.base_address;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGridParam {
    pub v: u32,
}

impl Mthd for SetGridParam {
    const ADDR: u16 = 0x0780;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryA {
    pub address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryA {
    const ADDR: u16 = 0x0790;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryB {
    pub address_lower: u32,
}

impl Mthd for SetShaderLocalMemoryB {
    const ADDR: u16 = 0x0794;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryC {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryC {
    const ADDR: u16 = 0x0798;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size_upper < (1 << 6));
        val |= self.size_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryD {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryD {
    const ADDR: u16 = 0x079c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.size_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryE {
    pub default_size_per_warp: u32,
}

impl Mthd for SetShaderLocalMemoryE {
    const ADDR: u16 = 0x07a0;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.default_size_per_warp < (1 << 26));
        val |= self.default_size_per_warp << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct EndGrid {
    pub v: u32,
}

impl Mthd for EndGrid {
    const ADDR: u16 = 0x0a04;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLaunchSize {
    pub v: u32,
}

impl Mthd for SetLaunchSize {
    const ADDR: u16 = 0x0a08;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetApiVisibleCallLimitCta {
    _0 = 0x00000000,
    _1 = 0x00000001,
    _2 = 0x00000002,
    _4 = 0x00000003,
    _8 = 0x00000004,
    _16 = 0x00000005,
    _32 = 0x00000006,
    _64 = 0x00000007,
    _128 = 0x00000008,
    NoCheck = 0x0000000f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetApiVisibleCallLimit {
    pub cta: SetApiVisibleCallLimitCta,
}

impl Mthd for SetApiVisibleCallLimit {
    const ADDR: u16 = 0x0d64;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.cta as u32) < (1 << 4));
        val |= (self.cta as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderCacheControl {
    pub icache_prefetch_enable: bool,
}

impl Mthd for SetShaderCacheControl {
    const ADDR: u16 = 0x0d94;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.icache_prefetch_enable as u32) < (1 << 1));
        val |= (self.icache_prefetch_enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmTimeoutInterval {
    pub counter_bit: u32,
}

impl Mthd for SetSmTimeoutInterval {
    const ADDR: u16 = 0x0de4;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_bit < (1 << 6));
        val |= self.counter_bit << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x0f44;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x0f48;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x0f4c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x0f50;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetForceOneTextureUnit {
    pub enable: bool,
}

impl Mthd for SetForceOneTextureUnit {
    const ADDR: u16 = 0x1004;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetSpareNoop00 {
    const ADDR: u16 = 0x1040;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x1044;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x1048;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x104c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x1050;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop05 {
    pub v: u32,
}

impl Mthd for SetSpareNoop05 {
    const ADDR: u16 = 0x1054;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x1058;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x105c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x1060;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x1064;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x1068;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x106c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct UnbindAll {
    pub texture_headers: bool,
    pub texture_samplers: bool,
    pub constant_buffers: bool,
}

impl Mthd for UnbindAll {
    const ADDR: u16 = 0x10f4;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.texture_headers as u32) < (1 << 1));
        val |= (self.texture_headers as u32) << 0;

        assert!((self.texture_samplers as u32) < (1 << 1));
        val |= (self.texture_samplers as u32) << 4;

        assert!((self.constant_buffers as u32) < (1 << 1));
        val |= (self.constant_buffers as u32) << 8;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSamplerBindingV {
    Independently = 0x00000000,
    ViaHeaderBinding = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSamplerBinding {
    pub v: SetSamplerBindingV,
}

impl Mthd for SetSamplerBinding {
    const ADDR: u16 = 0x1234;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCacheNoWfi {
    pub lines: InvalidateTextureDataCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCacheNoWfi {
    const ADDR: u16 = 0x1288;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderSchedulingMode {
    OldestThreadFirst = 0x00000000,
    RoundRobin = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderScheduling {
    pub mode: SetShaderSchedulingMode,
}

impl Mthd for SetShaderScheduling {
    const ADDR: u16 = 0x12ac;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCache {
    pub lines: InvalidateSamplerCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCache {
    const ADDR: u16 = 0x1330;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCache {
    pub lines: InvalidateTextureHeaderCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCache {
    const ADDR: u16 = 0x1334;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLevels {
    L1Only = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
    pub levels: InvalidateTextureDataCacheLevels,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        assert!((self.levels as u32) < (1 << 2));
        val |= (self.levels as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalColorKey {
    pub enable: bool,
}

impl Mthd for SetGlobalColorKey {
    const ADDR: u16 = 0x1354;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheNoWfi {
    pub lines: InvalidateSamplerCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCacheNoWfi {
    const ADDR: u16 = 0x1424;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PerfmonTransfer {
    pub v: u32,
}

impl Mthd for PerfmonTransfer {
    const ADDR: u16 = 0x1524;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderExceptions {
    pub enable: bool,
}

impl Mthd for SetShaderExceptions {
    const ADDR: u16 = 0x1528;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexSamplerPoolA {
    const ADDR: u16 = 0x155c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexSamplerPoolB {
    const ADDR: u16 = 0x1560;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexSamplerPoolC {
    const ADDR: u16 = 0x1564;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.maximum_index < (1 << 20));
        val |= self.maximum_index << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexHeaderPoolA {
    const ADDR: u16 = 0x1574;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexHeaderPoolB {
    const ADDR: u16 = 0x1578;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexHeaderPoolC {
    const ADDR: u16 = 0x157c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.maximum_index < (1 << 22));
        val |= self.maximum_index << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionA {
    pub address_upper: u32,
}

impl Mthd for SetProgramRegionA {
    const ADDR: u16 = 0x1608;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionB {
    pub address_lower: u32,
}

impl Mthd for SetProgramRegionB {
    const ADDR: u16 = 0x160c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetCubemapInterFaceFilteringMode {
    UseWrap = 0x00000000,
    OverrideWrap = 0x00000001,
    AutoSpanSeam = 0x00000002,
    AutoCrossSeam = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCubemapInterFaceFiltering {
    pub mode: SetCubemapInterFaceFilteringMode,
}

impl Mthd for SetCubemapInterFaceFiltering {
    const ADDR: u16 = 0x1664;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlDefaultPartial {
    Zero = 0x00000000,
    Infinity = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderControl {
    pub default_partial: SetShaderControlDefaultPartial,
    pub zero_times_anything_is_zero: bool,
}

impl Mthd for SetShaderControl {
    const ADDR: u16 = 0x1690;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.default_partial as u32) < (1 << 1));
        val |= (self.default_partial as u32) << 0;

        assert!((self.zero_times_anything_is_zero as u32) < (1 << 1));
        val |= (self.zero_times_anything_is_zero as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindConstantBuffer {
    pub valid: bool,
    pub shader_slot: u32,
}

impl Mthd for BindConstantBuffer {
    const ADDR: u16 = 0x1694;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.shader_slot < (1 << 5));
        val |= self.shader_slot << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCachesNoWfi {
    pub instruction: bool,
    pub global_data: bool,
    pub uniform: bool,
    pub constant: bool,
}

impl Mthd for InvalidateShaderCachesNoWfi {
    const ADDR: u16 = 0x1698;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.global_data as u32) < (1 << 1));
        val |= (self.global_data as u32) << 4;

        assert!((self.uniform as u32) < (1 << 1));
        val |= (self.uniform as u32) << 8;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCache {
    pub thru_l2: bool,
}

impl Mthd for InvalidateConstantBufferCache {
    const ADDR: u16 = 0x1930;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.thru_l2 as u32) < (1 << 1));
        val |= (self.thru_l2 as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipeNop {
    pub v: u32,
}

impl Mthd for PipeNop {
    const ADDR: u16 = 0x1a2c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare00 {
    pub v: u32,
}

impl Mthd for SetSpare00 {
    const ADDR: u16 = 0x1a30;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare01 {
    pub v: u32,
}

impl Mthd for SetSpare01 {
    const ADDR: u16 = 0x1a34;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare02 {
    pub v: u32,
}

impl Mthd for SetSpare02 {
    const ADDR: u16 = 0x1a38;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare03 {
    pub v: u32,
}

impl Mthd for SetSpare03 {
    const ADDR: u16 = 0x1a3c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetReportSemaphoreA {
    const ADDR: u16 = 0x1b00;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetReportSemaphoreB {
    const ADDR: u16 = 0x1b04;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetReportSemaphoreC {
    const ADDR: u16 = 0x1b08;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub awaken_enable: bool,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub flush_disable: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorA {
    pub size: u32,
}

impl Mthd for SetConstantBufferSelectorA {
    const ADDR: u16 = 0x2380;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size < (1 << 17));
        val |= self.size << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorB {
    pub address_upper: u32,
}

impl Mthd for SetConstantBufferSelectorB {
    const ADDR: u16 = 0x2384;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorC {
    pub address_lower: u32,
}

impl Mthd for SetConstantBufferSelectorC {
    const ADDR: u16 = 0x2388;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBufferOffset {
    pub v: u32,
}

impl Mthd for LoadConstantBufferOffset {
    const ADDR: u16 = 0x238c;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBuffer {
    pub v: u32,
}

impl ArrayMthd for LoadConstantBuffer {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x2390 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetSuLdStTargetA {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x2700 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetSuLdStTargetB {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x2704 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetC {
    pub width: u32,
}

impl ArrayMthd for SetSuLdStTargetC {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x2708 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.width;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetDLayoutInMemory {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetD {
    pub height: u32,
    pub layout_in_memory: SetSuLdStTargetDLayoutInMemory,
}

impl ArrayMthd for SetSuLdStTargetD {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x270c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.height < (1 << 17));
        val |= self.height << 0;

        assert!((self.layout_in_memory as u32) < (1 << 1));
        val |= (self.layout_in_memory as u32) << 20;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatType {
    Color = 0x00000000,
    Zeta = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatColor {
    Disabled = 0x00000000,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rs32Gs32Bs32As32 = 0x000000c1,
    Ru32Gu32Bu32Au32 = 0x000000c2,
    Rf32Gf32Bf32X32 = 0x000000c3,
    Rs32Gs32Bs32X32 = 0x000000c4,
    Ru32Gu32Bu32X32 = 0x000000c5,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Rs16Gs16Bs16As16 = 0x000000c8,
    Ru16Gu16Bu16Au16 = 0x000000c9,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    Rs32Gs32 = 0x000000cc,
    Ru32Gu32 = 0x000000cd,
    Rf16Gf16Bf16X16 = 0x000000ce,
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2B10G10R10 = 0x000000d1,
    Au2Bu10Gu10Ru10 = 0x000000d2,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    An8Bn8Gn8Rn8 = 0x000000d7,
    As8Bs8Gs8Rs8 = 0x000000d8,
    Au8Bu8Gu8Ru8 = 0x000000d9,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    Rs16Gs16 = 0x000000dc,
    Ru16Gu16 = 0x000000dd,
    Rf16Gf16 = 0x000000de,
    A2R10G10B10 = 0x000000df,
    Bf10Gf11Rf11 = 0x000000e0,
    Rs32 = 0x000000e3,
    Ru32 = 0x000000e4,
    Rf32 = 0x000000e5,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Gs8Rs8 = 0x000000ec,
    Gu8Ru8 = 0x000000ed,
    R16 = 0x000000ee,
    Rn16 = 0x000000ef,
    Rs16 = 0x000000f0,
    Ru16 = 0x000000f1,
    Rf16 = 0x000000f2,
    R8 = 0x000000f3,
    Rn8 = 0x000000f4,
    Rs8 = 0x000000f5,
    Ru8 = 0x000000f6,
    A8 = 0x000000f7,
    X1R5G5B5 = 0x000000f8,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    R32 = 0x000000ff,
    A16 = 0x00000040,
    Af16 = 0x00000041,
    Af32 = 0x00000042,
    A8R8 = 0x00000043,
    R16A16 = 0x00000044,
    Rf16Af16 = 0x00000045,
    Rf32Af32 = 0x00000046,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatZeta {
    Z16 = 0x00000013,
    Z24S8 = 0x00000014,
    X8Z24 = 0x00000015,
    S8Z24 = 0x00000016,
    V8Z24 = 0x00000018,
    Zf32 = 0x0000000a,
    Zf32X24S8 = 0x00000019,
    X8Z24X16V8S8 = 0x0000001d,
    Zf32X16V8X8 = 0x0000001e,
    Zf32X16V8S8 = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetFormat {
    pub type_: SetSuLdStTargetFormatType,
    pub color: SetSuLdStTargetFormatColor,
    pub zeta: SetSuLdStTargetFormatZeta,
    pub suq_pixfmt: u32,
}

impl ArrayMthd for SetSuLdStTargetFormat {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x2710 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 1));
        val |= (self.type_ as u32) << 0;

        assert!((self.color as u32) < (1 << 8));
        val |= (self.color as u32) << 4;

        assert!((self.zeta as u32) < (1 << 5));
        val |= (self.zeta as u32) << 12;

        assert!(self.suq_pixfmt < (1 << 9));
        val |= self.suq_pixfmt << 17;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetBlockSize {
    pub width: SetSuLdStTargetBlockSizeWidth,
    pub height: SetSuLdStTargetBlockSizeHeight,
}

impl ArrayMthd for SetSuLdStTargetBlockSize {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x2714 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValue {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x335c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterEvent {
    pub event: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterEvent {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x337c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.event < (1 << 8));
        val |= self.event << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x339c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.event0 < (1 << 3));
        val |= self.event0 << 0;

        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 4;

        assert!(self.event1 < (1 << 3));
        val |= self.event1 << 8;

        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 12;

        assert!(self.event2 < (1 << 3));
        val |= self.event2 << 16;

        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 20;

        assert!(self.event3 < (1 << 3));
        val |= self.event3 << 24;

        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 28;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x33bc + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;

        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterTrapControl {
    pub mask: u32,
}

impl Mthd for SetShaderPerformanceCounterTrapControl {
    const ADDR: u16 = 0x33dc;
    const CLASS: u16 = 0x90c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.mask < (1 << 8));
        val |= self.mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x3400 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x3800 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        (0x3804 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}
