use crate::ArrayMthd;
use crate::Mthd;

// parsed class NV9097

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;

        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.type_ as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PeerSemaphoreReleaseOffsetUpper {
    pub v: u32,
}

impl Mthd for PeerSemaphoreReleaseOffsetUpper {
    const ADDR: u16 = 0x0128;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PeerSemaphoreReleaseOffset {
    pub v: u32,
}

impl Mthd for PeerSemaphoreReleaseOffset {
    const ADDR: u16 = 0x012c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RunDsNow {
    pub v: u32,
}

impl Mthd for RunDsNow {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold {
    Instantaneous = 0x00000000,
    _16 = 0x00000001,
    _32 = 0x00000002,
    _64 = 0x00000003,
    _128 = 0x00000004,
    _256 = 0x00000005,
    _512 = 0x00000006,
    _1024 = 0x00000007,
    _2048 = 0x00000008,
    _4096 = 0x00000009,
    _8192 = 0x0000000a,
    _16384 = 0x0000000b,
    _32768 = 0x0000000c,
    _65536 = 0x0000000d,
    _131072 = 0x0000000e,
    _262144 = 0x0000000f,
    _524288 = 0x00000010,
    _1048576 = 0x00000011,
    _2097152 = 0x00000012,
    _4194304 = 0x00000013,
    LatezAlways = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetOpportunisticEarlyZHysteresis {
    pub accumulated_prim_area_threshold:
        SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold,
}

impl Mthd for SetOpportunisticEarlyZHysteresis {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.accumulated_prim_area_threshold as u32) < (1 << 5));
        val |= (self.accumulated_prim_area_threshold as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterPipeSyncControl {
    pub prim_area_threshold: u32,
    pub enable: bool,
}

impl Mthd for SetRasterPipeSyncControl {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.prim_area_threshold < (1 << 22));
        val |= self.prim_area_threshold << 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAliasedLineWidthEnable {
    pub v: bool,
}

impl Mthd for SetAliasedLineWidthEnable {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetApiMandatedEarlyZ {
    pub enable: bool,
}

impl Mthd for SetApiMandatedEarlyZ {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGsDmFifo {
    pub size_raster_on: u32,
    pub size_raster_off: u32,
    pub spill_enabled: bool,
}

impl Mthd for SetGsDmFifo {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size_raster_on < (1 << 13));
        val |= self.size_raster_on << 0;

        assert!(self.size_raster_off < (1 << 13));
        val |= self.size_raster_off << 16;

        assert!((self.spill_enabled as u32) < (1 << 1));
        val |= (self.spill_enabled as u32) << 31;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopPrefetchReadRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopPrefetchReadRequests {
    pub policy: SetL2CacheControlForRopPrefetchReadRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopPrefetchReadRequests {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub uniform: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;

        assert!((self.uniform as u32) < (1 << 1));
        val |= (self.uniform as u32) << 8;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;

        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabVertex3F {
    pub v: u32,
}

impl ArrayMthd for SetVabVertex3F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0220 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabVertex4F {
    pub v: u32,
}

impl ArrayMthd for SetVabVertex4F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0230 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabNormal3F {
    pub v: u32,
}

impl ArrayMthd for SetVabNormal3F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0240 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabColor3F {
    pub v: u32,
}

impl ArrayMthd for SetVabColor3F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0250 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabColor4F {
    pub v: u32,
}

impl ArrayMthd for SetVabColor4F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0260 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabColor4Ub {
    pub v: u32,
}

impl ArrayMthd for SetVabColor4Ub {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0270 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord1F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord1F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0280 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord2F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord2F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0290 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord3F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord3F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x02a0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord4F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord4F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x02b0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGaToVaMappingModeV {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGaToVaMappingMode {
    pub v: SetGaToVaMappingModeV,
}

impl Mthd for SetGaToVaMappingMode {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadGaToVaMappingEntry {
    pub virtual_address_upper: u32,
    pub generic_address_upper: u32,
    pub read_enable: bool,
    pub write_enable: bool,
}

impl Mthd for LoadGaToVaMappingEntry {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.virtual_address_upper < (1 << 8));
        val |= self.virtual_address_upper << 0;

        assert!(self.generic_address_upper < (1 << 8));
        val |= self.generic_address_upper << 16;

        assert!((self.read_enable as u32) < (1 << 1));
        val |= (self.read_enable as u32) << 30;

        assert!((self.write_enable as u32) < (1 << 1));
        val |= (self.write_enable as u32) << 31;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTaskCircularBufferThrottle {
    pub task_count: u32,
}

impl Mthd for SetTaskCircularBufferThrottle {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.task_count < (1 << 22));
        val |= self.task_count << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPrimCircularBufferThrottle {
    pub prim_area: u32,
}

impl Mthd for SetPrimCircularBufferThrottle {
    const ADDR: u16 = 0x02d0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.prim_area < (1 << 22));
        val |= self.prim_area << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FlushAndInvalidateRopMiniCache {
    pub v: u32,
}

impl Mthd for FlushAndInvalidateRopMiniCache {
    const ADDR: u16 = 0x02d4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSurfaceClipIdBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSurfaceClipIdBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSurfaceClipIdBlockSizeDepth {
    OneGob = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdBlockSize {
    pub width: SetSurfaceClipIdBlockSizeWidth,
    pub height: SetSurfaceClipIdBlockSizeHeight,
    pub depth: SetSurfaceClipIdBlockSizeDepth,
}

impl Mthd for SetSurfaceClipIdBlockSize {
    const ADDR: u16 = 0x02d8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRasterBoundingBoxMode {
    BoundingBox = 0x00000000,
    FullViewport = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterBoundingBox {
    pub mode: SetRasterBoundingBoxMode,
    pub pad: u32,
}

impl Mthd for SetRasterBoundingBox {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;

        assert!(self.pad < (1 << 8));
        val |= self.pad << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PeerSemaphoreRelease {
    pub v: u32,
}

impl Mthd for PeerSemaphoreRelease {
    const ADDR: u16 = 0x02f0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsOutputSampleMaskUsage {
    pub enable: bool,
    pub qualify_by_anti_alias_enable: SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable,
}

impl Mthd for SetPsOutputSampleMaskUsage {
    const ADDR: u16 = 0x0300;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.qualify_by_anti_alias_enable as u32) < (1 << 1));
        val |= (self.qualify_by_anti_alias_enable as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawZeroIndex {
    pub count: u32,
}

impl Mthd for DrawZeroIndex {
    const ADDR: u16 = 0x0304;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.count;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL1ConfigurationDirectlyAddressableMemory {
    Size48Kb = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL1Configuration {
    pub directly_addressable_memory: SetL1ConfigurationDirectlyAddressableMemory,
}

impl Mthd for SetL1Configuration {
    const ADDR: u16 = 0x0308;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.directly_addressable_memory as u32) < (1 << 3));
        val |= (self.directly_addressable_memory as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableControl {
    pub conditional_load_constant_buffer: bool,
}

impl Mthd for SetRenderEnableControl {
    const ADDR: u16 = 0x030c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.conditional_load_constant_buffer as u32) < (1 << 1));
        val |= (self.conditional_load_constant_buffer as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct XXXSetCtEnable {
    pub target0: bool,
    pub target1: bool,
    pub target2: bool,
    pub target3: bool,
    pub target4: bool,
    pub target5: bool,
    pub target6: bool,
    pub target7: bool,
}

impl Mthd for XXXSetCtEnable {
    const ADDR: u16 = 0x0310;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.target0 as u32) < (1 << 1));
        val |= (self.target0 as u32) << 0;

        assert!((self.target1 as u32) < (1 << 1));
        val |= (self.target1 as u32) << 1;

        assert!((self.target2 as u32) < (1 << 1));
        val |= (self.target2 as u32) << 2;

        assert!((self.target3 as u32) < (1 << 1));
        val |= (self.target3 as u32) << 3;

        assert!((self.target4 as u32) < (1 << 1));
        val |= (self.target4 as u32) << 4;

        assert!((self.target5 as u32) < (1 << 1));
        val |= (self.target5 as u32) << 5;

        assert!((self.target6 as u32) < (1 << 1));
        val |= (self.target6 as u32) << 6;

        assert!((self.target7 as u32) < (1 << 1));
        val |= (self.target7 as u32) << 7;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIeeeCleanUpdate {
    pub enable: bool,
}

impl Mthd for SetIeeeCleanUpdate {
    const ADDR: u16 = 0x0314;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridLineLocationsPerPixel {
    _2X2 = 0x00000001,
    _4X4 = 0x00000002,
    _8X8 = 0x00000003,
    _16X16 = 0x00000004,
    _32X32 = 0x00000005,
    _64X64 = 0x00000006,
    _128X128 = 0x00000007,
    _256X256 = 0x00000008,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridLineRoundingMode {
    Rtne = 0x00000000,
    Tesla = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSnapGridLine {
    pub locations_per_pixel: SetSnapGridLineLocationsPerPixel,
    pub rounding_mode: SetSnapGridLineRoundingMode,
}

impl Mthd for SetSnapGridLine {
    const ADDR: u16 = 0x0318;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.locations_per_pixel as u32) < (1 << 4));
        val |= (self.locations_per_pixel as u32) << 0;

        assert!((self.rounding_mode as u32) < (1 << 1));
        val |= (self.rounding_mode as u32) << 8;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridNonLineLocationsPerPixel {
    _2X2 = 0x00000001,
    _4X4 = 0x00000002,
    _8X8 = 0x00000003,
    _16X16 = 0x00000004,
    _32X32 = 0x00000005,
    _64X64 = 0x00000006,
    _128X128 = 0x00000007,
    _256X256 = 0x00000008,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridNonLineRoundingMode {
    Rtne = 0x00000000,
    Tesla = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSnapGridNonLine {
    pub locations_per_pixel: SetSnapGridNonLineLocationsPerPixel,
    pub rounding_mode: SetSnapGridNonLineRoundingMode,
}

impl Mthd for SetSnapGridNonLine {
    const ADDR: u16 = 0x031c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.locations_per_pixel as u32) < (1 << 4));
        val |= (self.locations_per_pixel as u32) << 0;

        assert!((self.rounding_mode as u32) < (1 << 1));
        val |= (self.rounding_mode as u32) << 8;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTessellationParametersDomainType {
    Isoline = 0x00000000,
    Triangle = 0x00000001,
    Quad = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTessellationParametersSpacing {
    Integer = 0x00000000,
    FractionalOdd = 0x00000001,
    FractionalEven = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTessellationParametersOutputPrimitives {
    Points = 0x00000000,
    Lines = 0x00000001,
    TrianglesCw = 0x00000002,
    TrianglesCcw = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationParameters {
    pub domain_type: SetTessellationParametersDomainType,
    pub spacing: SetTessellationParametersSpacing,
    pub output_primitives: SetTessellationParametersOutputPrimitives,
}

impl Mthd for SetTessellationParameters {
    const ADDR: u16 = 0x0320;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.domain_type as u32) < (1 << 2));
        val |= (self.domain_type as u32) << 0;

        assert!((self.spacing as u32) < (1 << 2));
        val |= (self.spacing as u32) << 4;

        assert!((self.output_primitives as u32) < (1 << 2));
        val |= (self.output_primitives as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodU0OrDensity {
    pub v: u32,
}

impl Mthd for SetTessellationLodU0OrDensity {
    const ADDR: u16 = 0x0324;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodV0OrDetail {
    pub v: u32,
}

impl Mthd for SetTessellationLodV0OrDetail {
    const ADDR: u16 = 0x0328;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodU1OrW0 {
    pub v: u32,
}

impl Mthd for SetTessellationLodU1OrW0 {
    const ADDR: u16 = 0x032c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodV1 {
    pub v: u32,
}

impl Mthd for SetTessellationLodV1 {
    const ADDR: u16 = 0x0330;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTgLodInteriorU {
    pub v: u32,
}

impl Mthd for SetTgLodInteriorU {
    const ADDR: u16 = 0x0334;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTgLodInteriorV {
    pub v: u32,
}

impl Mthd for SetTgLodInteriorV {
    const ADDR: u16 = 0x0338;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg07 {
    pub v: u32,
}

impl Mthd for ReservedTg07 {
    const ADDR: u16 = 0x033c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg08 {
    pub v: u32,
}

impl Mthd for ReservedTg08 {
    const ADDR: u16 = 0x0340;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg09 {
    pub v: u32,
}

impl Mthd for ReservedTg09 {
    const ADDR: u16 = 0x0344;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg10 {
    pub v: u32,
}

impl Mthd for ReservedTg10 {
    const ADDR: u16 = 0x0348;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg11 {
    pub v: u32,
}

impl Mthd for ReservedTg11 {
    const ADDR: u16 = 0x034c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg12 {
    pub v: u32,
}

impl Mthd for ReservedTg12 {
    const ADDR: u16 = 0x0350;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg13 {
    pub v: u32,
}

impl Mthd for ReservedTg13 {
    const ADDR: u16 = 0x0354;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg14 {
    pub v: u32,
}

impl Mthd for ReservedTg14 {
    const ADDR: u16 = 0x0358;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg15 {
    pub v: u32,
}

impl Mthd for ReservedTg15 {
    const ADDR: u16 = 0x035c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSubtilingPerfKnobA {
    pub fraction_of_spm_register_file_per_subtile: u32,
    pub fraction_of_spm_pixel_output_buffer_per_subtile: u32,
    pub fraction_of_spm_triangle_ram_per_subtile: u32,
    pub fraction_of_max_quads_per_subtile: u32,
}

impl Mthd for SetSubtilingPerfKnobA {
    const ADDR: u16 = 0x0360;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.fraction_of_spm_register_file_per_subtile < (1 << 8));
        val |= self.fraction_of_spm_register_file_per_subtile << 0;

        assert!(self.fraction_of_spm_pixel_output_buffer_per_subtile < (1 << 8));
        val |= self.fraction_of_spm_pixel_output_buffer_per_subtile << 8;

        assert!(self.fraction_of_spm_triangle_ram_per_subtile < (1 << 8));
        val |= self.fraction_of_spm_triangle_ram_per_subtile << 16;

        assert!(self.fraction_of_max_quads_per_subtile < (1 << 8));
        val |= self.fraction_of_max_quads_per_subtile << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSubtilingPerfKnobB {
    pub fraction_of_max_primitives_per_subtile: u32,
}

impl Mthd for SetSubtilingPerfKnobB {
    const ADDR: u16 = 0x0364;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.fraction_of_max_primitives_per_subtile < (1 << 8));
        val |= self.fraction_of_max_primitives_per_subtile << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSubtilingPerfKnobC {
    pub reserved: u32,
}

impl Mthd for SetSubtilingPerfKnobC {
    const ADDR: u16 = 0x0368;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.reserved < (1 << 1));
        val |= self.reserved << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterEnable {
    pub v: bool,
}

impl Mthd for SetRasterEnable {
    const ADDR: u16 = 0x037c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferEnable {
    pub v: bool,
}

impl ArrayMthd for SetStreamOutBufferEnable {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0380 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferAddressA {
    pub upper: u32,
}

impl ArrayMthd for SetStreamOutBufferAddressA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0384 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferAddressB {
    pub lower: u32,
}

impl ArrayMthd for SetStreamOutBufferAddressB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0388 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferSize {
    pub bytes: u32,
}

impl ArrayMthd for SetStreamOutBufferSize {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x038c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.bytes;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferLoadWritePointer {
    pub start_offset: u32,
}

impl ArrayMthd for SetStreamOutBufferLoadWritePointer {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0390 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.start_offset;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabDataTypeless {
    pub v: u32,
}

impl ArrayMthd for SetVabDataTypeless {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0400 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutControlStream {
    pub select: u32,
}

impl ArrayMthd for SetStreamOutControlStream {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0700 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.select < (1 << 2));
        val |= self.select << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutControlComponentCount {
    pub max: u32,
}

impl ArrayMthd for SetStreamOutControlComponentCount {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0704 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.max < (1 << 8));
        val |= self.max << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutControlStride {
    pub bytes: u32,
}

impl ArrayMthd for SetStreamOutControlStride {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0708 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.bytes;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterInput {
    pub stream_select: u32,
}

impl Mthd for SetRasterInput {
    const ADDR: u16 = 0x0740;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.stream_select < (1 << 2));
        val |= self.stream_select << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutput {
    pub enable: bool,
}

impl Mthd for SetStreamOutput {
    const ADDR: u16 = 0x0744;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartTopologyChange {
    pub enable: bool,
}

impl Mthd for SetDaPrimitiveRestartTopologyChange {
    const ADDR: u16 = 0x0748;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaFraction {
    pub v: u32,
}

impl Mthd for SetAlphaFraction {
    const ADDR: u16 = 0x074c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetHybridAntiAliasControlCentroid {
    PerFragment = 0x00000000,
    PerPass = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetHybridAntiAliasControl {
    pub passes: u32,
    pub centroid: SetHybridAntiAliasControlCentroid,
}

impl Mthd for SetHybridAntiAliasControl {
    const ADDR: u16 = 0x0754;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.passes < (1 << 4));
        val |= self.passes << 0;

        assert!((self.centroid as u32) < (1 << 1));
        val |= (self.centroid as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxTiWarpsPerBatch {
    pub v: u32,
}

impl Mthd for SetMaxTiWarpsPerBatch {
    const ADDR: u16 = 0x075c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 6));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindow {
    pub base_address: u32,
}

impl Mthd for SetShaderLocalMemoryWindow {
    const ADDR: u16 = 0x077c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.base_address;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryA {
    pub address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryA {
    const ADDR: u16 = 0x0790;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryB {
    pub address_lower: u32,
}

impl Mthd for SetShaderLocalMemoryB {
    const ADDR: u16 = 0x0794;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryC {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryC {
    const ADDR: u16 = 0x0798;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size_upper < (1 << 6));
        val |= self.size_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryD {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryD {
    const ADDR: u16 = 0x079c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.size_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryE {
    pub default_size_per_warp: u32,
}

impl Mthd for SetShaderLocalMemoryE {
    const ADDR: u16 = 0x07a0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.default_size_per_warp < (1 << 26));
        val |= self.default_size_per_warp << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabVertex2F {
    pub v: u32,
}

impl ArrayMthd for SetVabVertex2F {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x07b0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionSizeA {
    pub width: u32,
}

impl Mthd for SetZcullRegionSizeA {
    const ADDR: u16 = 0x07c0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.width < (1 << 16));
        val |= self.width << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionSizeB {
    pub height: u32,
}

impl Mthd for SetZcullRegionSizeB {
    const ADDR: u16 = 0x07c4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.height < (1 << 16));
        val |= self.height << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionSizeC {
    pub depth: u32,
}

impl Mthd for SetZcullRegionSizeC {
    const ADDR: u16 = 0x07c8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.depth < (1 << 16));
        val |= self.depth << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionPixelOffsetC {
    pub depth: u32,
}

impl Mthd for SetZcullRegionPixelOffsetC {
    const ADDR: u16 = 0x07cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.depth < (1 << 16));
        val |= self.depth << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCullBeforeFetch {
    pub fetch_streams_once: bool,
}

impl Mthd for SetCullBeforeFetch {
    const ADDR: u16 = 0x07dc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.fetch_streams_once as u32) < (1 << 1));
        val |= (self.fetch_streams_once as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionLocation {
    pub start_aliquot: u32,
    pub aliquot_count: u32,
}

impl Mthd for SetZcullRegionLocation {
    const ADDR: u16 = 0x07e0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.start_aliquot < (1 << 16));
        val |= self.start_aliquot << 0;

        assert!(self.aliquot_count < (1 << 16));
        val |= self.aliquot_count << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionAliquots {
    pub per_layer: u32,
}

impl Mthd for SetZcullRegionAliquots {
    const ADDR: u16 = 0x07e4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.per_layer < (1 << 16));
        val |= self.per_layer << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageA {
    pub address_upper: u32,
}

impl Mthd for SetZcullStorageA {
    const ADDR: u16 = 0x07e8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageB {
    pub address_lower: u32,
}

impl Mthd for SetZcullStorageB {
    const ADDR: u16 = 0x07ec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageC {
    pub limit_address_upper: u32,
}

impl Mthd for SetZcullStorageC {
    const ADDR: u16 = 0x07f0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.limit_address_upper < (1 << 8));
        val |= self.limit_address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageD {
    pub limit_address_lower: u32,
}

impl Mthd for SetZcullStorageD {
    const ADDR: u16 = 0x07f4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.limit_address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtReadOnly {
    pub enable_z: bool,
    pub enable_stencil: bool,
}

impl Mthd for SetZtReadOnly {
    const ADDR: u16 = 0x07f8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable_z as u32) < (1 << 1));
        val |= (self.enable_z as u32) << 0;

        assert!((self.enable_stencil as u32) < (1 << 1));
        val |= (self.enable_stencil as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetColorTargetA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0800 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetColorTargetB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0804 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetWidth {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetWidth {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0808 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 28));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetHeight {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetHeight {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x080c + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetFormatV {
    Disabled = 0x00000000,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rs32Gs32Bs32As32 = 0x000000c1,
    Ru32Gu32Bu32Au32 = 0x000000c2,
    Rf32Gf32Bf32X32 = 0x000000c3,
    Rs32Gs32Bs32X32 = 0x000000c4,
    Ru32Gu32Bu32X32 = 0x000000c5,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Rs16Gs16Bs16As16 = 0x000000c8,
    Ru16Gu16Bu16Au16 = 0x000000c9,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    Rs32Gs32 = 0x000000cc,
    Ru32Gu32 = 0x000000cd,
    Rf16Gf16Bf16X16 = 0x000000ce,
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2B10G10R10 = 0x000000d1,
    Au2Bu10Gu10Ru10 = 0x000000d2,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    An8Bn8Gn8Rn8 = 0x000000d7,
    As8Bs8Gs8Rs8 = 0x000000d8,
    Au8Bu8Gu8Ru8 = 0x000000d9,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    Rs16Gs16 = 0x000000dc,
    Ru16Gu16 = 0x000000dd,
    Rf16Gf16 = 0x000000de,
    A2R10G10B10 = 0x000000df,
    Bf10Gf11Rf11 = 0x000000e0,
    Rs32 = 0x000000e3,
    Ru32 = 0x000000e4,
    Rf32 = 0x000000e5,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Gs8Rs8 = 0x000000ec,
    Gu8Ru8 = 0x000000ed,
    R16 = 0x000000ee,
    Rn16 = 0x000000ef,
    Rs16 = 0x000000f0,
    Ru16 = 0x000000f1,
    Rf16 = 0x000000f2,
    R8 = 0x000000f3,
    Rn8 = 0x000000f4,
    Rs8 = 0x000000f5,
    Ru8 = 0x000000f6,
    A8 = 0x000000f7,
    X1R5G5B5 = 0x000000f8,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    R32 = 0x000000ff,
    A16 = 0x00000040,
    Af16 = 0x00000041,
    Af32 = 0x00000042,
    A8R8 = 0x00000043,
    R16A16 = 0x00000044,
    Rf16Af16 = 0x00000045,
    Rf32Af32 = 0x00000046,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetFormat {
    pub v: SetColorTargetFormatV,
}

impl ArrayMthd for SetColorTargetFormat {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0810 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryBlockWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryBlockHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryBlockDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryThirdDimensionControl {
    ThirdDimensionDefinesArraySize = 0x00000000,
    ThirdDimensionDefinesDepthSize = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetMemory {
    pub block_width: SetColorTargetMemoryBlockWidth,
    pub block_height: SetColorTargetMemoryBlockHeight,
    pub block_depth: SetColorTargetMemoryBlockDepth,
    pub layout: SetColorTargetMemoryLayout,
    pub third_dimension_control: SetColorTargetMemoryThirdDimensionControl,
}

impl ArrayMthd for SetColorTargetMemory {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0814 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.block_width as u32) < (1 << 4));
        val |= (self.block_width as u32) << 0;

        assert!((self.block_height as u32) < (1 << 4));
        val |= (self.block_height as u32) << 4;

        assert!((self.block_depth as u32) < (1 << 4));
        val |= (self.block_depth as u32) << 8;

        assert!((self.layout as u32) < (1 << 1));
        val |= (self.layout as u32) << 12;

        assert!((self.third_dimension_control as u32) < (1 << 1));
        val |= (self.third_dimension_control as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetThirdDimension {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetThirdDimension {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0818 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 28));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetArrayPitch {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetArrayPitch {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x081c + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetLayer {
    pub offset: u32,
}

impl ArrayMthd for SetColorTargetLayer {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0820 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset < (1 << 16));
        val |= self.offset << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetMark {
    pub ieee_clean: bool,
}

impl ArrayMthd for SetColorTargetMark {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0824 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.ieee_clean as u32) < (1 << 1));
        val |= (self.ieee_clean as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleX {
    pub v: f32,
}

impl ArrayMthd for SetViewportScaleX {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0a00 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleY {
    pub v: f32,
}

impl ArrayMthd for SetViewportScaleY {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0a04 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportScaleZ {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0a08 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportOffsetX {
    pub v: f32,
}

impl ArrayMthd for SetViewportOffsetX {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0a0c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportOffsetY {
    pub v: f32,
}

impl ArrayMthd for SetViewportOffsetY {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0a10 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportOffsetZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportOffsetZ {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0a14 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipHorizontal {
    pub x0: u32,
    pub width: u32,
}

impl ArrayMthd for SetViewportClipHorizontal {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0c00 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x0 < (1 << 16));
        val |= self.x0 << 0;

        assert!(self.width < (1 << 16));
        val |= self.width << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipVertical {
    pub y0: u32,
    pub height: u32,
}

impl ArrayMthd for SetViewportClipVertical {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0c04 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.y0 < (1 << 16));
        val |= self.y0 << 0;

        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipMinZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportClipMinZ {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0c08 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipMaxZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportClipMaxZ {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0c0c + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl ArrayMthd for SetWindowClipHorizontal {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0d00 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;

        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl ArrayMthd for SetWindowClipVertical {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0d04 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;

        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdExtentX {
    pub minx: u32,
    pub width: u32,
}

impl ArrayMthd for SetClipIdExtentX {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0d40 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.minx < (1 << 16));
        val |= self.minx << 0;

        assert!(self.width < (1 << 16));
        val |= self.width << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdExtentY {
    pub miny: u32,
    pub height: u32,
}

impl ArrayMthd for SetClipIdExtentY {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0d44 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.miny < (1 << 16));
        val |= self.miny << 0;

        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxStreamOutputGsInstancesPerTask {
    pub v: u32,
}

impl Mthd for SetMaxStreamOutputGsInstancesPerTask {
    const ADDR: u16 = 0x0d60;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 11));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetApiVisibleCallLimitV {
    _0 = 0x00000000,
    _1 = 0x00000001,
    _2 = 0x00000002,
    _4 = 0x00000003,
    _8 = 0x00000004,
    _16 = 0x00000005,
    _32 = 0x00000006,
    _64 = 0x00000007,
    _128 = 0x00000008,
    NoCheck = 0x0000000f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetApiVisibleCallLimit {
    pub v: SetApiVisibleCallLimitV,
}

impl Mthd for SetApiVisibleCallLimit {
    const ADDR: u16 = 0x0d64;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 4));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStatisticsCounter {
    pub da_vertices_generated_enable: bool,
    pub da_primitives_generated_enable: bool,
    pub vs_invocations_enable: bool,
    pub gs_invocations_enable: bool,
    pub gs_primitives_generated_enable: bool,
    pub streaming_primitives_succeeded_enable: bool,
    pub streaming_primitives_needed_enable: bool,
    pub clipper_invocations_enable: bool,
    pub clipper_primitives_generated_enable: bool,
    pub ps_invocations_enable: bool,
    pub ti_invocations_enable: bool,
    pub ts_invocations_enable: bool,
    pub ts_primitives_generated_enable: bool,
    pub total_streaming_primitives_needed_succeeded_enable: bool,
    pub vtg_primitives_out_enable: bool,
    pub alpha_beta_clocks_enable: bool,
}

impl Mthd for SetStatisticsCounter {
    const ADDR: u16 = 0x0d68;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.da_vertices_generated_enable as u32) < (1 << 1));
        val |= (self.da_vertices_generated_enable as u32) << 0;

        assert!((self.da_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.da_primitives_generated_enable as u32) << 1;

        assert!((self.vs_invocations_enable as u32) < (1 << 1));
        val |= (self.vs_invocations_enable as u32) << 2;

        assert!((self.gs_invocations_enable as u32) < (1 << 1));
        val |= (self.gs_invocations_enable as u32) << 3;

        assert!((self.gs_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.gs_primitives_generated_enable as u32) << 4;

        assert!((self.streaming_primitives_succeeded_enable as u32) < (1 << 1));
        val |= (self.streaming_primitives_succeeded_enable as u32) << 5;

        assert!((self.streaming_primitives_needed_enable as u32) < (1 << 1));
        val |= (self.streaming_primitives_needed_enable as u32) << 6;

        assert!((self.clipper_invocations_enable as u32) < (1 << 1));
        val |= (self.clipper_invocations_enable as u32) << 7;

        assert!((self.clipper_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.clipper_primitives_generated_enable as u32) << 8;

        assert!((self.ps_invocations_enable as u32) < (1 << 1));
        val |= (self.ps_invocations_enable as u32) << 9;

        assert!((self.ti_invocations_enable as u32) < (1 << 1));
        val |= (self.ti_invocations_enable as u32) << 11;

        assert!((self.ts_invocations_enable as u32) < (1 << 1));
        val |= (self.ts_invocations_enable as u32) << 12;

        assert!((self.ts_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.ts_primitives_generated_enable as u32) << 13;

        assert!((self.total_streaming_primitives_needed_succeeded_enable as u32) < (1 << 1));
        val |= (self.total_streaming_primitives_needed_succeeded_enable as u32) << 14;

        assert!((self.vtg_primitives_out_enable as u32) < (1 << 1));
        val |= (self.vtg_primitives_out_enable as u32) << 10;

        assert!((self.alpha_beta_clocks_enable as u32) < (1 << 1));
        val |= (self.alpha_beta_clocks_enable as u32) << 15;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClearRectHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl Mthd for SetClearRectHorizontal {
    const ADDR: u16 = 0x0d6c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;

        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClearRectVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl Mthd for SetClearRectVertical {
    const ADDR: u16 = 0x0d70;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;

        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexArrayStart {
    pub v: u32,
}

impl Mthd for SetVertexArrayStart {
    const ADDR: u16 = 0x0d74;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArray {
    pub count: u32,
}

impl Mthd for DrawVertexArray {
    const ADDR: u16 = 0x0d78;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.count;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportZClipRange {
    NegativeWToPositiveW = 0x00000000,
    ZeroToPositiveW = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportZClip {
    pub range: SetViewportZClipRange,
}

impl Mthd for SetViewportZClip {
    const ADDR: u16 = 0x0d7c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.range as u32) < (1 << 1));
        val |= (self.range as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorClearValue {
    pub v: u32,
}

impl ArrayMthd for SetColorClearValue {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0d80 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZClearValue {
    pub v: f32,
}

impl Mthd for SetZClearValue {
    const ADDR: u16 = 0x0d90;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderCacheControl {
    pub icache_prefetch_enable: bool,
}

impl Mthd for SetShaderCacheControl {
    const ADDR: u16 = 0x0d94;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.icache_prefetch_enable as u32) < (1 << 1));
        val |= (self.icache_prefetch_enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsEnable {
    pub v: bool,
}

impl Mthd for SetReduceColorThresholdsEnable {
    const ADDR: u16 = 0x0d9c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilClearValue {
    pub v: u32,
}

impl Mthd for SetStencilClearValue {
    const ADDR: u16 = 0x0da0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetFrontPolygonModeV {
    Point = 0x00001b00,
    Line = 0x00001b01,
    Fill = 0x00001b02,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFrontPolygonMode {
    pub v: SetFrontPolygonModeV,
}

impl Mthd for SetFrontPolygonMode {
    const ADDR: u16 = 0x0dac;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackPolygonModeV {
    Point = 0x00001b00,
    Line = 0x00001b01,
    Fill = 0x00001b02,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackPolygonMode {
    pub v: SetBackPolygonModeV,
}

impl Mthd for SetBackPolygonMode {
    const ADDR: u16 = 0x0db0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolySmooth {
    pub enable: bool,
}

impl Mthd for SetPolySmooth {
    const ADDR: u16 = 0x0db4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtMark {
    pub ieee_clean: bool,
}

impl Mthd for SetZtMark {
    const ADDR: u16 = 0x0db8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.ieee_clean as u32) < (1 << 1));
        val |= (self.ieee_clean as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullDirFormatZdir {
    Less = 0x00000000,
    Greater = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullDirFormatZformat {
    Msb = 0x00000000,
    Fp = 0x00000001,
    Ztrick = 0x00000002,
    Zf321 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullDirFormat {
    pub zdir: SetZcullDirFormatZdir,
    pub zformat: SetZcullDirFormatZformat,
}

impl Mthd for SetZcullDirFormat {
    const ADDR: u16 = 0x0dbc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.zdir as u32) < (1 << 16));
        val |= (self.zdir as u32) << 0;

        assert!((self.zformat as u32) < (1 << 16));
        val |= (self.zformat as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolyOffsetPoint {
    pub enable: bool,
}

impl Mthd for SetPolyOffsetPoint {
    const ADDR: u16 = 0x0dc0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolyOffsetLine {
    pub enable: bool,
}

impl Mthd for SetPolyOffsetLine {
    const ADDR: u16 = 0x0dc4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolyOffsetFill {
    pub enable: bool,
}

impl Mthd for SetPolyOffsetFill {
    const ADDR: u16 = 0x0dc8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPatch {
    pub size: u32,
}

impl Mthd for SetPatch {
    const ADDR: u16 = 0x0dcc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size < (1 << 8));
        val |= self.size << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullCriterionSfunc {
    Never = 0x00000000,
    Less = 0x00000001,
    Equal = 0x00000002,
    Lequal = 0x00000003,
    Greater = 0x00000004,
    Notequal = 0x00000005,
    Gequal = 0x00000006,
    Always = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullCriterion {
    pub sfunc: SetZcullCriterionSfunc,
    pub no_invalidate: bool,
    pub force_match: bool,
    pub sref: u32,
    pub smask: u32,
}

impl Mthd for SetZcullCriterion {
    const ADDR: u16 = 0x0dd8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.sfunc as u32) < (1 << 8));
        val |= (self.sfunc as u32) << 0;

        assert!((self.no_invalidate as u32) < (1 << 1));
        val |= (self.no_invalidate as u32) << 8;

        assert!((self.force_match as u32) < (1 << 1));
        val |= (self.force_match as u32) << 9;

        assert!(self.sref < (1 << 8));
        val |= self.sref << 16;

        assert!(self.smask < (1 << 8));
        val |= self.smask << 24;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum XXXSetDaAttributeCacheLineV {
    Size128 = 0x00000000,
    Size64 = 0x00000001,
    Size32 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct XXXSetDaAttributeCacheLine {
    pub v: XXXSetDaAttributeCacheLineV,
}

impl Mthd for XXXSetDaAttributeCacheLine {
    const ADDR: u16 = 0x0ddc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmTimeoutInterval {
    pub counter_bit: u32,
}

impl Mthd for SetSmTimeoutInterval {
    const ADDR: u16 = 0x0de4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_bit < (1 << 6));
        val |= self.counter_bit << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartVertexArray {
    pub enable: bool,
}

impl Mthd for SetDaPrimitiveRestartVertexArray {
    const ADDR: u16 = 0x0de8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawInlineVertexVabUpdate {
    pub enable: bool,
}

impl Mthd for SetDrawInlineVertexVabUpdate {
    const ADDR: u16 = 0x0dec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct XXXSetReduceColor {
    pub u8_threshold: u32,
    pub fp16_threshold: u32,
}

impl Mthd for XXXSetReduceColor {
    const ADDR: u16 = 0x0df4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.u8_threshold < (1 << 8));
        val |= self.u8_threshold << 0;

        assert!(self.fp16_threshold < (1 << 16));
        val |= self.fp16_threshold << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowOffsetX {
    pub v: u32,
}

impl Mthd for SetWindowOffsetX {
    const ADDR: u16 = 0x0df8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowOffsetY {
    pub v: u32,
}

impl Mthd for SetWindowOffsetY {
    const ADDR: u16 = 0x0dfc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 18));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScissorEnable {
    pub v: bool,
}

impl ArrayMthd for SetScissorEnable {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0e00 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScissorHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl ArrayMthd for SetScissorHorizontal {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0e04 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;

        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScissorVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl ArrayMthd for SetScissorVertical {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0e08 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;

        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabNormal3S {
    pub v: u32,
}

impl ArrayMthd for SetVabNormal3S {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x0f00 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilFuncRef {
    pub v: u32,
}

impl Mthd for SetBackStencilFuncRef {
    const ADDR: u16 = 0x0f54;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilMask {
    pub v: u32,
}

impl Mthd for SetBackStencilMask {
    const ADDR: u16 = 0x0f58;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilFuncMask {
    pub v: u32,
}

impl Mthd for SetBackStencilFuncMask {
    const ADDR: u16 = 0x0f5c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamSubstituteA {
    pub address_upper: u32,
}

impl Mthd for SetVertexStreamSubstituteA {
    const ADDR: u16 = 0x0f84;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamSubstituteB {
    pub address_lower: u32,
}

impl Mthd for SetVertexStreamSubstituteB {
    const ADDR: u16 = 0x0f88;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetLineModePolygonClipGeneratedEdge {
    DrawLine = 0x00000000,
    DoNotDrawLine = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineModePolygonClip {
    pub generated_edge: SetLineModePolygonClipGeneratedEdge,
}

impl Mthd for SetLineModePolygonClip {
    const ADDR: u16 = 0x0f8c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.generated_edge as u32) < (1 << 1));
        val |= (self.generated_edge as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSingleCtWriteControl {
    pub enable: bool,
}

impl Mthd for SetSingleCtWriteControl {
    const ADDR: u16 = 0x0f90;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVtgWarpWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetVtgWarpWatermarks {
    const ADDR: u16 = 0x0f98;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.low < (1 << 16));
        val |= self.low << 0;

        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBoundsMin {
    pub v: f32,
}

impl Mthd for SetDepthBoundsMin {
    const ADDR: u16 = 0x0f9c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBoundsMax {
    pub v: f32,
}

impl Mthd for SetDepthBoundsMax {
    const ADDR: u16 = 0x0fa0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtMrtEnable {
    pub v: bool,
}

impl Mthd for SetCtMrtEnable {
    const ADDR: u16 = 0x0fac;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetNonmultisampledZV {
    PerSample = 0x00000000,
    AtPixelCenter = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNonmultisampledZ {
    pub v: SetNonmultisampledZV,
}

impl Mthd for SetNonmultisampledZ {
    const ADDR: u16 = 0x0fb0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX0Y0 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX0Y0 {
    const ADDR: u16 = 0x0fbc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX1Y0 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX1Y0 {
    const ADDR: u16 = 0x0fc0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX0Y1 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX0Y1 {
    const ADDR: u16 = 0x0fc4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX1Y1 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX1Y1 {
    const ADDR: u16 = 0x0fc8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdMemoryA {
    pub offset_upper: u32,
}

impl Mthd for SetSurfaceClipIdMemoryA {
    const ADDR: u16 = 0x0fcc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdMemoryB {
    pub offset_lower: u32,
}

impl Mthd for SetSurfaceClipIdMemoryB {
    const ADDR: u16 = 0x0fd0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendOptControl {
    pub allow_float_pixel_kills: bool,
}

impl Mthd for SetBlendOptControl {
    const ADDR: u16 = 0x0fdc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.allow_float_pixel_kills as u32) < (1 << 1));
        val |= (self.allow_float_pixel_kills as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtA {
    pub offset_upper: u32,
}

impl Mthd for SetZtA {
    const ADDR: u16 = 0x0fe0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtB {
    pub offset_lower: u32,
}

impl Mthd for SetZtB {
    const ADDR: u16 = 0x0fe4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtFormatV {
    Z16 = 0x00000013,
    Z24S8 = 0x00000014,
    X8Z24 = 0x00000015,
    S8Z24 = 0x00000016,
    V8Z24 = 0x00000018,
    Zf32 = 0x0000000a,
    Zf32X24S8 = 0x00000019,
    X8Z24X16V8S8 = 0x0000001d,
    Zf32X16V8X8 = 0x0000001e,
    Zf32X16V8S8 = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtFormat {
    pub v: SetZtFormatV,
}

impl Mthd for SetZtFormat {
    const ADDR: u16 = 0x0fe8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 5));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtBlockSizeDepth {
    OneGob = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtBlockSize {
    pub width: SetZtBlockSizeWidth,
    pub height: SetZtBlockSizeHeight,
    pub depth: SetZtBlockSizeDepth,
}

impl Mthd for SetZtBlockSize {
    const ADDR: u16 = 0x0fec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtArrayPitch {
    pub v: u32,
}

impl Mthd for SetZtArrayPitch {
    const ADDR: u16 = 0x0ff0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipHorizontal {
    pub x: u32,
    pub width: u32,
}

impl Mthd for SetSurfaceClipHorizontal {
    const ADDR: u16 = 0x0ff4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x < (1 << 16));
        val |= self.x << 0;

        assert!(self.width < (1 << 16));
        val |= self.width << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipVertical {
    pub y: u32,
    pub height: u32,
}

impl Mthd for SetSurfaceClipVertical {
    const ADDR: u16 = 0x0ff8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.y < (1 << 16));
        val |= self.y << 0;

        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForVafRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForVafRequests {
    pub system_memory_volatile: bool,
    pub policy: SetL2CacheControlForVafRequestsPolicy,
}

impl Mthd for SetL2CacheControlForVafRequests {
    const ADDR: u16 = 0x1000;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.system_memory_volatile as u32) < (1 << 1));
        val |= (self.system_memory_volatile as u32) << 0;

        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetForceOneTextureUnit {
    pub enable: bool,
}

impl Mthd for SetForceOneTextureUnit {
    const ADDR: u16 = 0x1004;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationCutHeight {
    pub v: u32,
}

impl Mthd for SetTessellationCutHeight {
    const ADDR: u16 = 0x1008;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 5));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxGsInstancesPerTask {
    pub v: u32,
}

impl Mthd for SetMaxGsInstancesPerTask {
    const ADDR: u16 = 0x100c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 11));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxGsOutputVerticesPerTask {
    pub v: u32,
}

impl Mthd for SetMaxGsOutputVerticesPerTask {
    const ADDR: u16 = 0x1010;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGsOutputCbStorageMultiplier {
    pub v: u32,
}

impl Mthd for SetGsOutputCbStorageMultiplier {
    const ADDR: u16 = 0x1018;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 10));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBetaCbStorageConstraint {
    pub enable: bool,
}

impl Mthd for SetBetaCbStorageConstraint {
    const ADDR: u16 = 0x101c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTiOutputCbStorageMultiplier {
    pub v: u32,
}

impl Mthd for SetTiOutputCbStorageMultiplier {
    const ADDR: u16 = 0x1020;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 10));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaCbStorageConstraint {
    pub enable: bool,
}

impl Mthd for SetAlphaCbStorageConstraint {
    const ADDR: u16 = 0x1024;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetSpareNoop00 {
    const ADDR: u16 = 0x1040;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x1044;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x1048;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x104c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x1050;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop05 {
    pub v: u32,
}

impl Mthd for SetSpareNoop05 {
    const ADDR: u16 = 0x1054;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x1058;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x105c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x1060;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x1064;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x1068;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x106c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x1070;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x1074;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x1078;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x107c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsUnorm8 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsUnorm8 {
    const ADDR: u16 = 0x10cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;

        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsUnorm10 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsUnorm10 {
    const ADDR: u16 = 0x10e0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;

        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsUnorm16 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsUnorm16 {
    const ADDR: u16 = 0x10e4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;

        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsFp11 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsFp11 {
    const ADDR: u16 = 0x10e8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.all_covered_all_hit_once < (1 << 6));
        val |= self.all_covered_all_hit_once << 0;

        assert!(self.all_covered < (1 << 6));
        val |= self.all_covered << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsFp16 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsFp16 {
    const ADDR: u16 = 0x10ec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;

        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsSrgb8 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsSrgb8 {
    const ADDR: u16 = 0x10f0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;

        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct UnbindAll {
    pub texture_headers: bool,
    pub texture_samplers: bool,
    pub constant_buffers: bool,
}

impl Mthd for UnbindAll {
    const ADDR: u16 = 0x10f4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.texture_headers as u32) < (1 << 1));
        val |= (self.texture_headers as u32) << 0;

        assert!((self.texture_samplers as u32) < (1 << 1));
        val |= (self.texture_samplers as u32) << 4;

        assert!((self.constant_buffers as u32) < (1 << 1));
        val |= (self.constant_buffers as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClearSurfaceControl {
    pub respect_stencil_mask: bool,
    pub use_clear_rect: bool,
    pub use_scissor0: bool,
    pub use_viewport_clip0: bool,
}

impl Mthd for SetClearSurfaceControl {
    const ADDR: u16 = 0x10f8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.respect_stencil_mask as u32) < (1 << 1));
        val |= (self.respect_stencil_mask as u32) << 0;

        assert!((self.use_clear_rect as u32) < (1 << 1));
        val |= (self.use_clear_rect as u32) << 4;

        assert!((self.use_scissor0 as u32) < (1 << 1));
        val |= (self.use_scissor0 as u32) << 8;

        assert!((self.use_viewport_clip0 as u32) < (1 << 1));
        val |= (self.use_viewport_clip0 as u32) << 12;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopNoninterlockedReadRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopNoninterlockedReadRequests {
    pub policy: SetL2CacheControlForRopNoninterlockedReadRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopNoninterlockedReadRequests {
    const ADDR: u16 = 0x10fc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperationDataHi {
    pub v: u32,
}

impl Mthd for NoOperationDataHi {
    const ADDR: u16 = 0x110c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBiasControl {
    pub depth_format_dependent: bool,
}

impl Mthd for SetDepthBiasControl {
    const ADDR: u16 = 0x1110;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.depth_format_dependent as u32) < (1 << 1));
        val |= (self.depth_format_dependent as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerEnd {
    pub v: u32,
}

impl Mthd for PmTriggerEnd {
    const ADDR: u16 = 0x1114;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexIdBase {
    pub v: u32,
}

impl Mthd for SetVertexIdBase {
    const ADDR: u16 = 0x1118;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaOutputAttributeSkipMaskA {
    pub attribute0_comp0: bool,
    pub attribute0_comp1: bool,
    pub attribute0_comp2: bool,
    pub attribute0_comp3: bool,
    pub attribute1_comp0: bool,
    pub attribute1_comp1: bool,
    pub attribute1_comp2: bool,
    pub attribute1_comp3: bool,
    pub attribute2_comp0: bool,
    pub attribute2_comp1: bool,
    pub attribute2_comp2: bool,
    pub attribute2_comp3: bool,
    pub attribute3_comp0: bool,
    pub attribute3_comp1: bool,
    pub attribute3_comp2: bool,
    pub attribute3_comp3: bool,
    pub attribute4_comp0: bool,
    pub attribute4_comp1: bool,
    pub attribute4_comp2: bool,
    pub attribute4_comp3: bool,
    pub attribute5_comp0: bool,
    pub attribute5_comp1: bool,
    pub attribute5_comp2: bool,
    pub attribute5_comp3: bool,
    pub attribute6_comp0: bool,
    pub attribute6_comp1: bool,
    pub attribute6_comp2: bool,
    pub attribute6_comp3: bool,
    pub attribute7_comp0: bool,
    pub attribute7_comp1: bool,
    pub attribute7_comp2: bool,
    pub attribute7_comp3: bool,
}

impl ArrayMthd for SetDaOutputAttributeSkipMaskA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1120 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.attribute0_comp0 as u32) < (1 << 1));
        val |= (self.attribute0_comp0 as u32) << 0;

        assert!((self.attribute0_comp1 as u32) < (1 << 1));
        val |= (self.attribute0_comp1 as u32) << 1;

        assert!((self.attribute0_comp2 as u32) < (1 << 1));
        val |= (self.attribute0_comp2 as u32) << 2;

        assert!((self.attribute0_comp3 as u32) < (1 << 1));
        val |= (self.attribute0_comp3 as u32) << 3;

        assert!((self.attribute1_comp0 as u32) < (1 << 1));
        val |= (self.attribute1_comp0 as u32) << 4;

        assert!((self.attribute1_comp1 as u32) < (1 << 1));
        val |= (self.attribute1_comp1 as u32) << 5;

        assert!((self.attribute1_comp2 as u32) < (1 << 1));
        val |= (self.attribute1_comp2 as u32) << 6;

        assert!((self.attribute1_comp3 as u32) < (1 << 1));
        val |= (self.attribute1_comp3 as u32) << 7;

        assert!((self.attribute2_comp0 as u32) < (1 << 1));
        val |= (self.attribute2_comp0 as u32) << 8;

        assert!((self.attribute2_comp1 as u32) < (1 << 1));
        val |= (self.attribute2_comp1 as u32) << 9;

        assert!((self.attribute2_comp2 as u32) < (1 << 1));
        val |= (self.attribute2_comp2 as u32) << 10;

        assert!((self.attribute2_comp3 as u32) < (1 << 1));
        val |= (self.attribute2_comp3 as u32) << 11;

        assert!((self.attribute3_comp0 as u32) < (1 << 1));
        val |= (self.attribute3_comp0 as u32) << 12;

        assert!((self.attribute3_comp1 as u32) < (1 << 1));
        val |= (self.attribute3_comp1 as u32) << 13;

        assert!((self.attribute3_comp2 as u32) < (1 << 1));
        val |= (self.attribute3_comp2 as u32) << 14;

        assert!((self.attribute3_comp3 as u32) < (1 << 1));
        val |= (self.attribute3_comp3 as u32) << 15;

        assert!((self.attribute4_comp0 as u32) < (1 << 1));
        val |= (self.attribute4_comp0 as u32) << 16;

        assert!((self.attribute4_comp1 as u32) < (1 << 1));
        val |= (self.attribute4_comp1 as u32) << 17;

        assert!((self.attribute4_comp2 as u32) < (1 << 1));
        val |= (self.attribute4_comp2 as u32) << 18;

        assert!((self.attribute4_comp3 as u32) < (1 << 1));
        val |= (self.attribute4_comp3 as u32) << 19;

        assert!((self.attribute5_comp0 as u32) < (1 << 1));
        val |= (self.attribute5_comp0 as u32) << 20;

        assert!((self.attribute5_comp1 as u32) < (1 << 1));
        val |= (self.attribute5_comp1 as u32) << 21;

        assert!((self.attribute5_comp2 as u32) < (1 << 1));
        val |= (self.attribute5_comp2 as u32) << 22;

        assert!((self.attribute5_comp3 as u32) < (1 << 1));
        val |= (self.attribute5_comp3 as u32) << 23;

        assert!((self.attribute6_comp0 as u32) < (1 << 1));
        val |= (self.attribute6_comp0 as u32) << 24;

        assert!((self.attribute6_comp1 as u32) < (1 << 1));
        val |= (self.attribute6_comp1 as u32) << 25;

        assert!((self.attribute6_comp2 as u32) < (1 << 1));
        val |= (self.attribute6_comp2 as u32) << 26;

        assert!((self.attribute6_comp3 as u32) < (1 << 1));
        val |= (self.attribute6_comp3 as u32) << 27;

        assert!((self.attribute7_comp0 as u32) < (1 << 1));
        val |= (self.attribute7_comp0 as u32) << 28;

        assert!((self.attribute7_comp1 as u32) < (1 << 1));
        val |= (self.attribute7_comp1 as u32) << 29;

        assert!((self.attribute7_comp2 as u32) < (1 << 1));
        val |= (self.attribute7_comp2 as u32) << 30;

        assert!((self.attribute7_comp3 as u32) < (1 << 1));
        val |= (self.attribute7_comp3 as u32) << 31;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaOutputAttributeSkipMaskB {
    pub attribute0_comp0: bool,
    pub attribute0_comp1: bool,
    pub attribute0_comp2: bool,
    pub attribute0_comp3: bool,
    pub attribute1_comp0: bool,
    pub attribute1_comp1: bool,
    pub attribute1_comp2: bool,
    pub attribute1_comp3: bool,
    pub attribute2_comp0: bool,
    pub attribute2_comp1: bool,
    pub attribute2_comp2: bool,
    pub attribute2_comp3: bool,
    pub attribute3_comp0: bool,
    pub attribute3_comp1: bool,
    pub attribute3_comp2: bool,
    pub attribute3_comp3: bool,
    pub attribute4_comp0: bool,
    pub attribute4_comp1: bool,
    pub attribute4_comp2: bool,
    pub attribute4_comp3: bool,
    pub attribute5_comp0: bool,
    pub attribute5_comp1: bool,
    pub attribute5_comp2: bool,
    pub attribute5_comp3: bool,
    pub attribute6_comp0: bool,
    pub attribute6_comp1: bool,
    pub attribute6_comp2: bool,
    pub attribute6_comp3: bool,
    pub attribute7_comp0: bool,
    pub attribute7_comp1: bool,
    pub attribute7_comp2: bool,
    pub attribute7_comp3: bool,
}

impl ArrayMthd for SetDaOutputAttributeSkipMaskB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1128 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.attribute0_comp0 as u32) < (1 << 1));
        val |= (self.attribute0_comp0 as u32) << 0;

        assert!((self.attribute0_comp1 as u32) < (1 << 1));
        val |= (self.attribute0_comp1 as u32) << 1;

        assert!((self.attribute0_comp2 as u32) < (1 << 1));
        val |= (self.attribute0_comp2 as u32) << 2;

        assert!((self.attribute0_comp3 as u32) < (1 << 1));
        val |= (self.attribute0_comp3 as u32) << 3;

        assert!((self.attribute1_comp0 as u32) < (1 << 1));
        val |= (self.attribute1_comp0 as u32) << 4;

        assert!((self.attribute1_comp1 as u32) < (1 << 1));
        val |= (self.attribute1_comp1 as u32) << 5;

        assert!((self.attribute1_comp2 as u32) < (1 << 1));
        val |= (self.attribute1_comp2 as u32) << 6;

        assert!((self.attribute1_comp3 as u32) < (1 << 1));
        val |= (self.attribute1_comp3 as u32) << 7;

        assert!((self.attribute2_comp0 as u32) < (1 << 1));
        val |= (self.attribute2_comp0 as u32) << 8;

        assert!((self.attribute2_comp1 as u32) < (1 << 1));
        val |= (self.attribute2_comp1 as u32) << 9;

        assert!((self.attribute2_comp2 as u32) < (1 << 1));
        val |= (self.attribute2_comp2 as u32) << 10;

        assert!((self.attribute2_comp3 as u32) < (1 << 1));
        val |= (self.attribute2_comp3 as u32) << 11;

        assert!((self.attribute3_comp0 as u32) < (1 << 1));
        val |= (self.attribute3_comp0 as u32) << 12;

        assert!((self.attribute3_comp1 as u32) < (1 << 1));
        val |= (self.attribute3_comp1 as u32) << 13;

        assert!((self.attribute3_comp2 as u32) < (1 << 1));
        val |= (self.attribute3_comp2 as u32) << 14;

        assert!((self.attribute3_comp3 as u32) < (1 << 1));
        val |= (self.attribute3_comp3 as u32) << 15;

        assert!((self.attribute4_comp0 as u32) < (1 << 1));
        val |= (self.attribute4_comp0 as u32) << 16;

        assert!((self.attribute4_comp1 as u32) < (1 << 1));
        val |= (self.attribute4_comp1 as u32) << 17;

        assert!((self.attribute4_comp2 as u32) < (1 << 1));
        val |= (self.attribute4_comp2 as u32) << 18;

        assert!((self.attribute4_comp3 as u32) < (1 << 1));
        val |= (self.attribute4_comp3 as u32) << 19;

        assert!((self.attribute5_comp0 as u32) < (1 << 1));
        val |= (self.attribute5_comp0 as u32) << 20;

        assert!((self.attribute5_comp1 as u32) < (1 << 1));
        val |= (self.attribute5_comp1 as u32) << 21;

        assert!((self.attribute5_comp2 as u32) < (1 << 1));
        val |= (self.attribute5_comp2 as u32) << 22;

        assert!((self.attribute5_comp3 as u32) < (1 << 1));
        val |= (self.attribute5_comp3 as u32) << 23;

        assert!((self.attribute6_comp0 as u32) < (1 << 1));
        val |= (self.attribute6_comp0 as u32) << 24;

        assert!((self.attribute6_comp1 as u32) < (1 << 1));
        val |= (self.attribute6_comp1 as u32) << 25;

        assert!((self.attribute6_comp2 as u32) < (1 << 1));
        val |= (self.attribute6_comp2 as u32) << 26;

        assert!((self.attribute6_comp3 as u32) < (1 << 1));
        val |= (self.attribute6_comp3 as u32) << 27;

        assert!((self.attribute7_comp0 as u32) < (1 << 1));
        val |= (self.attribute7_comp0 as u32) << 28;

        assert!((self.attribute7_comp1 as u32) < (1 << 1));
        val |= (self.attribute7_comp1 as u32) << 29;

        assert!((self.attribute7_comp2 as u32) < (1 << 1));
        val |= (self.attribute7_comp2 as u32) << 30;

        assert!((self.attribute7_comp3 as u32) < (1 << 1));
        val |= (self.attribute7_comp3 as u32) << 31;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerFormatEnable {
    pub snorm8_unorm16_snorm16: bool,
}

impl Mthd for SetBlendPerFormatEnable {
    const ADDR: u16 = 0x1140;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.snorm8_unorm16_snorm16 as u32) < (1 << 1));
        val |= (self.snorm8_unorm16_snorm16 as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FlushPendingWrites {
    pub sm_does_global_store: u32,
}

impl Mthd for FlushPendingWrites {
    const ADDR: u16 = 0x1144;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.sm_does_global_store < (1 << 1));
        val |= self.sm_does_global_store << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVabDataControlFormat {
    UnusedEnumDoNotUseBecauseItWillGoAway = 0x00000000,
    NumSnorm = 0x00000001,
    NumUnorm = 0x00000002,
    NumSint = 0x00000003,
    NumUint = 0x00000004,
    NumUscaled = 0x00000005,
    NumSscaled = 0x00000006,
    NumFloat = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabDataControl {
    pub vab_index: u32,
    pub component_count: u32,
    pub component_byte_width: u32,
    pub format: SetVabDataControlFormat,
}

impl Mthd for SetVabDataControl {
    const ADDR: u16 = 0x114c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.vab_index < (1 << 8));
        val |= self.vab_index << 0;

        assert!(self.component_count < (1 << 3));
        val |= self.component_count << 8;

        assert!(self.component_byte_width < (1 << 3));
        val |= self.component_byte_width << 12;

        assert!((self.format as u32) < (1 << 3));
        val |= (self.format as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabData {
    pub v: u32,
}

impl ArrayMthd for SetVabData {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1150 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeASource {
    Active = 0x00000000,
    Inactive = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeAComponentBitWidths {
    R32G32B32A32 = 0x00000001,
    R32G32B32 = 0x00000002,
    R16G16B16A16 = 0x00000003,
    R32G32 = 0x00000004,
    R16G16B16 = 0x00000005,
    A8B8G8R8 = 0x0000002f,
    R8G8B8A8 = 0x0000000a,
    X8B8G8R8 = 0x00000033,
    A2B10G10R10 = 0x00000030,
    B10G11R11 = 0x00000031,
    R16G16 = 0x0000000f,
    R32 = 0x00000012,
    R8G8B8 = 0x00000013,
    G8R8 = 0x00000032,
    R8G8 = 0x00000018,
    R16 = 0x0000001b,
    R8 = 0x0000001d,
    A8 = 0x00000034,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeANumericalType {
    UnusedEnumDoNotUseBecauseItWillGoAway = 0x00000000,
    NumSnorm = 0x00000001,
    NumUnorm = 0x00000002,
    NumSint = 0x00000003,
    NumUint = 0x00000004,
    NumUscaled = 0x00000005,
    NumSscaled = 0x00000006,
    NumFloat = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexAttributeA {
    pub stream: u32,
    pub source: SetVertexAttributeASource,
    pub offset: u32,
    pub component_bit_widths: SetVertexAttributeAComponentBitWidths,
    pub numerical_type: SetVertexAttributeANumericalType,
    pub swap_r_and_b: bool,
}

impl ArrayMthd for SetVertexAttributeA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1160 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.stream < (1 << 5));
        val |= self.stream << 0;

        assert!((self.source as u32) < (1 << 1));
        val |= (self.source as u32) << 6;

        assert!(self.offset < (1 << 14));
        val |= self.offset << 7;

        assert!((self.component_bit_widths as u32) < (1 << 6));
        val |= (self.component_bit_widths as u32) << 21;

        assert!((self.numerical_type as u32) < (1 << 3));
        val |= (self.numerical_type as u32) << 27;

        assert!((self.swap_r_and_b as u32) < (1 << 1));
        val |= (self.swap_r_and_b as u32) << 31;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeBSource {
    Active = 0x00000000,
    Inactive = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeBComponentBitWidths {
    R32G32B32A32 = 0x00000001,
    R32G32B32 = 0x00000002,
    R16G16B16A16 = 0x00000003,
    R32G32 = 0x00000004,
    R16G16B16 = 0x00000005,
    A8B8G8R8 = 0x0000002f,
    R8G8B8A8 = 0x0000000a,
    X8B8G8R8 = 0x00000033,
    A2B10G10R10 = 0x00000030,
    B10G11R11 = 0x00000031,
    R16G16 = 0x0000000f,
    R32 = 0x00000012,
    R8G8B8 = 0x00000013,
    G8R8 = 0x00000032,
    R8G8 = 0x00000018,
    R16 = 0x0000001b,
    R8 = 0x0000001d,
    A8 = 0x00000034,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeBNumericalType {
    UnusedEnumDoNotUseBecauseItWillGoAway = 0x00000000,
    NumSnorm = 0x00000001,
    NumUnorm = 0x00000002,
    NumSint = 0x00000003,
    NumUint = 0x00000004,
    NumUscaled = 0x00000005,
    NumSscaled = 0x00000006,
    NumFloat = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexAttributeB {
    pub stream: u32,
    pub source: SetVertexAttributeBSource,
    pub offset: u32,
    pub component_bit_widths: SetVertexAttributeBComponentBitWidths,
    pub numerical_type: SetVertexAttributeBNumericalType,
    pub swap_r_and_b: bool,
}

impl ArrayMthd for SetVertexAttributeB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x11a0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.stream < (1 << 5));
        val |= self.stream << 0;

        assert!((self.source as u32) < (1 << 1));
        val |= (self.source as u32) << 6;

        assert!(self.offset < (1 << 14));
        val |= self.offset << 7;

        assert!((self.component_bit_widths as u32) < (1 << 6));
        val |= (self.component_bit_widths as u32) << 21;

        assert!((self.numerical_type as u32) < (1 << 3));
        val |= (self.numerical_type as u32) << 27;

        assert!((self.swap_r_and_b as u32) < (1 << 1));
        val |= (self.swap_r_and_b as u32) << 31;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawVertexArrayBeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArrayBeginEndInstanceFirst {
    pub start_index: u32,
    pub count: u32,
    pub topology: DrawVertexArrayBeginEndInstanceFirstTopology,
}

impl Mthd for DrawVertexArrayBeginEndInstanceFirst {
    const ADDR: u16 = 0x1214;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.start_index < (1 << 16));
        val |= self.start_index << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawVertexArrayBeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArrayBeginEndInstanceSubsequent {
    pub start_index: u32,
    pub count: u32,
    pub topology: DrawVertexArrayBeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawVertexArrayBeginEndInstanceSubsequent {
    const ADDR: u16 = 0x1218;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.start_index < (1 << 16));
        val |= self.start_index << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtSelect {
    pub target_count: u32,
    pub target0: u32,
    pub target1: u32,
    pub target2: u32,
    pub target3: u32,
    pub target4: u32,
    pub target5: u32,
    pub target6: u32,
    pub target7: u32,
}

impl Mthd for SetCtSelect {
    const ADDR: u16 = 0x121c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.target_count < (1 << 4));
        val |= self.target_count << 0;

        assert!(self.target0 < (1 << 3));
        val |= self.target0 << 4;

        assert!(self.target1 < (1 << 3));
        val |= self.target1 << 7;

        assert!(self.target2 < (1 << 3));
        val |= self.target2 << 10;

        assert!(self.target3 < (1 << 3));
        val |= self.target3 << 13;

        assert!(self.target4 < (1 << 3));
        val |= self.target4 << 16;

        assert!(self.target5 < (1 << 3));
        val |= self.target5 << 19;

        assert!(self.target6 < (1 << 3));
        val |= self.target6 << 22;

        assert!(self.target7 < (1 << 3));
        val |= self.target7 << 25;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetCompressionThresholdSamples {
    _0 = 0x00000000,
    _1 = 0x00000001,
    _2 = 0x00000002,
    _4 = 0x00000003,
    _8 = 0x00000004,
    _16 = 0x00000005,
    _32 = 0x00000006,
    _64 = 0x00000007,
    _128 = 0x00000008,
    _256 = 0x00000009,
    _512 = 0x0000000a,
    _1024 = 0x0000000b,
    _2048 = 0x0000000c,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCompressionThreshold {
    pub samples: SetCompressionThresholdSamples,
}

impl Mthd for SetCompressionThreshold {
    const ADDR: u16 = 0x1220;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.samples as u32) < (1 << 4));
        val |= (self.samples as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSizeA {
    pub width: u32,
}

impl Mthd for SetZtSizeA {
    const ADDR: u16 = 0x1228;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.width < (1 << 28));
        val |= self.width << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSizeB {
    pub height: u32,
}

impl Mthd for SetZtSizeB {
    const ADDR: u16 = 0x122c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.height < (1 << 17));
        val |= self.height << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtSizeCControl {
    ThirdDimensionDefinesArraySize = 0x00000000,
    ArraySizeIsOne = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSizeC {
    pub third_dimension: u32,
    pub control: SetZtSizeCControl,
}

impl Mthd for SetZtSizeC {
    const ADDR: u16 = 0x1230;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.third_dimension < (1 << 16));
        val |= self.third_dimension << 0;

        assert!((self.control as u32) < (1 << 1));
        val |= (self.control as u32) << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSamplerBindingV {
    Independently = 0x00000000,
    ViaHeaderBinding = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSamplerBinding {
    pub v: SetSamplerBindingV,
}

impl Mthd for SetSamplerBinding {
    const ADDR: u16 = 0x1234;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawAuto {
    pub byte_count: u32,
}

impl Mthd for DrawAuto {
    const ADDR: u16 = 0x123c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.byte_count;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetCircularBufferSize {
    const ADDR: u16 = 0x1280;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.cache_lines_per_sm < (1 << 10));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVtgRegisterWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetVtgRegisterWatermarks {
    const ADDR: u16 = 0x1284;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.low < (1 << 16));
        val |= self.low << 0;

        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCacheNoWfi {
    pub lines: InvalidateTextureDataCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCacheNoWfi {
    const ADDR: u16 = 0x1288;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopInterlockedReadRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopInterlockedReadRequests {
    pub policy: SetL2CacheControlForRopInterlockedReadRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopInterlockedReadRequests {
    const ADDR: u16 = 0x1290;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartIndexTopologyChange {
    pub v: u32,
}

impl Mthd for SetDaPrimitiveRestartIndexTopologyChange {
    const ADDR: u16 = 0x12a4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderSchedulingMode {
    OldestThreadFirst = 0x00000000,
    RoundRobin = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderScheduling {
    pub mode: SetShaderSchedulingMode,
}

impl Mthd for SetShaderScheduling {
    const ADDR: u16 = 0x12ac;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearZcullRegion {
    pub z_enable: bool,
    pub stencil_enable: bool,
    pub use_clear_rect: bool,
    pub use_rt_array_index: bool,
    pub rt_array_index: u32,
    pub make_conservative: bool,
}

impl Mthd for ClearZcullRegion {
    const ADDR: u16 = 0x12c8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;

        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 4;

        assert!((self.use_clear_rect as u32) < (1 << 1));
        val |= (self.use_clear_rect as u32) << 1;

        assert!((self.use_rt_array_index as u32) < (1 << 1));
        val |= (self.use_rt_array_index as u32) << 2;

        assert!(self.rt_array_index < (1 << 16));
        val |= self.rt_array_index << 5;

        assert!((self.make_conservative as u32) < (1 << 1));
        val |= (self.make_conservative as u32) << 3;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthTest {
    pub enable: bool,
}

impl Mthd for SetDepthTest {
    const ADDR: u16 = 0x12cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetFillModeV {
    Point = 0x00000001,
    Wireframe = 0x00000002,
    Solid = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFillMode {
    pub v: SetFillModeV,
}

impl Mthd for SetFillMode {
    const ADDR: u16 = 0x12d0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShadeModeV {
    Flat = 0x00000001,
    Gouraud = 0x00000002,
    OglFlat = 0x00001d00,
    OglSmooth = 0x00001d01,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadeMode {
    pub v: SetShadeModeV,
}

impl Mthd for SetShadeMode {
    const ADDR: u16 = 0x12d4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopNoninterlockedWriteRequests {
    pub policy: SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopNoninterlockedWriteRequests {
    const ADDR: u16 = 0x12d8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopInterlockedWriteRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopInterlockedWriteRequests {
    pub policy: SetL2CacheControlForRopInterlockedWriteRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopInterlockedWriteRequests {
    const ADDR: u16 = 0x12dc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaToCoverageDitherControlDitherFootprint {
    Pixels1X1 = 0x00000000,
    Pixels2X2 = 0x00000001,
    Pixels1X1VirtualSamples = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaToCoverageDitherControl {
    pub dither_footprint: SetAlphaToCoverageDitherControlDitherFootprint,
}

impl Mthd for SetAlphaToCoverageDitherControl {
    const ADDR: u16 = 0x12e0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.dither_footprint as u32) < (1 << 4));
        val |= (self.dither_footprint as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendStatePerTarget {
    pub enable: bool,
}

impl Mthd for SetBlendStatePerTarget {
    const ADDR: u16 = 0x12e4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthWrite {
    pub enable: bool,
}

impl Mthd for SetDepthWrite {
    const ADDR: u16 = 0x12e8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaTest {
    pub enable: bool,
}

impl Mthd for SetAlphaTest {
    const ADDR: u16 = 0x12ec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineIndex4X8Align {
    pub count: u32,
    pub start: u32,
}

impl Mthd for SetInlineIndex4X8Align {
    const ADDR: u16 = 0x1300;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.count < (1 << 30));
        val |= self.count << 0;

        assert!(self.start < (1 << 2));
        val |= self.start << 30;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineIndex4X8 {
    pub index0: u32,
    pub index1: u32,
    pub index2: u32,
    pub index3: u32,
}

impl Mthd for DrawInlineIndex4X8 {
    const ADDR: u16 = 0x1304;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.index0 < (1 << 8));
        val |= self.index0 << 0;

        assert!(self.index1 < (1 << 8));
        val |= self.index1 << 8;

        assert!(self.index2 < (1 << 8));
        val |= self.index2 << 16;

        assert!(self.index3 < (1 << 8));
        val |= self.index3 << 24;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum D3DSetCullModeV {
    None = 0x00000001,
    Cw = 0x00000002,
    Ccw = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct D3DSetCullMode {
    pub v: D3DSetCullModeV,
}

impl Mthd for D3DSetCullMode {
    const ADDR: u16 = 0x1308;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDepthFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthFunc {
    pub v: SetDepthFuncV,
}

impl Mthd for SetDepthFunc {
    const ADDR: u16 = 0x130c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaRef {
    pub v: u32,
}

impl Mthd for SetAlphaRef {
    const ADDR: u16 = 0x1310;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaFunc {
    pub v: SetAlphaFuncV,
}

impl Mthd for SetAlphaFunc {
    const ADDR: u16 = 0x1314;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawAutoStride {
    pub v: u32,
}

impl Mthd for SetDrawAutoStride {
    const ADDR: u16 = 0x1318;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 12));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstRed {
    pub v: f32,
}

impl Mthd for SetBlendConstRed {
    const ADDR: u16 = 0x131c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstGreen {
    pub v: f32,
}

impl Mthd for SetBlendConstGreen {
    const ADDR: u16 = 0x1320;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstBlue {
    pub v: f32,
}

impl Mthd for SetBlendConstBlue {
    const ADDR: u16 = 0x1324;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstAlpha {
    pub v: f32,
}

impl Mthd for SetBlendConstAlpha {
    const ADDR: u16 = 0x1328;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCache {
    pub lines: InvalidateSamplerCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCache {
    const ADDR: u16 = 0x1330;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCache {
    pub lines: InvalidateTextureHeaderCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCache {
    const ADDR: u16 = 0x1334;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLevels {
    L1Only = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
    pub levels: InvalidateTextureDataCacheLevels,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        assert!((self.levels as u32) < (1 << 2));
        val |= (self.levels as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendSeparateForAlpha {
    pub enable: bool,
}

impl Mthd for SetBlendSeparateForAlpha {
    const ADDR: u16 = 0x133c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendColorOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendColorOp {
    pub v: SetBlendColorOpV,
}

impl Mthd for SetBlendColorOp {
    const ADDR: u16 = 0x1340;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendColorSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendColorSourceCoeff {
    pub v: SetBlendColorSourceCoeffV,
}

impl Mthd for SetBlendColorSourceCoeff {
    const ADDR: u16 = 0x1344;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendColorDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendColorDestCoeff {
    pub v: SetBlendColorDestCoeffV,
}

impl Mthd for SetBlendColorDestCoeff {
    const ADDR: u16 = 0x1348;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendAlphaOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendAlphaOp {
    pub v: SetBlendAlphaOpV,
}

impl Mthd for SetBlendAlphaOp {
    const ADDR: u16 = 0x134c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendAlphaSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendAlphaSourceCoeff {
    pub v: SetBlendAlphaSourceCoeffV,
}

impl Mthd for SetBlendAlphaSourceCoeff {
    const ADDR: u16 = 0x1350;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalColorKey {
    pub enable: bool,
}

impl Mthd for SetGlobalColorKey {
    const ADDR: u16 = 0x1354;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendAlphaDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendAlphaDestCoeff {
    pub v: SetBlendAlphaDestCoeffV,
}

impl Mthd for SetBlendAlphaDestCoeff {
    const ADDR: u16 = 0x1358;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSingleRopControl {
    pub enable: bool,
}

impl Mthd for SetSingleRopControl {
    const ADDR: u16 = 0x135c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlend {
    pub enable: bool,
}

impl ArrayMthd for SetBlend {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1360 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilTest {
    pub enable: bool,
}

impl Mthd for SetStencilTest {
    const ADDR: u16 = 0x1380;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilOpFailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilOpFail {
    pub v: SetStencilOpFailV,
}

impl Mthd for SetStencilOpFail {
    const ADDR: u16 = 0x1384;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilOpZfailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilOpZfail {
    pub v: SetStencilOpZfailV,
}

impl Mthd for SetStencilOpZfail {
    const ADDR: u16 = 0x1388;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilOpZpassV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilOpZpass {
    pub v: SetStencilOpZpassV,
}

impl Mthd for SetStencilOpZpass {
    const ADDR: u16 = 0x138c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilFunc {
    pub v: SetStencilFuncV,
}

impl Mthd for SetStencilFunc {
    const ADDR: u16 = 0x1390;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilFuncRef {
    pub v: u32,
}

impl Mthd for SetStencilFuncRef {
    const ADDR: u16 = 0x1394;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilFuncMask {
    pub v: u32,
}

impl Mthd for SetStencilFuncMask {
    const ADDR: u16 = 0x1398;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilMask {
    pub v: u32,
}

impl Mthd for SetStencilMask {
    const ADDR: u16 = 0x139c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawAutoStart {
    pub byte_count: u32,
}

impl Mthd for SetDrawAutoStart {
    const ADDR: u16 = 0x13a4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.byte_count;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsSaturate {
    pub output0: bool,
    pub output1: bool,
    pub output2: bool,
    pub output3: bool,
    pub output4: bool,
    pub output5: bool,
    pub output6: bool,
    pub output7: bool,
}

impl Mthd for SetPsSaturate {
    const ADDR: u16 = 0x13a8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.output0 as u32) < (1 << 1));
        val |= (self.output0 as u32) << 0;

        assert!((self.output1 as u32) < (1 << 1));
        val |= (self.output1 as u32) << 4;

        assert!((self.output2 as u32) < (1 << 1));
        val |= (self.output2 as u32) << 8;

        assert!((self.output3 as u32) < (1 << 1));
        val |= (self.output3 as u32) << 12;

        assert!((self.output4 as u32) < (1 << 1));
        val |= (self.output4 as u32) << 16;

        assert!((self.output5 as u32) < (1 << 1));
        val |= (self.output5 as u32) << 20;

        assert!((self.output6 as u32) < (1 << 1));
        val |= (self.output6 as u32) << 24;

        assert!((self.output7 as u32) < (1 << 1));
        val |= (self.output7 as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetWindowOriginMode {
    UpperLeft = 0x00000000,
    LowerLeft = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowOrigin {
    pub mode: SetWindowOriginMode,
    pub flip_y: bool,
}

impl Mthd for SetWindowOrigin {
    const ADDR: u16 = 0x13ac;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;

        assert!((self.flip_y as u32) < (1 << 1));
        val |= (self.flip_y as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineWidthFloat {
    pub v: f32,
}

impl Mthd for SetLineWidthFloat {
    const ADDR: u16 = 0x13b0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAliasedLineWidthFloat {
    pub v: f32,
}

impl Mthd for SetAliasedLineWidthFloat {
    const ADDR: u16 = 0x13b4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineMultisampleOverride {
    pub enable: bool,
}

impl Mthd for SetLineMultisampleOverride {
    const ADDR: u16 = 0x1418;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaHysteresis {
    pub rounds_of_alpha: u32,
}

impl Mthd for SetAlphaHysteresis {
    const ADDR: u16 = 0x1420;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.rounds_of_alpha < (1 << 8));
        val |= self.rounds_of_alpha << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheNoWfi {
    pub lines: InvalidateSamplerCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCacheNoWfi {
    const ADDR: u16 = 0x1424;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheNoWfi {
    pub lines: InvalidateTextureHeaderCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCacheNoWfi {
    const ADDR: u16 = 0x1428;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateDaDmaCache {
    pub v: u32,
}

impl Mthd for InvalidateDaDmaCache {
    const ADDR: u16 = 0x142c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct XXXSetReduceDstColor {
    pub unorm_enable: bool,
    pub srgb_enable: bool,
}

impl Mthd for XXXSetReduceDstColor {
    const ADDR: u16 = 0x1430;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.unorm_enable as u32) < (1 << 1));
        val |= (self.unorm_enable as u32) << 4;

        assert!((self.srgb_enable as u32) < (1 << 1));
        val |= (self.srgb_enable as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalBaseVertexIndex {
    pub v: u32,
}

impl Mthd for SetGlobalBaseVertexIndex {
    const ADDR: u16 = 0x1434;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalBaseInstanceIndex {
    pub v: u32,
}

impl Mthd for SetGlobalBaseInstanceIndex {
    const ADDR: u16 = 0x1438;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct XXXSetClearControl {
    pub respect_stencil_mask: bool,
    pub use_clear_rect: bool,
}

impl Mthd for XXXSetClearControl {
    const ADDR: u16 = 0x143c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.respect_stencil_mask as u32) < (1 << 1));
        val |= (self.respect_stencil_mask as u32) << 0;

        assert!((self.use_clear_rect as u32) < (1 << 1));
        val |= (self.use_clear_rect as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsWarpWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetPsWarpWatermarks {
    const ADDR: u16 = 0x1450;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.low < (1 << 16));
        val |= self.low << 0;

        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsRegisterWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetPsRegisterWatermarks {
    const ADDR: u16 = 0x1454;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.low < (1 << 16));
        val |= self.low << 0;

        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StoreZcull {
    pub v: u32,
}

impl Mthd for StoreZcull {
    const ADDR: u16 = 0x1464;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadZcull {
    pub v: u32,
}

impl Mthd for LoadZcull {
    const ADDR: u16 = 0x1500;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdHeight {
    pub v: u32,
}

impl Mthd for SetSurfaceClipIdHeight {
    const ADDR: u16 = 0x1504;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdClearRectHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl Mthd for SetClipIdClearRectHorizontal {
    const ADDR: u16 = 0x1508;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;

        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdClearRectVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl Mthd for SetClipIdClearRectVertical {
    const ADDR: u16 = 0x150c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;

        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetUserClipEnable {
    pub plane0: bool,
    pub plane1: bool,
    pub plane2: bool,
    pub plane3: bool,
    pub plane4: bool,
    pub plane5: bool,
    pub plane6: bool,
    pub plane7: bool,
}

impl Mthd for SetUserClipEnable {
    const ADDR: u16 = 0x1510;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.plane0 as u32) < (1 << 1));
        val |= (self.plane0 as u32) << 0;

        assert!((self.plane1 as u32) < (1 << 1));
        val |= (self.plane1 as u32) << 1;

        assert!((self.plane2 as u32) < (1 << 1));
        val |= (self.plane2 as u32) << 2;

        assert!((self.plane3 as u32) < (1 << 1));
        val |= (self.plane3 as u32) << 3;

        assert!((self.plane4 as u32) < (1 << 1));
        val |= (self.plane4 as u32) << 4;

        assert!((self.plane5 as u32) < (1 << 1));
        val |= (self.plane5 as u32) << 5;

        assert!((self.plane6 as u32) < (1 << 1));
        val |= (self.plane6 as u32) << 6;

        assert!((self.plane7 as u32) < (1 << 1));
        val |= (self.plane7 as u32) << 7;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZpassPixelCount {
    pub enable: bool,
}

impl Mthd for SetZpassPixelCount {
    const ADDR: u16 = 0x1514;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointSize {
    pub v: u32,
}

impl Mthd for SetPointSize {
    const ADDR: u16 = 0x1518;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStats {
    pub enable: bool,
}

impl Mthd for SetZcullStats {
    const ADDR: u16 = 0x151c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointSprite {
    pub enable: bool,
}

impl Mthd for SetPointSprite {
    const ADDR: u16 = 0x1520;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderExceptions {
    pub enable: bool,
}

impl Mthd for SetShaderExceptions {
    const ADDR: u16 = 0x1528;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ClearReportValueType {
    DaVerticesGenerated = 0x00000012,
    DaPrimitivesGenerated = 0x00000013,
    VsInvocations = 0x00000015,
    TiInvocations = 0x00000016,
    TsInvocations = 0x00000017,
    TsPrimitivesGenerated = 0x00000018,
    GsInvocations = 0x0000001a,
    GsPrimitivesGenerated = 0x0000001b,
    VtgPrimitivesOut = 0x0000001f,
    StreamingPrimitivesSucceeded = 0x00000010,
    StreamingPrimitivesNeeded = 0x00000011,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x00000003,
    ClipperInvocations = 0x0000001c,
    ClipperPrimitivesGenerated = 0x0000001d,
    ZcullStats = 0x00000002,
    PsInvocations = 0x0000001e,
    ZpassPixelCnt = 0x00000001,
    AlphaBetaClocks = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearReportValue {
    pub type_: ClearReportValueType,
}

impl Mthd for ClearReportValue {
    const ADDR: u16 = 0x1530;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 5));
        val |= (self.type_ as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasEnable {
    pub v: bool,
}

impl Mthd for SetAntiAliasEnable {
    const ADDR: u16 = 0x1534;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSelect {
    pub target_count: u32,
}

impl Mthd for SetZtSelect {
    const ADDR: u16 = 0x1538;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.target_count < (1 << 1));
        val |= self.target_count << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasAlphaControlAlphaToCoverage {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasAlphaControlAlphaToOne {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasAlphaControl {
    pub alpha_to_coverage: SetAntiAliasAlphaControlAlphaToCoverage,
    pub alpha_to_one: SetAntiAliasAlphaControlAlphaToOne,
}

impl Mthd for SetAntiAliasAlphaControl {
    const ADDR: u16 = 0x153c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.alpha_to_coverage as u32) < (1 << 1));
        val |= (self.alpha_to_coverage as u32) << 0;

        assert!((self.alpha_to_one as u32) < (1 << 1));
        val |= (self.alpha_to_one as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexSamplerPoolA {
    const ADDR: u16 = 0x155c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexSamplerPoolB {
    const ADDR: u16 = 0x1560;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexSamplerPoolC {
    const ADDR: u16 = 0x1564;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.maximum_index < (1 << 20));
        val |= self.maximum_index << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSlopeScaleDepthBias {
    pub v: f32,
}

impl Mthd for SetSlopeScaleDepthBias {
    const ADDR: u16 = 0x156c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasedLine {
    pub enable: bool,
}

impl Mthd for SetAntiAliasedLine {
    const ADDR: u16 = 0x1570;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexHeaderPoolA {
    const ADDR: u16 = 0x1574;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexHeaderPoolB {
    const ADDR: u16 = 0x1578;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexHeaderPoolC {
    const ADDR: u16 = 0x157c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.maximum_index < (1 << 22));
        val |= self.maximum_index << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetActiveZcullRegion {
    pub id: u32,
}

impl Mthd for SetActiveZcullRegion {
    const ADDR: u16 = 0x1590;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.id < (1 << 6));
        val |= self.id << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTwoSidedStencilTest {
    pub enable: bool,
}

impl Mthd for SetTwoSidedStencilTest {
    const ADDR: u16 = 0x1594;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilOpFailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilOpFail {
    pub v: SetBackStencilOpFailV,
}

impl Mthd for SetBackStencilOpFail {
    const ADDR: u16 = 0x1598;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilOpZfailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilOpZfail {
    pub v: SetBackStencilOpZfailV,
}

impl Mthd for SetBackStencilOpZfail {
    const ADDR: u16 = 0x159c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilOpZpassV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilOpZpass {
    pub v: SetBackStencilOpZpassV,
}

impl Mthd for SetBackStencilOpZpass {
    const ADDR: u16 = 0x15a0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilFunc {
    pub v: SetBackStencilFuncV,
}

impl Mthd for SetBackStencilFunc {
    const ADDR: u16 = 0x15a4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrgbWrite {
    pub enable: bool,
}

impl Mthd for SetSrgbWrite {
    const ADDR: u16 = 0x15b8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBias {
    pub v: f32,
}

impl Mthd for SetDepthBias {
    const ADDR: u16 = 0x15bc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullRegionFormatType {
    Z4X4 = 0x00000000,
    Zs4X4 = 0x00000001,
    Z4X2 = 0x00000002,
    Z2X4 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionFormat {
    pub type_: SetZcullRegionFormatType,
}

impl Mthd for SetZcullRegionFormat {
    const ADDR: u16 = 0x15c8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 2));
        val |= (self.type_ as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRtLayerControl {
    VSelectsLayer = 0x00000000,
    GeometryShaderSelectsLayer = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRtLayer {
    pub v: u32,
    pub control: SetRtLayerControl,
}

impl Mthd for SetRtLayer {
    const ADDR: u16 = 0x15cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        assert!((self.control as u32) < (1 << 1));
        val |= (self.control as u32) << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasSamples {
    Mode1X1 = 0x00000000,
    Mode2X1 = 0x00000001,
    Mode2X2 = 0x00000002,
    Mode4X2 = 0x00000003,
    Mode4X2D3D = 0x00000004,
    Mode2X1D3D = 0x00000005,
    Mode4X4 = 0x00000006,
    Mode2X2Vc4 = 0x00000008,
    Mode2X2Vc12 = 0x00000009,
    Mode4X2Vc8 = 0x0000000a,
    Mode4X2Vc24 = 0x0000000b,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAlias {
    pub samples: SetAntiAliasSamples,
}

impl Mthd for SetAntiAlias {
    const ADDR: u16 = 0x15d0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.samples as u32) < (1 << 4));
        val |= (self.samples as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetEdgeFlag {
    pub v: bool,
}

impl Mthd for SetEdgeFlag {
    const ADDR: u16 = 0x15e4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineIndex {
    pub v: u32,
}

impl Mthd for DrawInlineIndex {
    const ADDR: u16 = 0x15e8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineIndex2X16Align {
    pub count: u32,
    pub start_odd: bool,
}

impl Mthd for SetInlineIndex2X16Align {
    const ADDR: u16 = 0x15ec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.count < (1 << 31));
        val |= self.count << 0;

        assert!((self.start_odd as u32) < (1 << 1));
        val |= (self.start_odd as u32) << 31;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineIndex2X16 {
    pub even: u32,
    pub odd: u32,
}

impl Mthd for DrawInlineIndex2X16 {
    const ADDR: u16 = 0x15f0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.even < (1 << 16));
        val |= self.even << 0;

        assert!(self.odd < (1 << 16));
        val |= self.odd << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexGlobalBaseOffsetA {
    pub upper: u32,
}

impl Mthd for SetVertexGlobalBaseOffsetA {
    const ADDR: u16 = 0x15f4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexGlobalBaseOffsetB {
    pub lower: u32,
}

impl Mthd for SetVertexGlobalBaseOffsetB {
    const ADDR: u16 = 0x15f8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionPixelOffsetA {
    pub width: u32,
}

impl Mthd for SetZcullRegionPixelOffsetA {
    const ADDR: u16 = 0x15fc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.width < (1 << 16));
        val |= self.width << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionPixelOffsetB {
    pub height: u32,
}

impl Mthd for SetZcullRegionPixelOffsetB {
    const ADDR: u16 = 0x1600;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.height < (1 << 16));
        val |= self.height << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectRmode {
    Zero = 0x00000000,
    FromR = 0x00000001,
    FromS = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectOrigin {
    Bottom = 0x00000000,
    Top = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture0 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture1 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture2 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture3 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture4 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture5 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture6 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture7 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture8 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture9 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointSpriteSelect {
    pub rmode: SetPointSpriteSelectRmode,
    pub origin: SetPointSpriteSelectOrigin,
    pub texture0: SetPointSpriteSelectTexture0,
    pub texture1: SetPointSpriteSelectTexture1,
    pub texture2: SetPointSpriteSelectTexture2,
    pub texture3: SetPointSpriteSelectTexture3,
    pub texture4: SetPointSpriteSelectTexture4,
    pub texture5: SetPointSpriteSelectTexture5,
    pub texture6: SetPointSpriteSelectTexture6,
    pub texture7: SetPointSpriteSelectTexture7,
    pub texture8: SetPointSpriteSelectTexture8,
    pub texture9: SetPointSpriteSelectTexture9,
}

impl Mthd for SetPointSpriteSelect {
    const ADDR: u16 = 0x1604;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.rmode as u32) < (1 << 2));
        val |= (self.rmode as u32) << 0;

        assert!((self.origin as u32) < (1 << 1));
        val |= (self.origin as u32) << 2;

        assert!((self.texture0 as u32) < (1 << 1));
        val |= (self.texture0 as u32) << 3;

        assert!((self.texture1 as u32) < (1 << 1));
        val |= (self.texture1 as u32) << 4;

        assert!((self.texture2 as u32) < (1 << 1));
        val |= (self.texture2 as u32) << 5;

        assert!((self.texture3 as u32) < (1 << 1));
        val |= (self.texture3 as u32) << 6;

        assert!((self.texture4 as u32) < (1 << 1));
        val |= (self.texture4 as u32) << 7;

        assert!((self.texture5 as u32) < (1 << 1));
        val |= (self.texture5 as u32) << 8;

        assert!((self.texture6 as u32) < (1 << 1));
        val |= (self.texture6 as u32) << 9;

        assert!((self.texture7 as u32) < (1 << 1));
        val |= (self.texture7 as u32) << 10;

        assert!((self.texture8 as u32) < (1 << 1));
        val |= (self.texture8 as u32) << 11;

        assert!((self.texture9 as u32) < (1 << 1));
        val |= (self.texture9 as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionA {
    pub address_upper: u32,
}

impl Mthd for SetProgramRegionA {
    const ADDR: u16 = 0x1608;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionB {
    pub address_lower: u32,
}

impl Mthd for SetProgramRegionB {
    const ADDR: u16 = 0x160c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultColorFrontDiffuse {
    Vector0001 = 0x00000000,
    Vector1111 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultColorFrontSpecular {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultGenericVector {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultFixedFncTexture {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultDx9Color0 {
    Vector0001 = 0x00000000,
    Vector1111 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultDx9Color1ToColor15 {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAttributeDefault {
    pub color_front_diffuse: SetAttributeDefaultColorFrontDiffuse,
    pub color_front_specular: SetAttributeDefaultColorFrontSpecular,
    pub generic_vector: SetAttributeDefaultGenericVector,
    pub fixed_fnc_texture: SetAttributeDefaultFixedFncTexture,
    pub dx9_color0: SetAttributeDefaultDx9Color0,
    pub dx9_color1_to_color15: SetAttributeDefaultDx9Color1ToColor15,
}

impl Mthd for SetAttributeDefault {
    const ADDR: u16 = 0x1610;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.color_front_diffuse as u32) < (1 << 1));
        val |= (self.color_front_diffuse as u32) << 0;

        assert!((self.color_front_specular as u32) < (1 << 1));
        val |= (self.color_front_specular as u32) << 1;

        assert!((self.generic_vector as u32) < (1 << 1));
        val |= (self.generic_vector as u32) << 2;

        assert!((self.fixed_fnc_texture as u32) < (1 << 1));
        val |= (self.fixed_fnc_texture as u32) << 3;

        assert!((self.dx9_color0 as u32) < (1 << 1));
        val |= (self.dx9_color0 as u32) << 4;

        assert!((self.dx9_color1_to_color15 as u32) < (1 << 1));
        val |= (self.dx9_color1_to_color15 as u32) << 5;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct End {
    pub v: u32,
}

impl Mthd for End {
    const ADDR: u16 = 0x1614;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginOp {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginPrimitiveId {
    First = 0x00000000,
    Unchanged = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginInstanceId {
    First = 0x00000000,
    Subsequent = 0x00000001,
    Unchanged = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginSplitMode {
    NormalBeginNormalEnd = 0x00000000,
    NormalBeginOpenEnd = 0x00000001,
    OpenBeginOpenEnd = 0x00000002,
    OpenBeginNormalEnd = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Begin {
    pub op: BeginOp,
    pub primitive_id: BeginPrimitiveId,
    pub instance_id: BeginInstanceId,
    pub split_mode: BeginSplitMode,
}

impl Mthd for Begin {
    const ADDR: u16 = 0x1618;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.op as u32) < (1 << 16));
        val |= (self.op as u32) << 0;

        assert!((self.primitive_id as u32) < (1 << 1));
        val |= (self.primitive_id as u32) << 24;

        assert!((self.instance_id as u32) < (1 << 2));
        val |= (self.instance_id as u32) << 26;

        assert!((self.split_mode as u32) < (1 << 2));
        val |= (self.split_mode as u32) << 29;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexIdCopy {
    pub enable: bool,
    pub attribute_slot: u32,
}

impl Mthd for SetVertexIdCopy {
    const ADDR: u16 = 0x161c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!(self.attribute_slot < (1 << 8));
        val |= self.attribute_slot << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct AddToPrimitiveId {
    pub v: u32,
}

impl Mthd for AddToPrimitiveId {
    const ADDR: u16 = 0x1620;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadPrimitiveId {
    pub v: u32,
}

impl Mthd for LoadPrimitiveId {
    const ADDR: u16 = 0x1624;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderBasedCull {
    pub batch_cull_enable: bool,
    pub before_fetch_enable: bool,
}

impl Mthd for SetShaderBasedCull {
    const ADDR: u16 = 0x162c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.batch_cull_enable as u32) < (1 << 1));
        val |= (self.batch_cull_enable as u32) << 1;

        assert!((self.before_fetch_enable as u32) < (1 << 1));
        val |= (self.before_fetch_enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderIsaVersion {
    pub minor_sub: u32,
    pub minor: u32,
    pub major: u32,
}

impl Mthd for SetShaderIsaVersion {
    const ADDR: u16 = 0x1634;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.minor_sub < (1 << 8));
        val |= self.minor_sub << 0;

        assert!(self.minor < (1 << 8));
        val |= self.minor << 8;

        assert!(self.major < (1 << 8));
        val |= self.major << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFermiClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetFermiClassVersion {
    const ADDR: u16 = 0x1638;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVabPageReadSelect {
    Pages0And1 = 0x00000000,
    Pages0And2 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabPage {
    pub read_select: SetVabPageReadSelect,
}

impl Mthd for SetVabPage {
    const ADDR: u16 = 0x163c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.read_select as u32) < (1 << 1));
        val |= (self.read_select as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineVertex {
    pub v: u32,
}

impl Mthd for DrawInlineVertex {
    const ADDR: u16 = 0x1640;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestart {
    pub enable: bool,
}

impl Mthd for SetDaPrimitiveRestart {
    const ADDR: u16 = 0x1644;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartIndex {
    pub v: u32,
}

impl Mthd for SetDaPrimitiveRestartIndex {
    const ADDR: u16 = 0x1648;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaOutput {
    pub vertex_id_uses_array_start: bool,
}

impl Mthd for SetDaOutput {
    const ADDR: u16 = 0x164c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.vertex_id_uses_array_start as u32) < (1 << 1));
        val |= (self.vertex_id_uses_array_start as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasedPoint {
    pub enable: bool,
}

impl Mthd for SetAntiAliasedPoint {
    const ADDR: u16 = 0x1658;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointCenterModeV {
    Ogl = 0x00000000,
    D3D = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointCenterMode {
    pub v: SetPointCenterModeV,
}

impl Mthd for SetPointCenterMode {
    const ADDR: u16 = 0x165c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetCubemapInterFaceFilteringMode {
    UseWrap = 0x00000000,
    OverrideWrap = 0x00000001,
    AutoSpanSeam = 0x00000002,
    AutoCrossSeam = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCubemapInterFaceFiltering {
    pub mode: SetCubemapInterFaceFilteringMode,
}

impl Mthd for SetCubemapInterFaceFiltering {
    const ADDR: u16 = 0x1664;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 1;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetLineSmoothParametersFalloff {
    _100 = 0x00000000,
    _133 = 0x00000001,
    _160 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineSmoothParameters {
    pub falloff: SetLineSmoothParametersFalloff,
}

impl Mthd for SetLineSmoothParameters {
    const ADDR: u16 = 0x1668;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.falloff as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineStipple {
    pub enable: bool,
}

impl Mthd for SetLineStipple {
    const ADDR: u16 = 0x166c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineSmoothEdgeTable {
    pub v0: u32,
    pub v1: u32,
    pub v2: u32,
    pub v3: u32,
}

impl ArrayMthd for SetLineSmoothEdgeTable {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1670 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v0 < (1 << 8));
        val |= self.v0 << 0;

        assert!(self.v1 < (1 << 8));
        val |= self.v1 << 8;

        assert!(self.v2 < (1 << 8));
        val |= self.v2 << 16;

        assert!(self.v3 < (1 << 8));
        val |= self.v3 << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineStippleParameters {
    pub factor: u32,
    pub pattern: u32,
}

impl Mthd for SetLineStippleParameters {
    const ADDR: u16 = 0x1680;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.factor < (1 << 8));
        val |= self.factor << 0;

        assert!(self.pattern < (1 << 16));
        val |= self.pattern << 8;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetProvokingVertexV {
    First = 0x00000000,
    Last = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProvokingVertex {
    pub v: SetProvokingVertexV,
}

impl Mthd for SetProvokingVertex {
    const ADDR: u16 = 0x1684;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTwoSidedLight {
    pub enable: bool,
}

impl Mthd for SetTwoSidedLight {
    const ADDR: u16 = 0x1688;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolygonStipple {
    pub enable: bool,
}

impl Mthd for SetPolygonStipple {
    const ADDR: u16 = 0x168c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlDefaultPartial {
    Zero = 0x00000000,
    Infinity = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderControl {
    pub default_partial: SetShaderControlDefaultPartial,
    pub zero_times_anything_is_zero: bool,
}

impl Mthd for SetShaderControl {
    const ADDR: u16 = 0x1690;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.default_partial as u32) < (1 << 1));
        val |= (self.default_partial as u32) << 0;

        assert!((self.zero_times_anything_is_zero as u32) < (1 << 1));
        val |= (self.zero_times_anything_is_zero as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchVertex {
    pub v: u32,
}

impl Mthd for LaunchVertex {
    const ADDR: u16 = 0x169c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckFermiClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckFermiClassVersion {
    const ADDR: u16 = 0x16a0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSphVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetSphVersion {
    const ADDR: u16 = 0x16a4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckSphVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckSphVersion {
    const ADDR: u16 = 0x16a8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaToCoverageOverrideQualifyByAntiAliasEnable {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaToCoverageOverride {
    pub qualify_by_anti_alias_enable: SetAlphaToCoverageOverrideQualifyByAntiAliasEnable,
    pub qualify_by_ps_sample_mask_output: SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput,
}

impl Mthd for SetAlphaToCoverageOverride {
    const ADDR: u16 = 0x16b4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.qualify_by_anti_alias_enable as u32) < (1 << 1));
        val |= (self.qualify_by_anti_alias_enable as u32) << 0;

        assert!((self.qualify_by_ps_sample_mask_output as u32) < (1 << 1));
        val |= (self.qualify_by_ps_sample_mask_output as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolygonStipplePattern {
    pub v: u32,
}

impl ArrayMthd for SetPolygonStipplePattern {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1700 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAamVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetAamVersion {
    const ADDR: u16 = 0x1790;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckAamVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckAamVersion {
    const ADDR: u16 = 0x1794;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtLayer {
    pub offset: u32,
}

impl Mthd for SetZtLayer {
    const ADDR: u16 = 0x179c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset < (1 << 16));
        val |= self.offset << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabMemoryAreaA {
    pub offset_upper: u32,
}

impl Mthd for SetVabMemoryAreaA {
    const ADDR: u16 = 0x17bc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabMemoryAreaB {
    pub offset_lower: u32,
}

impl Mthd for SetVabMemoryAreaB {
    const ADDR: u16 = 0x17c0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVabMemoryAreaCSize {
    Bytes64K = 0x00000001,
    Bytes128K = 0x00000002,
    Bytes256K = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabMemoryAreaC {
    pub size: SetVabMemoryAreaCSize,
}

impl Mthd for SetVabMemoryAreaC {
    const ADDR: u16 = 0x17c4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.size as u32) < (1 << 2));
        val |= (self.size as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferA {
    pub address_upper: u32,
}

impl Mthd for SetIndexBufferA {
    const ADDR: u16 = 0x17c8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferB {
    pub address_lower: u32,
}

impl Mthd for SetIndexBufferB {
    const ADDR: u16 = 0x17cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferC {
    pub limit_address_upper: u32,
}

impl Mthd for SetIndexBufferC {
    const ADDR: u16 = 0x17d0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.limit_address_upper < (1 << 8));
        val |= self.limit_address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferD {
    pub limit_address_lower: u32,
}

impl Mthd for SetIndexBufferD {
    const ADDR: u16 = 0x17d4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.limit_address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetIndexBufferEIndexSize {
    OneByte = 0x00000000,
    TwoBytes = 0x00000001,
    FourBytes = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferE {
    pub index_size: SetIndexBufferEIndexSize,
}

impl Mthd for SetIndexBufferE {
    const ADDR: u16 = 0x17d8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.index_size as u32) < (1 << 2));
        val |= (self.index_size as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferF {
    pub first: u32,
}

impl Mthd for SetIndexBufferF {
    const ADDR: u16 = 0x17dc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.first;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer {
    pub count: u32,
}

impl Mthd for DrawIndexBuffer {
    const ADDR: u16 = 0x17e0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.count;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer32BeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer32BeginEndInstanceFirst {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer32BeginEndInstanceFirstTopology,
}

impl Mthd for DrawIndexBuffer32BeginEndInstanceFirst {
    const ADDR: u16 = 0x17e4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.first < (1 << 16));
        val |= self.first << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer16BeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer16BeginEndInstanceFirst {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer16BeginEndInstanceFirstTopology,
}

impl Mthd for DrawIndexBuffer16BeginEndInstanceFirst {
    const ADDR: u16 = 0x17e8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.first < (1 << 16));
        val |= self.first << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer8BeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer8BeginEndInstanceFirst {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer8BeginEndInstanceFirstTopology,
}

impl Mthd for DrawIndexBuffer8BeginEndInstanceFirst {
    const ADDR: u16 = 0x17ec;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.first < (1 << 16));
        val |= self.first << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer32BeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer32BeginEndInstanceSubsequent {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer32BeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawIndexBuffer32BeginEndInstanceSubsequent {
    const ADDR: u16 = 0x17f0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.first < (1 << 16));
        val |= self.first << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer16BeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer16BeginEndInstanceSubsequent {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer16BeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawIndexBuffer16BeginEndInstanceSubsequent {
    const ADDR: u16 = 0x17f4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.first < (1 << 16));
        val |= self.first << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer8BeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer8BeginEndInstanceSubsequent {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer8BeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawIndexBuffer8BeginEndInstanceSubsequent {
    const ADDR: u16 = 0x17f8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.first < (1 << 16));
        val |= self.first << 0;

        assert!(self.count < (1 << 12));
        val |= self.count << 16;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBiasClamp {
    pub v: f32,
}

impl Mthd for SetDepthBiasClamp {
    const ADDR: u16 = 0x187c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamInstanceA {
    pub is_instanced: bool,
}

impl ArrayMthd for SetVertexStreamInstanceA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1880 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.is_instanced as u32) < (1 << 1));
        val |= (self.is_instanced as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamInstanceB {
    pub is_instanced: bool,
}

impl ArrayMthd for SetVertexStreamInstanceB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x18c0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.is_instanced as u32) < (1 << 1));
        val |= (self.is_instanced as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAttributePointSize {
    pub enable: bool,
    pub slot: u32,
}

impl Mthd for SetAttributePointSize {
    const ADDR: u16 = 0x1910;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!(self.slot < (1 << 8));
        val |= self.slot << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OglSetCull {
    pub enable: bool,
}

impl Mthd for OglSetCull {
    const ADDR: u16 = 0x1918;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum OglSetFrontFaceV {
    Cw = 0x00000900,
    Ccw = 0x00000901,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OglSetFrontFace {
    pub v: OglSetFrontFaceV,
}

impl Mthd for OglSetFrontFace {
    const ADDR: u16 = 0x191c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum OglSetCullFaceV {
    Front = 0x00000404,
    Back = 0x00000405,
    FrontAndBack = 0x00000408,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OglSetCullFace {
    pub v: OglSetCullFaceV,
}

impl Mthd for OglSetCullFace {
    const ADDR: u16 = 0x1920;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportPixelCenter {
    AtHalfIntegers = 0x00000000,
    AtIntegers = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportPixel {
    pub center: SetViewportPixelCenter,
}

impl Mthd for SetViewportPixel {
    const ADDR: u16 = 0x1924;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.center as u32) < (1 << 1));
        val |= (self.center as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleOffset {
    pub enable: bool,
}

impl Mthd for SetViewportScaleOffset {
    const ADDR: u16 = 0x192c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCache {
    pub thru_l2: bool,
}

impl Mthd for InvalidateConstantBufferCache {
    const ADDR: u16 = 0x1930;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.thru_l2 as u32) < (1 << 1));
        val |= (self.thru_l2 as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMinZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMaxZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlLinePointCullGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryClip {
    WzeroClip = 0x00000000,
    Passthru = 0x00000001,
    FrustumXyClip = 0x00000002,
    FrustumXyzClip = 0x00000003,
    WzeroClipNoZCull = 0x00000004,
    FrustumZClip = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardbandZ {
    SameAsXyGuardband = 0x00000000,
    Scale256 = 0x00000001,
    Scale1 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipControl {
    pub min_z_zero_max_z_one: bool,
    pub pixel_min_z: SetViewportClipControlPixelMinZ,
    pub pixel_max_z: SetViewportClipControlPixelMaxZ,
    pub geometry_guardband: SetViewportClipControlGeometryGuardband,
    pub line_point_cull_guardband: SetViewportClipControlLinePointCullGuardband,
    pub geometry_clip: SetViewportClipControlGeometryClip,
    pub geometry_guardband_z: SetViewportClipControlGeometryGuardbandZ,
}

impl Mthd for SetViewportClipControl {
    const ADDR: u16 = 0x193c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.min_z_zero_max_z_one as u32) < (1 << 1));
        val |= (self.min_z_zero_max_z_one as u32) << 0;

        assert!((self.pixel_min_z as u32) < (1 << 1));
        val |= (self.pixel_min_z as u32) << 3;

        assert!((self.pixel_max_z as u32) < (1 << 1));
        val |= (self.pixel_max_z as u32) << 4;

        assert!((self.geometry_guardband as u32) < (1 << 1));
        val |= (self.geometry_guardband as u32) << 7;

        assert!((self.line_point_cull_guardband as u32) < (1 << 1));
        val |= (self.line_point_cull_guardband as u32) << 10;

        assert!((self.geometry_clip as u32) < (1 << 3));
        val |= (self.geometry_clip as u32) << 11;

        assert!((self.geometry_guardband_z as u32) < (1 << 2));
        val |= (self.geometry_guardband_z as u32) << 1;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane0 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane1 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane2 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane3 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane4 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane5 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane6 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane7 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetUserClipOp {
    pub plane0: SetUserClipOpPlane0,
    pub plane1: SetUserClipOpPlane1,
    pub plane2: SetUserClipOpPlane2,
    pub plane3: SetUserClipOpPlane3,
    pub plane4: SetUserClipOpPlane4,
    pub plane5: SetUserClipOpPlane5,
    pub plane6: SetUserClipOpPlane6,
    pub plane7: SetUserClipOpPlane7,
}

impl Mthd for SetUserClipOp {
    const ADDR: u16 = 0x1940;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.plane0 as u32) < (1 << 1));
        val |= (self.plane0 as u32) << 0;

        assert!((self.plane1 as u32) < (1 << 1));
        val |= (self.plane1 as u32) << 4;

        assert!((self.plane2 as u32) < (1 << 1));
        val |= (self.plane2 as u32) << 8;

        assert!((self.plane3 as u32) < (1 << 1));
        val |= (self.plane3 as u32) << 12;

        assert!((self.plane4 as u32) < (1 << 1));
        val |= (self.plane4 as u32) << 16;

        assert!((self.plane5 as u32) < (1 << 1));
        val |= (self.plane5 as u32) << 20;

        assert!((self.plane6 as u32) < (1 << 1));
        val |= (self.plane6 as u32) << 24;

        assert!((self.plane7 as u32) < (1 << 1));
        val |= (self.plane7 as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPrimitiveTopologyControlOverride {
    UseTopologyInBeginMethods = 0x00000000,
    UseSeparateTopologyState = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPrimitiveTopologyControl {
    pub override_: SetPrimitiveTopologyControlOverride,
}

impl Mthd for SetPrimitiveTopologyControl {
    const ADDR: u16 = 0x1948;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.override_ as u32) < (1 << 1));
        val |= (self.override_ as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipEnable {
    pub v: bool,
}

impl Mthd for SetWindowClipEnable {
    const ADDR: u16 = 0x194c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetWindowClipTypeV {
    Inclusive = 0x00000000,
    Exclusive = 0x00000001,
    Clipall = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipType {
    pub v: SetWindowClipTypeV,
}

impl Mthd for SetWindowClipType {
    const ADDR: u16 = 0x1950;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateZcullV {
    Invalidate = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateZcull {
    pub v: InvalidateZcullV,
}

impl Mthd for InvalidateZcull {
    const ADDR: u16 = 0x1958;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcull {
    pub z_enable: bool,
    pub stencil_enable: bool,
}

impl Mthd for SetZcull {
    const ADDR: u16 = 0x1968;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;

        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullBounds {
    pub z_min_unbounded_enable: bool,
    pub z_max_unbounded_enable: bool,
}

impl Mthd for SetZcullBounds {
    const ADDR: u16 = 0x196c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_min_unbounded_enable as u32) < (1 << 1));
        val |= (self.z_min_unbounded_enable as u32) << 0;

        assert!((self.z_max_unbounded_enable as u32) < (1 << 1));
        val |= (self.z_max_unbounded_enable as u32) << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPrimitiveTopologyV {
    Pointlist = 0x00000001,
    Linelist = 0x00000002,
    Linestrip = 0x00000003,
    Trianglelist = 0x00000004,
    Trianglestrip = 0x00000005,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patchlist = 0x0000000e,
    LegacyPoints = 0x00001001,
    LegacyIndexedlinelist = 0x00001002,
    LegacyIndexedtrianglelist = 0x00001003,
    LegacyLinelist = 0x0000100f,
    LegacyLinestrip = 0x00001010,
    LegacyIndexedlinestrip = 0x00001011,
    LegacyTrianglelist = 0x00001012,
    LegacyTrianglestrip = 0x00001013,
    LegacyIndexedtrianglestrip = 0x00001014,
    LegacyTrianglefan = 0x00001015,
    LegacyIndexedtrianglefan = 0x00001016,
    LegacyTrianglefanImm = 0x00001017,
    LegacyLinelistImm = 0x00001018,
    LegacyIndexedtrianglelist2 = 0x0000101a,
    LegacyIndexedlinelist2 = 0x0000101b,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPrimitiveTopology {
    pub v: SetPrimitiveTopologyV,
}

impl Mthd for SetPrimitiveTopology {
    const ADDR: u16 = 0x1970;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 16));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ZcullSync {
    pub v: u32,
}

impl Mthd for ZcullSync {
    const ADDR: u16 = 0x1978;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdTest {
    pub enable: bool,
}

impl Mthd for SetClipIdTest {
    const ADDR: u16 = 0x197c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdWidth {
    pub v: u32,
}

impl Mthd for SetSurfaceClipIdWidth {
    const ADDR: u16 = 0x1980;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipId {
    pub v: u32,
}

impl Mthd for SetClipId {
    const ADDR: u16 = 0x1984;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBoundsTest {
    pub enable: bool,
}

impl Mthd for SetDepthBoundsTest {
    const ADDR: u16 = 0x19bc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendFloatOption {
    pub zero_times_anything_is_zero: bool,
}

impl Mthd for SetBlendFloatOption {
    const ADDR: u16 = 0x19c0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.zero_times_anything_is_zero as u32) < (1 << 1));
        val |= (self.zero_times_anything_is_zero as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLogicOp {
    pub enable: bool,
}

impl Mthd for SetLogicOp {
    const ADDR: u16 = 0x19c4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetLogicOpFuncV {
    Clear = 0x00001500,
    And = 0x00001501,
    AndReverse = 0x00001502,
    Copy = 0x00001503,
    AndInverted = 0x00001504,
    Noop = 0x00001505,
    Xor = 0x00001506,
    Or = 0x00001507,
    Nor = 0x00001508,
    Equiv = 0x00001509,
    Invert = 0x0000150a,
    OrReverse = 0x0000150b,
    CopyInverted = 0x0000150c,
    OrInverted = 0x0000150d,
    Nand = 0x0000150e,
    Set = 0x0000150f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLogicOpFunc {
    pub v: SetLogicOpFuncV,
}

impl Mthd for SetLogicOpFunc {
    const ADDR: u16 = 0x19c8;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZCompression {
    pub enable: bool,
}

impl Mthd for SetZCompression {
    const ADDR: u16 = 0x19cc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearSurface {
    pub z_enable: bool,
    pub stencil_enable: bool,
    pub r_enable: bool,
    pub g_enable: bool,
    pub b_enable: bool,
    pub a_enable: bool,
    pub mrt_select: u32,
    pub rt_array_index: u32,
}

impl Mthd for ClearSurface {
    const ADDR: u16 = 0x19d0;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;

        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 1;

        assert!((self.r_enable as u32) < (1 << 1));
        val |= (self.r_enable as u32) << 2;

        assert!((self.g_enable as u32) < (1 << 1));
        val |= (self.g_enable as u32) << 3;

        assert!((self.b_enable as u32) < (1 << 1));
        val |= (self.b_enable as u32) << 4;

        assert!((self.a_enable as u32) < (1 << 1));
        val |= (self.a_enable as u32) << 5;

        assert!(self.mrt_select < (1 << 4));
        val |= self.mrt_select << 6;

        assert!(self.rt_array_index < (1 << 16));
        val |= self.rt_array_index << 10;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearClipIdSurface {
    pub v: u32,
}

impl Mthd for ClearClipIdSurface {
    const ADDR: u16 = 0x19d4;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorCompression {
    pub enable: bool,
}

impl ArrayMthd for SetColorCompression {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x19e0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtWrite {
    pub r_enable: bool,
    pub g_enable: bool,
    pub b_enable: bool,
    pub a_enable: bool,
}

impl ArrayMthd for SetCtWrite {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1a00 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.r_enable as u32) < (1 << 1));
        val |= (self.r_enable as u32) << 0;

        assert!((self.g_enable as u32) < (1 << 1));
        val |= (self.g_enable as u32) << 4;

        assert!((self.b_enable as u32) < (1 << 1));
        val |= (self.b_enable as u32) << 8;

        assert!((self.a_enable as u32) < (1 << 1));
        val |= (self.a_enable as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipeNop {
    pub v: u32,
}

impl Mthd for PipeNop {
    const ADDR: u16 = 0x1a2c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare00 {
    pub v: u32,
}

impl Mthd for SetSpare00 {
    const ADDR: u16 = 0x1a30;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare01 {
    pub v: u32,
}

impl Mthd for SetSpare01 {
    const ADDR: u16 = 0x1a34;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare02 {
    pub v: u32,
}

impl Mthd for SetSpare02 {
    const ADDR: u16 = 0x1a38;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare03 {
    pub v: u32,
}

impl Mthd for SetSpare03 {
    const ADDR: u16 = 0x1a3c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetReportSemaphoreA {
    const ADDR: u16 = 0x1b00;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetReportSemaphoreB {
    const ADDR: u16 = 0x1b04;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetReportSemaphoreC {
    const ADDR: u16 = 0x1b08;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDRelease {
    AfterAllPreceedingReadsComplete = 0x00000000,
    AfterAllPreceedingWritesComplete = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDAcquire {
    BeforeAnyFollowingWritesStart = 0x00000000,
    BeforeAnyFollowingReadsStart = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDPipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDComparison {
    Eq = 0x00000000,
    Ge = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub release: SetReportSemaphoreDRelease,
    pub acquire: SetReportSemaphoreDAcquire,
    pub pipeline_location: SetReportSemaphoreDPipelineLocation,
    pub comparison: SetReportSemaphoreDComparison,
    pub awaken_enable: bool,
    pub report: SetReportSemaphoreDReport,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub sub_report: u32,
    pub report_dword_number: u32,
    pub flush_disable: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.release as u32) < (1 << 1));
        val |= (self.release as u32) << 4;

        assert!((self.acquire as u32) < (1 << 1));
        val |= (self.acquire as u32) << 8;

        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 12;

        assert!((self.comparison as u32) < (1 << 1));
        val |= (self.comparison as u32) << 16;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 23;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 5;

        assert!(self.report_dword_number < (1 << 1));
        val |= self.report_dword_number << 21;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamAFormat {
    pub stride: u32,
    pub enable: bool,
}

impl ArrayMthd for SetVertexStreamAFormat {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1c00 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.stride < (1 << 12));
        val |= self.stride << 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamALocationA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetVertexStreamALocationA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1c04 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamALocationB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetVertexStreamALocationB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1c08 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamAFrequency {
    pub v: u32,
}

impl ArrayMthd for SetVertexStreamAFrequency {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1c0c + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBFormat {
    pub stride: u32,
    pub enable: bool,
}

impl ArrayMthd for SetVertexStreamBFormat {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1d00 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.stride < (1 << 12));
        val |= self.stride << 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBLocationA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetVertexStreamBLocationA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1d04 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBLocationB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetVertexStreamBLocationB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1d08 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBFrequency {
    pub v: u32,
}

impl ArrayMthd for SetVertexStreamBFrequency {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1d0c + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetSeparateForAlpha {
    pub enable: bool,
}

impl ArrayMthd for SetBlendPerTargetSeparateForAlpha {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e00 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetColorOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetColorOp {
    pub v: SetBlendPerTargetColorOpV,
}

impl ArrayMthd for SetBlendPerTargetColorOp {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e04 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetColorSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetColorSourceCoeff {
    pub v: SetBlendPerTargetColorSourceCoeffV,
}

impl ArrayMthd for SetBlendPerTargetColorSourceCoeff {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e08 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetColorDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetColorDestCoeff {
    pub v: SetBlendPerTargetColorDestCoeffV,
}

impl ArrayMthd for SetBlendPerTargetColorDestCoeff {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e0c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetAlphaOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetAlphaOp {
    pub v: SetBlendPerTargetAlphaOpV,
}

impl ArrayMthd for SetBlendPerTargetAlphaOp {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e10 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetAlphaSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetAlphaSourceCoeff {
    pub v: SetBlendPerTargetAlphaSourceCoeffV,
}

impl ArrayMthd for SetBlendPerTargetAlphaSourceCoeff {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e14 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetAlphaDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetAlphaDestCoeff {
    pub v: SetBlendPerTargetAlphaDestCoeffV,
}

impl ArrayMthd for SetBlendPerTargetAlphaDestCoeff {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1e18 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitAA {
    pub upper: u32,
}

impl ArrayMthd for SetVertexStreamLimitAA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1f00 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitAB {
    pub lower: u32,
}

impl ArrayMthd for SetVertexStreamLimitAB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1f04 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitBA {
    pub upper: u32,
}

impl ArrayMthd for SetVertexStreamLimitBA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1f80 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitBB {
    pub lower: u32,
}

impl ArrayMthd for SetVertexStreamLimitBB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x1f84 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPipelineShaderType {
    VertexCullBeforeFetch = 0x00000000,
    Vertex = 0x00000001,
    TessellationInit = 0x00000002,
    Tessellation = 0x00000003,
    Geometry = 0x00000004,
    Pixel = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineShader {
    pub enable: bool,
    pub type_: SetPipelineShaderType,
}

impl ArrayMthd for SetPipelineShader {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2000 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.type_ as u32) < (1 << 4));
        val |= (self.type_ as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineProgram {
    pub offset: u32,
}

impl ArrayMthd for SetPipelineProgram {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2004 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedA {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2008 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineRegisterCount {
    pub v: u32,
}

impl ArrayMthd for SetPipelineRegisterCount {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x200c + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineBinding {
    pub group: u32,
}

impl ArrayMthd for SetPipelineBinding {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2010 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.group < (1 << 3));
        val |= self.group << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedB {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2014 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedC {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedC {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2018 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedD {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedD {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x201c + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedE {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedE {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2020 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBindingControlTextureMaxActiveSamplers {
    _1 = 0x00000000,
    _2 = 0x00000001,
    _4 = 0x00000002,
    _8 = 0x00000003,
    _16 = 0x00000004,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBindingControlTextureMaxActiveHeaders {
    _1 = 0x00000000,
    _2 = 0x00000001,
    _4 = 0x00000002,
    _8 = 0x00000003,
    _16 = 0x00000004,
    _32 = 0x00000005,
    _64 = 0x00000006,
    _128 = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindingControlTexture {
    pub max_active_samplers: SetBindingControlTextureMaxActiveSamplers,
    pub max_active_headers: SetBindingControlTextureMaxActiveHeaders,
}

impl ArrayMthd for SetBindingControlTexture {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2200 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.max_active_samplers as u32) < (1 << 4));
        val |= (self.max_active_samplers as u32) << 0;

        assert!((self.max_active_headers as u32) < (1 << 4));
        val |= (self.max_active_headers as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindingControlReservedA {
    pub v: u32,
}

impl ArrayMthd for SetBindingControlReservedA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2204 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindingControlReservedB {
    pub v: u32,
}

impl ArrayMthd for SetBindingControlReservedB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2208 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x2300;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x2304;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x2308;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x230c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x2310;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x2314;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x2318;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x231c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x2320;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x2324;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x2328;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x232c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x2330;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x2334;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x2338;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x233c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x2340;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x2344;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x2348;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x234c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x2350;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x2354;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x2358;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x235c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x2360;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x2364;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x2368;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x236c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x2370;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x2374;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x2378;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x237c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorA {
    pub size: u32,
}

impl Mthd for SetConstantBufferSelectorA {
    const ADDR: u16 = 0x2380;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size < (1 << 17));
        val |= self.size << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorB {
    pub address_upper: u32,
}

impl Mthd for SetConstantBufferSelectorB {
    const ADDR: u16 = 0x2384;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorC {
    pub address_lower: u32,
}

impl Mthd for SetConstantBufferSelectorC {
    const ADDR: u16 = 0x2388;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBufferOffset {
    pub v: u32,
}

impl Mthd for LoadConstantBufferOffset {
    const ADDR: u16 = 0x238c;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBuffer {
    pub v: u32,
}

impl ArrayMthd for LoadConstantBuffer {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2390 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupTextureSampler {
    pub valid: bool,
    pub sampler_slot: u32,
    pub index: u32,
}

impl ArrayMthd for BindGroupTextureSampler {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2400 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.sampler_slot < (1 << 8));
        val |= self.sampler_slot << 4;

        assert!(self.index < (1 << 13));
        val |= self.index << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupTextureHeader {
    pub valid: bool,
    pub texture_slot: u32,
    pub index: u32,
}

impl ArrayMthd for BindGroupTextureHeader {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2404 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.texture_slot < (1 << 8));
        val |= self.texture_slot << 1;

        assert!(self.index < (1 << 22));
        val |= self.index << 9;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupExtraTextureSampler {
    pub valid: bool,
    pub sampler_slot: u32,
    pub index: u32,
}

impl ArrayMthd for BindGroupExtraTextureSampler {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2408 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.sampler_slot < (1 << 8));
        val |= self.sampler_slot << 4;

        assert!(self.index < (1 << 13));
        val |= self.index << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupExtraTextureHeader {
    pub valid: bool,
    pub texture_slot: u32,
    pub index: u32,
}

impl ArrayMthd for BindGroupExtraTextureHeader {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x240c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.texture_slot < (1 << 8));
        val |= self.texture_slot << 1;

        assert!(self.index < (1 << 22));
        val |= self.index << 9;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupConstantBuffer {
    pub valid: bool,
    pub shader_slot: u32,
}

impl ArrayMthd for BindGroupConstantBuffer {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2410 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.shader_slot < (1 << 5));
        val |= self.shader_slot << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedGroupBReservedA {
    pub v: u32,
}

impl ArrayMthd for ReservedGroupBReservedA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2500 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedGroupBReservedB {
    pub v: u32,
}

impl ArrayMthd for ReservedGroupBReservedB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2504 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedGroupBReservedC {
    pub v: u32,
}

impl ArrayMthd for ReservedGroupBReservedC {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2508 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedGroupBReservedD {
    pub v: u32,
}

impl ArrayMthd for ReservedGroupBReservedD {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x250c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedGroupBReservedE {
    pub v: u32,
}

impl ArrayMthd for ReservedGroupBReservedE {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2510 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorClamp {
    pub enable: bool,
}

impl Mthd for SetColorClamp {
    const ADDR: u16 = 0x2600;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetSuLdStTargetA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2700 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetSuLdStTargetB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2704 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetC {
    pub width: u32,
}

impl ArrayMthd for SetSuLdStTargetC {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2708 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.width;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetDLayoutInMemory {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetD {
    pub height: u32,
    pub layout_in_memory: SetSuLdStTargetDLayoutInMemory,
}

impl ArrayMthd for SetSuLdStTargetD {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x270c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.height < (1 << 17));
        val |= self.height << 0;

        assert!((self.layout_in_memory as u32) < (1 << 1));
        val |= (self.layout_in_memory as u32) << 20;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatType {
    Color = 0x00000000,
    Zeta = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatColor {
    Disabled = 0x00000000,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rs32Gs32Bs32As32 = 0x000000c1,
    Ru32Gu32Bu32Au32 = 0x000000c2,
    Rf32Gf32Bf32X32 = 0x000000c3,
    Rs32Gs32Bs32X32 = 0x000000c4,
    Ru32Gu32Bu32X32 = 0x000000c5,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Rs16Gs16Bs16As16 = 0x000000c8,
    Ru16Gu16Bu16Au16 = 0x000000c9,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    Rs32Gs32 = 0x000000cc,
    Ru32Gu32 = 0x000000cd,
    Rf16Gf16Bf16X16 = 0x000000ce,
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2B10G10R10 = 0x000000d1,
    Au2Bu10Gu10Ru10 = 0x000000d2,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    An8Bn8Gn8Rn8 = 0x000000d7,
    As8Bs8Gs8Rs8 = 0x000000d8,
    Au8Bu8Gu8Ru8 = 0x000000d9,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    Rs16Gs16 = 0x000000dc,
    Ru16Gu16 = 0x000000dd,
    Rf16Gf16 = 0x000000de,
    A2R10G10B10 = 0x000000df,
    Bf10Gf11Rf11 = 0x000000e0,
    Rs32 = 0x000000e3,
    Ru32 = 0x000000e4,
    Rf32 = 0x000000e5,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Gs8Rs8 = 0x000000ec,
    Gu8Ru8 = 0x000000ed,
    R16 = 0x000000ee,
    Rn16 = 0x000000ef,
    Rs16 = 0x000000f0,
    Ru16 = 0x000000f1,
    Rf16 = 0x000000f2,
    R8 = 0x000000f3,
    Rn8 = 0x000000f4,
    Rs8 = 0x000000f5,
    Ru8 = 0x000000f6,
    A8 = 0x000000f7,
    X1R5G5B5 = 0x000000f8,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    R32 = 0x000000ff,
    A16 = 0x00000040,
    Af16 = 0x00000041,
    Af32 = 0x00000042,
    A8R8 = 0x00000043,
    R16A16 = 0x00000044,
    Rf16Af16 = 0x00000045,
    Rf32Af32 = 0x00000046,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatZeta {
    Z16 = 0x00000013,
    Z24S8 = 0x00000014,
    X8Z24 = 0x00000015,
    S8Z24 = 0x00000016,
    V8Z24 = 0x00000018,
    Zf32 = 0x0000000a,
    Zf32X24S8 = 0x00000019,
    X8Z24X16V8S8 = 0x0000001d,
    Zf32X16V8X8 = 0x0000001e,
    Zf32X16V8S8 = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetFormat {
    pub type_: SetSuLdStTargetFormatType,
    pub color: SetSuLdStTargetFormatColor,
    pub zeta: SetSuLdStTargetFormatZeta,
}

impl ArrayMthd for SetSuLdStTargetFormat {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2710 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 1));
        val |= (self.type_ as u32) << 0;

        assert!((self.color as u32) < (1 << 8));
        val |= (self.color as u32) << 4;

        assert!((self.zeta as u32) < (1 << 5));
        val |= (self.zeta as u32) << 12;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetBlockSize {
    pub width: SetSuLdStTargetBlockSizeWidth,
    pub height: SetSuLdStTargetBlockSizeHeight,
}

impl ArrayMthd for SetSuLdStTargetBlockSize {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x2714 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValue {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x335c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterEvent {
    pub event: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterEvent {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x337c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.event < (1 << 8));
        val |= self.event << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x339c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.event0 < (1 << 3));
        val |= self.event0 << 0;

        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 4;

        assert!(self.event1 < (1 << 3));
        val |= self.event1 << 8;

        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 12;

        assert!(self.event2 < (1 << 3));
        val |= self.event2 << 16;

        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 20;

        assert!(self.event3 < (1 << 3));
        val |= self.event3 << 24;

        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 28;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x33bc + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;

        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterTrapControl {
    pub mask: u32,
}

impl Mthd for SetShaderPerformanceCounterTrapControl {
    const ADDR: u16 = 0x33dc;
    const CLASS: u16 = 0x9097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.mask < (1 << 8));
        val |= self.mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x3400 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x3800 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0x9097;

    fn addr(i: usize) -> u16 {
        (0x3804 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}
