use crate::ArrayMthd;
use crate::Mthd;

// parsed class NV902D

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;

        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 25));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.type_ as u32;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeSwitchState {
    pub valid: bool,
    pub save_macro: u32,
    pub restore_macro: u32,
}

impl Mthd for SetMmeSwitchState {
    const ADDR: u16 = 0x01ec;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.save_macro < (1 << 8));
        val |= self.save_macro << 4;

        assert!(self.restore_macro < (1 << 8));
        val |= self.restore_macro << 12;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstFormatV {
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    Y18X8 = 0x0000001c,
    Rf16 = 0x000000f2,
    Rf32 = 0x000000e5,
    Rf32Gf32 = 0x000000cb,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf16Gf16Bf16X16 = 0x000000ce,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rf32Gf32Bf32X32 = 0x000000c3,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Bf10Gf11Rf11 = 0x000000e0,
    An8Bn8Gn8Rn8 = 0x000000d7,
    Rf16Gf16 = 0x000000de,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Rn16 = 0x000000ef,
    Rn8 = 0x000000f4,
    A8 = 0x000000f7,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstFormat {
    pub v: SetDstFormatV,
}

impl Mthd for SetDstFormat {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstMemoryLayoutV {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstMemoryLayout {
    pub v: SetDstMemoryLayoutV,
}

impl Mthd for SetDstMemoryLayout {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.height as u32) < (1 << 3));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 3));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstPitch {
    pub v: u32,
}

impl Mthd for SetDstPitch {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOffsetUpper {
    pub v: u32,
}

impl Mthd for SetDstOffsetUpper {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOffsetLower {
    pub v: u32,
}

impl Mthd for SetDstOffsetLower {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FlushAndInvalidateRopMiniCache {
    pub v: u32,
}

impl Mthd for FlushAndInvalidateRopMiniCache {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcFormatV {
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Ay8 = 0x0000001d,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    Y18X8 = 0x0000001c,
    Rf16 = 0x000000f2,
    Rf32 = 0x000000e5,
    Rf32Gf32 = 0x000000cb,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf16Gf16Bf16X16 = 0x000000ce,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rf32Gf32Bf32X32 = 0x000000c3,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Bf10Gf11Rf11 = 0x000000e0,
    An8Bn8Gn8Rn8 = 0x000000d7,
    Rf16Gf16 = 0x000000de,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Rn16 = 0x000000ef,
    Rn8 = 0x000000f4,
    A8 = 0x000000f7,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcFormat {
    pub v: SetSrcFormatV,
}

impl Mthd for SetSrcFormat {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcMemoryLayoutV {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcMemoryLayout {
    pub v: SetSrcMemoryLayoutV,
}

impl Mthd for SetSrcMemoryLayout {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcBlockSize {
    pub height: SetSrcBlockSizeHeight,
    pub depth: SetSrcBlockSizeDepth,
}

impl Mthd for SetSrcBlockSize {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.height as u32) < (1 << 3));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 3));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcDepth {
    pub v: u32,
}

impl Mthd for SetSrcDepth {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum TwodInvalidateTextureDataCacheV {
    L1Only = 0x00000000,
    L2Only = 0x00000001,
    L1AndL2 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct TwodInvalidateTextureDataCache {
    pub v: TwodInvalidateTextureDataCacheV,
}

impl Mthd for TwodInvalidateTextureDataCache {
    const ADDR: u16 = 0x0240;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcPitch {
    pub v: u32,
}

impl Mthd for SetSrcPitch {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcWidth {
    pub v: u32,
}

impl Mthd for SetSrcWidth {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcHeight {
    pub v: u32,
}

impl Mthd for SetSrcHeight {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcOffsetUpper {
    pub v: u32,
}

impl Mthd for SetSrcOffsetUpper {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcOffsetLower {
    pub v: u32,
}

impl Mthd for SetSrcOffsetLower {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemorySectorPromotionV {
    NoPromotion = 0x00000000,
    PromoteTo2V = 0x00000001,
    PromoteTo2H = 0x00000002,
    PromoteTo4 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySectorPromotion {
    pub v: SetPixelsFromMemorySectorPromotionV,
}

impl Mthd for SetPixelsFromMemorySectorPromotion {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetNumProcessingClustersV {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNumProcessingClusters {
    pub v: SetNumProcessingClustersV,
}

impl Mthd for SetNumProcessingClusters {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x0278;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipX0 {
    pub v: u32,
}

impl Mthd for SetClipX0 {
    const ADDR: u16 = 0x0280;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipY0 {
    pub v: u32,
}

impl Mthd for SetClipY0 {
    const ADDR: u16 = 0x0284;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipWidth {
    pub v: u32,
}

impl Mthd for SetClipWidth {
    const ADDR: u16 = 0x0288;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipHeight {
    pub v: u32,
}

impl Mthd for SetClipHeight {
    const ADDR: u16 = 0x028c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipEnable {
    pub v: bool,
}

impl Mthd for SetClipEnable {
    const ADDR: u16 = 0x0290;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorKeyFormatV {
    A16R5G6B5 = 0x00000000,
    A1R5G5B5 = 0x00000001,
    A8R8G8B8 = 0x00000002,
    A2R10G10B10 = 0x00000003,
    Y8 = 0x00000004,
    Y16 = 0x00000005,
    Y32 = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorKeyFormat {
    pub v: SetColorKeyFormatV,
}

impl Mthd for SetColorKeyFormat {
    const ADDR: u16 = 0x0294;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorKey {
    pub v: u32,
}

impl Mthd for SetColorKey {
    const ADDR: u16 = 0x0298;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorKeyEnable {
    pub v: bool,
}

impl Mthd for SetColorKeyEnable {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRop {
    pub v: u32,
}

impl Mthd for SetRop {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBeta1 {
    pub v: u32,
}

impl Mthd for SetBeta1 {
    const ADDR: u16 = 0x02a4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBeta4 {
    pub b: u32,
    pub g: u32,
    pub r: u32,
    pub a: u32,
}

impl Mthd for SetBeta4 {
    const ADDR: u16 = 0x02a8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.b < (1 << 8));
        val |= self.b << 0;

        assert!(self.g < (1 << 8));
        val |= self.g << 8;

        assert!(self.r < (1 << 8));
        val |= self.r << 16;

        assert!(self.a < (1 << 8));
        val |= self.a << 24;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetOperationV {
    SrccopyAnd = 0x00000000,
    RopAnd = 0x00000001,
    BlendAnd = 0x00000002,
    Srccopy = 0x00000003,
    Rop = 0x00000004,
    SrccopyPremult = 0x00000005,
    BlendPremult = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetOperation {
    pub v: SetOperationV,
}

impl Mthd for SetOperation {
    const ADDR: u16 = 0x02ac;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPatternOffset {
    pub x: u32,
    pub y: u32,
}

impl Mthd for SetPatternOffset {
    const ADDR: u16 = 0x02b0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x < (1 << 6));
        val |= self.x << 0;

        assert!(self.y < (1 << 6));
        val |= self.y << 8;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPatternSelectV {
    Monochrome8X8 = 0x00000000,
    Monochrome64X1 = 0x00000001,
    Monochrome1X64 = 0x00000002,
    Color = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPatternSelect {
    pub v: SetPatternSelectV,
}

impl Mthd for SetPatternSelect {
    const ADDR: u16 = 0x02b4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstColorRenderToZetaSurface {
    pub v: bool,
}

impl Mthd for SetDstColorRenderToZetaSurface {
    const ADDR: u16 = 0x02b8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x02bc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x02c0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x02d0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCompression {
    pub enable: bool,
}

impl Mthd for SetCompression {
    const ADDR: u16 = 0x02d4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x02d8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemoryDirectionHorizontal {
    HwDecides = 0x00000000,
    LeftToRight = 0x00000001,
    RightToLeft = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemoryDirectionVertical {
    HwDecides = 0x00000000,
    TopToBottom = 0x00000001,
    BottomToTop = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDirection {
    pub horizontal: SetPixelsFromMemoryDirectionHorizontal,
    pub vertical: SetPixelsFromMemoryDirectionVertical,
}

impl Mthd for SetPixelsFromMemoryDirection {
    const ADDR: u16 = 0x02e0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.horizontal as u32) < (1 << 2));
        val |= (self.horizontal as u32) << 0;

        assert!((self.vertical as u32) < (1 << 2));
        val |= (self.vertical as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMonochromePatternColorFormatV {
    A8X8R5G6B5 = 0x00000000,
    A1R5G5B5 = 0x00000001,
    A8R8G8B8 = 0x00000002,
    A8Y8 = 0x00000003,
    A8X8Y16 = 0x00000004,
    Y32 = 0x00000005,
    ByteExpand = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternColorFormat {
    pub v: SetMonochromePatternColorFormatV,
}

impl Mthd for SetMonochromePatternColorFormat {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMonochromePatternFormatV {
    Cga6M1 = 0x00000000,
    LeM1 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternFormat {
    pub v: SetMonochromePatternFormatV,
}

impl Mthd for SetMonochromePatternFormat {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternColor0 {
    pub v: u32,
}

impl Mthd for SetMonochromePatternColor0 {
    const ADDR: u16 = 0x02f0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternColor1 {
    pub v: u32,
}

impl Mthd for SetMonochromePatternColor1 {
    const ADDR: u16 = 0x02f4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePattern0 {
    pub v: u32,
}

impl Mthd for SetMonochromePattern0 {
    const ADDR: u16 = 0x02f8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePattern1 {
    pub v: u32,
}

impl Mthd for SetMonochromePattern1 {
    const ADDR: u16 = 0x02fc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternX8R8G8B8 {
    pub b0: u32,
    pub g0: u32,
    pub r0: u32,
    pub ignore0: u32,
}

impl ArrayMthd for ColorPatternX8R8G8B8 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x0300 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.b0 < (1 << 8));
        val |= self.b0 << 0;

        assert!(self.g0 < (1 << 8));
        val |= self.g0 << 8;

        assert!(self.r0 < (1 << 8));
        val |= self.r0 << 16;

        assert!(self.ignore0 < (1 << 8));
        val |= self.ignore0 << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternR5G6B5 {
    pub b0: u32,
    pub g0: u32,
    pub r0: u32,
    pub b1: u32,
    pub g1: u32,
    pub r1: u32,
}

impl ArrayMthd for ColorPatternR5G6B5 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x0400 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.b0 < (1 << 5));
        val |= self.b0 << 0;

        assert!(self.g0 < (1 << 6));
        val |= self.g0 << 5;

        assert!(self.r0 < (1 << 5));
        val |= self.r0 << 11;

        assert!(self.b1 < (1 << 5));
        val |= self.b1 << 16;

        assert!(self.g1 < (1 << 6));
        val |= self.g1 << 21;

        assert!(self.r1 < (1 << 5));
        val |= self.r1 << 27;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternX1R5G5B5 {
    pub b0: u32,
    pub g0: u32,
    pub r0: u32,
    pub ignore0: u32,
    pub b1: u32,
    pub g1: u32,
    pub r1: u32,
    pub ignore1: u32,
}

impl ArrayMthd for ColorPatternX1R5G5B5 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x0480 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.b0 < (1 << 5));
        val |= self.b0 << 0;

        assert!(self.g0 < (1 << 5));
        val |= self.g0 << 5;

        assert!(self.r0 < (1 << 5));
        val |= self.r0 << 10;

        assert!(self.ignore0 < (1 << 1));
        val |= self.ignore0 << 15;

        assert!(self.b1 < (1 << 5));
        val |= self.b1 << 16;

        assert!(self.g1 < (1 << 5));
        val |= self.g1 << 21;

        assert!(self.r1 < (1 << 5));
        val |= self.r1 << 26;

        assert!(self.ignore1 < (1 << 1));
        val |= self.ignore1 << 31;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternY8 {
    pub y0: u32,
    pub y1: u32,
    pub y2: u32,
    pub y3: u32,
}

impl ArrayMthd for ColorPatternY8 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x0500 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.y0 < (1 << 8));
        val |= self.y0 << 0;

        assert!(self.y1 < (1 << 8));
        val |= self.y1 << 8;

        assert!(self.y2 < (1 << 8));
        val |= self.y2 << 16;

        assert!(self.y3 < (1 << 8));
        val |= self.y3 << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor0 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor0 {
    const ADDR: u16 = 0x0540;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor1 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor1 {
    const ADDR: u16 = 0x0544;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor2 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor2 {
    const ADDR: u16 = 0x0548;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor3 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor3 {
    const ADDR: u16 = 0x054c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressA {
    pub upper: u32,
}

impl Mthd for SetMmeMemAddressA {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 25));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressB {
    pub lower: u32,
}

impl Mthd for SetMmeMemAddressB {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataRamAddress {
    pub word: u32,
}

impl Mthd for SetMmeDataRamAddress {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.word;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaRead {
    pub length: u32,
}

impl Mthd for MmeDmaRead {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReadFifoed {
    pub length: u32,
}

impl Mthd for MmeDmaReadFifoed {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWrite {
    pub length: u32,
}

impl Mthd for MmeDmaWrite {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionFormat {
    Unsigned = 0x00000000,
    Signed = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionSize {
    FourBytes = 0x00000000,
    EightBytes = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReduction {
    pub reduction_op: MmeDmaReductionReductionOp,
    pub reduction_format: MmeDmaReductionReductionFormat,
    pub reduction_size: MmeDmaReductionReductionSize,
}

impl Mthd for MmeDmaReduction {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 0;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 4;

        assert!((self.reduction_size as u32) < (1 << 1));
        val |= (self.reduction_size as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSysmembar {
    pub v: u32,
}

impl Mthd for MmeDmaSysmembar {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSync {
    pub value: u32,
}

impl Mthd for MmeDmaSync {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeDataFifoConfigFifoSize {
    Size0Kb = 0x00000000,
    Size4Kb = 0x00000001,
    Size8Kb = 0x00000002,
    Size12Kb = 0x00000003,
    Size16Kb = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataFifoConfig {
    pub fifo_size: SetMmeDataFifoConfigFifoSize,
}

impl Mthd for SetMmeDataFifoConfig {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.fifo_size as u32) < (1 << 3));
        val |= (self.fifo_size as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum RenderSolidPrimModeV {
    Points = 0x00000000,
    Lines = 0x00000001,
    Polyline = 0x00000002,
    Triangles = 0x00000003,
    Rects = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimMode {
    pub v: RenderSolidPrimModeV,
}

impl Mthd for RenderSolidPrimMode {
    const ADDR: u16 = 0x0580;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderSolidPrimColorFormatV {
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    A8R8G8B8 = 0x000000cf,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8B8G8R8 = 0x000000f9,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColorFormat {
    pub v: SetRenderSolidPrimColorFormatV,
}

impl Mthd for SetRenderSolidPrimColorFormat {
    const ADDR: u16 = 0x0584;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor {
    const ADDR: u16 = 0x0588;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidLineTieBreakBits {
    pub xmaj_xinc_yinc: u32,
    pub xmaj_xdec_yinc: u32,
    pub ymaj_xinc_yinc: u32,
    pub ymaj_xdec_yinc: u32,
}

impl Mthd for SetRenderSolidLineTieBreakBits {
    const ADDR: u16 = 0x058c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.xmaj_xinc_yinc < (1 << 1));
        val |= self.xmaj_xinc_yinc << 0;

        assert!(self.xmaj_xdec_yinc < (1 << 1));
        val |= self.xmaj_xdec_yinc << 4;

        assert!(self.ymaj_xinc_yinc < (1 << 1));
        val |= self.ymaj_xinc_yinc << 8;

        assert!(self.ymaj_xdec_yinc < (1 << 1));
        val |= self.ymaj_xdec_yinc << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimPointXY {
    pub x: u32,
    pub y: u32,
}

impl Mthd for RenderSolidPrimPointXY {
    const ADDR: u16 = 0x05e0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x < (1 << 16));
        val |= self.x << 0;

        assert!(self.y < (1 << 16));
        val |= self.y << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimPointSetX {
    pub v: u32,
}

impl ArrayMthd for RenderSolidPrimPointSetX {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x0600 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimPointY {
    pub v: u32,
}

impl ArrayMthd for RenderSolidPrimPointY {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x0604 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuDataTypeV {
    Color = 0x00000000,
    Index = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDataType {
    pub v: SetPixelsFromCpuDataTypeV,
}

impl Mthd for SetPixelsFromCpuDataType {
    const ADDR: u16 = 0x0800;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuColorFormatV {
    A8R8G8B8 = 0x000000cf,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8B8G8R8 = 0x000000f9,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuColorFormat {
    pub v: SetPixelsFromCpuColorFormatV,
}

impl Mthd for SetPixelsFromCpuColorFormat {
    const ADDR: u16 = 0x0804;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuIndexFormatV {
    I1 = 0x00000000,
    I4 = 0x00000001,
    I8 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuIndexFormat {
    pub v: SetPixelsFromCpuIndexFormatV,
}

impl Mthd for SetPixelsFromCpuIndexFormat {
    const ADDR: u16 = 0x0808;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuMonoFormatV {
    Cga6M1 = 0x00000000,
    LeM1 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuMonoFormat {
    pub v: SetPixelsFromCpuMonoFormatV,
}

impl Mthd for SetPixelsFromCpuMonoFormat {
    const ADDR: u16 = 0x080c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuWrapV {
    WrapPixel = 0x00000000,
    WrapByte = 0x00000001,
    WrapDword = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuWrap {
    pub v: SetPixelsFromCpuWrapV,
}

impl Mthd for SetPixelsFromCpuWrap {
    const ADDR: u16 = 0x0810;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuColor0 {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuColor0 {
    const ADDR: u16 = 0x0814;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuColor1 {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuColor1 {
    const ADDR: u16 = 0x0818;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuMonoOpacityV {
    Transparent = 0x00000000,
    Opaque = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuMonoOpacity {
    pub v: SetPixelsFromCpuMonoOpacityV,
}

impl Mthd for SetPixelsFromCpuMonoOpacity {
    const ADDR: u16 = 0x081c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuSrcWidth {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuSrcWidth {
    const ADDR: u16 = 0x0838;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuSrcHeight {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuSrcHeight {
    const ADDR: u16 = 0x083c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDxDuFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDxDuFrac {
    const ADDR: u16 = 0x0840;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDxDuInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDxDuInt {
    const ADDR: u16 = 0x0844;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDyDvFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDyDvFrac {
    const ADDR: u16 = 0x0848;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDyDvInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDyDvInt {
    const ADDR: u16 = 0x084c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstX0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstX0Frac {
    const ADDR: u16 = 0x0850;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstX0Int {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstX0Int {
    const ADDR: u16 = 0x0854;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstY0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstY0Frac {
    const ADDR: u16 = 0x0858;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstY0Int {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstY0Int {
    const ADDR: u16 = 0x085c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PixelsFromCpuData {
    pub v: u32,
}

impl Mthd for PixelsFromCpuData {
    const ADDR: u16 = 0x0860;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBigEndianControl {
    pub x32_swap_1: u32,
    pub x32_swap_4: u32,
    pub x32_swap_8: u32,
    pub x32_swap_16: u32,
    pub x16_swap_1: u32,
    pub x16_swap_4: u32,
    pub x16_swap_8: u32,
    pub x16_swap_16: u32,
    pub x8_swap_1: u32,
    pub x8_swap_4: u32,
    pub x8_swap_8: u32,
    pub x8_swap_16: u32,
    pub i1_x8_cga6_swap_1: u32,
    pub i1_x8_cga6_swap_4: u32,
    pub i1_x8_cga6_swap_8: u32,
    pub i1_x8_cga6_swap_16: u32,
    pub i1_x8_le_swap_1: u32,
    pub i1_x8_le_swap_4: u32,
    pub i1_x8_le_swap_8: u32,
    pub i1_x8_le_swap_16: u32,
    pub i4_swap_1: u32,
    pub i4_swap_4: u32,
    pub i4_swap_8: u32,
    pub i4_swap_16: u32,
    pub i8_swap_1: u32,
    pub i8_swap_4: u32,
    pub i8_swap_8: u32,
    pub i8_swap_16: u32,
    pub override_: u32,
}

impl Mthd for SetBigEndianControl {
    const ADDR: u16 = 0x0870;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x32_swap_1 < (1 << 1));
        val |= self.x32_swap_1 << 0;

        assert!(self.x32_swap_4 < (1 << 1));
        val |= self.x32_swap_4 << 1;

        assert!(self.x32_swap_8 < (1 << 1));
        val |= self.x32_swap_8 << 2;

        assert!(self.x32_swap_16 < (1 << 1));
        val |= self.x32_swap_16 << 3;

        assert!(self.x16_swap_1 < (1 << 1));
        val |= self.x16_swap_1 << 4;

        assert!(self.x16_swap_4 < (1 << 1));
        val |= self.x16_swap_4 << 5;

        assert!(self.x16_swap_8 < (1 << 1));
        val |= self.x16_swap_8 << 6;

        assert!(self.x16_swap_16 < (1 << 1));
        val |= self.x16_swap_16 << 7;

        assert!(self.x8_swap_1 < (1 << 1));
        val |= self.x8_swap_1 << 8;

        assert!(self.x8_swap_4 < (1 << 1));
        val |= self.x8_swap_4 << 9;

        assert!(self.x8_swap_8 < (1 << 1));
        val |= self.x8_swap_8 << 10;

        assert!(self.x8_swap_16 < (1 << 1));
        val |= self.x8_swap_16 << 11;

        assert!(self.i1_x8_cga6_swap_1 < (1 << 1));
        val |= self.i1_x8_cga6_swap_1 << 12;

        assert!(self.i1_x8_cga6_swap_4 < (1 << 1));
        val |= self.i1_x8_cga6_swap_4 << 13;

        assert!(self.i1_x8_cga6_swap_8 < (1 << 1));
        val |= self.i1_x8_cga6_swap_8 << 14;

        assert!(self.i1_x8_cga6_swap_16 < (1 << 1));
        val |= self.i1_x8_cga6_swap_16 << 15;

        assert!(self.i1_x8_le_swap_1 < (1 << 1));
        val |= self.i1_x8_le_swap_1 << 16;

        assert!(self.i1_x8_le_swap_4 < (1 << 1));
        val |= self.i1_x8_le_swap_4 << 17;

        assert!(self.i1_x8_le_swap_8 < (1 << 1));
        val |= self.i1_x8_le_swap_8 << 18;

        assert!(self.i1_x8_le_swap_16 < (1 << 1));
        val |= self.i1_x8_le_swap_16 << 19;

        assert!(self.i4_swap_1 < (1 << 1));
        val |= self.i4_swap_1 << 20;

        assert!(self.i4_swap_4 < (1 << 1));
        val |= self.i4_swap_4 << 21;

        assert!(self.i4_swap_8 < (1 << 1));
        val |= self.i4_swap_8 << 22;

        assert!(self.i4_swap_16 < (1 << 1));
        val |= self.i4_swap_16 << 23;

        assert!(self.i8_swap_1 < (1 << 1));
        val |= self.i8_swap_1 << 24;

        assert!(self.i8_swap_4 < (1 << 1));
        val |= self.i8_swap_4 << 25;

        assert!(self.i8_swap_8 < (1 << 1));
        val |= self.i8_swap_8 << 26;

        assert!(self.i8_swap_16 < (1 << 1));
        val |= self.i8_swap_16 << 27;

        assert!(self.override_ < (1 << 1));
        val |= self.override_ << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemoryBlockShapeV {
    Auto = 0x00000000,
    Shape8X8 = 0x00000001,
    Shape16X4 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryBlockShape {
    pub v: SetPixelsFromMemoryBlockShapeV,
}

impl Mthd for SetPixelsFromMemoryBlockShape {
    const ADDR: u16 = 0x0880;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryCorralSize {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryCorralSize {
    const ADDR: u16 = 0x0884;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 10));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySafeOverlap {
    pub v: bool,
}

impl Mthd for SetPixelsFromMemorySafeOverlap {
    const ADDR: u16 = 0x0888;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemorySampleModeOrigin {
    Center = 0x00000000,
    Corner = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemorySampleModeFilter {
    Point = 0x00000000,
    Bilinear = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySampleMode {
    pub origin: SetPixelsFromMemorySampleModeOrigin,
    pub filter: SetPixelsFromMemorySampleModeFilter,
}

impl Mthd for SetPixelsFromMemorySampleMode {
    const ADDR: u16 = 0x088c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.origin as u32) < (1 << 1));
        val |= (self.origin as u32) << 0;

        assert!((self.filter as u32) < (1 << 1));
        val |= (self.filter as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstX0 {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstX0 {
    const ADDR: u16 = 0x08b0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstY0 {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstY0 {
    const ADDR: u16 = 0x08b4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstWidth {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstWidth {
    const ADDR: u16 = 0x08b8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstHeight {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstHeight {
    const ADDR: u16 = 0x08bc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDuDxFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDuDxFrac {
    const ADDR: u16 = 0x08c0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDuDxInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDuDxInt {
    const ADDR: u16 = 0x08c4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDvDyFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDvDyFrac {
    const ADDR: u16 = 0x08c8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDvDyInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDvDyInt {
    const ADDR: u16 = 0x08cc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySrcX0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemorySrcX0Frac {
    const ADDR: u16 = 0x08d0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySrcX0Int {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemorySrcX0Int {
    const ADDR: u16 = 0x08d4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySrcY0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemorySrcY0Frac {
    const ADDR: u16 = 0x08d8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PixelsFromMemorySrcY0Int {
    pub v: u32,
}

impl Mthd for PixelsFromMemorySrcY0Int {
    const ADDR: u16 = 0x08dc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x08e0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x08e4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x08e8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x08ec;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x08f0;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x08f4;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x08f8;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x08fc;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0900;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0904;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0908;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x090c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0910;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0914;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0918;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x091c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0920;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0924;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0928;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x092c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0930;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0934;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0938;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x093c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0940;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0944;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0948;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x094c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0950;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0954;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0958;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x095c;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWriteMethodBarrier {
    pub v: u32,
}

impl Mthd for MmeDmaWriteMethodBarrier {
    const ADDR: u16 = 0x0dec;
    const CLASS: u16 = 0x902d;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x3400 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x3800 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        (0x3804 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}
