#include "nv_push_clcbc0.h"

#include <stdio.h>

const char*
P_PARSE_NVCBC0_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVCBC0_SET_OBJECT:
        return "NVCBC0_SET_OBJECT";
    case NVCBC0_NO_OPERATION:
        return "NVCBC0_NO_OPERATION";
    case NVCBC0_SET_NOTIFY_A:
        return "NVCBC0_SET_NOTIFY_A";
    case NVCBC0_SET_NOTIFY_B:
        return "NVCBC0_SET_NOTIFY_B";
    case NVCBC0_NOTIFY:
        return "NVCBC0_NOTIFY";
    case NVCBC0_WAIT_FOR_IDLE:
        return "NVCBC0_WAIT_FOR_IDLE";
    case NVCBC0_LOAD_MME_INSTRUCTION_RAM_POINTER:
        return "NVCBC0_LOAD_MME_INSTRUCTION_RAM_POINTER";
    case NVCBC0_LOAD_MME_INSTRUCTION_RAM:
        return "NVCBC0_LOAD_MME_INSTRUCTION_RAM";
    case NVCBC0_LOAD_MME_START_ADDRESS_RAM_POINTER:
        return "NVCBC0_LOAD_MME_START_ADDRESS_RAM_POINTER";
    case NVCBC0_LOAD_MME_START_ADDRESS_RAM:
        return "NVCBC0_LOAD_MME_START_ADDRESS_RAM";
    case NVCBC0_SET_MME_SHADOW_RAM_CONTROL:
        return "NVCBC0_SET_MME_SHADOW_RAM_CONTROL";
    case NVCBC0_SET_GLOBAL_RENDER_ENABLE_A:
        return "NVCBC0_SET_GLOBAL_RENDER_ENABLE_A";
    case NVCBC0_SET_GLOBAL_RENDER_ENABLE_B:
        return "NVCBC0_SET_GLOBAL_RENDER_ENABLE_B";
    case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C:
        return "NVCBC0_SET_GLOBAL_RENDER_ENABLE_C";
    case NVCBC0_SEND_GO_IDLE:
        return "NVCBC0_SEND_GO_IDLE";
    case NVCBC0_PM_TRIGGER:
        return "NVCBC0_PM_TRIGGER";
    case NVCBC0_PM_TRIGGER_WFI:
        return "NVCBC0_PM_TRIGGER_WFI";
    case NVCBC0_FE_ATOMIC_SEQUENCE_BEGIN:
        return "NVCBC0_FE_ATOMIC_SEQUENCE_BEGIN";
    case NVCBC0_FE_ATOMIC_SEQUENCE_END:
        return "NVCBC0_FE_ATOMIC_SEQUENCE_END";
    case NVCBC0_SET_INSTRUMENTATION_METHOD_HEADER:
        return "NVCBC0_SET_INSTRUMENTATION_METHOD_HEADER";
    case NVCBC0_SET_INSTRUMENTATION_METHOD_DATA:
        return "NVCBC0_SET_INSTRUMENTATION_METHOD_DATA";
    case NVCBC0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER:
        return "NVCBC0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER";
    case NVCBC0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER:
        return "NVCBC0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER";
    case NVCBC0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER:
        return "NVCBC0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER";
    case NVCBC0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER:
        return "NVCBC0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER";
    case NVCBC0_REPORT_SEMAPHORE_EXECUTE:
        return "NVCBC0_REPORT_SEMAPHORE_EXECUTE";
    case NVCBC0_LINE_LENGTH_IN:
        return "NVCBC0_LINE_LENGTH_IN";
    case NVCBC0_LINE_COUNT:
        return "NVCBC0_LINE_COUNT";
    case NVCBC0_OFFSET_OUT_UPPER:
        return "NVCBC0_OFFSET_OUT_UPPER";
    case NVCBC0_OFFSET_OUT:
        return "NVCBC0_OFFSET_OUT";
    case NVCBC0_PITCH_OUT:
        return "NVCBC0_PITCH_OUT";
    case NVCBC0_SET_DST_BLOCK_SIZE:
        return "NVCBC0_SET_DST_BLOCK_SIZE";
    case NVCBC0_SET_DST_WIDTH:
        return "NVCBC0_SET_DST_WIDTH";
    case NVCBC0_SET_DST_HEIGHT:
        return "NVCBC0_SET_DST_HEIGHT";
    case NVCBC0_SET_DST_DEPTH:
        return "NVCBC0_SET_DST_DEPTH";
    case NVCBC0_SET_DST_LAYER:
        return "NVCBC0_SET_DST_LAYER";
    case NVCBC0_SET_DST_ORIGIN_BYTES_X:
        return "NVCBC0_SET_DST_ORIGIN_BYTES_X";
    case NVCBC0_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVCBC0_SET_DST_ORIGIN_SAMPLES_Y";
    case NVCBC0_LAUNCH_DMA:
        return "NVCBC0_LAUNCH_DMA";
    case NVCBC0_LOAD_INLINE_DATA:
        return "NVCBC0_LOAD_INLINE_DATA";
    case NVCBC0_SET_I2M_SEMAPHORE_A:
        return "NVCBC0_SET_I2M_SEMAPHORE_A";
    case NVCBC0_SET_I2M_SEMAPHORE_B:
        return "NVCBC0_SET_I2M_SEMAPHORE_B";
    case NVCBC0_SET_I2M_SEMAPHORE_C:
        return "NVCBC0_SET_I2M_SEMAPHORE_C";
    case NVCBC0_SET_SM_SCG_CONTROL:
        return "NVCBC0_SET_SM_SCG_CONTROL";
    case NVCBC0_SET_MME_SWITCH_STATE:
        return "NVCBC0_SET_MME_SWITCH_STATE";
    case NVCBC0_SET_I2M_SPARE_NOOP00:
        return "NVCBC0_SET_I2M_SPARE_NOOP00";
    case NVCBC0_SET_I2M_SPARE_NOOP01:
        return "NVCBC0_SET_I2M_SPARE_NOOP01";
    case NVCBC0_SET_I2M_SPARE_NOOP02:
        return "NVCBC0_SET_I2M_SPARE_NOOP02";
    case NVCBC0_SET_I2M_SPARE_NOOP03:
        return "NVCBC0_SET_I2M_SPARE_NOOP03";
    case NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_A:
        return "NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_A";
    case NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_B:
        return "NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_B";
    case NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_C:
        return "NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_C";
    case NVCBC0_PERFMON_TRANSFER:
        return "NVCBC0_PERFMON_TRANSFER";
    case NVCBC0_SET_QMD_VIRTUALIZATION_BASE_A:
        return "NVCBC0_SET_QMD_VIRTUALIZATION_BASE_A";
    case NVCBC0_SET_QMD_VIRTUALIZATION_BASE_B:
        return "NVCBC0_SET_QMD_VIRTUALIZATION_BASE_B";
    case NVCBC0_INVALIDATE_SHADER_CACHES:
        return "NVCBC0_INVALIDATE_SHADER_CACHES";
    case NVCBC0_SET_RESERVED_SW_METHOD00:
        return "NVCBC0_SET_RESERVED_SW_METHOD00";
    case NVCBC0_SET_RESERVED_SW_METHOD01:
        return "NVCBC0_SET_RESERVED_SW_METHOD01";
    case NVCBC0_SET_RESERVED_SW_METHOD02:
        return "NVCBC0_SET_RESERVED_SW_METHOD02";
    case NVCBC0_SET_RESERVED_SW_METHOD03:
        return "NVCBC0_SET_RESERVED_SW_METHOD03";
    case NVCBC0_SET_RESERVED_SW_METHOD04:
        return "NVCBC0_SET_RESERVED_SW_METHOD04";
    case NVCBC0_SET_RESERVED_SW_METHOD05:
        return "NVCBC0_SET_RESERVED_SW_METHOD05";
    case NVCBC0_SET_RESERVED_SW_METHOD06:
        return "NVCBC0_SET_RESERVED_SW_METHOD06";
    case NVCBC0_SET_RESERVED_SW_METHOD07:
        return "NVCBC0_SET_RESERVED_SW_METHOD07";
    case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
        return "NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI";
    case NVCBC0_SET_CWD_REF_COUNTER:
        return "NVCBC0_SET_CWD_REF_COUNTER";
    case NVCBC0_SET_RESERVED_SW_METHOD08:
        return "NVCBC0_SET_RESERVED_SW_METHOD08";
    case NVCBC0_SET_RESERVED_SW_METHOD09:
        return "NVCBC0_SET_RESERVED_SW_METHOD09";
    case NVCBC0_SET_RESERVED_SW_METHOD10:
        return "NVCBC0_SET_RESERVED_SW_METHOD10";
    case NVCBC0_SET_RESERVED_SW_METHOD11:
        return "NVCBC0_SET_RESERVED_SW_METHOD11";
    case NVCBC0_SET_RESERVED_SW_METHOD12:
        return "NVCBC0_SET_RESERVED_SW_METHOD12";
    case NVCBC0_SET_RESERVED_SW_METHOD13:
        return "NVCBC0_SET_RESERVED_SW_METHOD13";
    case NVCBC0_SET_RESERVED_SW_METHOD14:
        return "NVCBC0_SET_RESERVED_SW_METHOD14";
    case NVCBC0_SET_RESERVED_SW_METHOD15:
        return "NVCBC0_SET_RESERVED_SW_METHOD15";
    case NVCBC0_SET_COMPUTE_CLASS_VERSION:
        return "NVCBC0_SET_COMPUTE_CLASS_VERSION";
    case NVCBC0_CHECK_COMPUTE_CLASS_VERSION:
        return "NVCBC0_CHECK_COMPUTE_CLASS_VERSION";
    case NVCBC0_SET_QMD_VERSION:
        return "NVCBC0_SET_QMD_VERSION";
    case NVCBC0_INVALIDATE_SKED_CACHES:
        return "NVCBC0_INVALIDATE_SKED_CACHES";
    case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL:
        return "NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL";
    case NVCBC0_SET_SHADER_SHARED_MEMORY_WINDOW_A:
        return "NVCBC0_SET_SHADER_SHARED_MEMORY_WINDOW_A";
    case NVCBC0_SET_SHADER_SHARED_MEMORY_WINDOW_B:
        return "NVCBC0_SET_SHADER_SHARED_MEMORY_WINDOW_B";
    case NVCBC0_SET_CWD_SLOT_COUNT:
        return "NVCBC0_SET_CWD_SLOT_COUNT";
    case NVCBC0_SEND_PCAS_A:
        return "NVCBC0_SEND_PCAS_A";
    case NVCBC0_SEND_PCAS_B:
        return "NVCBC0_SEND_PCAS_B";
    case NVCBC0_SEND_SIGNALING_PCAS_B:
        return "NVCBC0_SEND_SIGNALING_PCAS_B";
    case NVCBC0_SEND_SIGNALING_PCAS2_B:
        return "NVCBC0_SEND_SIGNALING_PCAS2_B";
    case NVCBC0_SET_SKED_CACHE_CONTROL:
        return "NVCBC0_SET_SKED_CACHE_CONTROL";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C";
    case NVCBC0_SET_SPA_VERSION:
        return "NVCBC0_SET_SPA_VERSION";
    case NVCBC0_SET_INLINE_QMD_ADDRESS_A:
        return "NVCBC0_SET_INLINE_QMD_ADDRESS_A";
    case NVCBC0_SET_INLINE_QMD_ADDRESS_B:
        return "NVCBC0_SET_INLINE_QMD_ADDRESS_B";
    case NVCBC0_LOAD_INLINE_QMD_DATA(0):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(0)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(1):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(1)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(2):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(2)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(3):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(3)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(4):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(4)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(5):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(5)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(6):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(6)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(7):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(7)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(8):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(8)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(9):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(9)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(10):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(10)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(11):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(11)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(12):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(12)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(13):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(13)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(14):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(14)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(15):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(15)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(16):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(16)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(17):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(17)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(18):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(18)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(19):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(19)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(20):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(20)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(21):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(21)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(22):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(22)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(23):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(23)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(24):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(24)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(25):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(25)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(26):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(26)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(27):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(27)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(28):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(28)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(29):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(29)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(30):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(30)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(31):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(31)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(32):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(32)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(33):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(33)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(34):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(34)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(35):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(35)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(36):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(36)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(37):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(37)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(38):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(38)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(39):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(39)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(40):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(40)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(41):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(41)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(42):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(42)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(43):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(43)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(44):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(44)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(45):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(45)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(46):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(46)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(47):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(47)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(48):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(48)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(49):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(49)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(50):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(50)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(51):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(51)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(52):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(52)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(53):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(53)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(54):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(54)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(55):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(55)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(56):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(56)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(57):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(57)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(58):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(58)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(59):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(59)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(60):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(60)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(61):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(61)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(62):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(62)";
    case NVCBC0_LOAD_INLINE_QMD_DATA(63):
        return "NVCBC0_LOAD_INLINE_QMD_DATA(63)";
    case NVCBC0_SET_FALCON00:
        return "NVCBC0_SET_FALCON00";
    case NVCBC0_SET_FALCON01:
        return "NVCBC0_SET_FALCON01";
    case NVCBC0_SET_FALCON02:
        return "NVCBC0_SET_FALCON02";
    case NVCBC0_SET_FALCON03:
        return "NVCBC0_SET_FALCON03";
    case NVCBC0_SET_FALCON04:
        return "NVCBC0_SET_FALCON04";
    case NVCBC0_SET_FALCON05:
        return "NVCBC0_SET_FALCON05";
    case NVCBC0_SET_FALCON06:
        return "NVCBC0_SET_FALCON06";
    case NVCBC0_SET_FALCON07:
        return "NVCBC0_SET_FALCON07";
    case NVCBC0_SET_FALCON08:
        return "NVCBC0_SET_FALCON08";
    case NVCBC0_SET_FALCON09:
        return "NVCBC0_SET_FALCON09";
    case NVCBC0_SET_FALCON10:
        return "NVCBC0_SET_FALCON10";
    case NVCBC0_SET_FALCON11:
        return "NVCBC0_SET_FALCON11";
    case NVCBC0_SET_FALCON12:
        return "NVCBC0_SET_FALCON12";
    case NVCBC0_SET_FALCON13:
        return "NVCBC0_SET_FALCON13";
    case NVCBC0_SET_FALCON14:
        return "NVCBC0_SET_FALCON14";
    case NVCBC0_SET_FALCON15:
        return "NVCBC0_SET_FALCON15";
    case NVCBC0_SET_MME_MEM_ADDRESS_A:
        return "NVCBC0_SET_MME_MEM_ADDRESS_A";
    case NVCBC0_SET_MME_MEM_ADDRESS_B:
        return "NVCBC0_SET_MME_MEM_ADDRESS_B";
    case NVCBC0_SET_MME_DATA_RAM_ADDRESS:
        return "NVCBC0_SET_MME_DATA_RAM_ADDRESS";
    case NVCBC0_MME_DMA_READ:
        return "NVCBC0_MME_DMA_READ";
    case NVCBC0_MME_DMA_READ_FIFOED:
        return "NVCBC0_MME_DMA_READ_FIFOED";
    case NVCBC0_MME_DMA_WRITE:
        return "NVCBC0_MME_DMA_WRITE";
    case NVCBC0_MME_DMA_REDUCTION:
        return "NVCBC0_MME_DMA_REDUCTION";
    case NVCBC0_MME_DMA_SYSMEMBAR:
        return "NVCBC0_MME_DMA_SYSMEMBAR";
    case NVCBC0_MME_DMA_SYNC:
        return "NVCBC0_MME_DMA_SYNC";
    case NVCBC0_SET_MME_DATA_FIFO_CONFIG:
        return "NVCBC0_SET_MME_DATA_FIFO_CONFIG";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_A:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_A";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_B:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_B";
    case NVCBC0_SET_TEXTURE_HEADER_VERSION:
        return "NVCBC0_SET_TEXTURE_HEADER_VERSION";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_WINDOW_A:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_WINDOW_A";
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_WINDOW_B:
        return "NVCBC0_SET_SHADER_LOCAL_MEMORY_WINDOW_B";
    case NVCBC0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A:
        return "NVCBC0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A";
    case NVCBC0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B:
        return "NVCBC0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B";
    case NVCBC0_THROTTLE_SM:
        return "NVCBC0_THROTTLE_SM";
    case NVCBC0_SET_SHADER_CACHE_CONTROL:
        return "NVCBC0_SET_SHADER_CACHE_CONTROL";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(0):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(0)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(1):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(1)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(2):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(2)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(3):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(3)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(4):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(4)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(5):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(5)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(6):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(6)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(7):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(7)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(8):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(8)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(9):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(9)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(10):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(10)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(11):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(11)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(12):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(12)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(13):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(13)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(14):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(14)";
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(15):
        return "NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(15)";
    case NVCBC0_SET_SM_TIMEOUT_INTERVAL:
        return "NVCBC0_SET_SM_TIMEOUT_INTERVAL";
    case NVCBC0_MME_DMA_WRITE_METHOD_BARRIER:
        return "NVCBC0_MME_DMA_WRITE_METHOD_BARRIER";
    case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
        return "NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI";
    case NVCBC0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT:
        return "NVCBC0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT";
    case NVCBC0_INVALIDATE_SAMPLER_CACHE:
        return "NVCBC0_INVALIDATE_SAMPLER_CACHE";
    case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE:
        return "NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE";
    case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE:
        return "NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE";
    case NVCBC0_INVALIDATE_SAMPLER_CACHE_NO_WFI:
        return "NVCBC0_INVALIDATE_SAMPLER_CACHE_NO_WFI";
    case NVCBC0_SET_SHADER_EXCEPTIONS:
        return "NVCBC0_SET_SHADER_EXCEPTIONS";
    case NVCBC0_SET_RENDER_ENABLE_A:
        return "NVCBC0_SET_RENDER_ENABLE_A";
    case NVCBC0_SET_RENDER_ENABLE_B:
        return "NVCBC0_SET_RENDER_ENABLE_B";
    case NVCBC0_SET_RENDER_ENABLE_C:
        return "NVCBC0_SET_RENDER_ENABLE_C";
    case NVCBC0_SET_TEX_SAMPLER_POOL_A:
        return "NVCBC0_SET_TEX_SAMPLER_POOL_A";
    case NVCBC0_SET_TEX_SAMPLER_POOL_B:
        return "NVCBC0_SET_TEX_SAMPLER_POOL_B";
    case NVCBC0_SET_TEX_SAMPLER_POOL_C:
        return "NVCBC0_SET_TEX_SAMPLER_POOL_C";
    case NVCBC0_SET_TEX_HEADER_POOL_A:
        return "NVCBC0_SET_TEX_HEADER_POOL_A";
    case NVCBC0_SET_TEX_HEADER_POOL_B:
        return "NVCBC0_SET_TEX_HEADER_POOL_B";
    case NVCBC0_SET_TEX_HEADER_POOL_C:
        return "NVCBC0_SET_TEX_HEADER_POOL_C";
    case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI:
        return "NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI";
    case NVCBC0_SET_RENDER_ENABLE_OVERRIDE:
        return "NVCBC0_SET_RENDER_ENABLE_OVERRIDE";
    case NVCBC0_PIPE_NOP:
        return "NVCBC0_PIPE_NOP";
    case NVCBC0_SET_SPARE00:
        return "NVCBC0_SET_SPARE00";
    case NVCBC0_SET_SPARE01:
        return "NVCBC0_SET_SPARE01";
    case NVCBC0_SET_SPARE02:
        return "NVCBC0_SET_SPARE02";
    case NVCBC0_SET_SPARE03:
        return "NVCBC0_SET_SPARE03";
    case NVCBC0_SET_REPORT_SEMAPHORE_A:
        return "NVCBC0_SET_REPORT_SEMAPHORE_A";
    case NVCBC0_SET_REPORT_SEMAPHORE_B:
        return "NVCBC0_SET_REPORT_SEMAPHORE_B";
    case NVCBC0_SET_REPORT_SEMAPHORE_C:
        return "NVCBC0_SET_REPORT_SEMAPHORE_C";
    case NVCBC0_SET_REPORT_SEMAPHORE_D:
        return "NVCBC0_SET_REPORT_SEMAPHORE_D";
    case NVCBC0_SET_TRAP_HANDLER_A:
        return "NVCBC0_SET_TRAP_HANDLER_A";
    case NVCBC0_SET_TRAP_HANDLER_B:
        return "NVCBC0_SET_TRAP_HANDLER_B";
    case NVCBC0_SET_BINDLESS_TEXTURE:
        return "NVCBC0_SET_BINDLESS_TEXTURE";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7)";
    case NVCBC0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVCBC0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVCBC0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVCBC0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7)";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL";
    case NVCBC0_START_SHADER_PERFORMANCE_COUNTER:
        return "NVCBC0_START_SHADER_PERFORMANCE_COUNTER";
    case NVCBC0_STOP_SHADER_PERFORMANCE_COUNTER:
        return "NVCBC0_STOP_SHADER_PERFORMANCE_COUNTER";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER";
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
        return "NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(0):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(0)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(1):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(1)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(2):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(2)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(3):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(3)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(4):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(4)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(5):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(5)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(6):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(6)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(7):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(7)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(8):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(8)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(9):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(9)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(10):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(10)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(11):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(11)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(12):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(12)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(13):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(13)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(14):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(14)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(15):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(15)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(16):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(16)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(17):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(17)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(18):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(18)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(19):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(19)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(20):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(20)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(21):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(21)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(22):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(22)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(23):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(23)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(24):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(24)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(25):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(25)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(26):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(26)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(27):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(27)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(28):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(28)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(29):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(29)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(30):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(30)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(31):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(31)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(32):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(32)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(33):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(33)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(34):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(34)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(35):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(35)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(36):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(36)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(37):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(37)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(38):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(38)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(39):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(39)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(40):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(40)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(41):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(41)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(42):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(42)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(43):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(43)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(44):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(44)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(45):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(45)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(46):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(46)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(47):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(47)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(48):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(48)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(49):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(49)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(50):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(50)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(51):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(51)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(52):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(52)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(53):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(53)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(54):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(54)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(55):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(55)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(56):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(56)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(57):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(57)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(58):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(58)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(59):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(59)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(60):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(60)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(61):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(61)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(62):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(62)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(63):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(63)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(64):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(64)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(65):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(65)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(66):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(66)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(67):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(67)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(68):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(68)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(69):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(69)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(70):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(70)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(71):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(71)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(72):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(72)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(73):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(73)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(74):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(74)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(75):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(75)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(76):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(76)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(77):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(77)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(78):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(78)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(79):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(79)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(80):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(80)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(81):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(81)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(82):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(82)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(83):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(83)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(84):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(84)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(85):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(85)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(86):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(86)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(87):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(87)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(88):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(88)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(89):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(89)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(90):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(90)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(91):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(91)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(92):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(92)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(93):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(93)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(94):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(94)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(95):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(95)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(96):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(96)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(97):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(97)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(98):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(98)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(99):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(99)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(100):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(100)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(101):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(101)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(102):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(102)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(103):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(103)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(104):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(104)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(105):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(105)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(106):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(106)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(107):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(107)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(108):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(108)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(109):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(109)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(110):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(110)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(111):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(111)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(112):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(112)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(113):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(113)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(114):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(114)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(115):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(115)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(116):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(116)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(117):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(117)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(118):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(118)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(119):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(119)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(120):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(120)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(121):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(121)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(122):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(122)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(123):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(123)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(124):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(124)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(125):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(125)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(126):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(126)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(127):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(127)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(128):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(128)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(129):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(129)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(130):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(130)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(131):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(131)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(132):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(132)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(133):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(133)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(134):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(134)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(135):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(135)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(136):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(136)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(137):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(137)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(138):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(138)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(139):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(139)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(140):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(140)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(141):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(141)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(142):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(142)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(143):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(143)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(144):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(144)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(145):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(145)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(146):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(146)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(147):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(147)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(148):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(148)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(149):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(149)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(150):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(150)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(151):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(151)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(152):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(152)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(153):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(153)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(154):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(154)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(155):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(155)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(156):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(156)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(157):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(157)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(158):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(158)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(159):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(159)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(160):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(160)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(161):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(161)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(162):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(162)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(163):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(163)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(164):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(164)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(165):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(165)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(166):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(166)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(167):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(167)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(168):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(168)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(169):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(169)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(170):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(170)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(171):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(171)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(172):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(172)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(173):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(173)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(174):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(174)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(175):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(175)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(176):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(176)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(177):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(177)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(178):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(178)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(179):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(179)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(180):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(180)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(181):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(181)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(182):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(182)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(183):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(183)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(184):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(184)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(185):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(185)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(186):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(186)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(187):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(187)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(188):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(188)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(189):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(189)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(190):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(190)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(191):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(191)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(192):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(192)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(193):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(193)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(194):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(194)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(195):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(195)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(196):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(196)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(197):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(197)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(198):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(198)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(199):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(199)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(200):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(200)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(201):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(201)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(202):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(202)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(203):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(203)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(204):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(204)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(205):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(205)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(206):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(206)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(207):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(207)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(208):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(208)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(209):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(209)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(210):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(210)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(211):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(211)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(212):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(212)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(213):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(213)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(214):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(214)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(215):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(215)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(216):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(216)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(217):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(217)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(218):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(218)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(219):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(219)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(220):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(220)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(221):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(221)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(222):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(222)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(223):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(223)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(224):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(224)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(225):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(225)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(226):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(226)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(227):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(227)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(228):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(228)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(229):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(229)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(230):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(230)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(231):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(231)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(232):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(232)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(233):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(233)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(234):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(234)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(235):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(235)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(236):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(236)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(237):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(237)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(238):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(238)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(239):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(239)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(240):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(240)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(241):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(241)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(242):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(242)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(243):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(243)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(244):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(244)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(245):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(245)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(246):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(246)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(247):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(247)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(248):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(248)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(249):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(249)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(250):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(250)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(251):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(251)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(252):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(252)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(253):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(253)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(254):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(254)";
    case NVCBC0_SET_MME_SHADOW_SCRATCH(255):
        return "NVCBC0_SET_MME_SHADOW_SCRATCH(255)";
    case NVCBC0_CALL_MME_MACRO(0):
        return "NVCBC0_CALL_MME_MACRO(0)";
    case NVCBC0_CALL_MME_MACRO(1):
        return "NVCBC0_CALL_MME_MACRO(1)";
    case NVCBC0_CALL_MME_MACRO(2):
        return "NVCBC0_CALL_MME_MACRO(2)";
    case NVCBC0_CALL_MME_MACRO(3):
        return "NVCBC0_CALL_MME_MACRO(3)";
    case NVCBC0_CALL_MME_MACRO(4):
        return "NVCBC0_CALL_MME_MACRO(4)";
    case NVCBC0_CALL_MME_MACRO(5):
        return "NVCBC0_CALL_MME_MACRO(5)";
    case NVCBC0_CALL_MME_MACRO(6):
        return "NVCBC0_CALL_MME_MACRO(6)";
    case NVCBC0_CALL_MME_MACRO(7):
        return "NVCBC0_CALL_MME_MACRO(7)";
    case NVCBC0_CALL_MME_MACRO(8):
        return "NVCBC0_CALL_MME_MACRO(8)";
    case NVCBC0_CALL_MME_MACRO(9):
        return "NVCBC0_CALL_MME_MACRO(9)";
    case NVCBC0_CALL_MME_MACRO(10):
        return "NVCBC0_CALL_MME_MACRO(10)";
    case NVCBC0_CALL_MME_MACRO(11):
        return "NVCBC0_CALL_MME_MACRO(11)";
    case NVCBC0_CALL_MME_MACRO(12):
        return "NVCBC0_CALL_MME_MACRO(12)";
    case NVCBC0_CALL_MME_MACRO(13):
        return "NVCBC0_CALL_MME_MACRO(13)";
    case NVCBC0_CALL_MME_MACRO(14):
        return "NVCBC0_CALL_MME_MACRO(14)";
    case NVCBC0_CALL_MME_MACRO(15):
        return "NVCBC0_CALL_MME_MACRO(15)";
    case NVCBC0_CALL_MME_MACRO(16):
        return "NVCBC0_CALL_MME_MACRO(16)";
    case NVCBC0_CALL_MME_MACRO(17):
        return "NVCBC0_CALL_MME_MACRO(17)";
    case NVCBC0_CALL_MME_MACRO(18):
        return "NVCBC0_CALL_MME_MACRO(18)";
    case NVCBC0_CALL_MME_MACRO(19):
        return "NVCBC0_CALL_MME_MACRO(19)";
    case NVCBC0_CALL_MME_MACRO(20):
        return "NVCBC0_CALL_MME_MACRO(20)";
    case NVCBC0_CALL_MME_MACRO(21):
        return "NVCBC0_CALL_MME_MACRO(21)";
    case NVCBC0_CALL_MME_MACRO(22):
        return "NVCBC0_CALL_MME_MACRO(22)";
    case NVCBC0_CALL_MME_MACRO(23):
        return "NVCBC0_CALL_MME_MACRO(23)";
    case NVCBC0_CALL_MME_MACRO(24):
        return "NVCBC0_CALL_MME_MACRO(24)";
    case NVCBC0_CALL_MME_MACRO(25):
        return "NVCBC0_CALL_MME_MACRO(25)";
    case NVCBC0_CALL_MME_MACRO(26):
        return "NVCBC0_CALL_MME_MACRO(26)";
    case NVCBC0_CALL_MME_MACRO(27):
        return "NVCBC0_CALL_MME_MACRO(27)";
    case NVCBC0_CALL_MME_MACRO(28):
        return "NVCBC0_CALL_MME_MACRO(28)";
    case NVCBC0_CALL_MME_MACRO(29):
        return "NVCBC0_CALL_MME_MACRO(29)";
    case NVCBC0_CALL_MME_MACRO(30):
        return "NVCBC0_CALL_MME_MACRO(30)";
    case NVCBC0_CALL_MME_MACRO(31):
        return "NVCBC0_CALL_MME_MACRO(31)";
    case NVCBC0_CALL_MME_MACRO(32):
        return "NVCBC0_CALL_MME_MACRO(32)";
    case NVCBC0_CALL_MME_MACRO(33):
        return "NVCBC0_CALL_MME_MACRO(33)";
    case NVCBC0_CALL_MME_MACRO(34):
        return "NVCBC0_CALL_MME_MACRO(34)";
    case NVCBC0_CALL_MME_MACRO(35):
        return "NVCBC0_CALL_MME_MACRO(35)";
    case NVCBC0_CALL_MME_MACRO(36):
        return "NVCBC0_CALL_MME_MACRO(36)";
    case NVCBC0_CALL_MME_MACRO(37):
        return "NVCBC0_CALL_MME_MACRO(37)";
    case NVCBC0_CALL_MME_MACRO(38):
        return "NVCBC0_CALL_MME_MACRO(38)";
    case NVCBC0_CALL_MME_MACRO(39):
        return "NVCBC0_CALL_MME_MACRO(39)";
    case NVCBC0_CALL_MME_MACRO(40):
        return "NVCBC0_CALL_MME_MACRO(40)";
    case NVCBC0_CALL_MME_MACRO(41):
        return "NVCBC0_CALL_MME_MACRO(41)";
    case NVCBC0_CALL_MME_MACRO(42):
        return "NVCBC0_CALL_MME_MACRO(42)";
    case NVCBC0_CALL_MME_MACRO(43):
        return "NVCBC0_CALL_MME_MACRO(43)";
    case NVCBC0_CALL_MME_MACRO(44):
        return "NVCBC0_CALL_MME_MACRO(44)";
    case NVCBC0_CALL_MME_MACRO(45):
        return "NVCBC0_CALL_MME_MACRO(45)";
    case NVCBC0_CALL_MME_MACRO(46):
        return "NVCBC0_CALL_MME_MACRO(46)";
    case NVCBC0_CALL_MME_MACRO(47):
        return "NVCBC0_CALL_MME_MACRO(47)";
    case NVCBC0_CALL_MME_MACRO(48):
        return "NVCBC0_CALL_MME_MACRO(48)";
    case NVCBC0_CALL_MME_MACRO(49):
        return "NVCBC0_CALL_MME_MACRO(49)";
    case NVCBC0_CALL_MME_MACRO(50):
        return "NVCBC0_CALL_MME_MACRO(50)";
    case NVCBC0_CALL_MME_MACRO(51):
        return "NVCBC0_CALL_MME_MACRO(51)";
    case NVCBC0_CALL_MME_MACRO(52):
        return "NVCBC0_CALL_MME_MACRO(52)";
    case NVCBC0_CALL_MME_MACRO(53):
        return "NVCBC0_CALL_MME_MACRO(53)";
    case NVCBC0_CALL_MME_MACRO(54):
        return "NVCBC0_CALL_MME_MACRO(54)";
    case NVCBC0_CALL_MME_MACRO(55):
        return "NVCBC0_CALL_MME_MACRO(55)";
    case NVCBC0_CALL_MME_MACRO(56):
        return "NVCBC0_CALL_MME_MACRO(56)";
    case NVCBC0_CALL_MME_MACRO(57):
        return "NVCBC0_CALL_MME_MACRO(57)";
    case NVCBC0_CALL_MME_MACRO(58):
        return "NVCBC0_CALL_MME_MACRO(58)";
    case NVCBC0_CALL_MME_MACRO(59):
        return "NVCBC0_CALL_MME_MACRO(59)";
    case NVCBC0_CALL_MME_MACRO(60):
        return "NVCBC0_CALL_MME_MACRO(60)";
    case NVCBC0_CALL_MME_MACRO(61):
        return "NVCBC0_CALL_MME_MACRO(61)";
    case NVCBC0_CALL_MME_MACRO(62):
        return "NVCBC0_CALL_MME_MACRO(62)";
    case NVCBC0_CALL_MME_MACRO(63):
        return "NVCBC0_CALL_MME_MACRO(63)";
    case NVCBC0_CALL_MME_MACRO(64):
        return "NVCBC0_CALL_MME_MACRO(64)";
    case NVCBC0_CALL_MME_MACRO(65):
        return "NVCBC0_CALL_MME_MACRO(65)";
    case NVCBC0_CALL_MME_MACRO(66):
        return "NVCBC0_CALL_MME_MACRO(66)";
    case NVCBC0_CALL_MME_MACRO(67):
        return "NVCBC0_CALL_MME_MACRO(67)";
    case NVCBC0_CALL_MME_MACRO(68):
        return "NVCBC0_CALL_MME_MACRO(68)";
    case NVCBC0_CALL_MME_MACRO(69):
        return "NVCBC0_CALL_MME_MACRO(69)";
    case NVCBC0_CALL_MME_MACRO(70):
        return "NVCBC0_CALL_MME_MACRO(70)";
    case NVCBC0_CALL_MME_MACRO(71):
        return "NVCBC0_CALL_MME_MACRO(71)";
    case NVCBC0_CALL_MME_MACRO(72):
        return "NVCBC0_CALL_MME_MACRO(72)";
    case NVCBC0_CALL_MME_MACRO(73):
        return "NVCBC0_CALL_MME_MACRO(73)";
    case NVCBC0_CALL_MME_MACRO(74):
        return "NVCBC0_CALL_MME_MACRO(74)";
    case NVCBC0_CALL_MME_MACRO(75):
        return "NVCBC0_CALL_MME_MACRO(75)";
    case NVCBC0_CALL_MME_MACRO(76):
        return "NVCBC0_CALL_MME_MACRO(76)";
    case NVCBC0_CALL_MME_MACRO(77):
        return "NVCBC0_CALL_MME_MACRO(77)";
    case NVCBC0_CALL_MME_MACRO(78):
        return "NVCBC0_CALL_MME_MACRO(78)";
    case NVCBC0_CALL_MME_MACRO(79):
        return "NVCBC0_CALL_MME_MACRO(79)";
    case NVCBC0_CALL_MME_MACRO(80):
        return "NVCBC0_CALL_MME_MACRO(80)";
    case NVCBC0_CALL_MME_MACRO(81):
        return "NVCBC0_CALL_MME_MACRO(81)";
    case NVCBC0_CALL_MME_MACRO(82):
        return "NVCBC0_CALL_MME_MACRO(82)";
    case NVCBC0_CALL_MME_MACRO(83):
        return "NVCBC0_CALL_MME_MACRO(83)";
    case NVCBC0_CALL_MME_MACRO(84):
        return "NVCBC0_CALL_MME_MACRO(84)";
    case NVCBC0_CALL_MME_MACRO(85):
        return "NVCBC0_CALL_MME_MACRO(85)";
    case NVCBC0_CALL_MME_MACRO(86):
        return "NVCBC0_CALL_MME_MACRO(86)";
    case NVCBC0_CALL_MME_MACRO(87):
        return "NVCBC0_CALL_MME_MACRO(87)";
    case NVCBC0_CALL_MME_MACRO(88):
        return "NVCBC0_CALL_MME_MACRO(88)";
    case NVCBC0_CALL_MME_MACRO(89):
        return "NVCBC0_CALL_MME_MACRO(89)";
    case NVCBC0_CALL_MME_MACRO(90):
        return "NVCBC0_CALL_MME_MACRO(90)";
    case NVCBC0_CALL_MME_MACRO(91):
        return "NVCBC0_CALL_MME_MACRO(91)";
    case NVCBC0_CALL_MME_MACRO(92):
        return "NVCBC0_CALL_MME_MACRO(92)";
    case NVCBC0_CALL_MME_MACRO(93):
        return "NVCBC0_CALL_MME_MACRO(93)";
    case NVCBC0_CALL_MME_MACRO(94):
        return "NVCBC0_CALL_MME_MACRO(94)";
    case NVCBC0_CALL_MME_MACRO(95):
        return "NVCBC0_CALL_MME_MACRO(95)";
    case NVCBC0_CALL_MME_MACRO(96):
        return "NVCBC0_CALL_MME_MACRO(96)";
    case NVCBC0_CALL_MME_MACRO(97):
        return "NVCBC0_CALL_MME_MACRO(97)";
    case NVCBC0_CALL_MME_MACRO(98):
        return "NVCBC0_CALL_MME_MACRO(98)";
    case NVCBC0_CALL_MME_MACRO(99):
        return "NVCBC0_CALL_MME_MACRO(99)";
    case NVCBC0_CALL_MME_MACRO(100):
        return "NVCBC0_CALL_MME_MACRO(100)";
    case NVCBC0_CALL_MME_MACRO(101):
        return "NVCBC0_CALL_MME_MACRO(101)";
    case NVCBC0_CALL_MME_MACRO(102):
        return "NVCBC0_CALL_MME_MACRO(102)";
    case NVCBC0_CALL_MME_MACRO(103):
        return "NVCBC0_CALL_MME_MACRO(103)";
    case NVCBC0_CALL_MME_MACRO(104):
        return "NVCBC0_CALL_MME_MACRO(104)";
    case NVCBC0_CALL_MME_MACRO(105):
        return "NVCBC0_CALL_MME_MACRO(105)";
    case NVCBC0_CALL_MME_MACRO(106):
        return "NVCBC0_CALL_MME_MACRO(106)";
    case NVCBC0_CALL_MME_MACRO(107):
        return "NVCBC0_CALL_MME_MACRO(107)";
    case NVCBC0_CALL_MME_MACRO(108):
        return "NVCBC0_CALL_MME_MACRO(108)";
    case NVCBC0_CALL_MME_MACRO(109):
        return "NVCBC0_CALL_MME_MACRO(109)";
    case NVCBC0_CALL_MME_MACRO(110):
        return "NVCBC0_CALL_MME_MACRO(110)";
    case NVCBC0_CALL_MME_MACRO(111):
        return "NVCBC0_CALL_MME_MACRO(111)";
    case NVCBC0_CALL_MME_MACRO(112):
        return "NVCBC0_CALL_MME_MACRO(112)";
    case NVCBC0_CALL_MME_MACRO(113):
        return "NVCBC0_CALL_MME_MACRO(113)";
    case NVCBC0_CALL_MME_MACRO(114):
        return "NVCBC0_CALL_MME_MACRO(114)";
    case NVCBC0_CALL_MME_MACRO(115):
        return "NVCBC0_CALL_MME_MACRO(115)";
    case NVCBC0_CALL_MME_MACRO(116):
        return "NVCBC0_CALL_MME_MACRO(116)";
    case NVCBC0_CALL_MME_MACRO(117):
        return "NVCBC0_CALL_MME_MACRO(117)";
    case NVCBC0_CALL_MME_MACRO(118):
        return "NVCBC0_CALL_MME_MACRO(118)";
    case NVCBC0_CALL_MME_MACRO(119):
        return "NVCBC0_CALL_MME_MACRO(119)";
    case NVCBC0_CALL_MME_MACRO(120):
        return "NVCBC0_CALL_MME_MACRO(120)";
    case NVCBC0_CALL_MME_MACRO(121):
        return "NVCBC0_CALL_MME_MACRO(121)";
    case NVCBC0_CALL_MME_MACRO(122):
        return "NVCBC0_CALL_MME_MACRO(122)";
    case NVCBC0_CALL_MME_MACRO(123):
        return "NVCBC0_CALL_MME_MACRO(123)";
    case NVCBC0_CALL_MME_MACRO(124):
        return "NVCBC0_CALL_MME_MACRO(124)";
    case NVCBC0_CALL_MME_MACRO(125):
        return "NVCBC0_CALL_MME_MACRO(125)";
    case NVCBC0_CALL_MME_MACRO(126):
        return "NVCBC0_CALL_MME_MACRO(126)";
    case NVCBC0_CALL_MME_MACRO(127):
        return "NVCBC0_CALL_MME_MACRO(127)";
    case NVCBC0_CALL_MME_MACRO(128):
        return "NVCBC0_CALL_MME_MACRO(128)";
    case NVCBC0_CALL_MME_MACRO(129):
        return "NVCBC0_CALL_MME_MACRO(129)";
    case NVCBC0_CALL_MME_MACRO(130):
        return "NVCBC0_CALL_MME_MACRO(130)";
    case NVCBC0_CALL_MME_MACRO(131):
        return "NVCBC0_CALL_MME_MACRO(131)";
    case NVCBC0_CALL_MME_MACRO(132):
        return "NVCBC0_CALL_MME_MACRO(132)";
    case NVCBC0_CALL_MME_MACRO(133):
        return "NVCBC0_CALL_MME_MACRO(133)";
    case NVCBC0_CALL_MME_MACRO(134):
        return "NVCBC0_CALL_MME_MACRO(134)";
    case NVCBC0_CALL_MME_MACRO(135):
        return "NVCBC0_CALL_MME_MACRO(135)";
    case NVCBC0_CALL_MME_MACRO(136):
        return "NVCBC0_CALL_MME_MACRO(136)";
    case NVCBC0_CALL_MME_MACRO(137):
        return "NVCBC0_CALL_MME_MACRO(137)";
    case NVCBC0_CALL_MME_MACRO(138):
        return "NVCBC0_CALL_MME_MACRO(138)";
    case NVCBC0_CALL_MME_MACRO(139):
        return "NVCBC0_CALL_MME_MACRO(139)";
    case NVCBC0_CALL_MME_MACRO(140):
        return "NVCBC0_CALL_MME_MACRO(140)";
    case NVCBC0_CALL_MME_MACRO(141):
        return "NVCBC0_CALL_MME_MACRO(141)";
    case NVCBC0_CALL_MME_MACRO(142):
        return "NVCBC0_CALL_MME_MACRO(142)";
    case NVCBC0_CALL_MME_MACRO(143):
        return "NVCBC0_CALL_MME_MACRO(143)";
    case NVCBC0_CALL_MME_MACRO(144):
        return "NVCBC0_CALL_MME_MACRO(144)";
    case NVCBC0_CALL_MME_MACRO(145):
        return "NVCBC0_CALL_MME_MACRO(145)";
    case NVCBC0_CALL_MME_MACRO(146):
        return "NVCBC0_CALL_MME_MACRO(146)";
    case NVCBC0_CALL_MME_MACRO(147):
        return "NVCBC0_CALL_MME_MACRO(147)";
    case NVCBC0_CALL_MME_MACRO(148):
        return "NVCBC0_CALL_MME_MACRO(148)";
    case NVCBC0_CALL_MME_MACRO(149):
        return "NVCBC0_CALL_MME_MACRO(149)";
    case NVCBC0_CALL_MME_MACRO(150):
        return "NVCBC0_CALL_MME_MACRO(150)";
    case NVCBC0_CALL_MME_MACRO(151):
        return "NVCBC0_CALL_MME_MACRO(151)";
    case NVCBC0_CALL_MME_MACRO(152):
        return "NVCBC0_CALL_MME_MACRO(152)";
    case NVCBC0_CALL_MME_MACRO(153):
        return "NVCBC0_CALL_MME_MACRO(153)";
    case NVCBC0_CALL_MME_MACRO(154):
        return "NVCBC0_CALL_MME_MACRO(154)";
    case NVCBC0_CALL_MME_MACRO(155):
        return "NVCBC0_CALL_MME_MACRO(155)";
    case NVCBC0_CALL_MME_MACRO(156):
        return "NVCBC0_CALL_MME_MACRO(156)";
    case NVCBC0_CALL_MME_MACRO(157):
        return "NVCBC0_CALL_MME_MACRO(157)";
    case NVCBC0_CALL_MME_MACRO(158):
        return "NVCBC0_CALL_MME_MACRO(158)";
    case NVCBC0_CALL_MME_MACRO(159):
        return "NVCBC0_CALL_MME_MACRO(159)";
    case NVCBC0_CALL_MME_MACRO(160):
        return "NVCBC0_CALL_MME_MACRO(160)";
    case NVCBC0_CALL_MME_MACRO(161):
        return "NVCBC0_CALL_MME_MACRO(161)";
    case NVCBC0_CALL_MME_MACRO(162):
        return "NVCBC0_CALL_MME_MACRO(162)";
    case NVCBC0_CALL_MME_MACRO(163):
        return "NVCBC0_CALL_MME_MACRO(163)";
    case NVCBC0_CALL_MME_MACRO(164):
        return "NVCBC0_CALL_MME_MACRO(164)";
    case NVCBC0_CALL_MME_MACRO(165):
        return "NVCBC0_CALL_MME_MACRO(165)";
    case NVCBC0_CALL_MME_MACRO(166):
        return "NVCBC0_CALL_MME_MACRO(166)";
    case NVCBC0_CALL_MME_MACRO(167):
        return "NVCBC0_CALL_MME_MACRO(167)";
    case NVCBC0_CALL_MME_MACRO(168):
        return "NVCBC0_CALL_MME_MACRO(168)";
    case NVCBC0_CALL_MME_MACRO(169):
        return "NVCBC0_CALL_MME_MACRO(169)";
    case NVCBC0_CALL_MME_MACRO(170):
        return "NVCBC0_CALL_MME_MACRO(170)";
    case NVCBC0_CALL_MME_MACRO(171):
        return "NVCBC0_CALL_MME_MACRO(171)";
    case NVCBC0_CALL_MME_MACRO(172):
        return "NVCBC0_CALL_MME_MACRO(172)";
    case NVCBC0_CALL_MME_MACRO(173):
        return "NVCBC0_CALL_MME_MACRO(173)";
    case NVCBC0_CALL_MME_MACRO(174):
        return "NVCBC0_CALL_MME_MACRO(174)";
    case NVCBC0_CALL_MME_MACRO(175):
        return "NVCBC0_CALL_MME_MACRO(175)";
    case NVCBC0_CALL_MME_MACRO(176):
        return "NVCBC0_CALL_MME_MACRO(176)";
    case NVCBC0_CALL_MME_MACRO(177):
        return "NVCBC0_CALL_MME_MACRO(177)";
    case NVCBC0_CALL_MME_MACRO(178):
        return "NVCBC0_CALL_MME_MACRO(178)";
    case NVCBC0_CALL_MME_MACRO(179):
        return "NVCBC0_CALL_MME_MACRO(179)";
    case NVCBC0_CALL_MME_MACRO(180):
        return "NVCBC0_CALL_MME_MACRO(180)";
    case NVCBC0_CALL_MME_MACRO(181):
        return "NVCBC0_CALL_MME_MACRO(181)";
    case NVCBC0_CALL_MME_MACRO(182):
        return "NVCBC0_CALL_MME_MACRO(182)";
    case NVCBC0_CALL_MME_MACRO(183):
        return "NVCBC0_CALL_MME_MACRO(183)";
    case NVCBC0_CALL_MME_MACRO(184):
        return "NVCBC0_CALL_MME_MACRO(184)";
    case NVCBC0_CALL_MME_MACRO(185):
        return "NVCBC0_CALL_MME_MACRO(185)";
    case NVCBC0_CALL_MME_MACRO(186):
        return "NVCBC0_CALL_MME_MACRO(186)";
    case NVCBC0_CALL_MME_MACRO(187):
        return "NVCBC0_CALL_MME_MACRO(187)";
    case NVCBC0_CALL_MME_MACRO(188):
        return "NVCBC0_CALL_MME_MACRO(188)";
    case NVCBC0_CALL_MME_MACRO(189):
        return "NVCBC0_CALL_MME_MACRO(189)";
    case NVCBC0_CALL_MME_MACRO(190):
        return "NVCBC0_CALL_MME_MACRO(190)";
    case NVCBC0_CALL_MME_MACRO(191):
        return "NVCBC0_CALL_MME_MACRO(191)";
    case NVCBC0_CALL_MME_MACRO(192):
        return "NVCBC0_CALL_MME_MACRO(192)";
    case NVCBC0_CALL_MME_MACRO(193):
        return "NVCBC0_CALL_MME_MACRO(193)";
    case NVCBC0_CALL_MME_MACRO(194):
        return "NVCBC0_CALL_MME_MACRO(194)";
    case NVCBC0_CALL_MME_MACRO(195):
        return "NVCBC0_CALL_MME_MACRO(195)";
    case NVCBC0_CALL_MME_MACRO(196):
        return "NVCBC0_CALL_MME_MACRO(196)";
    case NVCBC0_CALL_MME_MACRO(197):
        return "NVCBC0_CALL_MME_MACRO(197)";
    case NVCBC0_CALL_MME_MACRO(198):
        return "NVCBC0_CALL_MME_MACRO(198)";
    case NVCBC0_CALL_MME_MACRO(199):
        return "NVCBC0_CALL_MME_MACRO(199)";
    case NVCBC0_CALL_MME_MACRO(200):
        return "NVCBC0_CALL_MME_MACRO(200)";
    case NVCBC0_CALL_MME_MACRO(201):
        return "NVCBC0_CALL_MME_MACRO(201)";
    case NVCBC0_CALL_MME_MACRO(202):
        return "NVCBC0_CALL_MME_MACRO(202)";
    case NVCBC0_CALL_MME_MACRO(203):
        return "NVCBC0_CALL_MME_MACRO(203)";
    case NVCBC0_CALL_MME_MACRO(204):
        return "NVCBC0_CALL_MME_MACRO(204)";
    case NVCBC0_CALL_MME_MACRO(205):
        return "NVCBC0_CALL_MME_MACRO(205)";
    case NVCBC0_CALL_MME_MACRO(206):
        return "NVCBC0_CALL_MME_MACRO(206)";
    case NVCBC0_CALL_MME_MACRO(207):
        return "NVCBC0_CALL_MME_MACRO(207)";
    case NVCBC0_CALL_MME_MACRO(208):
        return "NVCBC0_CALL_MME_MACRO(208)";
    case NVCBC0_CALL_MME_MACRO(209):
        return "NVCBC0_CALL_MME_MACRO(209)";
    case NVCBC0_CALL_MME_MACRO(210):
        return "NVCBC0_CALL_MME_MACRO(210)";
    case NVCBC0_CALL_MME_MACRO(211):
        return "NVCBC0_CALL_MME_MACRO(211)";
    case NVCBC0_CALL_MME_MACRO(212):
        return "NVCBC0_CALL_MME_MACRO(212)";
    case NVCBC0_CALL_MME_MACRO(213):
        return "NVCBC0_CALL_MME_MACRO(213)";
    case NVCBC0_CALL_MME_MACRO(214):
        return "NVCBC0_CALL_MME_MACRO(214)";
    case NVCBC0_CALL_MME_MACRO(215):
        return "NVCBC0_CALL_MME_MACRO(215)";
    case NVCBC0_CALL_MME_MACRO(216):
        return "NVCBC0_CALL_MME_MACRO(216)";
    case NVCBC0_CALL_MME_MACRO(217):
        return "NVCBC0_CALL_MME_MACRO(217)";
    case NVCBC0_CALL_MME_MACRO(218):
        return "NVCBC0_CALL_MME_MACRO(218)";
    case NVCBC0_CALL_MME_MACRO(219):
        return "NVCBC0_CALL_MME_MACRO(219)";
    case NVCBC0_CALL_MME_MACRO(220):
        return "NVCBC0_CALL_MME_MACRO(220)";
    case NVCBC0_CALL_MME_MACRO(221):
        return "NVCBC0_CALL_MME_MACRO(221)";
    case NVCBC0_CALL_MME_MACRO(222):
        return "NVCBC0_CALL_MME_MACRO(222)";
    case NVCBC0_CALL_MME_MACRO(223):
        return "NVCBC0_CALL_MME_MACRO(223)";
    case NVCBC0_CALL_MME_MACRO(224):
        return "NVCBC0_CALL_MME_MACRO(224)";
    case NVCBC0_CALL_MME_MACRO(225):
        return "NVCBC0_CALL_MME_MACRO(225)";
    case NVCBC0_CALL_MME_MACRO(226):
        return "NVCBC0_CALL_MME_MACRO(226)";
    case NVCBC0_CALL_MME_MACRO(227):
        return "NVCBC0_CALL_MME_MACRO(227)";
    case NVCBC0_CALL_MME_MACRO(228):
        return "NVCBC0_CALL_MME_MACRO(228)";
    case NVCBC0_CALL_MME_MACRO(229):
        return "NVCBC0_CALL_MME_MACRO(229)";
    case NVCBC0_CALL_MME_MACRO(230):
        return "NVCBC0_CALL_MME_MACRO(230)";
    case NVCBC0_CALL_MME_MACRO(231):
        return "NVCBC0_CALL_MME_MACRO(231)";
    case NVCBC0_CALL_MME_MACRO(232):
        return "NVCBC0_CALL_MME_MACRO(232)";
    case NVCBC0_CALL_MME_MACRO(233):
        return "NVCBC0_CALL_MME_MACRO(233)";
    case NVCBC0_CALL_MME_MACRO(234):
        return "NVCBC0_CALL_MME_MACRO(234)";
    case NVCBC0_CALL_MME_MACRO(235):
        return "NVCBC0_CALL_MME_MACRO(235)";
    case NVCBC0_CALL_MME_MACRO(236):
        return "NVCBC0_CALL_MME_MACRO(236)";
    case NVCBC0_CALL_MME_MACRO(237):
        return "NVCBC0_CALL_MME_MACRO(237)";
    case NVCBC0_CALL_MME_MACRO(238):
        return "NVCBC0_CALL_MME_MACRO(238)";
    case NVCBC0_CALL_MME_MACRO(239):
        return "NVCBC0_CALL_MME_MACRO(239)";
    case NVCBC0_CALL_MME_MACRO(240):
        return "NVCBC0_CALL_MME_MACRO(240)";
    case NVCBC0_CALL_MME_MACRO(241):
        return "NVCBC0_CALL_MME_MACRO(241)";
    case NVCBC0_CALL_MME_MACRO(242):
        return "NVCBC0_CALL_MME_MACRO(242)";
    case NVCBC0_CALL_MME_MACRO(243):
        return "NVCBC0_CALL_MME_MACRO(243)";
    case NVCBC0_CALL_MME_MACRO(244):
        return "NVCBC0_CALL_MME_MACRO(244)";
    case NVCBC0_CALL_MME_MACRO(245):
        return "NVCBC0_CALL_MME_MACRO(245)";
    case NVCBC0_CALL_MME_MACRO(246):
        return "NVCBC0_CALL_MME_MACRO(246)";
    case NVCBC0_CALL_MME_MACRO(247):
        return "NVCBC0_CALL_MME_MACRO(247)";
    case NVCBC0_CALL_MME_MACRO(248):
        return "NVCBC0_CALL_MME_MACRO(248)";
    case NVCBC0_CALL_MME_MACRO(249):
        return "NVCBC0_CALL_MME_MACRO(249)";
    case NVCBC0_CALL_MME_MACRO(250):
        return "NVCBC0_CALL_MME_MACRO(250)";
    case NVCBC0_CALL_MME_MACRO(251):
        return "NVCBC0_CALL_MME_MACRO(251)";
    case NVCBC0_CALL_MME_MACRO(252):
        return "NVCBC0_CALL_MME_MACRO(252)";
    case NVCBC0_CALL_MME_MACRO(253):
        return "NVCBC0_CALL_MME_MACRO(253)";
    case NVCBC0_CALL_MME_MACRO(254):
        return "NVCBC0_CALL_MME_MACRO(254)";
    case NVCBC0_CALL_MME_MACRO(255):
        return "NVCBC0_CALL_MME_MACRO(255)";
    case NVCBC0_CALL_MME_DATA(0):
        return "NVCBC0_CALL_MME_DATA(0)";
    case NVCBC0_CALL_MME_DATA(1):
        return "NVCBC0_CALL_MME_DATA(1)";
    case NVCBC0_CALL_MME_DATA(2):
        return "NVCBC0_CALL_MME_DATA(2)";
    case NVCBC0_CALL_MME_DATA(3):
        return "NVCBC0_CALL_MME_DATA(3)";
    case NVCBC0_CALL_MME_DATA(4):
        return "NVCBC0_CALL_MME_DATA(4)";
    case NVCBC0_CALL_MME_DATA(5):
        return "NVCBC0_CALL_MME_DATA(5)";
    case NVCBC0_CALL_MME_DATA(6):
        return "NVCBC0_CALL_MME_DATA(6)";
    case NVCBC0_CALL_MME_DATA(7):
        return "NVCBC0_CALL_MME_DATA(7)";
    case NVCBC0_CALL_MME_DATA(8):
        return "NVCBC0_CALL_MME_DATA(8)";
    case NVCBC0_CALL_MME_DATA(9):
        return "NVCBC0_CALL_MME_DATA(9)";
    case NVCBC0_CALL_MME_DATA(10):
        return "NVCBC0_CALL_MME_DATA(10)";
    case NVCBC0_CALL_MME_DATA(11):
        return "NVCBC0_CALL_MME_DATA(11)";
    case NVCBC0_CALL_MME_DATA(12):
        return "NVCBC0_CALL_MME_DATA(12)";
    case NVCBC0_CALL_MME_DATA(13):
        return "NVCBC0_CALL_MME_DATA(13)";
    case NVCBC0_CALL_MME_DATA(14):
        return "NVCBC0_CALL_MME_DATA(14)";
    case NVCBC0_CALL_MME_DATA(15):
        return "NVCBC0_CALL_MME_DATA(15)";
    case NVCBC0_CALL_MME_DATA(16):
        return "NVCBC0_CALL_MME_DATA(16)";
    case NVCBC0_CALL_MME_DATA(17):
        return "NVCBC0_CALL_MME_DATA(17)";
    case NVCBC0_CALL_MME_DATA(18):
        return "NVCBC0_CALL_MME_DATA(18)";
    case NVCBC0_CALL_MME_DATA(19):
        return "NVCBC0_CALL_MME_DATA(19)";
    case NVCBC0_CALL_MME_DATA(20):
        return "NVCBC0_CALL_MME_DATA(20)";
    case NVCBC0_CALL_MME_DATA(21):
        return "NVCBC0_CALL_MME_DATA(21)";
    case NVCBC0_CALL_MME_DATA(22):
        return "NVCBC0_CALL_MME_DATA(22)";
    case NVCBC0_CALL_MME_DATA(23):
        return "NVCBC0_CALL_MME_DATA(23)";
    case NVCBC0_CALL_MME_DATA(24):
        return "NVCBC0_CALL_MME_DATA(24)";
    case NVCBC0_CALL_MME_DATA(25):
        return "NVCBC0_CALL_MME_DATA(25)";
    case NVCBC0_CALL_MME_DATA(26):
        return "NVCBC0_CALL_MME_DATA(26)";
    case NVCBC0_CALL_MME_DATA(27):
        return "NVCBC0_CALL_MME_DATA(27)";
    case NVCBC0_CALL_MME_DATA(28):
        return "NVCBC0_CALL_MME_DATA(28)";
    case NVCBC0_CALL_MME_DATA(29):
        return "NVCBC0_CALL_MME_DATA(29)";
    case NVCBC0_CALL_MME_DATA(30):
        return "NVCBC0_CALL_MME_DATA(30)";
    case NVCBC0_CALL_MME_DATA(31):
        return "NVCBC0_CALL_MME_DATA(31)";
    case NVCBC0_CALL_MME_DATA(32):
        return "NVCBC0_CALL_MME_DATA(32)";
    case NVCBC0_CALL_MME_DATA(33):
        return "NVCBC0_CALL_MME_DATA(33)";
    case NVCBC0_CALL_MME_DATA(34):
        return "NVCBC0_CALL_MME_DATA(34)";
    case NVCBC0_CALL_MME_DATA(35):
        return "NVCBC0_CALL_MME_DATA(35)";
    case NVCBC0_CALL_MME_DATA(36):
        return "NVCBC0_CALL_MME_DATA(36)";
    case NVCBC0_CALL_MME_DATA(37):
        return "NVCBC0_CALL_MME_DATA(37)";
    case NVCBC0_CALL_MME_DATA(38):
        return "NVCBC0_CALL_MME_DATA(38)";
    case NVCBC0_CALL_MME_DATA(39):
        return "NVCBC0_CALL_MME_DATA(39)";
    case NVCBC0_CALL_MME_DATA(40):
        return "NVCBC0_CALL_MME_DATA(40)";
    case NVCBC0_CALL_MME_DATA(41):
        return "NVCBC0_CALL_MME_DATA(41)";
    case NVCBC0_CALL_MME_DATA(42):
        return "NVCBC0_CALL_MME_DATA(42)";
    case NVCBC0_CALL_MME_DATA(43):
        return "NVCBC0_CALL_MME_DATA(43)";
    case NVCBC0_CALL_MME_DATA(44):
        return "NVCBC0_CALL_MME_DATA(44)";
    case NVCBC0_CALL_MME_DATA(45):
        return "NVCBC0_CALL_MME_DATA(45)";
    case NVCBC0_CALL_MME_DATA(46):
        return "NVCBC0_CALL_MME_DATA(46)";
    case NVCBC0_CALL_MME_DATA(47):
        return "NVCBC0_CALL_MME_DATA(47)";
    case NVCBC0_CALL_MME_DATA(48):
        return "NVCBC0_CALL_MME_DATA(48)";
    case NVCBC0_CALL_MME_DATA(49):
        return "NVCBC0_CALL_MME_DATA(49)";
    case NVCBC0_CALL_MME_DATA(50):
        return "NVCBC0_CALL_MME_DATA(50)";
    case NVCBC0_CALL_MME_DATA(51):
        return "NVCBC0_CALL_MME_DATA(51)";
    case NVCBC0_CALL_MME_DATA(52):
        return "NVCBC0_CALL_MME_DATA(52)";
    case NVCBC0_CALL_MME_DATA(53):
        return "NVCBC0_CALL_MME_DATA(53)";
    case NVCBC0_CALL_MME_DATA(54):
        return "NVCBC0_CALL_MME_DATA(54)";
    case NVCBC0_CALL_MME_DATA(55):
        return "NVCBC0_CALL_MME_DATA(55)";
    case NVCBC0_CALL_MME_DATA(56):
        return "NVCBC0_CALL_MME_DATA(56)";
    case NVCBC0_CALL_MME_DATA(57):
        return "NVCBC0_CALL_MME_DATA(57)";
    case NVCBC0_CALL_MME_DATA(58):
        return "NVCBC0_CALL_MME_DATA(58)";
    case NVCBC0_CALL_MME_DATA(59):
        return "NVCBC0_CALL_MME_DATA(59)";
    case NVCBC0_CALL_MME_DATA(60):
        return "NVCBC0_CALL_MME_DATA(60)";
    case NVCBC0_CALL_MME_DATA(61):
        return "NVCBC0_CALL_MME_DATA(61)";
    case NVCBC0_CALL_MME_DATA(62):
        return "NVCBC0_CALL_MME_DATA(62)";
    case NVCBC0_CALL_MME_DATA(63):
        return "NVCBC0_CALL_MME_DATA(63)";
    case NVCBC0_CALL_MME_DATA(64):
        return "NVCBC0_CALL_MME_DATA(64)";
    case NVCBC0_CALL_MME_DATA(65):
        return "NVCBC0_CALL_MME_DATA(65)";
    case NVCBC0_CALL_MME_DATA(66):
        return "NVCBC0_CALL_MME_DATA(66)";
    case NVCBC0_CALL_MME_DATA(67):
        return "NVCBC0_CALL_MME_DATA(67)";
    case NVCBC0_CALL_MME_DATA(68):
        return "NVCBC0_CALL_MME_DATA(68)";
    case NVCBC0_CALL_MME_DATA(69):
        return "NVCBC0_CALL_MME_DATA(69)";
    case NVCBC0_CALL_MME_DATA(70):
        return "NVCBC0_CALL_MME_DATA(70)";
    case NVCBC0_CALL_MME_DATA(71):
        return "NVCBC0_CALL_MME_DATA(71)";
    case NVCBC0_CALL_MME_DATA(72):
        return "NVCBC0_CALL_MME_DATA(72)";
    case NVCBC0_CALL_MME_DATA(73):
        return "NVCBC0_CALL_MME_DATA(73)";
    case NVCBC0_CALL_MME_DATA(74):
        return "NVCBC0_CALL_MME_DATA(74)";
    case NVCBC0_CALL_MME_DATA(75):
        return "NVCBC0_CALL_MME_DATA(75)";
    case NVCBC0_CALL_MME_DATA(76):
        return "NVCBC0_CALL_MME_DATA(76)";
    case NVCBC0_CALL_MME_DATA(77):
        return "NVCBC0_CALL_MME_DATA(77)";
    case NVCBC0_CALL_MME_DATA(78):
        return "NVCBC0_CALL_MME_DATA(78)";
    case NVCBC0_CALL_MME_DATA(79):
        return "NVCBC0_CALL_MME_DATA(79)";
    case NVCBC0_CALL_MME_DATA(80):
        return "NVCBC0_CALL_MME_DATA(80)";
    case NVCBC0_CALL_MME_DATA(81):
        return "NVCBC0_CALL_MME_DATA(81)";
    case NVCBC0_CALL_MME_DATA(82):
        return "NVCBC0_CALL_MME_DATA(82)";
    case NVCBC0_CALL_MME_DATA(83):
        return "NVCBC0_CALL_MME_DATA(83)";
    case NVCBC0_CALL_MME_DATA(84):
        return "NVCBC0_CALL_MME_DATA(84)";
    case NVCBC0_CALL_MME_DATA(85):
        return "NVCBC0_CALL_MME_DATA(85)";
    case NVCBC0_CALL_MME_DATA(86):
        return "NVCBC0_CALL_MME_DATA(86)";
    case NVCBC0_CALL_MME_DATA(87):
        return "NVCBC0_CALL_MME_DATA(87)";
    case NVCBC0_CALL_MME_DATA(88):
        return "NVCBC0_CALL_MME_DATA(88)";
    case NVCBC0_CALL_MME_DATA(89):
        return "NVCBC0_CALL_MME_DATA(89)";
    case NVCBC0_CALL_MME_DATA(90):
        return "NVCBC0_CALL_MME_DATA(90)";
    case NVCBC0_CALL_MME_DATA(91):
        return "NVCBC0_CALL_MME_DATA(91)";
    case NVCBC0_CALL_MME_DATA(92):
        return "NVCBC0_CALL_MME_DATA(92)";
    case NVCBC0_CALL_MME_DATA(93):
        return "NVCBC0_CALL_MME_DATA(93)";
    case NVCBC0_CALL_MME_DATA(94):
        return "NVCBC0_CALL_MME_DATA(94)";
    case NVCBC0_CALL_MME_DATA(95):
        return "NVCBC0_CALL_MME_DATA(95)";
    case NVCBC0_CALL_MME_DATA(96):
        return "NVCBC0_CALL_MME_DATA(96)";
    case NVCBC0_CALL_MME_DATA(97):
        return "NVCBC0_CALL_MME_DATA(97)";
    case NVCBC0_CALL_MME_DATA(98):
        return "NVCBC0_CALL_MME_DATA(98)";
    case NVCBC0_CALL_MME_DATA(99):
        return "NVCBC0_CALL_MME_DATA(99)";
    case NVCBC0_CALL_MME_DATA(100):
        return "NVCBC0_CALL_MME_DATA(100)";
    case NVCBC0_CALL_MME_DATA(101):
        return "NVCBC0_CALL_MME_DATA(101)";
    case NVCBC0_CALL_MME_DATA(102):
        return "NVCBC0_CALL_MME_DATA(102)";
    case NVCBC0_CALL_MME_DATA(103):
        return "NVCBC0_CALL_MME_DATA(103)";
    case NVCBC0_CALL_MME_DATA(104):
        return "NVCBC0_CALL_MME_DATA(104)";
    case NVCBC0_CALL_MME_DATA(105):
        return "NVCBC0_CALL_MME_DATA(105)";
    case NVCBC0_CALL_MME_DATA(106):
        return "NVCBC0_CALL_MME_DATA(106)";
    case NVCBC0_CALL_MME_DATA(107):
        return "NVCBC0_CALL_MME_DATA(107)";
    case NVCBC0_CALL_MME_DATA(108):
        return "NVCBC0_CALL_MME_DATA(108)";
    case NVCBC0_CALL_MME_DATA(109):
        return "NVCBC0_CALL_MME_DATA(109)";
    case NVCBC0_CALL_MME_DATA(110):
        return "NVCBC0_CALL_MME_DATA(110)";
    case NVCBC0_CALL_MME_DATA(111):
        return "NVCBC0_CALL_MME_DATA(111)";
    case NVCBC0_CALL_MME_DATA(112):
        return "NVCBC0_CALL_MME_DATA(112)";
    case NVCBC0_CALL_MME_DATA(113):
        return "NVCBC0_CALL_MME_DATA(113)";
    case NVCBC0_CALL_MME_DATA(114):
        return "NVCBC0_CALL_MME_DATA(114)";
    case NVCBC0_CALL_MME_DATA(115):
        return "NVCBC0_CALL_MME_DATA(115)";
    case NVCBC0_CALL_MME_DATA(116):
        return "NVCBC0_CALL_MME_DATA(116)";
    case NVCBC0_CALL_MME_DATA(117):
        return "NVCBC0_CALL_MME_DATA(117)";
    case NVCBC0_CALL_MME_DATA(118):
        return "NVCBC0_CALL_MME_DATA(118)";
    case NVCBC0_CALL_MME_DATA(119):
        return "NVCBC0_CALL_MME_DATA(119)";
    case NVCBC0_CALL_MME_DATA(120):
        return "NVCBC0_CALL_MME_DATA(120)";
    case NVCBC0_CALL_MME_DATA(121):
        return "NVCBC0_CALL_MME_DATA(121)";
    case NVCBC0_CALL_MME_DATA(122):
        return "NVCBC0_CALL_MME_DATA(122)";
    case NVCBC0_CALL_MME_DATA(123):
        return "NVCBC0_CALL_MME_DATA(123)";
    case NVCBC0_CALL_MME_DATA(124):
        return "NVCBC0_CALL_MME_DATA(124)";
    case NVCBC0_CALL_MME_DATA(125):
        return "NVCBC0_CALL_MME_DATA(125)";
    case NVCBC0_CALL_MME_DATA(126):
        return "NVCBC0_CALL_MME_DATA(126)";
    case NVCBC0_CALL_MME_DATA(127):
        return "NVCBC0_CALL_MME_DATA(127)";
    case NVCBC0_CALL_MME_DATA(128):
        return "NVCBC0_CALL_MME_DATA(128)";
    case NVCBC0_CALL_MME_DATA(129):
        return "NVCBC0_CALL_MME_DATA(129)";
    case NVCBC0_CALL_MME_DATA(130):
        return "NVCBC0_CALL_MME_DATA(130)";
    case NVCBC0_CALL_MME_DATA(131):
        return "NVCBC0_CALL_MME_DATA(131)";
    case NVCBC0_CALL_MME_DATA(132):
        return "NVCBC0_CALL_MME_DATA(132)";
    case NVCBC0_CALL_MME_DATA(133):
        return "NVCBC0_CALL_MME_DATA(133)";
    case NVCBC0_CALL_MME_DATA(134):
        return "NVCBC0_CALL_MME_DATA(134)";
    case NVCBC0_CALL_MME_DATA(135):
        return "NVCBC0_CALL_MME_DATA(135)";
    case NVCBC0_CALL_MME_DATA(136):
        return "NVCBC0_CALL_MME_DATA(136)";
    case NVCBC0_CALL_MME_DATA(137):
        return "NVCBC0_CALL_MME_DATA(137)";
    case NVCBC0_CALL_MME_DATA(138):
        return "NVCBC0_CALL_MME_DATA(138)";
    case NVCBC0_CALL_MME_DATA(139):
        return "NVCBC0_CALL_MME_DATA(139)";
    case NVCBC0_CALL_MME_DATA(140):
        return "NVCBC0_CALL_MME_DATA(140)";
    case NVCBC0_CALL_MME_DATA(141):
        return "NVCBC0_CALL_MME_DATA(141)";
    case NVCBC0_CALL_MME_DATA(142):
        return "NVCBC0_CALL_MME_DATA(142)";
    case NVCBC0_CALL_MME_DATA(143):
        return "NVCBC0_CALL_MME_DATA(143)";
    case NVCBC0_CALL_MME_DATA(144):
        return "NVCBC0_CALL_MME_DATA(144)";
    case NVCBC0_CALL_MME_DATA(145):
        return "NVCBC0_CALL_MME_DATA(145)";
    case NVCBC0_CALL_MME_DATA(146):
        return "NVCBC0_CALL_MME_DATA(146)";
    case NVCBC0_CALL_MME_DATA(147):
        return "NVCBC0_CALL_MME_DATA(147)";
    case NVCBC0_CALL_MME_DATA(148):
        return "NVCBC0_CALL_MME_DATA(148)";
    case NVCBC0_CALL_MME_DATA(149):
        return "NVCBC0_CALL_MME_DATA(149)";
    case NVCBC0_CALL_MME_DATA(150):
        return "NVCBC0_CALL_MME_DATA(150)";
    case NVCBC0_CALL_MME_DATA(151):
        return "NVCBC0_CALL_MME_DATA(151)";
    case NVCBC0_CALL_MME_DATA(152):
        return "NVCBC0_CALL_MME_DATA(152)";
    case NVCBC0_CALL_MME_DATA(153):
        return "NVCBC0_CALL_MME_DATA(153)";
    case NVCBC0_CALL_MME_DATA(154):
        return "NVCBC0_CALL_MME_DATA(154)";
    case NVCBC0_CALL_MME_DATA(155):
        return "NVCBC0_CALL_MME_DATA(155)";
    case NVCBC0_CALL_MME_DATA(156):
        return "NVCBC0_CALL_MME_DATA(156)";
    case NVCBC0_CALL_MME_DATA(157):
        return "NVCBC0_CALL_MME_DATA(157)";
    case NVCBC0_CALL_MME_DATA(158):
        return "NVCBC0_CALL_MME_DATA(158)";
    case NVCBC0_CALL_MME_DATA(159):
        return "NVCBC0_CALL_MME_DATA(159)";
    case NVCBC0_CALL_MME_DATA(160):
        return "NVCBC0_CALL_MME_DATA(160)";
    case NVCBC0_CALL_MME_DATA(161):
        return "NVCBC0_CALL_MME_DATA(161)";
    case NVCBC0_CALL_MME_DATA(162):
        return "NVCBC0_CALL_MME_DATA(162)";
    case NVCBC0_CALL_MME_DATA(163):
        return "NVCBC0_CALL_MME_DATA(163)";
    case NVCBC0_CALL_MME_DATA(164):
        return "NVCBC0_CALL_MME_DATA(164)";
    case NVCBC0_CALL_MME_DATA(165):
        return "NVCBC0_CALL_MME_DATA(165)";
    case NVCBC0_CALL_MME_DATA(166):
        return "NVCBC0_CALL_MME_DATA(166)";
    case NVCBC0_CALL_MME_DATA(167):
        return "NVCBC0_CALL_MME_DATA(167)";
    case NVCBC0_CALL_MME_DATA(168):
        return "NVCBC0_CALL_MME_DATA(168)";
    case NVCBC0_CALL_MME_DATA(169):
        return "NVCBC0_CALL_MME_DATA(169)";
    case NVCBC0_CALL_MME_DATA(170):
        return "NVCBC0_CALL_MME_DATA(170)";
    case NVCBC0_CALL_MME_DATA(171):
        return "NVCBC0_CALL_MME_DATA(171)";
    case NVCBC0_CALL_MME_DATA(172):
        return "NVCBC0_CALL_MME_DATA(172)";
    case NVCBC0_CALL_MME_DATA(173):
        return "NVCBC0_CALL_MME_DATA(173)";
    case NVCBC0_CALL_MME_DATA(174):
        return "NVCBC0_CALL_MME_DATA(174)";
    case NVCBC0_CALL_MME_DATA(175):
        return "NVCBC0_CALL_MME_DATA(175)";
    case NVCBC0_CALL_MME_DATA(176):
        return "NVCBC0_CALL_MME_DATA(176)";
    case NVCBC0_CALL_MME_DATA(177):
        return "NVCBC0_CALL_MME_DATA(177)";
    case NVCBC0_CALL_MME_DATA(178):
        return "NVCBC0_CALL_MME_DATA(178)";
    case NVCBC0_CALL_MME_DATA(179):
        return "NVCBC0_CALL_MME_DATA(179)";
    case NVCBC0_CALL_MME_DATA(180):
        return "NVCBC0_CALL_MME_DATA(180)";
    case NVCBC0_CALL_MME_DATA(181):
        return "NVCBC0_CALL_MME_DATA(181)";
    case NVCBC0_CALL_MME_DATA(182):
        return "NVCBC0_CALL_MME_DATA(182)";
    case NVCBC0_CALL_MME_DATA(183):
        return "NVCBC0_CALL_MME_DATA(183)";
    case NVCBC0_CALL_MME_DATA(184):
        return "NVCBC0_CALL_MME_DATA(184)";
    case NVCBC0_CALL_MME_DATA(185):
        return "NVCBC0_CALL_MME_DATA(185)";
    case NVCBC0_CALL_MME_DATA(186):
        return "NVCBC0_CALL_MME_DATA(186)";
    case NVCBC0_CALL_MME_DATA(187):
        return "NVCBC0_CALL_MME_DATA(187)";
    case NVCBC0_CALL_MME_DATA(188):
        return "NVCBC0_CALL_MME_DATA(188)";
    case NVCBC0_CALL_MME_DATA(189):
        return "NVCBC0_CALL_MME_DATA(189)";
    case NVCBC0_CALL_MME_DATA(190):
        return "NVCBC0_CALL_MME_DATA(190)";
    case NVCBC0_CALL_MME_DATA(191):
        return "NVCBC0_CALL_MME_DATA(191)";
    case NVCBC0_CALL_MME_DATA(192):
        return "NVCBC0_CALL_MME_DATA(192)";
    case NVCBC0_CALL_MME_DATA(193):
        return "NVCBC0_CALL_MME_DATA(193)";
    case NVCBC0_CALL_MME_DATA(194):
        return "NVCBC0_CALL_MME_DATA(194)";
    case NVCBC0_CALL_MME_DATA(195):
        return "NVCBC0_CALL_MME_DATA(195)";
    case NVCBC0_CALL_MME_DATA(196):
        return "NVCBC0_CALL_MME_DATA(196)";
    case NVCBC0_CALL_MME_DATA(197):
        return "NVCBC0_CALL_MME_DATA(197)";
    case NVCBC0_CALL_MME_DATA(198):
        return "NVCBC0_CALL_MME_DATA(198)";
    case NVCBC0_CALL_MME_DATA(199):
        return "NVCBC0_CALL_MME_DATA(199)";
    case NVCBC0_CALL_MME_DATA(200):
        return "NVCBC0_CALL_MME_DATA(200)";
    case NVCBC0_CALL_MME_DATA(201):
        return "NVCBC0_CALL_MME_DATA(201)";
    case NVCBC0_CALL_MME_DATA(202):
        return "NVCBC0_CALL_MME_DATA(202)";
    case NVCBC0_CALL_MME_DATA(203):
        return "NVCBC0_CALL_MME_DATA(203)";
    case NVCBC0_CALL_MME_DATA(204):
        return "NVCBC0_CALL_MME_DATA(204)";
    case NVCBC0_CALL_MME_DATA(205):
        return "NVCBC0_CALL_MME_DATA(205)";
    case NVCBC0_CALL_MME_DATA(206):
        return "NVCBC0_CALL_MME_DATA(206)";
    case NVCBC0_CALL_MME_DATA(207):
        return "NVCBC0_CALL_MME_DATA(207)";
    case NVCBC0_CALL_MME_DATA(208):
        return "NVCBC0_CALL_MME_DATA(208)";
    case NVCBC0_CALL_MME_DATA(209):
        return "NVCBC0_CALL_MME_DATA(209)";
    case NVCBC0_CALL_MME_DATA(210):
        return "NVCBC0_CALL_MME_DATA(210)";
    case NVCBC0_CALL_MME_DATA(211):
        return "NVCBC0_CALL_MME_DATA(211)";
    case NVCBC0_CALL_MME_DATA(212):
        return "NVCBC0_CALL_MME_DATA(212)";
    case NVCBC0_CALL_MME_DATA(213):
        return "NVCBC0_CALL_MME_DATA(213)";
    case NVCBC0_CALL_MME_DATA(214):
        return "NVCBC0_CALL_MME_DATA(214)";
    case NVCBC0_CALL_MME_DATA(215):
        return "NVCBC0_CALL_MME_DATA(215)";
    case NVCBC0_CALL_MME_DATA(216):
        return "NVCBC0_CALL_MME_DATA(216)";
    case NVCBC0_CALL_MME_DATA(217):
        return "NVCBC0_CALL_MME_DATA(217)";
    case NVCBC0_CALL_MME_DATA(218):
        return "NVCBC0_CALL_MME_DATA(218)";
    case NVCBC0_CALL_MME_DATA(219):
        return "NVCBC0_CALL_MME_DATA(219)";
    case NVCBC0_CALL_MME_DATA(220):
        return "NVCBC0_CALL_MME_DATA(220)";
    case NVCBC0_CALL_MME_DATA(221):
        return "NVCBC0_CALL_MME_DATA(221)";
    case NVCBC0_CALL_MME_DATA(222):
        return "NVCBC0_CALL_MME_DATA(222)";
    case NVCBC0_CALL_MME_DATA(223):
        return "NVCBC0_CALL_MME_DATA(223)";
    case NVCBC0_CALL_MME_DATA(224):
        return "NVCBC0_CALL_MME_DATA(224)";
    case NVCBC0_CALL_MME_DATA(225):
        return "NVCBC0_CALL_MME_DATA(225)";
    case NVCBC0_CALL_MME_DATA(226):
        return "NVCBC0_CALL_MME_DATA(226)";
    case NVCBC0_CALL_MME_DATA(227):
        return "NVCBC0_CALL_MME_DATA(227)";
    case NVCBC0_CALL_MME_DATA(228):
        return "NVCBC0_CALL_MME_DATA(228)";
    case NVCBC0_CALL_MME_DATA(229):
        return "NVCBC0_CALL_MME_DATA(229)";
    case NVCBC0_CALL_MME_DATA(230):
        return "NVCBC0_CALL_MME_DATA(230)";
    case NVCBC0_CALL_MME_DATA(231):
        return "NVCBC0_CALL_MME_DATA(231)";
    case NVCBC0_CALL_MME_DATA(232):
        return "NVCBC0_CALL_MME_DATA(232)";
    case NVCBC0_CALL_MME_DATA(233):
        return "NVCBC0_CALL_MME_DATA(233)";
    case NVCBC0_CALL_MME_DATA(234):
        return "NVCBC0_CALL_MME_DATA(234)";
    case NVCBC0_CALL_MME_DATA(235):
        return "NVCBC0_CALL_MME_DATA(235)";
    case NVCBC0_CALL_MME_DATA(236):
        return "NVCBC0_CALL_MME_DATA(236)";
    case NVCBC0_CALL_MME_DATA(237):
        return "NVCBC0_CALL_MME_DATA(237)";
    case NVCBC0_CALL_MME_DATA(238):
        return "NVCBC0_CALL_MME_DATA(238)";
    case NVCBC0_CALL_MME_DATA(239):
        return "NVCBC0_CALL_MME_DATA(239)";
    case NVCBC0_CALL_MME_DATA(240):
        return "NVCBC0_CALL_MME_DATA(240)";
    case NVCBC0_CALL_MME_DATA(241):
        return "NVCBC0_CALL_MME_DATA(241)";
    case NVCBC0_CALL_MME_DATA(242):
        return "NVCBC0_CALL_MME_DATA(242)";
    case NVCBC0_CALL_MME_DATA(243):
        return "NVCBC0_CALL_MME_DATA(243)";
    case NVCBC0_CALL_MME_DATA(244):
        return "NVCBC0_CALL_MME_DATA(244)";
    case NVCBC0_CALL_MME_DATA(245):
        return "NVCBC0_CALL_MME_DATA(245)";
    case NVCBC0_CALL_MME_DATA(246):
        return "NVCBC0_CALL_MME_DATA(246)";
    case NVCBC0_CALL_MME_DATA(247):
        return "NVCBC0_CALL_MME_DATA(247)";
    case NVCBC0_CALL_MME_DATA(248):
        return "NVCBC0_CALL_MME_DATA(248)";
    case NVCBC0_CALL_MME_DATA(249):
        return "NVCBC0_CALL_MME_DATA(249)";
    case NVCBC0_CALL_MME_DATA(250):
        return "NVCBC0_CALL_MME_DATA(250)";
    case NVCBC0_CALL_MME_DATA(251):
        return "NVCBC0_CALL_MME_DATA(251)";
    case NVCBC0_CALL_MME_DATA(252):
        return "NVCBC0_CALL_MME_DATA(252)";
    case NVCBC0_CALL_MME_DATA(253):
        return "NVCBC0_CALL_MME_DATA(253)";
    case NVCBC0_CALL_MME_DATA(254):
        return "NVCBC0_CALL_MME_DATA(254)";
    case NVCBC0_CALL_MME_DATA(255):
        return "NVCBC0_CALL_MME_DATA(255)";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVCBC0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    uint32_t parsed;
    switch (idx) {
    case NVCBC0_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CLASS_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_NO_OPERATION:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_NOTIFY_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_NOTIFY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_NOTIFY:
    
        parsed = data;
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVCBC0_NOTIFY_TYPE_WRITE_ONLY:
            fprintf(fp, "WRITE_ONLY\n");
            break;
        case NVCBC0_NOTIFY_TYPE_WRITE_THEN_AWAKEN:
            fprintf(fp, "WRITE_THEN_AWAKEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_WAIT_FOR_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LOAD_MME_INSTRUCTION_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LOAD_MME_INSTRUCTION_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LOAD_MME_START_ADDRESS_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LOAD_MME_START_ADDRESS_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MME_SHADOW_RAM_CONTROL:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK:
            fprintf(fp, "METHOD_TRACK\n");
            break;
        case NVCBC0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER:
            fprintf(fp, "METHOD_TRACK_WITH_FILTER\n");
            break;
        case NVCBC0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH:
            fprintf(fp, "METHOD_PASSTHROUGH\n");
            break;
        case NVCBC0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY:
            fprintf(fp, "METHOD_REPLAY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_GLOBAL_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_GLOBAL_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVCBC0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SEND_GO_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_PM_TRIGGER_WFI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_FE_ATOMIC_SEQUENCE_BEGIN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_FE_ATOMIC_SEQUENCE_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_INSTRUMENTATION_METHOD_HEADER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_INSTRUMENTATION_METHOD_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_REPORT_SEMAPHORE_EXECUTE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_OPERATION_REPORT_ONLY:
            fprintf(fp, "REPORT_ONLY\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 2) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS:
            fprintf(fp, "SEMAPHORE_FOUR_WORDS\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD:
            fprintf(fp, "SEMAPHORE_ONE_WORD\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS:
            fprintf(fp, "SEMAPHORE_TWO_WORDS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.PAYLOAD_SIZE64 = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 2) - 1);
        fprintf(fp, "%s.TRAP_TYPE = ", prefix);
        switch (parsed) {
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_NONE:
            fprintf(fp, "TRAP_NONE\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_UNCONDITIONAL:
            fprintf(fp, "TRAP_UNCONDITIONAL\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL:
            fprintf(fp, "TRAP_CONDITIONAL\n");
            break;
        case NVCBC0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL_EXT:
            fprintf(fp, "TRAP_CONDITIONAL_EXT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_OFFSET_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVCBC0_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_DST_ORIGIN_BYTES_X:
    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_DST_ORIGIN_SAMPLES_Y:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVCBC0_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPLETION_TYPE = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE:
            fprintf(fp, "FLUSH_DISABLE\n");
            break;
        case NVCBC0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY:
            fprintf(fp, "FLUSH_ONLY\n");
            break;
        case NVCBC0_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE:
            fprintf(fp, "RELEASE_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVCBC0_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT:
            fprintf(fp, "INTERRUPT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_STRUCT_SIZE = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVCBC0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVCBC0_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_DISABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_LOAD_INLINE_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SM_SCG_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPUTE_IN_GRAPHICS = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_MME_SWITCH_STATE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.VALID = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_MME_SWITCH_STATE_VALID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_MME_SWITCH_STATE_VALID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SAVE_MACRO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 8) - 1);
        fprintf(fp, "%s.RESTORE_MACRO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SPARE_NOOP00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_I2M_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_VALID_SPAN_OVERFLOW_AREA_C:
    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_PERFMON_TRANSFER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_QMD_VIRTUALIZATION_BASE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_QMD_VIRTUALIZATION_BASE_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_SHADER_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DATA = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.LOCKS = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DATA = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_CWD_REF_COUNTER:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RESERVED_SW_METHOD15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_COMPUTE_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_CHECK_COMPUTE_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_QMD_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_SKED_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.I2M_ADDR_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.I2M_CONSTANT_BUFFER_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.I2M_DEPENDENT_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.IQ2M_ADDR_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.IQ2M_CONSTANT_BUFFER_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.IQ2M_DEPENDENT_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEND_PCAS_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_SHADER_SHARED_MEMORY_WINDOW_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.BASE_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_SHARED_MEMORY_WINDOW_B:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_CWD_SLOT_COUNT:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SEND_PCAS_A:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SEND_PCAS_B:
    
        parsed = (data >> 0) & ((1u << 24) - 1);
        fprintf(fp, "%s.FROM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.DELTA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SEND_SIGNALING_PCAS_B:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INVALIDATE = ", prefix);
        switch (parsed) {
        case NVCBC0_SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCHEDULE = ", prefix);
        switch (parsed) {
        case NVCBC0_SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SEND_SIGNALING_PCAS2_B:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.PCAS_ACTION = ", prefix);
        switch (parsed) {
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_NOP:
            fprintf(fp, "NOP\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE:
            fprintf(fp, "INVALIDATE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_SCHEDULE:
            fprintf(fp, "SCHEDULE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_COPY_SCHEDULE:
            fprintf(fp, "INVALIDATE_COPY_SCHEDULE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_PUT:
            fprintf(fp, "INCREMENT_PUT\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_DECREMENT_DEPENDENCE:
            fprintf(fp, "DECREMENT_DEPENDENCE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH:
            fprintf(fp, "PREFETCH\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH_SCHEDULE:
            fprintf(fp, "PREFETCH_SCHEDULE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE:
            fprintf(fp, "INVALIDATE_PREFETCH_COPY_SCHEDULE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING:
            fprintf(fp, "INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_DEPENDENCE:
            fprintf(fp, "INCREMENT_DEPENDENCE\n");
            break;
        case NVCBC0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_CWD_REF_COUNTER:
            fprintf(fp, "INCREMENT_CWD_REF_COUNTER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 6) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 10) - 1);
        fprintf(fp, "%s.OFFSET_MINUS_ONE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SKED_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_VEID = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SIZE_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B:
    
        parsed = data;
        fprintf(fp, "%s.SIZE_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C:
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.MAX_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAX_PLURAL_TPC_GPC_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAX_SINGLETON_TPC_GPC_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SPA_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MINOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_INLINE_QMD_ADDRESS_A:
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 1) - 1);
        fprintf(fp, "%s.INLINE_SIZE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_INLINE_QMD_ADDRESS_A_INLINE_SIZE_INLINE_256:
            fprintf(fp, "INLINE_256\n");
            break;
        case NVCBC0_SET_INLINE_QMD_ADDRESS_A_INLINE_SIZE_INLINE_384:
            fprintf(fp, "INLINE_384\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_INLINE_QMD_ADDRESS_B:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_LOAD_INLINE_QMD_DATA(0):
    case NVCBC0_LOAD_INLINE_QMD_DATA(1):
    case NVCBC0_LOAD_INLINE_QMD_DATA(2):
    case NVCBC0_LOAD_INLINE_QMD_DATA(3):
    case NVCBC0_LOAD_INLINE_QMD_DATA(4):
    case NVCBC0_LOAD_INLINE_QMD_DATA(5):
    case NVCBC0_LOAD_INLINE_QMD_DATA(6):
    case NVCBC0_LOAD_INLINE_QMD_DATA(7):
    case NVCBC0_LOAD_INLINE_QMD_DATA(8):
    case NVCBC0_LOAD_INLINE_QMD_DATA(9):
    case NVCBC0_LOAD_INLINE_QMD_DATA(10):
    case NVCBC0_LOAD_INLINE_QMD_DATA(11):
    case NVCBC0_LOAD_INLINE_QMD_DATA(12):
    case NVCBC0_LOAD_INLINE_QMD_DATA(13):
    case NVCBC0_LOAD_INLINE_QMD_DATA(14):
    case NVCBC0_LOAD_INLINE_QMD_DATA(15):
    case NVCBC0_LOAD_INLINE_QMD_DATA(16):
    case NVCBC0_LOAD_INLINE_QMD_DATA(17):
    case NVCBC0_LOAD_INLINE_QMD_DATA(18):
    case NVCBC0_LOAD_INLINE_QMD_DATA(19):
    case NVCBC0_LOAD_INLINE_QMD_DATA(20):
    case NVCBC0_LOAD_INLINE_QMD_DATA(21):
    case NVCBC0_LOAD_INLINE_QMD_DATA(22):
    case NVCBC0_LOAD_INLINE_QMD_DATA(23):
    case NVCBC0_LOAD_INLINE_QMD_DATA(24):
    case NVCBC0_LOAD_INLINE_QMD_DATA(25):
    case NVCBC0_LOAD_INLINE_QMD_DATA(26):
    case NVCBC0_LOAD_INLINE_QMD_DATA(27):
    case NVCBC0_LOAD_INLINE_QMD_DATA(28):
    case NVCBC0_LOAD_INLINE_QMD_DATA(29):
    case NVCBC0_LOAD_INLINE_QMD_DATA(30):
    case NVCBC0_LOAD_INLINE_QMD_DATA(31):
    case NVCBC0_LOAD_INLINE_QMD_DATA(32):
    case NVCBC0_LOAD_INLINE_QMD_DATA(33):
    case NVCBC0_LOAD_INLINE_QMD_DATA(34):
    case NVCBC0_LOAD_INLINE_QMD_DATA(35):
    case NVCBC0_LOAD_INLINE_QMD_DATA(36):
    case NVCBC0_LOAD_INLINE_QMD_DATA(37):
    case NVCBC0_LOAD_INLINE_QMD_DATA(38):
    case NVCBC0_LOAD_INLINE_QMD_DATA(39):
    case NVCBC0_LOAD_INLINE_QMD_DATA(40):
    case NVCBC0_LOAD_INLINE_QMD_DATA(41):
    case NVCBC0_LOAD_INLINE_QMD_DATA(42):
    case NVCBC0_LOAD_INLINE_QMD_DATA(43):
    case NVCBC0_LOAD_INLINE_QMD_DATA(44):
    case NVCBC0_LOAD_INLINE_QMD_DATA(45):
    case NVCBC0_LOAD_INLINE_QMD_DATA(46):
    case NVCBC0_LOAD_INLINE_QMD_DATA(47):
    case NVCBC0_LOAD_INLINE_QMD_DATA(48):
    case NVCBC0_LOAD_INLINE_QMD_DATA(49):
    case NVCBC0_LOAD_INLINE_QMD_DATA(50):
    case NVCBC0_LOAD_INLINE_QMD_DATA(51):
    case NVCBC0_LOAD_INLINE_QMD_DATA(52):
    case NVCBC0_LOAD_INLINE_QMD_DATA(53):
    case NVCBC0_LOAD_INLINE_QMD_DATA(54):
    case NVCBC0_LOAD_INLINE_QMD_DATA(55):
    case NVCBC0_LOAD_INLINE_QMD_DATA(56):
    case NVCBC0_LOAD_INLINE_QMD_DATA(57):
    case NVCBC0_LOAD_INLINE_QMD_DATA(58):
    case NVCBC0_LOAD_INLINE_QMD_DATA(59):
    case NVCBC0_LOAD_INLINE_QMD_DATA(60):
    case NVCBC0_LOAD_INLINE_QMD_DATA(61):
    case NVCBC0_LOAD_INLINE_QMD_DATA(62):
    case NVCBC0_LOAD_INLINE_QMD_DATA(63):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_FALCON15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MME_MEM_ADDRESS_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MME_MEM_ADDRESS_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MME_DATA_RAM_ADDRESS:
    
        parsed = data;
        fprintf(fp, "%s.WORD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_MME_DMA_READ:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_MME_DMA_READ_FIFOED:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_MME_DMA_WRITE:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_MME_DMA_REDUCTION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_SIZE = ", prefix);
        switch (parsed) {
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES:
            fprintf(fp, "FOUR_BYTES\n");
            break;
        case NVCBC0_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES:
            fprintf(fp, "EIGHT_BYTES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_MME_DMA_SYSMEMBAR:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_MME_DMA_SYNC:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MME_DATA_FIFO_CONFIG:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.FIFO_SIZE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB:
            fprintf(fp, "SIZE_0KB\n");
            break;
        case NVCBC0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB:
            fprintf(fp, "SIZE_4KB\n");
            break;
        case NVCBC0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB:
            fprintf(fp, "SIZE_8KB\n");
            break;
        case NVCBC0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB:
            fprintf(fp, "SIZE_12KB\n");
            break;
        case NVCBC0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TEXTURE_HEADER_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_WINDOW_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.BASE_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_LOCAL_MEMORY_WINDOW_B:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_THROTTLE_SM:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MULTIPLY_ADD = ", prefix);
        switch (parsed) {
        case NVCBC0_THROTTLE_SM_MULTIPLY_ADD_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_THROTTLE_SM_MULTIPLY_ADD_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_SHADER_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ICACHE_PREFETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(0):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(1):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(2):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(3):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(4):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(5):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(6):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(7):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(8):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(9):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(10):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(11):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(12):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(13):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(14):
    case NVCBC0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SM_TIMEOUT_INTERVAL:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.COUNTER_BIT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_MME_DMA_WRITE_METHOD_BARRIER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALL = ", prefix);
        switch (parsed) {
        case NVCBC0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_INVALIDATE_SAMPLER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SAMPLER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVCBC0_INVALIDATE_SAMPLER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVCBC0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVCBC0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_SAMPLER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVCBC0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_EXCEPTIONS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVCBC0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVCBC0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVCBC0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_TEX_SAMPLER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TEX_SAMPLER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TEX_SAMPLER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TEX_HEADER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TEX_HEADER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TEX_HEADER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GLOBAL_DATA = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_RENDER_ENABLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE:
            fprintf(fp, "USE_RENDER_ENABLE\n");
            break;
        case NVCBC0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER:
            fprintf(fp, "ALWAYS_RENDER\n");
            break;
        case NVCBC0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER:
            fprintf(fp, "NEVER_RENDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_PIPE_NOP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SPARE00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SPARE01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SPARE02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SPARE03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_REPORT_SEMAPHORE_D:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITIONAL_TRAP = ", prefix);
        switch (parsed) {
        case NVCBC0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCBC0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVCBC0_SET_TRAP_HANDLER_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_TRAP_HANDLER_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_BINDLESS_TEXTURE:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFER_SLOT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.EVENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPARE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.EDGE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.WINDOWED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.FUNC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_START_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_STOP_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_SET_MME_SHADOW_SCRATCH(0):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(1):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(2):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(3):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(4):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(5):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(6):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(7):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(8):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(9):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(10):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(11):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(12):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(13):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(14):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(15):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(16):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(17):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(18):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(19):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(20):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(21):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(22):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(23):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(24):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(25):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(26):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(27):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(28):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(29):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(30):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(31):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(32):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(33):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(34):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(35):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(36):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(37):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(38):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(39):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(40):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(41):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(42):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(43):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(44):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(45):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(46):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(47):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(48):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(49):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(50):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(51):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(52):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(53):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(54):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(55):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(56):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(57):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(58):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(59):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(60):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(61):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(62):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(63):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(64):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(65):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(66):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(67):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(68):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(69):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(70):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(71):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(72):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(73):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(74):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(75):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(76):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(77):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(78):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(79):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(80):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(81):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(82):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(83):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(84):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(85):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(86):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(87):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(88):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(89):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(90):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(91):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(92):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(93):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(94):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(95):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(96):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(97):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(98):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(99):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(100):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(101):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(102):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(103):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(104):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(105):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(106):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(107):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(108):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(109):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(110):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(111):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(112):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(113):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(114):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(115):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(116):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(117):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(118):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(119):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(120):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(121):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(122):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(123):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(124):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(125):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(126):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(127):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(128):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(129):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(130):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(131):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(132):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(133):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(134):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(135):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(136):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(137):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(138):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(139):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(140):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(141):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(142):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(143):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(144):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(145):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(146):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(147):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(148):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(149):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(150):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(151):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(152):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(153):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(154):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(155):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(156):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(157):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(158):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(159):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(160):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(161):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(162):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(163):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(164):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(165):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(166):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(167):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(168):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(169):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(170):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(171):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(172):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(173):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(174):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(175):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(176):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(177):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(178):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(179):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(180):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(181):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(182):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(183):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(184):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(185):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(186):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(187):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(188):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(189):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(190):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(191):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(192):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(193):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(194):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(195):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(196):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(197):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(198):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(199):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(200):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(201):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(202):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(203):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(204):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(205):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(206):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(207):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(208):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(209):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(210):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(211):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(212):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(213):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(214):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(215):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(216):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(217):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(218):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(219):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(220):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(221):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(222):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(223):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(224):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(225):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(226):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(227):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(228):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(229):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(230):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(231):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(232):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(233):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(234):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(235):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(236):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(237):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(238):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(239):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(240):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(241):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(242):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(243):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(244):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(245):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(246):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(247):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(248):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(249):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(250):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(251):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(252):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(253):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(254):
    case NVCBC0_SET_MME_SHADOW_SCRATCH(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_CALL_MME_MACRO(0):
    case NVCBC0_CALL_MME_MACRO(1):
    case NVCBC0_CALL_MME_MACRO(2):
    case NVCBC0_CALL_MME_MACRO(3):
    case NVCBC0_CALL_MME_MACRO(4):
    case NVCBC0_CALL_MME_MACRO(5):
    case NVCBC0_CALL_MME_MACRO(6):
    case NVCBC0_CALL_MME_MACRO(7):
    case NVCBC0_CALL_MME_MACRO(8):
    case NVCBC0_CALL_MME_MACRO(9):
    case NVCBC0_CALL_MME_MACRO(10):
    case NVCBC0_CALL_MME_MACRO(11):
    case NVCBC0_CALL_MME_MACRO(12):
    case NVCBC0_CALL_MME_MACRO(13):
    case NVCBC0_CALL_MME_MACRO(14):
    case NVCBC0_CALL_MME_MACRO(15):
    case NVCBC0_CALL_MME_MACRO(16):
    case NVCBC0_CALL_MME_MACRO(17):
    case NVCBC0_CALL_MME_MACRO(18):
    case NVCBC0_CALL_MME_MACRO(19):
    case NVCBC0_CALL_MME_MACRO(20):
    case NVCBC0_CALL_MME_MACRO(21):
    case NVCBC0_CALL_MME_MACRO(22):
    case NVCBC0_CALL_MME_MACRO(23):
    case NVCBC0_CALL_MME_MACRO(24):
    case NVCBC0_CALL_MME_MACRO(25):
    case NVCBC0_CALL_MME_MACRO(26):
    case NVCBC0_CALL_MME_MACRO(27):
    case NVCBC0_CALL_MME_MACRO(28):
    case NVCBC0_CALL_MME_MACRO(29):
    case NVCBC0_CALL_MME_MACRO(30):
    case NVCBC0_CALL_MME_MACRO(31):
    case NVCBC0_CALL_MME_MACRO(32):
    case NVCBC0_CALL_MME_MACRO(33):
    case NVCBC0_CALL_MME_MACRO(34):
    case NVCBC0_CALL_MME_MACRO(35):
    case NVCBC0_CALL_MME_MACRO(36):
    case NVCBC0_CALL_MME_MACRO(37):
    case NVCBC0_CALL_MME_MACRO(38):
    case NVCBC0_CALL_MME_MACRO(39):
    case NVCBC0_CALL_MME_MACRO(40):
    case NVCBC0_CALL_MME_MACRO(41):
    case NVCBC0_CALL_MME_MACRO(42):
    case NVCBC0_CALL_MME_MACRO(43):
    case NVCBC0_CALL_MME_MACRO(44):
    case NVCBC0_CALL_MME_MACRO(45):
    case NVCBC0_CALL_MME_MACRO(46):
    case NVCBC0_CALL_MME_MACRO(47):
    case NVCBC0_CALL_MME_MACRO(48):
    case NVCBC0_CALL_MME_MACRO(49):
    case NVCBC0_CALL_MME_MACRO(50):
    case NVCBC0_CALL_MME_MACRO(51):
    case NVCBC0_CALL_MME_MACRO(52):
    case NVCBC0_CALL_MME_MACRO(53):
    case NVCBC0_CALL_MME_MACRO(54):
    case NVCBC0_CALL_MME_MACRO(55):
    case NVCBC0_CALL_MME_MACRO(56):
    case NVCBC0_CALL_MME_MACRO(57):
    case NVCBC0_CALL_MME_MACRO(58):
    case NVCBC0_CALL_MME_MACRO(59):
    case NVCBC0_CALL_MME_MACRO(60):
    case NVCBC0_CALL_MME_MACRO(61):
    case NVCBC0_CALL_MME_MACRO(62):
    case NVCBC0_CALL_MME_MACRO(63):
    case NVCBC0_CALL_MME_MACRO(64):
    case NVCBC0_CALL_MME_MACRO(65):
    case NVCBC0_CALL_MME_MACRO(66):
    case NVCBC0_CALL_MME_MACRO(67):
    case NVCBC0_CALL_MME_MACRO(68):
    case NVCBC0_CALL_MME_MACRO(69):
    case NVCBC0_CALL_MME_MACRO(70):
    case NVCBC0_CALL_MME_MACRO(71):
    case NVCBC0_CALL_MME_MACRO(72):
    case NVCBC0_CALL_MME_MACRO(73):
    case NVCBC0_CALL_MME_MACRO(74):
    case NVCBC0_CALL_MME_MACRO(75):
    case NVCBC0_CALL_MME_MACRO(76):
    case NVCBC0_CALL_MME_MACRO(77):
    case NVCBC0_CALL_MME_MACRO(78):
    case NVCBC0_CALL_MME_MACRO(79):
    case NVCBC0_CALL_MME_MACRO(80):
    case NVCBC0_CALL_MME_MACRO(81):
    case NVCBC0_CALL_MME_MACRO(82):
    case NVCBC0_CALL_MME_MACRO(83):
    case NVCBC0_CALL_MME_MACRO(84):
    case NVCBC0_CALL_MME_MACRO(85):
    case NVCBC0_CALL_MME_MACRO(86):
    case NVCBC0_CALL_MME_MACRO(87):
    case NVCBC0_CALL_MME_MACRO(88):
    case NVCBC0_CALL_MME_MACRO(89):
    case NVCBC0_CALL_MME_MACRO(90):
    case NVCBC0_CALL_MME_MACRO(91):
    case NVCBC0_CALL_MME_MACRO(92):
    case NVCBC0_CALL_MME_MACRO(93):
    case NVCBC0_CALL_MME_MACRO(94):
    case NVCBC0_CALL_MME_MACRO(95):
    case NVCBC0_CALL_MME_MACRO(96):
    case NVCBC0_CALL_MME_MACRO(97):
    case NVCBC0_CALL_MME_MACRO(98):
    case NVCBC0_CALL_MME_MACRO(99):
    case NVCBC0_CALL_MME_MACRO(100):
    case NVCBC0_CALL_MME_MACRO(101):
    case NVCBC0_CALL_MME_MACRO(102):
    case NVCBC0_CALL_MME_MACRO(103):
    case NVCBC0_CALL_MME_MACRO(104):
    case NVCBC0_CALL_MME_MACRO(105):
    case NVCBC0_CALL_MME_MACRO(106):
    case NVCBC0_CALL_MME_MACRO(107):
    case NVCBC0_CALL_MME_MACRO(108):
    case NVCBC0_CALL_MME_MACRO(109):
    case NVCBC0_CALL_MME_MACRO(110):
    case NVCBC0_CALL_MME_MACRO(111):
    case NVCBC0_CALL_MME_MACRO(112):
    case NVCBC0_CALL_MME_MACRO(113):
    case NVCBC0_CALL_MME_MACRO(114):
    case NVCBC0_CALL_MME_MACRO(115):
    case NVCBC0_CALL_MME_MACRO(116):
    case NVCBC0_CALL_MME_MACRO(117):
    case NVCBC0_CALL_MME_MACRO(118):
    case NVCBC0_CALL_MME_MACRO(119):
    case NVCBC0_CALL_MME_MACRO(120):
    case NVCBC0_CALL_MME_MACRO(121):
    case NVCBC0_CALL_MME_MACRO(122):
    case NVCBC0_CALL_MME_MACRO(123):
    case NVCBC0_CALL_MME_MACRO(124):
    case NVCBC0_CALL_MME_MACRO(125):
    case NVCBC0_CALL_MME_MACRO(126):
    case NVCBC0_CALL_MME_MACRO(127):
    case NVCBC0_CALL_MME_MACRO(128):
    case NVCBC0_CALL_MME_MACRO(129):
    case NVCBC0_CALL_MME_MACRO(130):
    case NVCBC0_CALL_MME_MACRO(131):
    case NVCBC0_CALL_MME_MACRO(132):
    case NVCBC0_CALL_MME_MACRO(133):
    case NVCBC0_CALL_MME_MACRO(134):
    case NVCBC0_CALL_MME_MACRO(135):
    case NVCBC0_CALL_MME_MACRO(136):
    case NVCBC0_CALL_MME_MACRO(137):
    case NVCBC0_CALL_MME_MACRO(138):
    case NVCBC0_CALL_MME_MACRO(139):
    case NVCBC0_CALL_MME_MACRO(140):
    case NVCBC0_CALL_MME_MACRO(141):
    case NVCBC0_CALL_MME_MACRO(142):
    case NVCBC0_CALL_MME_MACRO(143):
    case NVCBC0_CALL_MME_MACRO(144):
    case NVCBC0_CALL_MME_MACRO(145):
    case NVCBC0_CALL_MME_MACRO(146):
    case NVCBC0_CALL_MME_MACRO(147):
    case NVCBC0_CALL_MME_MACRO(148):
    case NVCBC0_CALL_MME_MACRO(149):
    case NVCBC0_CALL_MME_MACRO(150):
    case NVCBC0_CALL_MME_MACRO(151):
    case NVCBC0_CALL_MME_MACRO(152):
    case NVCBC0_CALL_MME_MACRO(153):
    case NVCBC0_CALL_MME_MACRO(154):
    case NVCBC0_CALL_MME_MACRO(155):
    case NVCBC0_CALL_MME_MACRO(156):
    case NVCBC0_CALL_MME_MACRO(157):
    case NVCBC0_CALL_MME_MACRO(158):
    case NVCBC0_CALL_MME_MACRO(159):
    case NVCBC0_CALL_MME_MACRO(160):
    case NVCBC0_CALL_MME_MACRO(161):
    case NVCBC0_CALL_MME_MACRO(162):
    case NVCBC0_CALL_MME_MACRO(163):
    case NVCBC0_CALL_MME_MACRO(164):
    case NVCBC0_CALL_MME_MACRO(165):
    case NVCBC0_CALL_MME_MACRO(166):
    case NVCBC0_CALL_MME_MACRO(167):
    case NVCBC0_CALL_MME_MACRO(168):
    case NVCBC0_CALL_MME_MACRO(169):
    case NVCBC0_CALL_MME_MACRO(170):
    case NVCBC0_CALL_MME_MACRO(171):
    case NVCBC0_CALL_MME_MACRO(172):
    case NVCBC0_CALL_MME_MACRO(173):
    case NVCBC0_CALL_MME_MACRO(174):
    case NVCBC0_CALL_MME_MACRO(175):
    case NVCBC0_CALL_MME_MACRO(176):
    case NVCBC0_CALL_MME_MACRO(177):
    case NVCBC0_CALL_MME_MACRO(178):
    case NVCBC0_CALL_MME_MACRO(179):
    case NVCBC0_CALL_MME_MACRO(180):
    case NVCBC0_CALL_MME_MACRO(181):
    case NVCBC0_CALL_MME_MACRO(182):
    case NVCBC0_CALL_MME_MACRO(183):
    case NVCBC0_CALL_MME_MACRO(184):
    case NVCBC0_CALL_MME_MACRO(185):
    case NVCBC0_CALL_MME_MACRO(186):
    case NVCBC0_CALL_MME_MACRO(187):
    case NVCBC0_CALL_MME_MACRO(188):
    case NVCBC0_CALL_MME_MACRO(189):
    case NVCBC0_CALL_MME_MACRO(190):
    case NVCBC0_CALL_MME_MACRO(191):
    case NVCBC0_CALL_MME_MACRO(192):
    case NVCBC0_CALL_MME_MACRO(193):
    case NVCBC0_CALL_MME_MACRO(194):
    case NVCBC0_CALL_MME_MACRO(195):
    case NVCBC0_CALL_MME_MACRO(196):
    case NVCBC0_CALL_MME_MACRO(197):
    case NVCBC0_CALL_MME_MACRO(198):
    case NVCBC0_CALL_MME_MACRO(199):
    case NVCBC0_CALL_MME_MACRO(200):
    case NVCBC0_CALL_MME_MACRO(201):
    case NVCBC0_CALL_MME_MACRO(202):
    case NVCBC0_CALL_MME_MACRO(203):
    case NVCBC0_CALL_MME_MACRO(204):
    case NVCBC0_CALL_MME_MACRO(205):
    case NVCBC0_CALL_MME_MACRO(206):
    case NVCBC0_CALL_MME_MACRO(207):
    case NVCBC0_CALL_MME_MACRO(208):
    case NVCBC0_CALL_MME_MACRO(209):
    case NVCBC0_CALL_MME_MACRO(210):
    case NVCBC0_CALL_MME_MACRO(211):
    case NVCBC0_CALL_MME_MACRO(212):
    case NVCBC0_CALL_MME_MACRO(213):
    case NVCBC0_CALL_MME_MACRO(214):
    case NVCBC0_CALL_MME_MACRO(215):
    case NVCBC0_CALL_MME_MACRO(216):
    case NVCBC0_CALL_MME_MACRO(217):
    case NVCBC0_CALL_MME_MACRO(218):
    case NVCBC0_CALL_MME_MACRO(219):
    case NVCBC0_CALL_MME_MACRO(220):
    case NVCBC0_CALL_MME_MACRO(221):
    case NVCBC0_CALL_MME_MACRO(222):
    case NVCBC0_CALL_MME_MACRO(223):
    case NVCBC0_CALL_MME_MACRO(224):
    case NVCBC0_CALL_MME_MACRO(225):
    case NVCBC0_CALL_MME_MACRO(226):
    case NVCBC0_CALL_MME_MACRO(227):
    case NVCBC0_CALL_MME_MACRO(228):
    case NVCBC0_CALL_MME_MACRO(229):
    case NVCBC0_CALL_MME_MACRO(230):
    case NVCBC0_CALL_MME_MACRO(231):
    case NVCBC0_CALL_MME_MACRO(232):
    case NVCBC0_CALL_MME_MACRO(233):
    case NVCBC0_CALL_MME_MACRO(234):
    case NVCBC0_CALL_MME_MACRO(235):
    case NVCBC0_CALL_MME_MACRO(236):
    case NVCBC0_CALL_MME_MACRO(237):
    case NVCBC0_CALL_MME_MACRO(238):
    case NVCBC0_CALL_MME_MACRO(239):
    case NVCBC0_CALL_MME_MACRO(240):
    case NVCBC0_CALL_MME_MACRO(241):
    case NVCBC0_CALL_MME_MACRO(242):
    case NVCBC0_CALL_MME_MACRO(243):
    case NVCBC0_CALL_MME_MACRO(244):
    case NVCBC0_CALL_MME_MACRO(245):
    case NVCBC0_CALL_MME_MACRO(246):
    case NVCBC0_CALL_MME_MACRO(247):
    case NVCBC0_CALL_MME_MACRO(248):
    case NVCBC0_CALL_MME_MACRO(249):
    case NVCBC0_CALL_MME_MACRO(250):
    case NVCBC0_CALL_MME_MACRO(251):
    case NVCBC0_CALL_MME_MACRO(252):
    case NVCBC0_CALL_MME_MACRO(253):
    case NVCBC0_CALL_MME_MACRO(254):
    case NVCBC0_CALL_MME_MACRO(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVCBC0_CALL_MME_DATA(0):
    case NVCBC0_CALL_MME_DATA(1):
    case NVCBC0_CALL_MME_DATA(2):
    case NVCBC0_CALL_MME_DATA(3):
    case NVCBC0_CALL_MME_DATA(4):
    case NVCBC0_CALL_MME_DATA(5):
    case NVCBC0_CALL_MME_DATA(6):
    case NVCBC0_CALL_MME_DATA(7):
    case NVCBC0_CALL_MME_DATA(8):
    case NVCBC0_CALL_MME_DATA(9):
    case NVCBC0_CALL_MME_DATA(10):
    case NVCBC0_CALL_MME_DATA(11):
    case NVCBC0_CALL_MME_DATA(12):
    case NVCBC0_CALL_MME_DATA(13):
    case NVCBC0_CALL_MME_DATA(14):
    case NVCBC0_CALL_MME_DATA(15):
    case NVCBC0_CALL_MME_DATA(16):
    case NVCBC0_CALL_MME_DATA(17):
    case NVCBC0_CALL_MME_DATA(18):
    case NVCBC0_CALL_MME_DATA(19):
    case NVCBC0_CALL_MME_DATA(20):
    case NVCBC0_CALL_MME_DATA(21):
    case NVCBC0_CALL_MME_DATA(22):
    case NVCBC0_CALL_MME_DATA(23):
    case NVCBC0_CALL_MME_DATA(24):
    case NVCBC0_CALL_MME_DATA(25):
    case NVCBC0_CALL_MME_DATA(26):
    case NVCBC0_CALL_MME_DATA(27):
    case NVCBC0_CALL_MME_DATA(28):
    case NVCBC0_CALL_MME_DATA(29):
    case NVCBC0_CALL_MME_DATA(30):
    case NVCBC0_CALL_MME_DATA(31):
    case NVCBC0_CALL_MME_DATA(32):
    case NVCBC0_CALL_MME_DATA(33):
    case NVCBC0_CALL_MME_DATA(34):
    case NVCBC0_CALL_MME_DATA(35):
    case NVCBC0_CALL_MME_DATA(36):
    case NVCBC0_CALL_MME_DATA(37):
    case NVCBC0_CALL_MME_DATA(38):
    case NVCBC0_CALL_MME_DATA(39):
    case NVCBC0_CALL_MME_DATA(40):
    case NVCBC0_CALL_MME_DATA(41):
    case NVCBC0_CALL_MME_DATA(42):
    case NVCBC0_CALL_MME_DATA(43):
    case NVCBC0_CALL_MME_DATA(44):
    case NVCBC0_CALL_MME_DATA(45):
    case NVCBC0_CALL_MME_DATA(46):
    case NVCBC0_CALL_MME_DATA(47):
    case NVCBC0_CALL_MME_DATA(48):
    case NVCBC0_CALL_MME_DATA(49):
    case NVCBC0_CALL_MME_DATA(50):
    case NVCBC0_CALL_MME_DATA(51):
    case NVCBC0_CALL_MME_DATA(52):
    case NVCBC0_CALL_MME_DATA(53):
    case NVCBC0_CALL_MME_DATA(54):
    case NVCBC0_CALL_MME_DATA(55):
    case NVCBC0_CALL_MME_DATA(56):
    case NVCBC0_CALL_MME_DATA(57):
    case NVCBC0_CALL_MME_DATA(58):
    case NVCBC0_CALL_MME_DATA(59):
    case NVCBC0_CALL_MME_DATA(60):
    case NVCBC0_CALL_MME_DATA(61):
    case NVCBC0_CALL_MME_DATA(62):
    case NVCBC0_CALL_MME_DATA(63):
    case NVCBC0_CALL_MME_DATA(64):
    case NVCBC0_CALL_MME_DATA(65):
    case NVCBC0_CALL_MME_DATA(66):
    case NVCBC0_CALL_MME_DATA(67):
    case NVCBC0_CALL_MME_DATA(68):
    case NVCBC0_CALL_MME_DATA(69):
    case NVCBC0_CALL_MME_DATA(70):
    case NVCBC0_CALL_MME_DATA(71):
    case NVCBC0_CALL_MME_DATA(72):
    case NVCBC0_CALL_MME_DATA(73):
    case NVCBC0_CALL_MME_DATA(74):
    case NVCBC0_CALL_MME_DATA(75):
    case NVCBC0_CALL_MME_DATA(76):
    case NVCBC0_CALL_MME_DATA(77):
    case NVCBC0_CALL_MME_DATA(78):
    case NVCBC0_CALL_MME_DATA(79):
    case NVCBC0_CALL_MME_DATA(80):
    case NVCBC0_CALL_MME_DATA(81):
    case NVCBC0_CALL_MME_DATA(82):
    case NVCBC0_CALL_MME_DATA(83):
    case NVCBC0_CALL_MME_DATA(84):
    case NVCBC0_CALL_MME_DATA(85):
    case NVCBC0_CALL_MME_DATA(86):
    case NVCBC0_CALL_MME_DATA(87):
    case NVCBC0_CALL_MME_DATA(88):
    case NVCBC0_CALL_MME_DATA(89):
    case NVCBC0_CALL_MME_DATA(90):
    case NVCBC0_CALL_MME_DATA(91):
    case NVCBC0_CALL_MME_DATA(92):
    case NVCBC0_CALL_MME_DATA(93):
    case NVCBC0_CALL_MME_DATA(94):
    case NVCBC0_CALL_MME_DATA(95):
    case NVCBC0_CALL_MME_DATA(96):
    case NVCBC0_CALL_MME_DATA(97):
    case NVCBC0_CALL_MME_DATA(98):
    case NVCBC0_CALL_MME_DATA(99):
    case NVCBC0_CALL_MME_DATA(100):
    case NVCBC0_CALL_MME_DATA(101):
    case NVCBC0_CALL_MME_DATA(102):
    case NVCBC0_CALL_MME_DATA(103):
    case NVCBC0_CALL_MME_DATA(104):
    case NVCBC0_CALL_MME_DATA(105):
    case NVCBC0_CALL_MME_DATA(106):
    case NVCBC0_CALL_MME_DATA(107):
    case NVCBC0_CALL_MME_DATA(108):
    case NVCBC0_CALL_MME_DATA(109):
    case NVCBC0_CALL_MME_DATA(110):
    case NVCBC0_CALL_MME_DATA(111):
    case NVCBC0_CALL_MME_DATA(112):
    case NVCBC0_CALL_MME_DATA(113):
    case NVCBC0_CALL_MME_DATA(114):
    case NVCBC0_CALL_MME_DATA(115):
    case NVCBC0_CALL_MME_DATA(116):
    case NVCBC0_CALL_MME_DATA(117):
    case NVCBC0_CALL_MME_DATA(118):
    case NVCBC0_CALL_MME_DATA(119):
    case NVCBC0_CALL_MME_DATA(120):
    case NVCBC0_CALL_MME_DATA(121):
    case NVCBC0_CALL_MME_DATA(122):
    case NVCBC0_CALL_MME_DATA(123):
    case NVCBC0_CALL_MME_DATA(124):
    case NVCBC0_CALL_MME_DATA(125):
    case NVCBC0_CALL_MME_DATA(126):
    case NVCBC0_CALL_MME_DATA(127):
    case NVCBC0_CALL_MME_DATA(128):
    case NVCBC0_CALL_MME_DATA(129):
    case NVCBC0_CALL_MME_DATA(130):
    case NVCBC0_CALL_MME_DATA(131):
    case NVCBC0_CALL_MME_DATA(132):
    case NVCBC0_CALL_MME_DATA(133):
    case NVCBC0_CALL_MME_DATA(134):
    case NVCBC0_CALL_MME_DATA(135):
    case NVCBC0_CALL_MME_DATA(136):
    case NVCBC0_CALL_MME_DATA(137):
    case NVCBC0_CALL_MME_DATA(138):
    case NVCBC0_CALL_MME_DATA(139):
    case NVCBC0_CALL_MME_DATA(140):
    case NVCBC0_CALL_MME_DATA(141):
    case NVCBC0_CALL_MME_DATA(142):
    case NVCBC0_CALL_MME_DATA(143):
    case NVCBC0_CALL_MME_DATA(144):
    case NVCBC0_CALL_MME_DATA(145):
    case NVCBC0_CALL_MME_DATA(146):
    case NVCBC0_CALL_MME_DATA(147):
    case NVCBC0_CALL_MME_DATA(148):
    case NVCBC0_CALL_MME_DATA(149):
    case NVCBC0_CALL_MME_DATA(150):
    case NVCBC0_CALL_MME_DATA(151):
    case NVCBC0_CALL_MME_DATA(152):
    case NVCBC0_CALL_MME_DATA(153):
    case NVCBC0_CALL_MME_DATA(154):
    case NVCBC0_CALL_MME_DATA(155):
    case NVCBC0_CALL_MME_DATA(156):
    case NVCBC0_CALL_MME_DATA(157):
    case NVCBC0_CALL_MME_DATA(158):
    case NVCBC0_CALL_MME_DATA(159):
    case NVCBC0_CALL_MME_DATA(160):
    case NVCBC0_CALL_MME_DATA(161):
    case NVCBC0_CALL_MME_DATA(162):
    case NVCBC0_CALL_MME_DATA(163):
    case NVCBC0_CALL_MME_DATA(164):
    case NVCBC0_CALL_MME_DATA(165):
    case NVCBC0_CALL_MME_DATA(166):
    case NVCBC0_CALL_MME_DATA(167):
    case NVCBC0_CALL_MME_DATA(168):
    case NVCBC0_CALL_MME_DATA(169):
    case NVCBC0_CALL_MME_DATA(170):
    case NVCBC0_CALL_MME_DATA(171):
    case NVCBC0_CALL_MME_DATA(172):
    case NVCBC0_CALL_MME_DATA(173):
    case NVCBC0_CALL_MME_DATA(174):
    case NVCBC0_CALL_MME_DATA(175):
    case NVCBC0_CALL_MME_DATA(176):
    case NVCBC0_CALL_MME_DATA(177):
    case NVCBC0_CALL_MME_DATA(178):
    case NVCBC0_CALL_MME_DATA(179):
    case NVCBC0_CALL_MME_DATA(180):
    case NVCBC0_CALL_MME_DATA(181):
    case NVCBC0_CALL_MME_DATA(182):
    case NVCBC0_CALL_MME_DATA(183):
    case NVCBC0_CALL_MME_DATA(184):
    case NVCBC0_CALL_MME_DATA(185):
    case NVCBC0_CALL_MME_DATA(186):
    case NVCBC0_CALL_MME_DATA(187):
    case NVCBC0_CALL_MME_DATA(188):
    case NVCBC0_CALL_MME_DATA(189):
    case NVCBC0_CALL_MME_DATA(190):
    case NVCBC0_CALL_MME_DATA(191):
    case NVCBC0_CALL_MME_DATA(192):
    case NVCBC0_CALL_MME_DATA(193):
    case NVCBC0_CALL_MME_DATA(194):
    case NVCBC0_CALL_MME_DATA(195):
    case NVCBC0_CALL_MME_DATA(196):
    case NVCBC0_CALL_MME_DATA(197):
    case NVCBC0_CALL_MME_DATA(198):
    case NVCBC0_CALL_MME_DATA(199):
    case NVCBC0_CALL_MME_DATA(200):
    case NVCBC0_CALL_MME_DATA(201):
    case NVCBC0_CALL_MME_DATA(202):
    case NVCBC0_CALL_MME_DATA(203):
    case NVCBC0_CALL_MME_DATA(204):
    case NVCBC0_CALL_MME_DATA(205):
    case NVCBC0_CALL_MME_DATA(206):
    case NVCBC0_CALL_MME_DATA(207):
    case NVCBC0_CALL_MME_DATA(208):
    case NVCBC0_CALL_MME_DATA(209):
    case NVCBC0_CALL_MME_DATA(210):
    case NVCBC0_CALL_MME_DATA(211):
    case NVCBC0_CALL_MME_DATA(212):
    case NVCBC0_CALL_MME_DATA(213):
    case NVCBC0_CALL_MME_DATA(214):
    case NVCBC0_CALL_MME_DATA(215):
    case NVCBC0_CALL_MME_DATA(216):
    case NVCBC0_CALL_MME_DATA(217):
    case NVCBC0_CALL_MME_DATA(218):
    case NVCBC0_CALL_MME_DATA(219):
    case NVCBC0_CALL_MME_DATA(220):
    case NVCBC0_CALL_MME_DATA(221):
    case NVCBC0_CALL_MME_DATA(222):
    case NVCBC0_CALL_MME_DATA(223):
    case NVCBC0_CALL_MME_DATA(224):
    case NVCBC0_CALL_MME_DATA(225):
    case NVCBC0_CALL_MME_DATA(226):
    case NVCBC0_CALL_MME_DATA(227):
    case NVCBC0_CALL_MME_DATA(228):
    case NVCBC0_CALL_MME_DATA(229):
    case NVCBC0_CALL_MME_DATA(230):
    case NVCBC0_CALL_MME_DATA(231):
    case NVCBC0_CALL_MME_DATA(232):
    case NVCBC0_CALL_MME_DATA(233):
    case NVCBC0_CALL_MME_DATA(234):
    case NVCBC0_CALL_MME_DATA(235):
    case NVCBC0_CALL_MME_DATA(236):
    case NVCBC0_CALL_MME_DATA(237):
    case NVCBC0_CALL_MME_DATA(238):
    case NVCBC0_CALL_MME_DATA(239):
    case NVCBC0_CALL_MME_DATA(240):
    case NVCBC0_CALL_MME_DATA(241):
    case NVCBC0_CALL_MME_DATA(242):
    case NVCBC0_CALL_MME_DATA(243):
    case NVCBC0_CALL_MME_DATA(244):
    case NVCBC0_CALL_MME_DATA(245):
    case NVCBC0_CALL_MME_DATA(246):
    case NVCBC0_CALL_MME_DATA(247):
    case NVCBC0_CALL_MME_DATA(248):
    case NVCBC0_CALL_MME_DATA(249):
    case NVCBC0_CALL_MME_DATA(250):
    case NVCBC0_CALL_MME_DATA(251):
    case NVCBC0_CALL_MME_DATA(252):
    case NVCBC0_CALL_MME_DATA(253):
    case NVCBC0_CALL_MME_DATA(254):
    case NVCBC0_CALL_MME_DATA(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
