/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.marker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.marker.Mark;
import org.graalvm.visualvm.lib.jfluid.marker.Marker;
import org.graalvm.visualvm.lib.jfluid.results.cpu.marking.MarkMapping;

public class ClassMarker
implements Marker {
    private static Logger LOGGER = Logger.getLogger(ClassMarker.class.getName());
    private Map markMap = new HashMap();

    @Override
    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> mappings = new ArrayList<MarkMapping>();
        for (String className : this.markMap.keySet()) {
            ClientUtils.SourceCodeSelection markerMethod = new ClientUtils.SourceCodeSelection(className, "*", "");
            markerMethod.setMarkerMethod(true);
            mappings.add(new MarkMapping(markerMethod, (Mark)this.markMap.get(className)));
        }
        return mappings.toArray(new MarkMapping[0]);
    }

    @Override
    public Mark[] getMarks() {
        return new HashSet(this.markMap.values()).toArray(new Mark[0]);
    }

    public void addClassMark(String className, Mark mark) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Marking class " + className + " with " + mark.getId());
        }
        this.markMap.put(className, mark);
    }

    public void removeClassMark(String className) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking class " + className);
        }
        this.markMap.remove(className);
    }

    public void resetClassMarks() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking all classes");
        }
        this.markMap.clear();
    }
}

