/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.graalvm.visualvm.gotosource.SourcesRoot;
import org.openide.util.NbPreferences;

public final class SourceRoots {
    private static final String PROP_SAVED_ROOTS = "prop_SourceRoots_saved";
    private static final String ROOTS_DELIMITER = "|";
    private static String[] FORCED_ROOTS;

    private SourceRoots() {
    }

    public static String[] getRoots() {
        if (SourceRoots.areForcedRoots()) {
            return FORCED_ROOTS;
        }
        String definedString = NbPreferences.forModule(SourcesRoot.class).get(PROP_SAVED_ROOTS, "");
        return definedString.isEmpty() ? new String[]{} : definedString.split(Pattern.quote(ROOTS_DELIMITER));
    }

    public static void saveRoots(String[] roots) {
        if (SourceRoots.areForcedRoots()) {
            return;
        }
        String joinedString = String.join((CharSequence)ROOTS_DELIMITER, roots);
        NbPreferences.forModule(SourceRoots.class).put(PROP_SAVED_ROOTS, joinedString);
    }

    public static void forceRoots(String[] roots) {
        FORCED_ROOTS = roots == null || roots.length == 0 ? null : roots;
    }

    public static boolean areForcedRoots() {
        return FORCED_ROOTS != null;
    }

    public static String[] splitRoots(String rootsString) {
        ArrayList<String> roots = new ArrayList<String>();
        int length = rootsString.length();
        boolean inBlock = false;
        StringBuilder sb = new StringBuilder();
        for (int position = 0; position < length; ++position) {
            char currentChar = rootsString.charAt(position);
            if (currentChar == '[') {
                inBlock = true;
            } else if (currentChar == ']') {
                inBlock = false;
            }
            if (!inBlock && currentChar == File.pathSeparatorChar) {
                roots.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(currentChar);
            if (position != length - 1) continue;
            roots.add(sb.toString());
        }
        return roots.toArray(new String[0]);
    }
}

