/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

@DatabaseChange(name="dropColumn", description="Drop existing column(s)", priority=1, appliesTo={"column"})
public class DropColumnChange
extends AbstractChange
implements ChangeWithColumns<ColumnConfig> {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    @Override
    public boolean generateStatementsVolatile(Database database) {
        if (database instanceof SQLiteDatabase) {
            return true;
        }
        return super.generateStatementsVolatile(database);
    }

    @Override
    public boolean supports(Database database) {
        if (database instanceof SQLiteDatabase) {
            return true;
        }
        return super.supports(database);
    }

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof SQLiteDatabase) {
            ValidationErrors validationErrors = new ValidationErrors();
            validationErrors.checkRequiredField("tableName", this.tableName);
            validationErrors.checkRequiredField("columnName", this.columnName);
            return validationErrors;
        }
        return super.validate(database);
    }

    @DatabaseChangeProperty(mustEqualExisting="column", description="Name of the column to drop", requiredForDatabase={"none"})
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table containing the column to drop")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        if (this.isMultiple()) {
            return this.generateMultipeColumns(database);
        }
        return this.generateSingleColumn(database);
    }

    private SqlStatement[] generateMultipeColumns(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        ArrayList<DropColumnStatement> dropStatements = new ArrayList<DropColumnStatement>();
        for (ColumnConfig column : this.columns) {
            if (database instanceof SQLiteDatabase) {
                statements.addAll(Arrays.asList(this.generateStatementsForSQLiteDatabase(database, column.getName())));
                continue;
            }
            dropStatements.add(new DropColumnStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName()));
        }
        if (dropStatements.size() == 1) {
            statements.add((SqlStatement)dropStatements.get(0));
        } else {
            statements.add(new DropColumnStatement(dropStatements));
        }
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private SqlStatement[] generateSingleColumn(Database database) {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database, this.getColumnName());
        }
        ArrayList<AbstractSqlStatement> statements = new ArrayList<AbstractSqlStatement>();
        statements.add(new DropColumnStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName()));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        try {
            return new ChangeStatus().assertComplete(!SnapshotGeneratorFactory.getInstance().has(new Column(Table.class, this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName()), database), "Column exists");
        }
        catch (Exception e) {
            return new ChangeStatus().unknown(e);
        }
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database, final String columnName) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            @Override
            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            @Override
            public boolean createThisColumn(ColumnConfig column) {
                return !column.getName().equals(columnName);
            }

            @Override
            public boolean copyThisColumn(ColumnConfig column) {
                return !column.getName().equals(columnName);
            }

            @Override
            public boolean createThisIndex(Index index) {
                return !index.getColumns().contains(columnName);
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getCatalogName(), this.getSchemaName(), this.getTableName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        if (this.isMultiple()) {
            ArrayList<String> names = new ArrayList<String>(this.columns.size());
            for (ColumnConfig column : this.columns) {
                names.add(column.getName());
            }
            return "Columns " + StringUtils.join(names, ",") + " dropped from " + this.getTableName();
        }
        return "Column " + this.getTableName() + "." + this.getColumnName() + " dropped";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        Object value = super.getSerializableFieldValue(field);
        if (field.equals("columns") && ((List)value).size() == 0) {
            return null;
        }
        return value;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    @Override
    @DatabaseChangeProperty(description="Columns to be dropped.", requiredForDatabase={"none"})
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    private boolean isMultiple() {
        return this.columns != null && !this.columns.isEmpty();
    }
}

