/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImageDiskContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportImageRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private String description;
    private ListWithAutoConstructFlag<ImageDiskContainer> diskContainers;
    private String licenseType;
    private String hypervisor;
    private String architecture;
    private String platform;
    private ClientData clientData;
    private String clientToken;
    private String roleName;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ImportImageRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportImageRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ImageDiskContainer> getDiskContainers() {
        if (this.diskContainers == null) {
            this.diskContainers = new ListWithAutoConstructFlag();
            this.diskContainers.setAutoConstruct(true);
        }
        return this.diskContainers;
    }

    public void setDiskContainers(Collection<ImageDiskContainer> diskContainers) {
        if (diskContainers == null) {
            this.diskContainers = null;
            return;
        }
        ListWithAutoConstructFlag diskContainersCopy = new ListWithAutoConstructFlag(diskContainers.size());
        diskContainersCopy.addAll(diskContainers);
        this.diskContainers = diskContainersCopy;
    }

    public ImportImageRequest withDiskContainers(ImageDiskContainer ... diskContainers) {
        if (this.getDiskContainers() == null) {
            this.setDiskContainers(new ArrayList<ImageDiskContainer>(diskContainers.length));
        }
        for (ImageDiskContainer value : diskContainers) {
            this.getDiskContainers().add(value);
        }
        return this;
    }

    public ImportImageRequest withDiskContainers(Collection<ImageDiskContainer> diskContainers) {
        if (diskContainers == null) {
            this.diskContainers = null;
        } else {
            ListWithAutoConstructFlag diskContainersCopy = new ListWithAutoConstructFlag(diskContainers.size());
            diskContainersCopy.addAll(diskContainers);
            this.diskContainers = diskContainersCopy;
        }
        return this;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public ImportImageRequest withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public ImportImageRequest withHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public ImportImageRequest withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ImportImageRequest withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public ClientData getClientData() {
        return this.clientData;
    }

    public void setClientData(ClientData clientData) {
        this.clientData = clientData;
    }

    public ImportImageRequest withClientData(ClientData clientData) {
        this.clientData = clientData;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public ImportImageRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public ImportImageRequest withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDiskContainers() != null) {
            sb.append("DiskContainers: " + this.getDiskContainers() + ",");
        }
        if (this.getLicenseType() != null) {
            sb.append("LicenseType: " + this.getLicenseType() + ",");
        }
        if (this.getHypervisor() != null) {
            sb.append("Hypervisor: " + this.getHypervisor() + ",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: " + this.getPlatform() + ",");
        }
        if (this.getClientData() != null) {
            sb.append("ClientData: " + this.getClientData() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getRoleName() != null) {
            sb.append("RoleName: " + this.getRoleName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDiskContainers() == null ? 0 : ((Object)this.getDiskContainers()).hashCode());
        hashCode = 31 * hashCode + (this.getLicenseType() == null ? 0 : this.getLicenseType().hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getClientData() == null ? 0 : this.getClientData().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDiskContainers() == null ^ this.getDiskContainers() == null) {
            return false;
        }
        if (other.getDiskContainers() != null && !((Object)other.getDiskContainers()).equals(this.getDiskContainers())) {
            return false;
        }
        if (other.getLicenseType() == null ^ this.getLicenseType() == null) {
            return false;
        }
        if (other.getLicenseType() != null && !other.getLicenseType().equals(this.getLicenseType())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        if (other.getHypervisor() != null && !other.getHypervisor().equals(this.getHypervisor())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getClientData() == null ^ this.getClientData() == null) {
            return false;
        }
        if (other.getClientData() != null && !other.getClientData().equals(this.getClientData())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        return other.getRoleName() == null || other.getRoleName().equals(this.getRoleName());
    }
}

