"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
var _helpers = require("../../common/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class FieldMappingService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend GET mappings/view API.
     */
    _defineProperty(this, "getMappingsView", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const {
          indexName,
          ruleTopic
        } = request.query;
        const params = {
          indexName,
          ruleTopic
        };
        const getFieldMappingViewResponse = await client(_constants.CLIENT_FIELD_MAPPINGS_METHODS.GET_MAPPINGS_VIEW, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFieldMappingViewResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FieldMappingService - getMappingsView:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend GET Detector API.
     */
    _defineProperty(this, "createMappings", async (context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const client = this.getClient(request, context);
        const getDetectorResponse = await client(_constants.CLIENT_FIELD_MAPPINGS_METHODS.CREATE_MAPPINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - getDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend GET mappings/view API.
     */
    _defineProperty(this, "getMappings", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const {
          indexName
        } = request.query;
        const params = {
          indexName
        };
        const getFieldMappingsResponse = await client(_constants.CLIENT_FIELD_MAPPINGS_METHODS.GET_MAPPINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFieldMappingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FieldMappingService - getMappings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getIndexAliasFields", async (context, request, response) => {
      try {
        var _Object$values$;
        const {
          indexName
        } = request.params;
        const client = this.getClient(request, context);
        const mappingsResponse = await client(_constants.CLIENT_FIELD_MAPPINGS_METHODS.GET_INDEX_ALIAS_MAPPINGS, {
          indexName
        });
        const fields = [];
        (0, _helpers.extractFieldsFromMappings)(((_Object$values$ = Object.values(mappingsResponse)[0]) === null || _Object$values$ === void 0 || (_Object$values$ = _Object$values$.mappings) === null || _Object$values$ === void 0 ? void 0 : _Object$values$.properties) || {}, fields);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: fields
          }
        });
      } catch (error) {
        console.error('Security Analytics - FieldMappingService - getIndexAliasFields:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = FieldMappingService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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