"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantClient = void 0;
var _constants = require("../utils/constants");
var _get_agent = require("../routes/get_agent");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isDataSourceQuery = query => {
  if ('dataSourceId' in query && query.dataSourceId) {
    return true;
  }
  return false;
};
class AssistantClient {
  constructor(request, context) {
    this.request = request;
    this.context = context;
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "executeAgent", async (agentId, parameters) => {
      const client = await this.getOpenSearchClient();
      const response = await client.transport.request({
        method: 'POST',
        path: `${_constants.ML_COMMONS_BASE_API}/agents/${agentId}/_execute`,
        body: {
          parameters
        }
      });
      return response;
    });
    _defineProperty(this, "executeAgentByConfigName", async (agentConfigName, parameters) => {
      const agentId = await this.getAgentIdByConfigName(agentConfigName);
      return this.executeAgent(agentId, parameters);
    });
    _defineProperty(this, "getAgentIdByConfigName", async agentConfigName => {
      const client = await this.getOpenSearchClient();
      const agentId = await (0, _get_agent.getAgentIdByConfigName)(agentConfigName, client.transport);
      return agentId;
    });
  }
  async getOpenSearchClient() {
    if (!this.client) {
      let client = this.context.core.opensearch.client.asCurrentUser;
      if (isDataSourceQuery(this.request.query) && this.context.dataSource) {
        client = await this.context.dataSource.opensearch.getClient(this.request.query.dataSourceId);
      }
      this.client = client;
    }
    return this.client;
  }
}
exports.AssistantClient = AssistantClient;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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