/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.JavaThreadsProvider;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.ui.HTMLView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaFrameGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.JniLocalGCRoot;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.threads.ThreadStateIcon;

public class JavaThreadsView
extends HeapViewerFeature {
    private static final String FEATURE_ID = "java_threads";
    private static final String VIEW_OBJECTS_ID = "java_threads_objects";
    private static final String VIEW_HTML_ID = "java_threads_html";
    private Aggregation aggregation = Aggregation.NAMES;
    private JComponent component;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar aggregToolbar;
    private ProfilerToolbar pluginsToolbar;
    private final HTMLView htmlView;
    private final PluggableTreeTableView objectsView;
    private JToggleButton rObjects;
    private JToggleButton rHTML;
    private JToggleButton tbName;
    private JToggleButton tbState;
    private static final int MAX_EXPAND_SIZE = 1000;
    private static final int DEFAULT_EXPAND_SIZE = 800;

    public JavaThreadsView(HeapContext context, HeapViewerActions actions) {
        super(FEATURE_ID, Bundle.JavaThreadsView_Name(), Bundle.JavaThreadsView_Description(), Icons.getIcon((String)"ProfilerIcons.WindowThreads"), 300);
        Heap heap = context.getFragment().getHeap();
        this.objectsView = new PluggableTreeTableView(VIEW_OBJECTS_ID, context, actions, TreeTableViewColumn.instances(heap, false)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                switch (JavaThreadsView.this.getAggregation()) {
                    case NAMES: {
                        return JavaThreadsProvider.getThreadsNodes(root, heap);
                    }
                    case STATES: {
                        return JavaThreadsProvider.getStateNodes(root, heap);
                    }
                }
                throw new IllegalArgumentException(JavaThreadsView.this.getAggregation().toString());
            }

            @Override
            protected void childrenChanged() {
                JavaThreadsView.this.setupDefault();
            }

            @Override
            protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(new AbstractAction(Bundle.JavaThreadsView_ExpandAction()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(() -> JavaThreadsView.this.setupDefault());
                    }
                });
                popup.add(new AbstractAction(Bundle.JavaThreadsView_CollapseAction()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.collapseChildren(this.getRoot());
                            }
                        });
                    }
                });
            }
        };
        this.objectsView.setViewName(Bundle.JavaThreadsView_Name());
        this.htmlView = new HTMLView(VIEW_HTML_ID, context, actions, Bundle.JavaThreadsView_ComputingThreads()){

            @Override
            protected String computeData(HeapContext context, String viewID) {
                return JavaThreadsProvider.getThreadsHTML(context);
            }

            @Override
            protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
                return JavaThreadsProvider.getNode(url, context);
            }
        };
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    void selectInstance(long instanceID, String viewID) {
        if (this.rHTML == null) {
            this.init();
        }
        this.rHTML.setSelected(true);
        this.htmlView.selectReference(Long.toString(instanceID));
    }

    void configureAllThreads() {
        if (this.component != null) {
            this.rObjects.setSelected(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaThreadsView.this.objectsView.collapseChildren(JavaThreadsView.this.objectsView.getRoot());
                    JavaThreadsView.this.setupDefault();
                }
            });
        }
    }

    private void setupDefault() {
        HeapViewerNode[] children = this.objectsView.getRoot().getChildren();
        if (children.length > 1000) {
            children = Arrays.copyOf(children, 800);
        }
        for (HeapViewerNode child : children) {
            this.objectsView.expandNode(child);
        }
    }

    private synchronized void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        this.objectsView.reloadView();
    }

    private synchronized Aggregation getAggregation() {
        return this.aggregation;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaThreadsView_Results()));
        this.toolbar.addSpace(3);
        ButtonGroup resultsBG = new ButtonGroup();
        this.rObjects = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots"), true){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (JavaThreadsView.this.component != null) {
                        ((CardLayout)JavaThreadsView.this.component.getLayout()).first(JavaThreadsView.this.component);
                    }
                    if (JavaThreadsView.this.aggregToolbar != null) {
                        JavaThreadsView.this.aggregToolbar.getComponent().setVisible(true);
                    }
                    if (JavaThreadsView.this.pluginsToolbar != null) {
                        JavaThreadsView.this.pluginsToolbar.getComponent().setVisible(true);
                    }
                }
            }
        };
        this.rObjects.putClientProperty("JButton.buttonType", "segmented");
        this.rObjects.putClientProperty("JButton.segmentPosition", "first");
        this.rObjects.setToolTipText(Bundle.JavaThreadsView_TooltipObjects());
        resultsBG.add(this.rObjects);
        this.toolbar.add((Component)this.rObjects);
        this.rHTML = new JToggleButton(Icons.getIcon((String)"HeapWalkerIcons.Properties")){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (JavaThreadsView.this.component != null) {
                        ((CardLayout)JavaThreadsView.this.component.getLayout()).last(JavaThreadsView.this.component);
                    }
                    if (JavaThreadsView.this.aggregToolbar != null) {
                        JavaThreadsView.this.aggregToolbar.getComponent().setVisible(false);
                    }
                    if (JavaThreadsView.this.pluginsToolbar != null) {
                        JavaThreadsView.this.pluginsToolbar.getComponent().setVisible(false);
                    }
                }
            }
        };
        this.rHTML.putClientProperty("JButton.buttonType", "segmented");
        this.rHTML.putClientProperty("JButton.segmentPosition", "last");
        this.rHTML.setToolTipText(Bundle.JavaThreadsView_TooltipHTML());
        resultsBG.add(this.rHTML);
        this.toolbar.add((Component)this.rHTML);
        this.aggregToolbar = ProfilerToolbar.create((boolean)false);
        this.aggregToolbar.addSpace(8);
        this.aggregToolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Aggregation()));
        this.aggregToolbar.addSpace(2);
        final ButtonGroup aggregationBG = new ButtonGroup();
        class AggregationButton
        extends JToggleButton {
            private final Aggregation aggregation;

            AggregationButton(Aggregation aggregation, boolean selected) {
                super(aggregation.getIcon(), selected);
                this.aggregation = aggregation;
                this.setToolTipText(aggregation.toString());
                aggregationBG.add(this);
            }

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && this.aggregation != null) {
                    JavaThreadsView.this.setAggregation(this.aggregation);
                }
            }
        }
        this.tbName = new AggregationButton(Aggregation.NAMES, Aggregation.NAMES.equals((Object)this.aggregation));
        this.tbName.putClientProperty("JButton.buttonType", "segmented");
        this.tbName.putClientProperty("JButton.segmentPosition", "first");
        this.aggregToolbar.add((Component)this.tbName);
        this.tbState = new AggregationButton(Aggregation.STATES, Aggregation.STATES.equals((Object)this.aggregation));
        this.tbState.putClientProperty("JButton.buttonType", "segmented");
        this.tbState.putClientProperty("JButton.segmentPosition", "last");
        this.aggregToolbar.add((Component)this.tbState);
        this.toolbar.add(this.aggregToolbar);
        if (this.objectsView.hasPlugins()) {
            this.pluginsToolbar = ProfilerToolbar.create((boolean)false);
            this.pluginsToolbar.addSpace(8);
            this.pluginsToolbar.add((Component)new GrayLabel(Bundle.JavaThreadsView_Details()));
            this.pluginsToolbar.addSpace(2);
            this.pluginsToolbar.add(this.objectsView.getToolbar());
            this.toolbar.add(this.pluginsToolbar);
        }
        this.component = new JPanel(new CardLayout());
        this.component.add(this.objectsView.getComponent());
        this.component.add(this.htmlView.getComponent());
    }

    public static class SelectInstanceActionProvider
    extends HeapViewerNodeAction.Provider {
        @Override
        public boolean supportsView(HeapContext context, String viewID) {
            return !viewID.startsWith(JavaThreadsView.FEATURE_ID) && JavaHeapFragment.isJavaHeap(context);
        }

        @Override
        public HeapViewerNodeAction[] getActions(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            Heap heap = context.getFragment().getHeap();
            Instance instance = HeapViewerNode.getValue(node, DataType.INSTANCE, heap);
            if (instance == null) {
                return null;
            }
            Collection gcRoots = heap.getGCRoots(instance);
            for (GCRoot gcRoot : gcRoots) {
                JniLocalGCRoot frameJni;
                JavaFrameGCRoot frameVar;
                String gcRootKind = gcRoot.getKind();
                if (!("Java frame".equals(gcRootKind) ? (frameVar = (JavaFrameGCRoot)gcRoot).getFrameNumber() != -1 : ("JNI local".equals(gcRootKind) ? (frameJni = (JniLocalGCRoot)gcRoot).getFrameNumber() != -1 : "thread object".equals(gcRootKind)))) continue;
                return new HeapViewerNodeAction[]{new SelectInstanceAction(instance.getInstanceId(), actions)};
            }
            return null;
        }
    }

    private static class SelectInstanceAction
    extends HeapViewerNodeAction {
        private final long id;
        private final HeapViewerActions actions;

        SelectInstanceAction(long id, HeapViewerActions actions) {
            super(Bundle.JavaThreadsView_SelectAction(), 205);
            this.id = id;
            this.actions = actions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JavaThreadsView threadsView = this.actions.findFeature(JavaThreadsView.class);
            if (threadsView != null) {
                this.actions.selectFeature(threadsView);
                threadsView.selectInstance(this.id, JavaThreadsView.VIEW_HTML_ID);
            }
        }
    }

    public static class Provider
    extends HeapViewerFeature.Provider {
        @Override
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new JavaThreadsView(context, actions);
            }
            return null;
        }
    }

    private static enum Aggregation {
        NAMES(Bundle.JavaThreadsView_TName(), Icons.getIcon((String)"ProfilerIcons.Thread")),
        STATES(Bundle.JavaThreadsView_TState(), (Icon)new ThreadStateIcon(1, 15, 15));

        private final String aggregationName;
        private final Icon aggregationIcon;

        private Aggregation(String aggregationName, Icon aggregationIcon) {
            this.aggregationName = aggregationName;
            this.aggregationIcon = aggregationIcon;
        }

        public String toString() {
            return this.aggregationName;
        }

        public Icon getIcon() {
            return this.aggregationIcon;
        }
    }
}

