/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.AndCondition;
import com.google.firebase.remoteconfig.CustomSignalCondition;
import com.google.firebase.remoteconfig.OrCondition;
import com.google.firebase.remoteconfig.PercentCondition;
import com.google.firebase.remoteconfig.internal.ServerTemplateResponse;

class OneOfCondition {
    private OrCondition orCondition;
    private AndCondition andCondition;
    private PercentCondition percent;
    private CustomSignalCondition customSignal;
    private String trueValue;
    private String falseValue;

    OneOfCondition(ServerTemplateResponse.OneOfConditionResponse oneOfconditionResponse) {
        if (oneOfconditionResponse.getOrCondition() != null) {
            this.orCondition = new OrCondition(oneOfconditionResponse.getOrCondition());
        }
        if (oneOfconditionResponse.getAndCondition() != null) {
            this.andCondition = new AndCondition(oneOfconditionResponse.getAndCondition());
        }
        if (oneOfconditionResponse.getPercentCondition() != null) {
            this.percent = new PercentCondition(oneOfconditionResponse.getPercentCondition());
        }
        if (oneOfconditionResponse.getCustomSignalCondition() != null) {
            this.customSignal = new CustomSignalCondition(oneOfconditionResponse.getCustomSignalCondition());
        }
    }

    @VisibleForTesting
    OneOfCondition() {
        this.orCondition = null;
        this.andCondition = null;
        this.percent = null;
        this.trueValue = null;
        this.falseValue = null;
    }

    @Nullable
    OrCondition getOrCondition() {
        return this.orCondition;
    }

    @Nullable
    AndCondition getAndCondition() {
        return this.andCondition;
    }

    @Nullable
    String isTrue() {
        return this.trueValue;
    }

    @Nullable
    String isFalse() {
        return this.falseValue;
    }

    @Nullable
    PercentCondition getPercent() {
        return this.percent;
    }

    @Nullable
    CustomSignalCondition getCustomSignal() {
        return this.customSignal;
    }

    OneOfCondition setOrCondition(@NonNull OrCondition orCondition) {
        Preconditions.checkNotNull((Object)orCondition, (Object)"`Or` condition cannot be set to null.");
        this.orCondition = orCondition;
        return this;
    }

    OneOfCondition setAndCondition(@NonNull AndCondition andCondition) {
        Preconditions.checkNotNull((Object)andCondition, (Object)"`And` condition cannot be set to null.");
        this.andCondition = andCondition;
        return this;
    }

    OneOfCondition setPercent(@NonNull PercentCondition percent) {
        Preconditions.checkNotNull((Object)percent, (Object)"`Percent` condition cannot be set to null.");
        this.percent = percent;
        return this;
    }

    OneOfCondition setCustomSignal(@NonNull CustomSignalCondition customSignal) {
        Preconditions.checkNotNull((Object)customSignal, (Object)"`Custom signal` condition cannot be set to null.");
        this.customSignal = customSignal;
        return this;
    }

    OneOfCondition setTrue() {
        this.trueValue = "true";
        return this;
    }

    OneOfCondition setFalse() {
        this.falseValue = "false";
        return this;
    }

    ServerTemplateResponse.OneOfConditionResponse toOneOfConditionResponse() {
        ServerTemplateResponse.OneOfConditionResponse oneOfConditionResponse = new ServerTemplateResponse.OneOfConditionResponse();
        if (this.andCondition != null) {
            oneOfConditionResponse.setAndCondition(this.andCondition.toAndConditionResponse());
        }
        if (this.orCondition != null) {
            oneOfConditionResponse.setOrCondition(this.orCondition.toOrConditionResponse());
        }
        if (this.customSignal != null) {
            oneOfConditionResponse.setCustomSignalCondition(this.customSignal.toCustomConditonResponse());
        }
        if (this.percent != null) {
            oneOfConditionResponse.setPercentCondition(this.percent.toPercentConditionResponse());
        }
        return oneOfConditionResponse;
    }
}

