/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import io.netty.channel.ChannelHandlerContext;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.DateUtil;
import org.traccar.helper.NetworkUtil;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class PositionLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionLogger.class);
    private final CacheManager cacheManager;
    private final Set<String> logAttributes = new LinkedHashSet<String>();

    @Inject
    public PositionLogger(Config config, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.logAttributes.addAll(Arrays.asList(config.getString(Keys.LOGGER_ATTRIBUTES).split("[, ]")));
    }

    public void log(ChannelHandlerContext context, Position position) {
        Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(NetworkUtil.session(context.channel())).append("] ");
        builder.append("id: ").append(device.getUniqueId());
        Iterator<String> iterator = this.logAttributes.iterator();
        block20: while (iterator.hasNext()) {
            String attribute;
            switch (attribute = iterator.next()) {
                case "time": {
                    builder.append(", time: ").append(DateUtil.formatDate(position.getFixTime(), false));
                    continue block20;
                }
                case "position": {
                    builder.append(", lat: ").append(String.format("%.5f", position.getLatitude()));
                    builder.append(", lon: ").append(String.format("%.5f", position.getLongitude()));
                    continue block20;
                }
                case "speed": {
                    if (!(position.getSpeed() > 0.0)) continue block20;
                    builder.append(", speed: ").append(String.format("%.1f", position.getSpeed()));
                    continue block20;
                }
                case "course": {
                    builder.append(", course: ").append(String.format("%.1f", position.getCourse()));
                    continue block20;
                }
                case "altitude": {
                    builder.append(", altitude: ").append(String.format("%.1f", position.getAltitude()));
                    continue block20;
                }
                case "accuracy": {
                    if (!(position.getAccuracy() > 0.0)) continue block20;
                    builder.append(", accuracy: ").append(String.format("%.1f", position.getAccuracy()));
                    continue block20;
                }
                case "outdated": {
                    if (!position.getOutdated()) continue block20;
                    builder.append(", outdated");
                    continue block20;
                }
                case "invalid": {
                    if (position.getValid()) continue block20;
                    builder.append(", invalid");
                    continue block20;
                }
            }
            Object value = position.getAttributes().get(attribute);
            if (value == null) continue;
            builder.append(", ").append(attribute).append(": ").append(value);
        }
        LOGGER.info(builder.toString());
    }
}

