from typing import Any, Iterable, Match, Pattern as _Pattern

SPECIAL_CHARS: str
REPEAT_CHARS: str
DIGITS: set[Any]
OCTDIGITS: set[Any]
HEXDIGITS: set[Any]
WHITESPACE: set[Any]
ESCAPES: dict[str, tuple[str, int]]
CATEGORIES: dict[str, tuple[str, str] | tuple[str, list[tuple[str, str]]]]
FLAGS: dict[str, int]

class Pattern:
    flags: int
    open: list[int]
    groups: int
    groupdict: dict[str, int]
    lookbehind: int
    def __init__(self) -> None: ...
    def opengroup(self, name: str = ...) -> int: ...
    def closegroup(self, gid: int) -> None: ...
    def checkgroup(self, gid: int) -> bool: ...

_OpSubpatternType = tuple[int | None, int, int, SubPattern]
_OpGroupRefExistsType = tuple[int, SubPattern, SubPattern]
_OpInType = list[tuple[str, int]]
_OpBranchType = tuple[None, list[SubPattern]]
_AvType = _OpInType | _OpBranchType | Iterable[SubPattern] | _OpGroupRefExistsType | _OpSubpatternType
_CodeType = str | _AvType

class SubPattern:
    pattern: str
    data: list[_CodeType]
    width: int | None
    def __init__(self, pattern, data: list[_CodeType] = ...) -> None: ...
    def dump(self, level: int = ...) -> None: ...
    def __len__(self) -> int: ...
    def __delitem__(self, index: int | slice) -> None: ...
    def __getitem__(self, index: int | slice) -> SubPattern | _CodeType: ...
    def __setitem__(self, index: int | slice, code: _CodeType): ...
    def insert(self, index, code: _CodeType) -> None: ...
    def append(self, code: _CodeType) -> None: ...
    def getwidth(self) -> int: ...

class Tokenizer:
    string: str
    index: int
    def __init__(self, string: str) -> None: ...
    def match(self, char: str, skip: int = ...) -> int: ...
    def get(self) -> str | None: ...
    def tell(self) -> tuple[int, str | None]: ...
    def seek(self, index: int) -> None: ...

def isident(char: str) -> bool: ...
def isdigit(char: str) -> bool: ...
def isname(name: str) -> bool: ...
def parse(str: str, flags: int = ..., pattern: Pattern = ...) -> SubPattern: ...

_Template = tuple[list[tuple[int, int]], list[int | None]]

def parse_template(source: str, pattern: _Pattern[Any]) -> _Template: ...
def expand_template(template: _Template, match: Match[Any]) -> str: ...
