/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.EmphasisFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownRangedFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownWrappingFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eJ4\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0005R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks;", "", "<init>", "()V", "create", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "nodes", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "align", "Lkotlin/Function1;", "Lcom/intellij/formatting/Alignment;", "node", "isInsideBlockquote", "", "shouldWrapInsideBlockquote", "filterFromWhitespaces", "sequence", "emphasisLikeElements", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownBlocks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownBlocks.kt\norg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,78:1\n1255#2,2:79\n*S KotlinDebug\n*F\n+ 1 MarkdownBlocks.kt\norg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks\n*L\n57#1:79,2\n*E\n"})
public final class MarkdownBlocks {
    @NotNull
    public static final MarkdownBlocks INSTANCE = new MarkdownBlocks();
    @NotNull
    private static final TokenSet emphasisLikeElements;

    private MarkdownBlocks() {
    }

    @NotNull
    public final Sequence<MarkdownFormattingBlock> create(@NotNull Sequence<? extends ASTNode> nodes, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        return SequencesKt.map(this.filterFromWhitespaces(nodes), arg_0 -> MarkdownBlocks.create$lambda$0(settings, spacing, align, arg_0));
    }

    @NotNull
    public final MarkdownFormattingBlock create(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        IElementType iElementType = node.getElementType();
        return MarkdownTokenTypeSets.LIST_MARKERS.contains(iElementType) || MarkdownTokenTypeSets.WHITE_SPACES.contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BLOCK_QUOTE) ? (MarkdownFormattingBlock)MarkdownRangedFormattingBlock.Companion.trimmed(node, settings, spacing, (Alignment)align.invoke((Object)node), null) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN) ? new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false)) : (emphasisLikeElements.contains(iElementType) ? (MarkdownFormattingBlock)new EmphasisFormattingBlock(settings, spacing, node, (Alignment)align.invoke((Object)node)) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) ? (this.isInsideBlockquote(node) && !this.shouldWrapInsideBlockquote(settings) ? new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null) : (MarkdownFormattingBlock)new MarkdownWrappingFormattingBlock(settings, spacing, node, (Alignment)align.invoke((Object)node), null, 16, null)) : new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null))));
    }

    private final boolean isInsideBlockquote(ASTNode node) {
        boolean bl;
        block1: {
            Sequence<ASTNode> $this$any$iv = AstUtilsKt.parents(node, false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = MarkdownTokenTypeSets.BLOCK_QUOTE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"BLOCK_QUOTE");
                if (!AstUtilsKt.hasType(it, iElementType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean shouldWrapInsideBlockquote(CodeStyleSettings settings) {
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        MarkdownCustomCodeStyleSettings customSettings = (MarkdownCustomCodeStyleSettings)customCodeStyleSettings;
        return customSettings.WRAP_TEXT_IF_LONG && customSettings.WRAP_TEXT_INSIDE_BLOCKQUOTES;
    }

    @NotNull
    public final Sequence<ASTNode> filterFromWhitespaces(@NotNull Sequence<? extends ASTNode> sequence) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        return SequencesKt.filter(sequence, MarkdownBlocks::filterFromWhitespaces$lambda$0);
    }

    private static final MarkdownFormattingBlock create$lambda$0(CodeStyleSettings $settings, SpacingBuilder $spacing, Function1 $align, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.create(it, $settings, $spacing, (Function1<? super ASTNode, ? extends Alignment>)$align);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean filterFromWhitespaces$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!MarkdownTokenTypeSets.WHITE_SPACES.contains(it.getElementType())) return true;
        if (!MarkdownTokenTypeSets.WHITE_SPACES.contains(it.getElementType())) return false;
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) return false;
        return true;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.EMPH, MarkdownElementTypes.STRONG, MarkdownElementTypes.STRIKETHROUGH};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        emphasisLikeElements = tokenSet;
    }
}

