/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CompObj;
import net.sf.mpxj.mpp.MPP12Reader;
import net.sf.mpxj.mpp.MPP14Reader;
import net.sf.mpxj.mpp.MPP8Reader;
import net.sf.mpxj.mpp.MPP9Reader;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class MPPReader
extends AbstractProjectReader {
    private boolean m_preserveNoteFormatting;
    private boolean m_useRawTimephasedData;
    private boolean m_readPresentationData = true;
    private boolean m_readPropertiesOnly;
    private String m_readPassword;
    private List<ProjectListener> m_projectListeners;
    private static final Map<String, Class<? extends MPPVariantReader>> FILE_CLASS_MAP = new HashMap<String, Class<? extends MPPVariantReader>>();

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(inputStream);
            return this.read(pOIFSFileSystem);
        }
        catch (IOException iOException) {
            throw new MPXJException("Error reading file", iOException);
        }
    }

    public static String getFileFormat(POIFSFileSystem pOIFSFileSystem) throws IOException {
        String string = "";
        DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
        if (directoryNode.getEntryNames().contains("\u0001CompObj")) {
            CompObj compObj = new CompObj(new DocumentInputStream((DocumentEntry)directoryNode.getEntry("\u0001CompObj")));
            string = compObj.getFileFormat();
        }
        return string;
    }

    public ProjectFile read(POIFSFileSystem pOIFSFileSystem) throws MPXJException {
        try {
            ProjectFile projectFile = new ProjectFile();
            ProjectConfig projectConfig = projectFile.getProjectConfig();
            projectConfig.setAutoTaskID(false);
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoResourceID(false);
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoOutlineLevel(false);
            projectConfig.setAutoOutlineNumber(false);
            projectConfig.setAutoWBS(false);
            projectConfig.setAutoCalendarUniqueID(false);
            projectConfig.setAutoAssignmentUniqueID(false);
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
            CompObj compObj = new CompObj(new DocumentInputStream((DocumentEntry)directoryNode.getEntry("\u0001CompObj")));
            ProjectProperties projectProperties = projectFile.getProjectProperties();
            projectProperties.setFullApplicationName(compObj.getApplicationName());
            projectProperties.setApplicationVersion(compObj.getApplicationVersion());
            String string = compObj.getFileFormat();
            Class<? extends MPPVariantReader> clazz = FILE_CLASS_MAP.get(string);
            if (clazz == null) {
                throw new MPXJException("Invalid file format: " + string);
            }
            MPPVariantReader mPPVariantReader = clazz.newInstance();
            mPPVariantReader.process(this, projectFile, directoryNode);
            projectConfig.setAutoOutlineNumber(true);
            projectFile.updateStructure();
            projectConfig.setAutoOutlineNumber(false);
            Object object = projectFile.getTasks().iterator();
            while (object.hasNext()) {
                Task task;
                task.setSummary((task = (Task)object.next()).getChildTasks().size() != 0);
                List<DateRange> list = task.getSplits();
                if (list != null && list.isEmpty()) {
                    task.setSplits(null);
                }
                this.validationRelations(task);
            }
            projectConfig.updateUniqueCounters();
            object = projectFile.getProjectProperties().getProjectFilePath();
            if (object != null && ((String)object).startsWith("<>\\")) {
                projectProperties.setFileApplication("Microsoft Project Server");
            } else {
                projectProperties.setFileApplication("Microsoft");
            }
            projectProperties.setFileType("MPP");
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Error reading file", iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MPXJException("Error reading file", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new MPXJException("Error reading file", instantiationException);
        }
    }

    private void validationRelations(Task task) {
        List<Relation> list = task.getPredecessors();
        if (!list.isEmpty()) {
            ArrayList<Relation> arrayList = new ArrayList<Relation>();
            for (Relation relation : list) {
                Task task2 = relation.getSourceTask();
                Task task3 = relation.getTargetTask();
                String string = task2.getOutlineNumber();
                String string2 = task3.getOutlineNumber();
                if (string == null || string2 == null || !string.startsWith(string2 + ".")) continue;
                arrayList.add(relation);
            }
            for (Relation relation : arrayList) {
                relation.getSourceTask().removePredecessor(relation.getTargetTask(), relation.getType(), relation.getLag());
            }
        }
    }

    public boolean getPreserveNoteFormatting() {
        return this.m_preserveNoteFormatting;
    }

    public void setPreserveNoteFormatting(boolean bl) {
        this.m_preserveNoteFormatting = bl;
    }

    public boolean getUseRawTimephasedData() {
        return this.m_useRawTimephasedData;
    }

    public void setUseRawTimephasedData(boolean bl) {
        this.m_useRawTimephasedData = bl;
    }

    public boolean getReadPresentationData() {
        return this.m_readPresentationData;
    }

    public void setReadPresentationData(boolean bl) {
        this.m_readPresentationData = bl;
    }

    public boolean getReadPropertiesOnly() {
        return this.m_readPropertiesOnly;
    }

    public void setReadPropertiesOnly(boolean bl) {
        this.m_readPropertiesOnly = bl;
    }

    public void setReadPassword(String string) {
        this.m_readPassword = string;
    }

    public String getReadPassword() {
        return this.m_readPassword;
    }

    static {
        FILE_CLASS_MAP.put("MSProject.MPP9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL14", MPP14Reader.class);
    }
}

