/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) - 12) => ivec4(-76, 60, 76, -88)
 * (ivec4(-64, 72, 88, -76) - -6) => ivec4(-58, 78, 94, -70)
 * (ivec4(-64, 72, 88, -76) - 76) => ivec4(-140, -4, 12, -152)
 * (ivec4(-64, 72, 88, -76) - -32) => ivec4(-32, 104, 120, -44)
 * (ivec4(-64, 72, 88, -76) - 0) => ivec4(-64, 72, 88, -76)
 * (ivec4(64, 72, 88, 76) - 12) => ivec4(52, 60, 76, 64)
 * (ivec4(64, 72, 88, 76) - -6) => ivec4(70, 78, 94, 82)
 * (ivec4(64, 72, 88, 76) - 76) => ivec4(-12, -4, 12, 0)
 * (ivec4(64, 72, 88, 76) - -32) => ivec4(96, 104, 120, 108)
 * (ivec4(64, 72, 88, 76) - 0) => ivec4(64, 72, 88, 76)
 * (ivec4(-24, 40, -23, 64) - 12) => ivec4(-36, 28, -35, 52)
 * (ivec4(-24, 40, -23, 64) - -6) => ivec4(-18, 46, -17, 70)
 * (ivec4(-24, 40, -23, 64) - 76) => ivec4(-100, -36, -99, -12)
 * (ivec4(-24, 40, -23, 64) - -32) => ivec4(8, 72, 9, 96)
 * (ivec4(-24, 40, -23, 64) - 0) => ivec4(-24, 40, -23, 64)
 * (ivec4(24, 40, 23, 64) - 12) => ivec4(12, 28, 11, 52)
 * (ivec4(24, 40, 23, 64) - -6) => ivec4(30, 46, 29, 70)
 * (ivec4(24, 40, 23, 64) - 76) => ivec4(-52, -36, -53, -12)
 * (ivec4(24, 40, 23, 64) - -32) => ivec4(56, 72, 55, 96)
 * (ivec4(24, 40, 23, 64) - 0) => ivec4(24, 40, 23, 64)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) - 12), ivec4(-76, 60, 76, -88))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) - -6), ivec4(-58, 78, 94, -70))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) - 76), ivec4(-140, -4, 12, -152))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) - -32), ivec4(-32, 104, 120, -44))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) - 0), ivec4(-64, 72, 88, -76))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) - 12), ivec4(52, 60, 76, 64))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) - -6), ivec4(70, 78, 94, 82))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) - 76), ivec4(-12, -4, 12, 0))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) - -32), ivec4(96, 104, 120, 108))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) - 0), ivec4(64, 72, 88, 76))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) - 12), ivec4(-36, 28, -35, 52))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) - -6), ivec4(-18, 46, -17, 70))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) - 76), ivec4(-100, -36, -99, -12))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) - -32), ivec4(8, 72, 9, 96))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) - 0), ivec4(-24, 40, -23, 64))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) - 12), ivec4(12, 28, 11, 52))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) - -6), ivec4(30, 46, 29, 70))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) - 76), ivec4(-52, -36, -53, -12))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) - -32), ivec4(56, 72, 55, 96))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) - 0), ivec4(24, 40, 23, 64))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
