/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), -2.0) => vec4(-2.0, -2.0, -2.0, -2.0)
 * min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), -0.6666667) => vec4(-2.0, -0.6666667, -0.6666667, -0.6666667)
 * min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), 0.6666667) => vec4(-2.0, -0.6666667, 0.6666667, 0.6666667)
 * min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), 2.0) => vec4(-2.0, -0.6666667, 0.6666667, 2.0)
 */
#version 150

void main()
{
  float[distance(min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), -2.0), vec4(-2.0, -2.0, -2.0, -2.0)) <= 4e-05 ? 1 : -1] array0;
  float[distance(min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), -0.6666667), vec4(-2.0, -0.6666667, -0.6666667, -0.6666667)) <= 2.3094011e-05 ? 1 : -1] array1;
  float[distance(min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), 0.6666667), vec4(-2.0, -0.6666667, 0.6666667, 0.6666667)) <= 2.3094011e-05 ? 1 : -1] array2;
  float[distance(min(vec4(-2.0, -0.6666667, 0.6666667, 2.0), 2.0), vec4(-2.0, -0.6666667, 0.6666667, 2.0)) <= 2.9814239e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
