/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.cxf;

import java.util.Comparator;
import java.util.Objects;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceResourceProvider;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;

public class ComparableResourceComparator
implements ResourceComparator {
    private static Comparator<ServiceReferenceResourceProvider> comparator = new ServiceReferenceResourceProviderComparator();

    public int compare(ClassResourceInfo cri1, ClassResourceInfo cri2, Message message) {
        ResourceProvider rp1 = cri1.getResourceProvider();
        ResourceProvider rp2 = cri2.getResourceProvider();
        if (rp1 instanceof ServiceReferenceResourceProvider && rp2 instanceof ServiceReferenceResourceProvider) {
            return comparator.compare((ServiceReferenceResourceProvider)rp2, (ServiceReferenceResourceProvider)rp1);
        }
        if (rp1 instanceof ServiceReferenceResourceProvider) {
            return -1;
        }
        if (rp2 instanceof ServiceReferenceResourceProvider) {
            return 1;
        }
        return 0;
    }

    public int compare(OperationResourceInfo oper1, OperationResourceInfo oper2, Message message) {
        return 0;
    }

    private static class ServiceReferenceResourceProviderComparator
    implements Comparator<ServiceReferenceResourceProvider> {
        private ServiceReferenceResourceProviderComparator() {
        }

        @Override
        public int compare(ServiceReferenceResourceProvider rp1, ServiceReferenceResourceProvider rp2) {
            CachingServiceReference<?> ref1 = rp1.getImmutableServiceReference();
            CachingServiceReference<?> ref2 = rp2.getImmutableServiceReference();
            Object serviceRanking1 = ref1.getProperty("service.ranking");
            Object serviceRanking2 = ref2.getProperty("service.ranking");
            if (serviceRanking1 == null && serviceRanking2 == null || Objects.equals(serviceRanking1, serviceRanking2)) {
                return 0;
            }
            return ref1.compareTo(ref2);
        }
    }
}

