/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.UserProfileContext;

public final class UserProfileMetadata
implements Cloneable {
    private final UserProfileContext context;
    private List<AttributeMetadata> attributes;

    public UserProfileMetadata(UserProfileContext context) {
        this.context = context;
    }

    public List<AttributeMetadata> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(List<AttributeMetadata> metadata) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributeMetadata>();
        }
        this.attributes.addAll(metadata);
    }

    public AttributeMetadata addAttribute(AttributeMetadata metadata) {
        this.addAttributes(Arrays.asList(metadata));
        return metadata;
    }

    public AttributeMetadata addAttribute(String name, int guiOrder, AttributeValidatorMetadata ... validator) {
        return this.addAttribute(name, guiOrder, Arrays.asList(validator));
    }

    public AttributeMetadata addAttribute(String name, int guiOrder, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> readAllowed, AttributeValidatorMetadata ... validator) {
        return this.addAttribute(new AttributeMetadata(name, guiOrder, AttributeMetadata.ALWAYS_TRUE, writeAllowed, AttributeMetadata.ALWAYS_TRUE, readAllowed).addValidators(Arrays.asList(validator)));
    }

    public AttributeMetadata addAttribute(String name, int guiOrder, Predicate<AttributeContext> writeAllowed, List<AttributeValidatorMetadata> validators) {
        return this.addAttribute(new AttributeMetadata(name, guiOrder, AttributeMetadata.ALWAYS_TRUE, writeAllowed, AttributeMetadata.ALWAYS_TRUE, AttributeMetadata.ALWAYS_TRUE).addValidators(validators));
    }

    public AttributeMetadata addAttribute(String name, int guiOrder, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required, List<AttributeValidatorMetadata> validators) {
        return this.addAttribute(new AttributeMetadata(name, guiOrder, AttributeMetadata.ALWAYS_TRUE, writeAllowed, required, AttributeMetadata.ALWAYS_TRUE).addValidators(validators));
    }

    public AttributeMetadata addAttribute(String name, int guiOrder, List<AttributeValidatorMetadata> validators) {
        return this.addAttribute(new AttributeMetadata(name, guiOrder).addValidators(validators));
    }

    public AttributeMetadata addAttribute(String name, int guiOrder, List<AttributeValidatorMetadata> validator, Predicate<AttributeContext> selector, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required, Predicate<AttributeContext> readAllowed) {
        return this.addAttribute(new AttributeMetadata(name, guiOrder, selector, writeAllowed, required, readAllowed).addValidators(validator));
    }

    public List<AttributeMetadata> getAttribute(String name) {
        if (this.attributes == null) {
            return Collections.emptyList();
        }
        return this.attributes.stream().filter(c -> name.equals(c.getName())).collect(Collectors.toList());
    }

    public UserProfileContext getContext() {
        return this.context;
    }

    public UserProfileMetadata clone() {
        UserProfileMetadata metadata = new UserProfileMetadata(this.context);
        if (this.attributes != null) {
            metadata.addAttributes(this.attributes.stream().map(AttributeMetadata::clone).collect(Collectors.toList()));
        }
        return metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserProfileMetadata)) {
            return false;
        }
        UserProfileMetadata that = (UserProfileMetadata)o;
        return that.getContext().equals((Object)this.getContext());
    }

    public int hashCode() {
        return this.getContext().hashCode();
    }
}

