/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.crypto.CekManagementProvider;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.models.KeycloakSession;

public class EcdhEsCekManagementProvider
implements CekManagementProvider {
    private final KeycloakSession session;
    private final String jweAlgorithmName;

    public EcdhEsCekManagementProvider(KeycloakSession session, String jweAlgorithmName) {
        this.session = session;
        this.jweAlgorithmName = jweAlgorithmName;
    }

    public JWEAlgorithmProvider jweAlgorithmProvider() {
        if ("ECDH-ES".equals(this.jweAlgorithmName) || "ECDH-ES+A128KW".equals(this.jweAlgorithmName) || "ECDH-ES+A192KW".equals(this.jweAlgorithmName) || "ECDH-ES+A256KW".equals(this.jweAlgorithmName)) {
            return (JWEAlgorithmProvider)CryptoIntegration.getProvider().getAlgorithmProvider(JWEAlgorithmProvider.class, this.jweAlgorithmName);
        }
        return null;
    }
}

