/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import java.io.Serializable;
import java.util.Hashtable;

public class ASN1Type
implements Serializable {
    private int tag;
    private String name;
    private static Hashtable asn1Types = new Hashtable(27);
    public static final ASN1Type BOOLEAN = new ASN1Type(1, "BOOLEAN");
    public static final ASN1Type INTEGER = new ASN1Type(2, "INTEGER");
    public static final ASN1Type BIT_STRING = new ASN1Type(3, "BIT STRING");
    public static final ASN1Type OCTET_STRING = new ASN1Type(4, "OCTET STRING");
    public static final ASN1Type NULL = new ASN1Type(5, "NULL");
    public static final ASN1Type OBJECT_ID = new ASN1Type(6, "OBJECT IDENTIFIER");
    public static final ASN1Type ENUMERATED = new ASN1Type(10, "ENUMERATED");
    public static final ASN1Type PrintableString = new ASN1Type(19, "PrintableString");
    public static final ASN1Type T61String = new ASN1Type(20, "T61String");
    public static final ASN1Type IA5String = new ASN1Type(22, "IA5String");
    public static final ASN1Type UTCTime = new ASN1Type(23, "UTCTime");
    public static final ASN1Type GENERALIZEDTIME = new ASN1Type(24, "GeneralizedTime");
    public static final ASN1Type UniversalString = new ASN1Type(28, "UniversalString");
    public static final ASN1Type BMPString = new ASN1Type(30, "BMPString");
    public static final ASN1Type SEQUENCE = new ASN1Type(48, "SEQUENCE");
    public static final ASN1Type SET = new ASN1Type(49, "SET");
    public static final ASN1Type ContextSpecific = new ASN1Type(128, "ContextSpecific");

    public ASN1Type(int t, String n) {
        this.tag = t;
        this.name = n;
        asn1Types.put(new Integer(this.tag), this.name);
    }

    public ASN1Type(int t) {
        this.tag = t;
        this.name = ASN1Type.asn1Name(t);
    }

    public String getName() {
        return this.name;
    }

    public int getTag() {
        return this.tag;
    }

    public int hashCode() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ASN1Type)) {
            return false;
        }
        ASN1Type a = (ASN1Type)o;
        return a.tag == this.tag;
    }

    public String toString() {
        return "ASN.1 type " + this.name + " (" + ASN1Type.asn1Name(this.tag) + ") [" + this.tag + "] ";
    }

    public static String asn1Name(int t) {
        String n = (String)asn1Types.get(new Integer(t));
        if (n == null) {
            return "Unknown";
        }
        return n;
    }
}

