/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.client.streaming.I2PSocketAddress;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.SOCKSHeader;
import net.i2p.i2ptunnel.socks.SOCKSUDPUnwrapper;
import net.i2p.i2ptunnel.socks.SOCKSUDPWrapper;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.i2ptunnel.udp.UDPSink;
import net.i2p.i2ptunnel.udp.UDPSource;

public class SOCKSUDPPort
implements Source,
Sink {
    private final UDPSink udpsink;
    private final UDPSource udpsource;
    private final SOCKSUDPWrapper wrapper;
    private final SOCKSUDPUnwrapper unwrapper;

    public SOCKSUDPPort(InetAddress host, int port, Map<Integer, SOCKSUDPPort> replyMap) {
        ConcurrentHashMap<I2PSocketAddress, SOCKSHeader> cache = new ConcurrentHashMap<I2PSocketAddress, SOCKSHeader>(4);
        this.wrapper = new SOCKSUDPWrapper(cache);
        this.udpsink = new UDPSink(host, port);
        this.wrapper.setSink(this.udpsink);
        DatagramSocket sock = this.udpsink.getSocket();
        this.udpsource = new UDPSource(sock);
        this.unwrapper = new SOCKSUDPUnwrapper(cache);
        this.udpsource.setSink(this.unwrapper);
    }

    public int getPort() {
        return this.udpsink.getPort();
    }

    @Override
    public void setSink(Sink sink) {
        this.unwrapper.setSink(sink);
    }

    @Override
    public void start() {
        this.udpsource.start();
    }

    public void stop() {
        this.udpsink.stop();
        this.udpsource.stop();
    }

    @Override
    public void send(Destination from, int fromPort, int toPort, byte[] data) {
        this.wrapper.send(from, fromPort, toPort, data);
    }
}

