/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.AbstractGoodsLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;

public final class ProductionLabel
extends AbstractGoodsLabel {
    private static final Logger logger = Logger.getLogger(ProductionLabel.class.getName());
    private int maxIcons = 7;
    private boolean drawPlus;
    private final ImageIcon goodsIcon;
    private transient Image stringImage;

    public ProductionLabel(FreeColClient freeColClient, AbstractGoods ag) {
        this(freeColClient, ag, -1);
    }

    public ProductionLabel(FreeColClient freeColClient, AbstractGoods ag, int maximumProduction) {
        this(freeColClient, ag, maximumProduction, 0, false);
    }

    public ProductionLabel(FreeColClient freeColClient, AbstractGoods ag, int maximumProduction, int stockNumber, boolean showStockAmount) {
        super(freeColClient, ag);
        boolean showMax;
        ImageLibrary lib = this.getImageLibrary();
        if (this.getType() == null) {
            FreeCol.trace(logger, "Bad production label (no type)");
        } else if (stockNumber < 0 && this.getAmount() == 0) {
            FreeCol.trace(logger, "Bad production label: " + ag + " stock=" + stockNumber);
        }
        ClientOptions options = freeColClient.getClientOptions();
        GoodsType horses = freeColClient.getGame().getSpecification().getGoodsType("model.goods.horses");
        this.maxIcons = ag.getType() == horses ? 1 : options.getInteger("model.option.guiMaxNumberOfGoodsImages");
        this.goodsIcon = ag.getType() == null ? null : new ImageIcon(lib.getScaledGoodsTypeImage(ag.getType()));
        this.setFont(lib.getScaledFont("simple-bold-tiny", null));
        this.setForeground(this.getAmount() < 0 ? Color.RED : Color.WHITE);
        this.setToolTipText(this.getType() == null || this.getAmount() == 0 ? null : Messages.message(this.getAbstractGoods().getLabel()));
        int amount = this.getAmount();
        int displayNumber = options.getInteger("model.option.guiMinNumberToDisplayGoodsCount");
        boolean bl = showMax = amount > 0 && maximumProduction > amount;
        if (amount < 0 || amount >= displayNumber || amount > this.maxIcons || stockNumber > 0 || showMax) {
            Object number = "";
            if (showStockAmount && stockNumber >= 0) {
                number = String.valueOf(stockNumber);
                this.drawPlus = true;
            }
            if (amount >= 0 && this.drawPlus) {
                number = (String)number + "+";
            }
            number = (String)number + String.valueOf(amount);
            if (showMax) {
                number = (String)number + "/" + maximumProduction;
            }
            BufferedImage dummy = new BufferedImage(1, 1, 2);
            Graphics2D g = dummy.createGraphics();
            this.stringImage = lib.getStringImage(g, (String)number, this.getForeground(), this.getFont());
            g.dispose();
        } else {
            this.stringImage = null;
        }
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void paintComponent(Graphics g) {
        int actualWidth = this.getWidth();
        int drawImageCount = this.numberOfGoodsIconsToDisplay();
        int pixelsPerIcon = this.determinePixelsPerIcon();
        int goodsImagesWidth = pixelsPerIcon * (drawImageCount - 1) + this.goodsIcon.getIconWidth();
        int leftOffset = goodsImagesWidth < actualWidth ? (actualWidth - goodsImagesWidth) / 2 : 0;
        for (int i = 0; i < drawImageCount; ++i) {
            this.goodsIcon.paintIcon(null, g, leftOffset + i * pixelsPerIcon, 0);
        }
        if (this.stringImage != null) {
            int textOffsetX = (actualWidth - this.getProductionStringWidth()) / 2;
            g.drawImage(this.stringImage, textOffsetX, (this.goodsIcon.getIconHeight() - this.stringImage.getHeight(null)) / 2, null);
        }
    }

    public int determinePixelsPerIcon() {
        if (this.goodsIcon == null) {
            return 0;
        }
        int amount = Math.max(1, Math.abs(this.getAmount()));
        if (amount <= this.maxIcons) {
            return this.goodsIcon.getIconWidth() / amount;
        }
        return this.goodsIcon.getIconWidth() / 16;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int drawImageCount = this.numberOfGoodsIconsToDisplay();
        int iconWidth = this.goodsIcon != null ? this.goodsIcon.getIconWidth() : 0;
        int pixelsPerIcon = this.determinePixelsPerIcon();
        int width = Math.max(this.getProductionStringWidth(), pixelsPerIcon * (drawImageCount - 1) + iconWidth);
        int height = this.goodsIcon.getImage().getHeight(null);
        return new Dimension(width, height);
    }

    private int numberOfGoodsIconsToDisplay() {
        return Math.max(1, Math.min(Math.abs(this.getAmount()), this.maxIcons));
    }

    private int getProductionStringWidth() {
        return this.stringImage == null ? 0 : this.stringImage.getWidth(null);
    }
}

