/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.value.StringValue;

final class TinyCommentImpl
extends TinyNodeImpl {
    public TinyCommentImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        int start = this.tree.alpha[this.nodeNr];
        int len = this.tree.beta[this.nodeNr];
        if (len == 0) {
            return EmptyUnicodeString.getInstance();
        }
        return this.tree.commentBuffer.substring(start, start + len);
    }

    @Override
    public AtomicSequence atomize() {
        return new StringValue(this.getUnicodeStringValue());
    }

    @Override
    public int getNodeKind() {
        return 8;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        out.comment(this.getUnicodeStringValue(), locationId, 0);
    }
}

