/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class BaseCmd {
    private String cmdLineSyntax;
    private String cmdName;
    private String desc;
    private String onlineHelp;
    protected Map<String, Option> optMap = new HashMap<String, Option>();
    @Opt(opt="h", longOpt="help", hasArg=false, description="Print this help message")
    private boolean printHelp = false;
    protected String[] remainingArgs;
    protected String[] originalArgs;

    public static String getBaseName(String fn) {
        int x = fn.lastIndexOf(46);
        return x >= 0 ? fn.substring(0, x) : fn;
    }

    public static String getBaseName(Path fn) {
        return BaseCmd.getBaseName(fn.getFileName().toString());
    }

    public static void walkFileTreeX(final Path base, final FileVisitorX fv) throws IOException {
        Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fv.visitFile(file, base.relativize(file).toString());
                return super.visitFile(file, attrs);
            }
        });
    }

    public static void walkJarOrDir(Path in, FileVisitorX fv) throws IOException {
        if (Files.isDirectory(in, new LinkOption[0])) {
            BaseCmd.walkFileTreeX(in, fv);
        } else {
            try (FileSystem inputFileSystem = BaseCmd.openZip(in);){
                BaseCmd.walkFileTreeX(inputFileSystem.getPath("/", new String[0]), fv);
            }
        }
    }

    public static void createParentDirectories(Path p) throws IOException {
        Path parent = p.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static FileSystem createZip(Path output) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        Files.deleteIfExists(output);
        BaseCmd.createParentDirectories(output);
        for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
            String s = p.getScheme();
            if (!"jar".equals(s) && !"zip".equalsIgnoreCase(s)) continue;
            return p.newFileSystem(output, env);
        }
        throw new IOException("cant find zipfs support");
    }

    public static FileSystem openZip(Path in) throws IOException {
        for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
            String s = p.getScheme();
            if (!"jar".equals(s) && !"zip".equalsIgnoreCase(s)) continue;
            return p.newFileSystem(in, new HashMap());
        }
        throw new IOException("cant find zipfs support");
    }

    public BaseCmd() {
    }

    public BaseCmd(String cmdLineSyntax, String header) {
        int i = cmdLineSyntax.indexOf(32);
        if (i > 0) {
            this.cmdName = cmdLineSyntax.substring(0, i);
            this.cmdLineSyntax = cmdLineSyntax.substring(i + 1);
        }
        this.desc = header;
    }

    public BaseCmd(String cmdName, String cmdSyntax, String header) {
        this.cmdName = cmdName;
        this.cmdLineSyntax = cmdSyntax;
        this.desc = header;
    }

    private Set<Option> collectRequiredOptions(Map<String, Option> optMap) {
        HashSet<Option> options = new HashSet<Option>();
        for (Map.Entry<String, Option> e : optMap.entrySet()) {
            Option option = e.getValue();
            if (!option.required) continue;
            options.add(option);
        }
        return options;
    }

    protected Object convert(String value, Class type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.parseDouble(value);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(File.class)) {
            return new File(value);
        }
        if (type.equals(Path.class)) {
            return new File(value).toPath();
        }
        try {
            type.asSubclass(Enum.class);
            return Enum.valueOf(type, value);
        }
        catch (Exception exception) {
            throw new RuntimeException("can't convert [" + value + "] to type " + type);
        }
    }

    protected abstract void doCommandLine() throws Exception;

    public void doMain(String ... args) {
        try {
            this.initOptions();
            this.parseSetArgs(args);
            this.doCommandLine();
        }
        catch (HelpException e) {
            String msg = e.getMessage();
            if (msg != null && msg.length() > 0) {
                System.err.println("ERROR: " + msg);
            }
            this.usage();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected String getVersionString() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    protected void initOptionFromClass(Class<?> clz) {
        Field[] fs;
        if (clz == null) {
            return;
        }
        this.initOptionFromClass(clz.getSuperclass());
        Syntax syntax = clz.getAnnotation(Syntax.class);
        if (syntax != null) {
            this.cmdLineSyntax = syntax.syntax();
            this.cmdName = syntax.cmd();
            this.desc = syntax.desc();
            this.onlineHelp = syntax.onlineHelp();
        }
        for (Field f : fs = clz.getDeclaredFields()) {
            Opt opt = f.getAnnotation(Opt.class);
            if (opt == null) continue;
            f.setAccessible(true);
            Option option = new Option();
            option.field = f;
            option.description = opt.description();
            option.hasArg = opt.hasArg();
            option.required = opt.required();
            if ("".equals(opt.longOpt()) && "".equals(opt.opt())) {
                option.longOpt = BaseCmd.fromCamel(f.getName());
                if (f.getType().equals(Boolean.TYPE)) {
                    option.hasArg = false;
                    try {
                        if (f.getBoolean(this)) {
                            throw new RuntimeException("the value of " + f + " must be false, as it is declared as no args");
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.checkConflict(option, "--" + option.longOpt);
                continue;
            }
            if (!opt.hasArg()) {
                if (!f.getType().equals(Boolean.TYPE)) {
                    throw new RuntimeException("the type of " + f + " must be boolean, as it is declared as no args");
                }
                try {
                    if (f.getBoolean(this)) {
                        throw new RuntimeException("the value of " + f + " must be false, as it is declared as no args");
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            boolean haveLongOpt = false;
            if (!"".equals(opt.longOpt())) {
                option.longOpt = opt.longOpt();
                this.checkConflict(option, "--" + option.longOpt);
                haveLongOpt = true;
            }
            if (!"".equals(opt.argName())) {
                option.argName = opt.argName();
            }
            if (!"".equals(opt.opt())) {
                option.opt = opt.opt();
                this.checkConflict(option, "-" + option.opt);
                continue;
            }
            if (haveLongOpt) continue;
            throw new RuntimeException("opt or longOpt is not set in @Opt(...) " + f);
        }
    }

    private static String fromCamel(String name) {
        if (name.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] charArray = name.toCharArray();
        sb.append(Character.toLowerCase(charArray[0]));
        for (int i = 1; i < charArray.length; ++i) {
            char c = charArray[i];
            if (Character.isUpperCase(c)) {
                sb.append("-").append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void checkConflict(Option option, String key) {
        if (this.optMap.containsKey(key)) {
            Option preOption = this.optMap.get(key);
            throw new RuntimeException(String.format("[@Opt(...) %s] conflict with [@Opt(...) %s]", preOption.field.toString(), option.field));
        }
        this.optMap.put(key, option);
    }

    protected void initOptions() {
        this.initOptionFromClass(this.getClass());
    }

    public static void main(String ... args) throws Exception {
        if (args.length < 1) {
            System.err.println("d2j-run <class> [args]");
            return;
        }
        Class<?> clz = Class.forName(args[0]);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        if (BaseCmd.class.isAssignableFrom(clz)) {
            BaseCmd baseCmd = (BaseCmd)clz.newInstance();
            baseCmd.doMain(newArgs);
        } else {
            Method m = clz.getMethod("main", String[].class);
            m.setAccessible(true);
            m.invoke(null, new Object[]{newArgs});
        }
    }

    protected void parseSetArgs(String ... args) throws IllegalArgumentException, IllegalAccessException {
        this.originalArgs = args;
        ArrayList<String> remainsOptions = new ArrayList<String>();
        Set<Option> requiredOpts = this.collectRequiredOptions(this.optMap);
        Option needArgOpt = null;
        for (String s : args) {
            if (needArgOpt != null) {
                needArgOpt.field.set(this, this.convert(s, needArgOpt.field.getType()));
                needArgOpt = null;
                continue;
            }
            if (s.startsWith("-")) {
                Option opt = this.optMap.get(s);
                requiredOpts.remove(opt);
                if (opt == null) {
                    System.err.println("ERROR: Unrecognized option: " + s);
                    throw new HelpException();
                }
                if (opt.hasArg) {
                    needArgOpt = opt;
                    continue;
                }
                opt.field.set(this, true);
                continue;
            }
            remainsOptions.add(s);
        }
        if (needArgOpt != null) {
            System.err.println("ERROR: Option " + needArgOpt.getOptAndLongOpt() + " need an argument value");
            throw new HelpException();
        }
        this.remainingArgs = remainsOptions.toArray(new String[0]);
        if (this.printHelp) {
            throw new HelpException();
        }
        if (!requiredOpts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Options: ");
            boolean first = true;
            for (Option option : requiredOpts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" and ");
                }
                sb.append(option.getOptAndLongOpt());
            }
            sb.append(" is required");
            System.err.println(sb);
            throw new HelpException();
        }
    }

    protected void usage() {
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8), true);
        int maxLength = 80;
        int maxPaLength = 40;
        out.println(this.cmdName + " -- " + this.desc);
        out.println("usage: " + this.cmdName + " " + this.cmdLineSyntax);
        if (this.optMap.size() > 0) {
            out.println("options:");
        }
        TreeSet<Option> options = new TreeSet<Option>(this.optMap.values());
        int palength = -1;
        for (Option option : options) {
            int pa = 4 + option.getOptAndLongOpt().length();
            if (option.hasArg) {
                pa += 3 + option.argName.length();
            }
            if (pa >= 40 || pa <= palength) continue;
            palength = pa;
        }
        int pblength = 80 - palength;
        StringBuilder sb = new StringBuilder();
        for (Option option : options) {
            int i;
            String desc;
            sb.setLength(0);
            sb.append(" ").append(option.getOptAndLongOpt());
            if (option.hasArg) {
                sb.append(" <").append(option.argName).append(">");
            }
            if ((desc = option.description) == null || desc.length() == 0) {
                out.println(sb);
                continue;
            }
            for (i = palength - sb.length(); i > 0; --i) {
                sb.append(' ');
            }
            if (sb.length() > 40) {
                out.println(sb);
                sb.setLength(0);
                for (i = 0; i < palength; ++i) {
                    sb.append(' ');
                }
            }
            int nextStart = 0;
            while (nextStart < desc.length()) {
                if (desc.length() - nextStart < pblength) {
                    sb.append(desc.substring(nextStart));
                    out.println(sb);
                    nextStart = desc.length();
                    sb.setLength(0);
                    continue;
                }
                sb.append(desc, nextStart, nextStart + pblength);
                out.println(sb);
                sb.setLength(0);
                if ((nextStart += pblength) >= desc.length()) continue;
                for (int i2 = 0; i2 < palength; ++i2) {
                    sb.append(' ');
                }
            }
            if (sb.length() <= 0) continue;
            out.println(sb);
            sb.setLength(0);
        }
        String ver = this.getVersionString();
        if (ver != null && !"".equals(ver)) {
            out.println("version: " + ver);
        }
        if (this.onlineHelp != null && !"".equals(this.onlineHelp)) {
            if (this.onlineHelp.length() + "online help: ".length() > 80) {
                out.println("online help: ");
                out.println(this.onlineHelp);
            } else {
                out.println("online help: " + this.onlineHelp);
            }
        }
        out.flush();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Syntax {
        public String cmd();

        public String desc() default "";

        public String onlineHelp() default "";

        public String syntax() default "";
    }

    protected static class Option
    implements Comparable<Option> {
        public String argName = "arg";
        public String description;
        public Field field;
        public boolean hasArg = true;
        public String longOpt;
        public String opt;
        public boolean required = false;

        protected Option() {
        }

        @Override
        public int compareTo(Option o) {
            int result = Option.s(this.opt, o.opt);
            if (result == 0 && (result = Option.s(this.longOpt, o.longOpt)) == 0 && (result = Option.s(this.argName, o.argName)) == 0) {
                result = Option.s(this.description, o.description);
            }
            return result;
        }

        private static int s(String a, String b) {
            if (a != null && b != null) {
                return a.compareTo(b);
            }
            if (a != null) {
                return 1;
            }
            if (b != null) {
                return -1;
            }
            return 0;
        }

        public String getOptAndLongOpt() {
            StringBuilder sb = new StringBuilder();
            boolean havePrev = false;
            if (this.opt != null && this.opt.length() > 0) {
                sb.append("-").append(this.opt);
                havePrev = true;
            }
            if (this.longOpt != null && this.longOpt.length() > 0) {
                if (havePrev) {
                    sb.append(",");
                }
                sb.append("--").append(this.longOpt);
            }
            return sb.toString();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Opt {
        public String argName() default "";

        public String description() default "";

        public boolean hasArg() default true;

        public String longOpt() default "";

        public String opt() default "";

        public boolean required() default false;
    }

    protected static class HelpException
    extends RuntimeException {
        private static final long serialVersionUID = 5538069795297477488L;

        public HelpException() {
        }

        public HelpException(String message) {
            super(message);
        }
    }

    public static interface FileVisitorX {
        public void visitFile(Path var1, String var2) throws IOException;
    }
}

