/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.event.authorization;

import java.util.EventObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.event.authorization.AbstractAuthorizationEvent;
import org.springframework.security.event.authorization.AuthenticationCredentialsNotFoundEvent;
import org.springframework.security.event.authorization.AuthorizationFailureEvent;
import org.springframework.security.event.authorization.AuthorizedEvent;
import org.springframework.security.event.authorization.PublicInvocationEvent;

public class LoggerListener
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$event$authorization$LoggerListener == null ? (class$org$springframework$security$event$authorization$LoggerListener = LoggerListener.class$("org.springframework.security.event.authorization.LoggerListener")) : class$org$springframework$security$event$authorization$LoggerListener));
    static /* synthetic */ Class class$org$springframework$security$event$authorization$LoggerListener;

    public void onApplicationEvent(ApplicationEvent event) {
        AbstractAuthorizationEvent authEvent;
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            authEvent = (AuthenticationCredentialsNotFoundEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Security interception failed due to: " + (Object)((Object)((AuthenticationCredentialsNotFoundEvent)authEvent).getCredentialsNotFoundException()) + "; secure object: " + ((EventObject)((Object)authEvent)).getSource() + "; configuration attributes: " + ((AuthenticationCredentialsNotFoundEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof AuthorizationFailureEvent) {
            authEvent = (AuthorizationFailureEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Security authorization failed due to: " + (Object)((Object)((AuthorizationFailureEvent)authEvent).getAccessDeniedException()) + "; authenticated principal: " + ((AuthorizationFailureEvent)authEvent).getAuthentication() + "; secure object: " + ((EventObject)((Object)authEvent)).getSource() + "; configuration attributes: " + ((AuthorizationFailureEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof AuthorizedEvent) {
            authEvent = (AuthorizedEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Security authorized for authenticated principal: " + ((AuthorizedEvent)authEvent).getAuthentication() + "; secure object: " + ((EventObject)((Object)authEvent)).getSource() + "; configuration attributes: " + ((AuthorizedEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof PublicInvocationEvent) {
            authEvent = (PublicInvocationEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Security interception not required for public secure object: " + ((EventObject)((Object)authEvent)).getSource()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

