/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.field.RtfAnchor;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.table.RtfTable;
import com.lowagie.text.rtf.text.RtfAnnotation;
import com.lowagie.text.rtf.text.RtfChapter;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfNewPage;
import com.lowagie.text.rtf.text.RtfParagraph;
import com.lowagie.text.rtf.text.RtfPhrase;
import com.lowagie.text.rtf.text.RtfSection;

public class RtfMapper {
    RtfDocument rtfDoc;

    public RtfMapper(RtfDocument rtfDocument) {
        this.rtfDoc = rtfDocument;
    }

    public RtfBasicElement mapElement(Element element) throws DocumentException {
        RtfBasicElement rtfBasicElement = null;
        if (element instanceof RtfBasicElement) {
            rtfBasicElement = (RtfBasicElement)((Object)element);
            rtfBasicElement.setRtfDocument(this.rtfDoc);
            return rtfBasicElement;
        }
        switch (element.type()) {
            case 10: {
                if (((Chunk)element).getImage() != null) {
                    rtfBasicElement = new RtfImage(this.rtfDoc, ((Chunk)element).getImage());
                    break;
                }
                if (((Chunk)element).hasAttributes() && ((Chunk)element).getAttributes().containsKey("NEWPAGE")) {
                    rtfBasicElement = new RtfNewPage(this.rtfDoc);
                    break;
                }
                rtfBasicElement = new RtfChunk(this.rtfDoc, (Chunk)element);
                break;
            }
            case 11: {
                rtfBasicElement = new RtfPhrase(this.rtfDoc, (Phrase)element);
                break;
            }
            case 12: {
                rtfBasicElement = new RtfParagraph(this.rtfDoc, (Paragraph)element);
                break;
            }
            case 17: {
                rtfBasicElement = new RtfAnchor(this.rtfDoc, (Anchor)element);
                break;
            }
            case 29: {
                rtfBasicElement = new RtfAnnotation(this.rtfDoc, (Annotation)element);
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                rtfBasicElement = new RtfImage(this.rtfDoc, (Image)element);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                rtfBasicElement = new RtfInfoElement(this.rtfDoc, (Meta)element);
                break;
            }
            case 14: {
                rtfBasicElement = new RtfList(this.rtfDoc, (List)element);
                break;
            }
            case 15: {
                rtfBasicElement = new RtfListItem(this.rtfDoc, (ListItem)element);
                break;
            }
            case 13: {
                rtfBasicElement = new RtfSection(this.rtfDoc, (Section)element);
                break;
            }
            case 16: {
                rtfBasicElement = new RtfChapter(this.rtfDoc, (Chapter)element);
                break;
            }
            case 22: {
                try {
                    rtfBasicElement = new RtfTable(this.rtfDoc, (Table)element);
                    break;
                }
                catch (ClassCastException classCastException) {
                    rtfBasicElement = new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable());
                }
            }
        }
        return rtfBasicElement;
    }
}

