/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

class CustomPageTableModel
extends AbstractMultipleOptionsTableModel<CustomPage> {
    private static final long serialVersionUID = 4463944219657112162L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("custompages.table.header.enabled"), Constant.messages.getString("custompages.table.header.content"), Constant.messages.getString("custompages.table.header.contentlocation"), Constant.messages.getString("custompages.table.header.isregex"), Constant.messages.getString("custompages.table.header.type")};
    private List<CustomPage> customPages = new ArrayList<CustomPage>();

    public CustomPageTableModel(List<CustomPage> customPages) {
        this.customPages = new ArrayList<CustomPage>(customPages);
    }

    public CustomPageTableModel() {
        this.customPages = new ArrayList<CustomPage>();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.customPages.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CustomPage cp = this.customPages.get(rowIndex);
        if (cp == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return cp.isEnabled();
            }
            case 1: {
                return cp.getPageMatcher();
            }
            case 2: {
                return cp.getPageMatcherLocation().getName();
            }
            case 3: {
                return cp.isRegex();
            }
            case 4: {
                return cp.getType().getName();
            }
        }
        return null;
    }

    @Override
    public List<CustomPage> getElements() {
        return this.getCustomPages();
    }

    public List<CustomPage> getCustomPages() {
        return this.customPages;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setCustomPages(List<CustomPage> list) {
        this.customPages = new ArrayList<CustomPage>(list);
        this.fireTableDataChanged();
    }

    public void removeAllCustomPages() {
        this.customPages = new ArrayList<CustomPage>();
        this.fireTableDataChanged();
    }

    public void addCustomPage(CustomPage cp) {
        this.customPages.add(cp);
        this.fireTableRowsInserted(this.customPages.size() - 1, this.customPages.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(aValue instanceof Boolean)) {
            return;
        }
        if (columnIndex == 0) {
            this.customPages.get(rowIndex).setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 3) {
            this.customPages.get(rowIndex).setRegex((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

