/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.utils.JsonUtil;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiResponseSet<T>
extends ApiResponse {
    private Map<String, T> values = null;

    public ApiResponseSet(String name, Map<String, T> values) {
        super(name);
        this.values = values;
    }

    public void put(String key, T value) {
        this.values.put(key, value);
    }

    @Override
    public JSON toJSON() {
        if (this.values == null) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (Map.Entry<String, T> val : this.values.entrySet()) {
            T value = val.getValue();
            if (value instanceof String) {
                jo.put((Object)val.getKey(), (Object)JsonUtil.getJsonFriendlyString((String)value));
                continue;
            }
            jo.put((Object)val.getKey(), value);
        }
        return jo;
    }

    @Override
    public void toXML(Document doc, Element parent) {
        parent.setAttribute("type", "set");
        for (Map.Entry<String, T> val : this.values.entrySet()) {
            Element el = doc.createElement(val.getKey());
            String textValue = val.getValue() == null ? "" : val.getValue().toString();
            Text text = doc.createTextNode(XMLStringUtil.escapeControlChrs(textValue));
            el.appendChild(text);
            parent.appendChild(el);
        }
    }

    @Override
    public void toHTML(StringBuilder sb) {
        sb.append("<h2>" + StringEscapeUtils.escapeHtml4((String)this.getName()) + "</h2>\n");
        sb.append("<table border=\"1\">\n");
        for (Map.Entry<String, T> val : this.values.entrySet()) {
            sb.append("<tr><td>\n");
            sb.append(StringEscapeUtils.escapeHtml4((String)val.getKey()));
            sb.append("</td><td>\n");
            T value = val.getValue();
            if (value != null) {
                sb.append(StringEscapeUtils.escapeHtml4((String)value.toString()));
            }
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseSet ");
        sb.append(this.getName());
        sb.append(" : [\n");
        for (Map.Entry<String, T> val : this.values.entrySet()) {
            for (int i = 0; i < indent + 1; ++i) {
                sb.append("\t");
            }
            sb.append(val.getKey());
            sb.append(" = ");
            sb.append(val.getValue());
            sb.append("\n");
        }
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("]\n");
        return sb.toString();
    }

    protected Map<String, T> getValues() {
        return this.values;
    }
}

