/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class JFRSnapshotConfigurator
extends JPanel {
    private boolean internalChange = false;
    private static JFRSnapshotConfigurator defaultInstance;
    private JLabel jfrSnapshotFileLabel;
    private JTextField jfrSnapshotFileField;
    private JButton jfrSnapshotFileButton;
    private JCheckBox displaynameCheckbox;
    private JTextField displaynameField;
    private JCheckBox deleteSourceCheckbox;
    private JButton okButton;

    public static JFRSnapshotConfigurator defineJFRSnapshot() {
        JFRSnapshotConfigurator hc = JFRSnapshotConfigurator.getDefault();
        hc.setupDefineJFRSnapshot();
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"Title_Add_VM_Coredump"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            return hc;
        }
        return null;
    }

    public String getJFRSnapshotFile() {
        return this.jfrSnapshotFileField.getText().trim();
    }

    public String getDisplayname() {
        return this.displaynameField.getText().trim();
    }

    public boolean deleteSourceFile() {
        return this.deleteSourceCheckbox.isSelected();
    }

    private JFRSnapshotConfigurator() {
        this.initComponents();
        this.update();
    }

    private static JFRSnapshotConfigurator getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new JFRSnapshotConfigurator();
        }
        return defaultInstance;
    }

    private void setupDefineJFRSnapshot() {
        this.jfrSnapshotFileField.setEnabled(true);
        this.displaynameCheckbox.setSelected(false);
        this.displaynameCheckbox.setEnabled(true);
        this.jfrSnapshotFileField.setText("");
        this.displaynameField.setText("");
        this.deleteSourceCheckbox.setSelected(false);
    }

    private void update() {
        if (this.internalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String jfrSnapshotName = JFRSnapshotConfigurator.this.getJFRSnapshotFile();
                File jfrSnapshotFile = new File(jfrSnapshotName);
                if (!JFRSnapshotConfigurator.this.displaynameCheckbox.isSelected()) {
                    JFRSnapshotConfigurator.this.internalChange = true;
                    File file = new File(jfrSnapshotName);
                    if (file.isFile()) {
                        JFRSnapshotConfigurator.this.displaynameField.setText(file.getName());
                    }
                    JFRSnapshotConfigurator.this.internalChange = false;
                }
                String displayname = JFRSnapshotConfigurator.this.getDisplayname();
                JFRSnapshotConfigurator.this.displaynameField.setEnabled(JFRSnapshotConfigurator.this.displaynameCheckbox.isSelected());
                JFRSnapshotConfigurator.this.okButton.setEnabled(jfrSnapshotFile.exists() && jfrSnapshotFile.isFile() && !displayname.isEmpty());
            }
        });
    }

    private void chooseJFRSnapshot() {
        JFileChooser chooser = new JFileChooser(new File(this.getJFRSnapshotFile()));
        chooser.setDialogTitle(NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"LBL_Select_VM_Coredump"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(JFRSnapshotSupport.getCategory().getFileFilter());
        int returnVal = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (returnVal == 0) {
            this.jfrSnapshotFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.jfrSnapshotFileLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jfrSnapshotFileLabel, (String)NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"LBL_VM_Coredump_file"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.jfrSnapshotFileLabel, constraints);
        this.jfrSnapshotFileField = new JTextField();
        this.jfrSnapshotFileLabel.setLabelFor(this.jfrSnapshotFileField);
        this.jfrSnapshotFileField.setPreferredSize(new Dimension(220, this.jfrSnapshotFileField.getPreferredSize().height));
        this.jfrSnapshotFileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JFRSnapshotConfigurator.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JFRSnapshotConfigurator.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JFRSnapshotConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.jfrSnapshotFileField, constraints);
        this.jfrSnapshotFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.jfrSnapshotFileButton, (String)NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"LBL_Browse"));
        this.jfrSnapshotFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFRSnapshotConfigurator.this.chooseJFRSnapshot();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.jfrSnapshotFileButton, constraints);
        this.displaynameCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"LBL_Display_name"));
        this.displaynameCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFRSnapshotConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.displaynameCheckbox, constraints);
        this.displaynameField = new JTextField();
        this.displaynameField.setPreferredSize(new Dimension(220, this.displaynameField.getPreferredSize().height));
        this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JFRSnapshotConfigurator.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JFRSnapshotConfigurator.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JFRSnapshotConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.displaynameField, constraints);
        this.deleteSourceCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteSourceCheckbox, (String)NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"LBL_Delete_source_file"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(18, 10, 0, 0);
        this.add((Component)this.deleteSourceCheckbox, constraints);
        JPanel spacer = new JPanel(null);
        spacer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)spacer, constraints);
        this.okButton = new JButton(NbBundle.getMessage(JFRSnapshotConfigurator.class, (String)"LBL_OK"));
        this.displaynameCheckbox.setBorder(this.jfrSnapshotFileLabel.getBorder());
        this.deleteSourceCheckbox.setBorder(this.jfrSnapshotFileLabel.getBorder());
    }
}

