/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Maintenance;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class MaintenanceEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public MaintenanceEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void onPosition(Position position, BaseEventHandler.Callback callback) {
        Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
        if (lastPosition == null || position.getFixTime().compareTo(lastPosition.getFixTime()) < 0) {
            return;
        }
        for (Maintenance maintenance : this.cacheManager.getDeviceObjects(position.getDeviceId(), Maintenance.class)) {
            if (maintenance.getPeriod() == 0.0) continue;
            double oldValue = this.getValue(lastPosition, maintenance.getType());
            double newValue = this.getValue(position, maintenance.getType());
            if (oldValue == 0.0 || newValue == 0.0 || !(newValue >= maintenance.getStart()) || !(oldValue < maintenance.getStart()) && (long)((oldValue - maintenance.getStart()) / maintenance.getPeriod()) >= (long)((newValue - maintenance.getStart()) / maintenance.getPeriod())) continue;
            Event event = new Event("maintenance", position);
            event.setMaintenanceId(maintenance.getId());
            event.set(maintenance.getType(), newValue);
            callback.eventDetected(event);
        }
    }

    private double getValue(Position position, String type) {
        return switch (type) {
            case "serverTime" -> position.getServerTime().getTime();
            case "deviceTime" -> position.getDeviceTime().getTime();
            case "fixTime" -> position.getFixTime().getTime();
            default -> position.getDouble(type);
        };
    }
}

