/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Unsafe;
import com.intellij.util.containers.VarHandleWrapper;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Obsolete
@ApiStatus.Internal
class VarHandleWrapperUnsafe
extends VarHandleWrapper
implements VarHandleWrapper.VarHandleWrapperFactory {
    private final long OFFSET;
    private final int ABASE;
    private final int ASHIFT;

    private VarHandleWrapperUnsafe(long OFFSET) {
        this.OFFSET = OFFSET;
        this.ABASE = -1;
        this.ASHIFT = -1;
    }

    private VarHandleWrapperUnsafe(int ABASE, int ASHIFT) {
        this.ABASE = ABASE;
        this.ASHIFT = ASHIFT;
        this.OFFSET = -1L;
    }

    @Override
    @NotNull
    public VarHandleWrapper create(@NotNull Class<?> containingClass, @NotNull String name, @NotNull Class<?> type) {
        if (containingClass == null) {
            VarHandleWrapperUnsafe.$$$reportNull$$$0(0);
        }
        if (name == null) {
            VarHandleWrapperUnsafe.$$$reportNull$$$0(1);
        }
        if (type == null) {
            VarHandleWrapperUnsafe.$$$reportNull$$$0(2);
        }
        try {
            Field field = containingClass.getDeclaredField(name);
            long offset = Unsafe.objectFieldOffset(field);
            return new VarHandleWrapperUnsafe(offset);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VarHandleWrapper createForArrayElement(@NotNull Class<?> arrayClass) {
        if (arrayClass == null) {
            VarHandleWrapperUnsafe.$$$reportNull$$$0(3);
        }
        assert (arrayClass.isArray());
        int ABASE = Unsafe.arrayBaseOffset(arrayClass);
        int scale = Unsafe.arrayIndexScale(arrayClass);
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        int ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        return new VarHandleWrapperUnsafe(ABASE, ASHIFT);
    }

    @Override
    public boolean compareAndSet(Object thisObject, Object expected, Object actual) {
        assert (this.ASHIFT == -1);
        return Unsafe.compareAndSwapObject(thisObject, this.OFFSET, expected, actual);
    }

    @Override
    public boolean compareAndSetByte(Object thisObject, byte expected, byte actual) {
        int next;
        int cur;
        assert (this.ASHIFT == -1);
        long intWordOffset = this.OFFSET & 0xFFFFFFFFFFFFFFFCL;
        int byteIndex = (int)(this.OFFSET & 3L);
        int shift = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (3 - byteIndex) * 8 : byteIndex * 8;
        int mask = 255 << shift;
        int expBits = (expected & 0xFF) << shift;
        int updBits = (actual & 0xFF) << shift;
        do {
            if (((cur = Unsafe.getIntVolatile(thisObject, intWordOffset)) & mask) == expBits) continue;
            return false;
        } while (!Unsafe.compareAndSwapInt(thisObject, intWordOffset, cur, next = cur & ~mask | updBits));
        return true;
    }

    @Override
    public boolean compareAndSetInt(Object thisObject, int expected, int actual) {
        assert (this.ASHIFT == -1);
        return Unsafe.compareAndSwapInt(thisObject, this.OFFSET, expected, actual);
    }

    @Override
    public boolean compareAndSetLong(Object thisObject, long expected, long actual) {
        assert (this.ASHIFT == -1);
        return Unsafe.compareAndSwapLong(thisObject, this.OFFSET, expected, actual);
    }

    @Override
    public int getAndAdd(Object thisObject, int value) {
        return Unsafe.getAndAddInt(thisObject, this.OFFSET, value);
    }

    @Override
    public Object getVolatileArrayElement(Object thisObject, int index) {
        assert (this.OFFSET == -1L);
        return Unsafe.getObjectVolatile(thisObject, ((long)index << this.ASHIFT) + (long)this.ABASE);
    }

    @Override
    public void setVolatileArrayElement(Object thisObject, int index, Object value) {
        assert (this.OFFSET == -1L);
        Unsafe.putObjectVolatile(thisObject, ((long)index << this.ASHIFT) + (long)this.ABASE, value);
    }

    @Override
    public boolean compareAndSetArrayElement(Object thisObject, int index, Object expected, Object value) {
        assert (this.OFFSET == -1L);
        return Unsafe.compareAndSwapObject(thisObject, ((long)index << this.ASHIFT) + (long)this.ABASE, expected, value);
    }

    static void useUnsafeInConcurrentCollections() {
        FACTORY = new VarHandleWrapperUnsafe(-1L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/VarHandleWrapperUnsafe";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createForArrayElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

