/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.extension.JsonAnnotationsCollectionMode;
import org.jetbrains.annotations.NotNull;

public final class JsonComplianceCheckerOptions {
    public static final JsonComplianceCheckerOptions RELAX_ENUM_CHECK = new JsonComplianceCheckerOptions(true, false);
    private final boolean isCaseInsensitiveEnumCheck;
    private final boolean isForceStrict;
    private final boolean isReportMissingOptionalProperties;
    private final JsonAnnotationsCollectionMode errorsCollectionMode;

    public JsonComplianceCheckerOptions(boolean caseInsensitiveEnumCheck) {
        this(caseInsensitiveEnumCheck, false);
    }

    private JsonComplianceCheckerOptions(boolean caseInsensitiveEnumCheck, boolean forceStrict) {
        this(caseInsensitiveEnumCheck, forceStrict, false);
    }

    public JsonComplianceCheckerOptions(boolean isCaseInsensitiveEnumCheck, boolean isForceStrict, boolean isReportMissingOptionalProperties) {
        this(isCaseInsensitiveEnumCheck, isForceStrict, isReportMissingOptionalProperties, JsonAnnotationsCollectionMode.FIND_ALL);
    }

    public JsonComplianceCheckerOptions(boolean isCaseInsensitiveEnumCheck, boolean isForceStrict, boolean isReportMissingOptionalProperties, @NotNull JsonAnnotationsCollectionMode errorsCollectionMode) {
        if (errorsCollectionMode == null) {
            JsonComplianceCheckerOptions.$$$reportNull$$$0(0);
        }
        this.errorsCollectionMode = errorsCollectionMode;
        this.isCaseInsensitiveEnumCheck = isCaseInsensitiveEnumCheck;
        this.isForceStrict = isForceStrict;
        this.isReportMissingOptionalProperties = isReportMissingOptionalProperties;
    }

    public JsonComplianceCheckerOptions withForcedStrict() {
        return new JsonComplianceCheckerOptions(this.isCaseInsensitiveEnumCheck, true);
    }

    public boolean isCaseInsensitiveEnumCheck() {
        return this.isCaseInsensitiveEnumCheck;
    }

    public boolean isForceStrict() {
        return this.isForceStrict;
    }

    public boolean isReportMissingOptionalProperties() {
        return this.isReportMissingOptionalProperties;
    }

    public boolean shouldStopValidationAfterAnyErrorFound() {
        return JsonAnnotationsCollectionMode.FIND_FIRST.equals((Object)this.errorsCollectionMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsCollectionMode", "com/jetbrains/jsonSchema/impl/JsonComplianceCheckerOptions", "<init>"));
    }
}

