/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.core.typeahead;

import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalTypeAheadManager {
    public static final long MAX_TERMINAL_DELAY = TimeUnit.MILLISECONDS.toNanos(1500L);
    private static final int LATENCY_MIN_SAMPLES_TO_TURN_ON = 2;
    private static final double LATENCY_TOGGLE_OFF_THRESHOLD = 0.5;
    private static final Logger LOG = LoggerFactory.getLogger(TerminalTypeAheadManager.class);
    private final TypeAheadTerminalModel myTerminalModel;
    @Nullable
    private Debouncer myClearPredictionsDebouncer;
    private final List<TypeAheadPrediction> myPredictions = new ArrayList<TypeAheadPrediction>();
    private final LatencyStatistics myLatencyStatistics = new LatencyStatistics();
    private boolean myIsShowingPredictions = false;
    private volatile boolean myOutOfSyncDetected = false;
    private long myLastTypedTime;
    private Integer myLeftMostCursorPosition = null;
    private boolean myIsNotPasswordPrompt = false;
    @Nullable
    private TypeAheadPrediction myLastSuccessfulPrediction = null;

    public TerminalTypeAheadManager(@NotNull TypeAheadTerminalModel terminalModel) {
        this.myTerminalModel = terminalModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminalStateChanged() {
        if (!this.myTerminalModel.isTypeAheadEnabled() || this.myOutOfSyncDetected) {
            return;
        }
        this.myTerminalModel.lock();
        try {
            if (this.myTerminalModel.isUsingAlternateBuffer()) {
                this.resetState();
                return;
            }
            TypeAheadTerminalModel.LineWithCursorX lineWithCursorX = this.myTerminalModel.getCurrentLineWithCursor();
            if (!this.myPredictions.isEmpty()) {
                this.updateLeftMostCursorPosition(lineWithCursorX.myCursorX);
                if (this.myClearPredictionsDebouncer != null) {
                    this.myClearPredictionsDebouncer.call();
                }
            }
            if (this.myLastSuccessfulPrediction != null && lineWithCursorX.equals(this.myLastSuccessfulPrediction.myPredictedLineWithCursorX)) {
                return;
            }
            ArrayList<TypeAheadPrediction> removedPredictions = new ArrayList<TypeAheadPrediction>();
            while (!this.myPredictions.isEmpty() && !lineWithCursorX.equals(this.myPredictions.get((int)0).myPredictedLineWithCursorX)) {
                removedPredictions.add(this.myPredictions.remove(0));
            }
            if (this.myPredictions.isEmpty()) {
                this.myOutOfSyncDetected = true;
                this.resetState();
            } else {
                this.myLastSuccessfulPrediction = this.myPredictions.remove(0);
                removedPredictions.add(this.myLastSuccessfulPrediction);
                for (TypeAheadPrediction prediction : removedPredictions) {
                    this.myLatencyStatistics.adjustLatency(prediction);
                    if (!(prediction instanceof CharacterPrediction)) continue;
                    this.myIsNotPasswordPrompt = true;
                }
                this.applyPredictions();
            }
        }
        finally {
            this.myTerminalModel.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyEvent(@NotNull TypeAheadEvent keyEvent) {
        if (!this.myTerminalModel.isTypeAheadEnabled()) {
            return;
        }
        this.myTerminalModel.lock();
        try {
            boolean hasTypedRecently;
            if (this.myTerminalModel.isUsingAlternateBuffer()) {
                this.resetState();
                return;
            }
            TypeAheadTerminalModel.LineWithCursorX lineWithCursorX = this.myTerminalModel.getCurrentLineWithCursor();
            long prevTypedTime = this.myLastTypedTime;
            this.myLastTypedTime = System.nanoTime();
            long autoSyncDelay = this.myLatencyStatistics.getSampleSize() >= 2 ? Math.min(this.myLatencyStatistics.getMaxLatency(), MAX_TERMINAL_DELAY) : MAX_TERMINAL_DELAY;
            boolean bl = hasTypedRecently = System.nanoTime() - prevTypedTime < autoSyncDelay;
            if (hasTypedRecently) {
                if (this.myOutOfSyncDetected) {
                    return;
                }
            } else {
                this.myOutOfSyncDetected = false;
            }
            this.reevaluatePredictorState(hasTypedRecently);
            this.updateLeftMostCursorPosition(lineWithCursorX.myCursorX);
            if (this.myPredictions.isEmpty() && this.myClearPredictionsDebouncer != null) {
                this.myClearPredictionsDebouncer.call();
            }
            TypeAheadPrediction prediction = this.createPrediction(lineWithCursorX, keyEvent);
            this.myPredictions.add(prediction);
            this.applyPredictions();
            LOG.debug("Created " + String.valueOf((Object)keyEvent.myEventType) + " prediction");
        }
        finally {
            this.myTerminalModel.unlock();
        }
    }

    public void onResize() {
        if (!this.myTerminalModel.isTypeAheadEnabled()) {
            return;
        }
        this.myTerminalModel.lock();
        try {
            this.resetState();
        }
        finally {
            this.myTerminalModel.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCursorX() {
        this.myTerminalModel.lock();
        try {
            List<TypeAheadPrediction> predictions;
            if (this.myTerminalModel.isUsingAlternateBuffer() && !this.myPredictions.isEmpty()) {
                this.resetState();
            }
            int cursorX = (predictions = this.getVisiblePredictions()).isEmpty() ? this.myTerminalModel.getCurrentLineWithCursor().myCursorX : predictions.get((int)(predictions.size() - 1)).myPredictedLineWithCursorX.myCursorX;
            int n = cursorX + 1;
            return n;
        }
        finally {
            this.myTerminalModel.unlock();
        }
    }

    public void debounce() {
        this.myTerminalModel.lock();
        try {
            if (!this.myPredictions.isEmpty()) {
                LOG.debug("Debounce");
                this.resetState();
            }
        }
        finally {
            this.myTerminalModel.unlock();
        }
    }

    public void setClearPredictionsDebouncer(@NotNull Debouncer clearPredictionsDebouncer) {
        this.myClearPredictionsDebouncer = clearPredictionsDebouncer;
    }

    @Nullable
    private TypeAheadPrediction getLastPrediction() {
        return this.myPredictions.isEmpty() ? null : this.myPredictions.get(this.myPredictions.size() - 1);
    }

    @NotNull
    private @NotNull List<@NotNull TypeAheadPrediction> getVisiblePredictions() {
        int lastVisiblePredictionIndex;
        for (lastVisiblePredictionIndex = 0; lastVisiblePredictionIndex < this.myPredictions.size() && this.myPredictions.get((int)lastVisiblePredictionIndex).myIsNotTentative; ++lastVisiblePredictionIndex) {
        }
        return --lastVisiblePredictionIndex >= 0 ? this.myPredictions.subList(0, lastVisiblePredictionIndex + 1) : Collections.emptyList();
    }

    private void updateLeftMostCursorPosition(int cursorX) {
        this.myLeftMostCursorPosition = this.myLeftMostCursorPosition == null ? Integer.valueOf(cursorX) : Integer.valueOf(Math.min(this.myLeftMostCursorPosition, cursorX));
    }

    private void resetState() {
        this.myTerminalModel.clearPredictions();
        this.myPredictions.clear();
        this.myLeftMostCursorPosition = null;
        this.myLastSuccessfulPrediction = null;
        this.myIsNotPasswordPrompt = false;
        if (this.myClearPredictionsDebouncer != null) {
            this.myClearPredictionsDebouncer.terminateCall();
        }
    }

    private void reevaluatePredictorState(boolean hasTypedRecently) {
        if (!this.myTerminalModel.isTypeAheadEnabled()) {
            this.myIsShowingPredictions = false;
        } else if (this.myLatencyStatistics.getSampleSize() >= 2) {
            long latency = this.myLatencyStatistics.getLatencyMedian();
            if (latency >= this.myTerminalModel.getLatencyThreshold()) {
                this.myIsShowingPredictions = true;
            } else if ((double)latency < (double)this.myTerminalModel.getLatencyThreshold() * 0.5 && !hasTypedRecently) {
                this.myIsShowingPredictions = false;
            }
        }
    }

    private void applyPredictions() {
        List<TypeAheadPrediction> predictions = this.getVisiblePredictions();
        this.myTerminalModel.clearPredictions();
        for (TypeAheadPrediction prediction : predictions) {
            int predictedCursorX = prediction.myPredictedLineWithCursorX.myCursorX;
            if (prediction instanceof CharacterPrediction) {
                this.myTerminalModel.insertCharacter(((CharacterPrediction)prediction).myCharacter, predictedCursorX - 1);
                this.myTerminalModel.moveCursor(predictedCursorX);
                continue;
            }
            if (prediction instanceof BackspacePrediction) {
                this.myTerminalModel.moveCursor(predictedCursorX);
                this.myTerminalModel.removeCharacters(predictedCursorX, ((BackspacePrediction)prediction).myAmount);
                continue;
            }
            if (prediction instanceof CursorMovePrediction) {
                this.myTerminalModel.moveCursor(predictedCursorX);
                continue;
            }
            if (prediction instanceof DeletePrediction) {
                this.myTerminalModel.removeCharacters(predictedCursorX, 1);
                continue;
            }
            throw new IllegalStateException("Unsupported prediction type");
        }
        this.myTerminalModel.forceRedraw();
    }

    @NotNull
    private TypeAheadPrediction createPrediction(@NotNull TypeAheadTerminalModel.LineWithCursorX initialLineWithCursorX, @NotNull TypeAheadEvent keyEvent) {
        if (this.getLastPrediction() instanceof HardBoundary) {
            return new HardBoundary();
        }
        TypeAheadPrediction lastPrediction = this.getLastPrediction();
        TypeAheadTerminalModel.LineWithCursorX newLineWCursorX = lastPrediction != null ? lastPrediction.myPredictedLineWithCursorX.copy() : initialLineWithCursorX.copy();
        switch (keyEvent.myEventType) {
            case Character: {
                if (newLineWCursorX.myCursorX >= this.myTerminalModel.getTerminalWidth()) {
                    return new HardBoundary();
                }
                boolean hasCharacterPredictions = this.myPredictions.stream().anyMatch(prediction -> prediction instanceof CharacterPrediction);
                Character ch = keyEvent.getCharacterOrNull();
                if (ch == null) {
                    throw new IllegalStateException("KeyEvent type is Character but keyEvent.myCharacter == null");
                }
                if (newLineWCursorX.myLineText.length() < newLineWCursorX.myCursorX) {
                    newLineWCursorX.myLineText.append(" ".repeat(newLineWCursorX.myCursorX - newLineWCursorX.myLineText.length()));
                }
                newLineWCursorX.myLineText.insert(newLineWCursorX.myCursorX, ch);
                ++newLineWCursorX.myCursorX;
                if (newLineWCursorX.myLineText.length() > this.myTerminalModel.getTerminalWidth()) {
                    newLineWCursorX.myLineText.delete(this.myTerminalModel.getTerminalWidth(), newLineWCursorX.myLineText.length());
                }
                return new CharacterPrediction(newLineWCursorX, ch.charValue(), (this.myIsNotPasswordPrompt || hasCharacterPredictions) && this.myIsShowingPredictions);
            }
            case Backspace: {
                if (newLineWCursorX.myCursorX == 0) {
                    return new HardBoundary();
                }
                --newLineWCursorX.myCursorX;
                if (newLineWCursorX.myCursorX < newLineWCursorX.myLineText.length()) {
                    newLineWCursorX.myLineText.deleteCharAt(newLineWCursorX.myCursorX);
                }
                return new BackspacePrediction(newLineWCursorX, 1, this.myLeftMostCursorPosition != null && this.myLeftMostCursorPosition <= newLineWCursorX.myCursorX && this.myIsShowingPredictions);
            }
            case AltBackspace: {
                int oldCursorX = newLineWCursorX.myCursorX;
                newLineWCursorX.moveToWordBoundary(false, this.myTerminalModel.getShellType());
                if (newLineWCursorX.myCursorX < 0) {
                    return new HardBoundary();
                }
                int amount = oldCursorX - newLineWCursorX.myCursorX;
                if (newLineWCursorX.myCursorX < newLineWCursorX.myLineText.length()) {
                    newLineWCursorX.myLineText.delete(newLineWCursorX.myCursorX, Math.min(oldCursorX, newLineWCursorX.myLineText.length()));
                }
                return new BackspacePrediction(newLineWCursorX, amount, this.myLeftMostCursorPosition != null && this.myLeftMostCursorPosition <= newLineWCursorX.myCursorX && this.myIsShowingPredictions);
            }
            case LeftArrow: 
            case RightArrow: {
                int amount = keyEvent.myEventType == TypeAheadEvent.EventType.RightArrow ? 1 : -1;
                newLineWCursorX.myCursorX += amount;
                if (newLineWCursorX.myCursorX < 0 || newLineWCursorX.myCursorX >= Math.max(newLineWCursorX.myLineText.length() + 1, this.myTerminalModel.getTerminalWidth())) {
                    return new HardBoundary();
                }
                return new CursorMovePrediction(newLineWCursorX, amount, this.myLeftMostCursorPosition != null && this.myLeftMostCursorPosition <= newLineWCursorX.myCursorX && newLineWCursorX.myCursorX <= newLineWCursorX.myLineText.length() && this.myIsShowingPredictions);
            }
            case AltLeftArrow: 
            case AltRightArrow: {
                int oldCursorX = newLineWCursorX.myCursorX;
                newLineWCursorX.moveToWordBoundary(keyEvent.myEventType == TypeAheadEvent.EventType.AltRightArrow, this.myTerminalModel.getShellType());
                if (newLineWCursorX.myCursorX < 0 || newLineWCursorX.myCursorX >= Math.max(newLineWCursorX.myLineText.length() + 1, this.myTerminalModel.getTerminalWidth())) {
                    return new HardBoundary();
                }
                int amount = newLineWCursorX.myCursorX - oldCursorX;
                return new CursorMovePrediction(newLineWCursorX, amount, this.myLeftMostCursorPosition != null && this.myLeftMostCursorPosition <= newLineWCursorX.myCursorX && newLineWCursorX.myCursorX <= newLineWCursorX.myLineText.length() && this.myIsShowingPredictions);
            }
            case Delete: {
                if (newLineWCursorX.myCursorX < newLineWCursorX.myLineText.length()) {
                    newLineWCursorX.myLineText.deleteCharAt(newLineWCursorX.myCursorX);
                }
                return new DeletePrediction(newLineWCursorX, this.myIsShowingPredictions);
            }
            case Home: {
                int amount = this.myLeftMostCursorPosition - newLineWCursorX.myCursorX;
                newLineWCursorX.myCursorX = this.myLeftMostCursorPosition;
                return new CursorMovePrediction(newLineWCursorX, amount, this.myIsShowingPredictions);
            }
            case End: {
                int newCursorPosition = newLineWCursorX.myLineText.length();
                if (newCursorPosition == this.myTerminalModel.getTerminalWidth()) {
                    --newCursorPosition;
                }
                int amount = newCursorPosition - newLineWCursorX.myCursorX;
                newLineWCursorX.myCursorX = newLineWCursorX.myLineText.length();
                return new CursorMovePrediction(newLineWCursorX, amount, this.myIsShowingPredictions);
            }
            case Unknown: {
                return new HardBoundary();
            }
        }
        throw new IllegalStateException("Unprocessed TypeAheadKeyboardEvent type");
    }

    private static class CursorMovePrediction
    extends TypeAheadPrediction {
        public final int myAmount;

        public CursorMovePrediction(TypeAheadTerminalModel.LineWithCursorX predictedLineWithCursorX, int amount, boolean isNotTentative) {
            super(predictedLineWithCursorX, isNotTentative);
            this.myAmount = amount;
        }
    }

    private static class DeletePrediction
    extends TypeAheadPrediction {
        public DeletePrediction(TypeAheadTerminalModel.LineWithCursorX predictedLineWithCursorX, boolean isNotTentative) {
            super(predictedLineWithCursorX, isNotTentative);
        }
    }

    private static class BackspacePrediction
    extends TypeAheadPrediction {
        public final int myAmount;

        public BackspacePrediction(TypeAheadTerminalModel.LineWithCursorX predictedLineWithCursorX, int amount, boolean isNotTentative) {
            super(predictedLineWithCursorX, isNotTentative);
            this.myAmount = amount;
        }
    }

    private static class CharacterPrediction
    extends TypeAheadPrediction {
        public final char myCharacter;

        public CharacterPrediction(TypeAheadTerminalModel.LineWithCursorX predictedLineWithCursorX, char character, boolean isNotTentative) {
            super(predictedLineWithCursorX, isNotTentative);
            this.myCharacter = character;
        }
    }

    private static class HardBoundary
    extends TypeAheadPrediction {
        public HardBoundary() {
            super(new TypeAheadTerminalModel.LineWithCursorX(new StringBuffer(), -100), false);
        }
    }

    private static abstract class TypeAheadPrediction {
        public final long myCreatedTime;
        public final boolean myIsNotTentative;
        public final TypeAheadTerminalModel.LineWithCursorX myPredictedLineWithCursorX;

        private TypeAheadPrediction(TypeAheadTerminalModel.LineWithCursorX predictedLineWithCursorX, boolean isNotTentative) {
            this.myPredictedLineWithCursorX = predictedLineWithCursorX;
            this.myIsNotTentative = isNotTentative;
            this.myCreatedTime = System.nanoTime();
        }
    }

    static class LatencyStatistics {
        private static final int LATENCY_BUFFER_SIZE = 30;
        private final LinkedList<Long> myLatencies = new LinkedList();

        LatencyStatistics() {
        }

        public void adjustLatency(@NotNull TypeAheadPrediction prediction) {
            this.myLatencies.add(System.nanoTime() - prediction.myCreatedTime);
            if (this.myLatencies.size() > 30) {
                this.myLatencies.removeFirst();
            }
        }

        public long getLatencyMedian() {
            if (this.myLatencies.isEmpty()) {
                throw new IllegalStateException("Tried to calculate latency with sample size of 0");
            }
            Long[] sortedLatencies = (Long[])this.myLatencies.stream().sorted().toArray(Long[]::new);
            if (sortedLatencies.length % 2 == 0) {
                return (sortedLatencies[sortedLatencies.length / 2 - 1] + sortedLatencies[sortedLatencies.length / 2]) / 2L;
            }
            return sortedLatencies[sortedLatencies.length / 2];
        }

        public long getMaxLatency() {
            if (this.myLatencies.isEmpty()) {
                throw new IllegalStateException("Tried to get max latency with sample size of 0");
            }
            return Collections.max(this.myLatencies);
        }

        private int getSampleSize() {
            return this.myLatencies.size();
        }
    }

    public static class TypeAheadEvent {
        public EventType myEventType;
        @Nullable
        private Character myCharacter = null;
        private static final Map<Sequence, EventType> sequenceToEventType = Map.ofEntries(Map.entry(new Sequence(27, 91, 51, 126), EventType.Delete), Map.entry(new Sequence(127), EventType.Backspace), Map.entry(new Sequence(27, 127), EventType.AltBackspace), Map.entry(new Sequence(27, 79, 68), EventType.LeftArrow), Map.entry(new Sequence(27, 91, 68), EventType.LeftArrow), Map.entry(new Sequence(27, 79, 67), EventType.RightArrow), Map.entry(new Sequence(27, 91, 67), EventType.RightArrow), Map.entry(new Sequence(27, 98), EventType.AltLeftArrow), Map.entry(new Sequence(27, 91, 49, 59, 51, 68), EventType.AltLeftArrow), Map.entry(new Sequence(27, 91, 49, 59, 53, 68), EventType.AltLeftArrow), Map.entry(new Sequence(27, 102), EventType.AltRightArrow), Map.entry(new Sequence(27, 91, 49, 59, 51, 67), EventType.AltRightArrow), Map.entry(new Sequence(27, 91, 49, 59, 53, 67), EventType.AltRightArrow), Map.entry(new Sequence(27, 91, 72), EventType.Home), Map.entry(new Sequence(27, 79, 72), EventType.Home), Map.entry(new Sequence(1), EventType.Home), Map.entry(new Sequence(27, 91, 70), EventType.End), Map.entry(new Sequence(27, 79, 70), EventType.End), Map.entry(new Sequence(5), EventType.End));

        public TypeAheadEvent(EventType eventType) {
            this.myEventType = eventType;
        }

        public TypeAheadEvent(EventType eventType, char ch) {
            this.myEventType = eventType;
            this.myCharacter = Character.valueOf(ch);
        }

        @NotNull
        public static @NotNull List<@NotNull TypeAheadEvent> fromByteArray(byte[] byteArray) {
            if (byteArray.length == 0) {
                return Collections.emptyList();
            }
            String stringRepresentation = new String(byteArray);
            if (TypeAheadEvent.isPrintableUnicode(stringRepresentation.charAt(0))) {
                return TypeAheadEvent.fromString(stringRepresentation);
            }
            return Collections.singletonList(TypeAheadEvent.fromSequence(byteArray));
        }

        @NotNull
        public static TypeAheadEvent fromChar(char ch) {
            if (TypeAheadEvent.isPrintableUnicode(ch)) {
                return new TypeAheadEvent(EventType.Character, ch);
            }
            return new TypeAheadEvent(EventType.Unknown);
        }

        @NotNull
        public static @NotNull List<@NotNull TypeAheadEvent> fromString(@NotNull String string) {
            if (string.isEmpty()) {
                return Collections.emptyList();
            }
            if (!TypeAheadEvent.isPrintableUnicode(string.charAt(0))) {
                return Collections.singletonList(TypeAheadEvent.fromSequence(string.getBytes()));
            }
            ArrayList<@NotNull TypeAheadEvent> events = new ArrayList<TypeAheadEvent>();
            for (char ch : string.toCharArray()) {
                TypeAheadEvent event = TypeAheadEvent.fromChar(ch);
                events.add(event);
                if (event.myEventType == EventType.Unknown) break;
            }
            return events;
        }

        @Nullable
        public Character getCharacterOrNull() {
            return this.myCharacter;
        }

        @Contract(pure=true)
        private static boolean isPrintableUnicode(char c) {
            int t = Character.getType(c);
            return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
        }

        @NotNull
        private static TypeAheadEvent fromSequence(byte[] byteArray) {
            return new TypeAheadEvent(sequenceToEventType.getOrDefault(new Sequence(byteArray), EventType.Unknown));
        }

        private static class Sequence {
            private final byte[] mySequence;

            Sequence(int ... bytesAsInt) {
                this.mySequence = Sequence.makeCode(bytesAsInt);
            }

            Sequence(byte[] sequence) {
                this.mySequence = sequence;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Sequence)) {
                    return false;
                }
                Sequence sequence = (Sequence)o;
                return Arrays.equals(this.mySequence, sequence.mySequence);
            }

            public int hashCode() {
                return Arrays.hashCode(this.mySequence);
            }

            private static byte[] makeCode(int ... bytesAsInt) {
                byte[] bytes = new byte[bytesAsInt.length];
                int i = 0;
                for (int byteAsInt : bytesAsInt) {
                    bytes[i] = (byte)byteAsInt;
                    ++i;
                }
                return bytes;
            }
        }

        public static enum EventType {
            Character,
            Backspace,
            AltBackspace,
            LeftArrow,
            RightArrow,
            AltLeftArrow,
            AltRightArrow,
            Delete,
            Home,
            End,
            Unknown;

        }
    }
}

