/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RestUtil {
    public static String[] SPHINX_DIRECTIVES = new String[]{"module::", "automodule::", "autoclass::", "toctree::", "glossary::", "code-block::", "versionadded::", "versionchanged::", "deprecated::", "seealso::", "centered::", "hlist::", "index::", "productionlist::", "highlight::", "literalinclude::", "sectionauthor::", "codeauthor::", "only::", "tabularcolumns::", "py:function::", "default-domain::", "py:module::", "py:currentmodule::", "py:data::", "py:exception::", "py:function::", "py:class::", "py:attribute::", "py:method::", "py:staticmethod::", "py:classmethod::", "c:function::", "c:member::", "c:macro::", "c:type::", "c:var::", "cpp:class::", "cpp:function::", "cpp:member::", "cpp:type::", "option::", "envvar::", "program::", "describe::", "object::", "js:function::", "js:class::", "js:data::", "js:attribute::", "rst:directive::", "rst:role::"};
    public static final Set<String> PREDEFINED_ROLES = new HashSet<String>();
    public static final Set<String> SPHINX_ROLES = new HashSet<String>();
    private static final Map<String, String[]> DIRECTIVES = Maps.newHashMap();

    private RestUtil() {
    }

    public static String[] getDirectiveOptions(String directive) {
        if (DIRECTIVES.containsKey(directive)) {
            return DIRECTIVES.get(directive);
        }
        return new String[0];
    }

    public static Set<String> getDirectives() {
        return DIRECTIVES.keySet();
    }

    static {
        PREDEFINED_ROLES.add(":emphasis:");
        PREDEFINED_ROLES.add(":literal:");
        PREDEFINED_ROLES.add(":pep-reference:");
        PREDEFINED_ROLES.add(":PEP:");
        PREDEFINED_ROLES.add(":rfc-reference:");
        PREDEFINED_ROLES.add(":RFC:");
        PREDEFINED_ROLES.add(":strong:");
        PREDEFINED_ROLES.add(":subscript:");
        PREDEFINED_ROLES.add(":sub:");
        PREDEFINED_ROLES.add(":superscript:");
        PREDEFINED_ROLES.add(":sup:");
        PREDEFINED_ROLES.add(":title-reference:");
        PREDEFINED_ROLES.add(":title:");
        PREDEFINED_ROLES.add(":t:");
        PREDEFINED_ROLES.add(":raw:");
        SPHINX_ROLES.add(":py:mod:");
        SPHINX_ROLES.add(":py:func:");
        SPHINX_ROLES.add(":py:data:");
        SPHINX_ROLES.add(":py:const:");
        SPHINX_ROLES.add(":py:class:");
        SPHINX_ROLES.add(":py:meth:");
        SPHINX_ROLES.add(":py:attr:");
        SPHINX_ROLES.add(":py:exc:");
        SPHINX_ROLES.add(":py:obj:");
        SPHINX_ROLES.add(":ref:");
        SPHINX_ROLES.add(":doc:");
        SPHINX_ROLES.add(":download:");
        SPHINX_ROLES.add(":envvar:");
        SPHINX_ROLES.add(":token:");
        SPHINX_ROLES.add(":keyword:");
        SPHINX_ROLES.add(":option:");
        SPHINX_ROLES.add(":term:");
        SPHINX_ROLES.add(":abbr:");
        SPHINX_ROLES.add(":command:");
        SPHINX_ROLES.add(":dfn:");
        SPHINX_ROLES.add(":file:");
        SPHINX_ROLES.add(":guilabel:");
        SPHINX_ROLES.add(":kbd:");
        SPHINX_ROLES.add(":mailheader:");
        SPHINX_ROLES.add(":makevar:");
        SPHINX_ROLES.add(":manpage:");
        SPHINX_ROLES.add(":menuselection:");
        SPHINX_ROLES.add(":mimetype:");
        SPHINX_ROLES.add(":newsgroup:");
        SPHINX_ROLES.add(":program:");
        SPHINX_ROLES.add(":regexp:");
        SPHINX_ROLES.add(":samp:");
        SPHINX_ROLES.add(":pep:");
        SPHINX_ROLES.add(":rfc:");
        DIRECTIVES.put("attention::", new String[0]);
        DIRECTIVES.put("caution::", new String[0]);
        DIRECTIVES.put("danger::", new String[0]);
        DIRECTIVES.put("error::", new String[0]);
        DIRECTIVES.put("hint::", new String[0]);
        DIRECTIVES.put("important::", new String[0]);
        DIRECTIVES.put("note::", new String[0]);
        DIRECTIVES.put("tip::", new String[0]);
        DIRECTIVES.put("warning::", new String[0]);
        DIRECTIVES.put("admonition::", new String[]{":class:"});
        DIRECTIVES.put("image::", new String[]{":alt:", ":height:", ":width:", ":scale:", ":align:", ":target:", ":class:"});
        DIRECTIVES.put("figure::", new String[]{":alt:", ":height:", ":width:", ":scale:", ":align:", ":target:", ":class:", ":figwidth:", ":figclass:"});
        DIRECTIVES.put("topic::", new String[]{":class:"});
        DIRECTIVES.put("sidebar::", new String[]{":subtitle:", ":class:"});
        DIRECTIVES.put("line-block::", new String[]{":class:"});
        DIRECTIVES.put("parsed-literal::", new String[]{":class:"});
        DIRECTIVES.put("rubric::", new String[]{":class:"});
        DIRECTIVES.put("epigraph::", new String[0]);
        DIRECTIVES.put("highlights::", new String[0]);
        DIRECTIVES.put("pull-quote::", new String[0]);
        DIRECTIVES.put("compound::", new String[]{":class:"});
        DIRECTIVES.put("container::", new String[0]);
        DIRECTIVES.put("table::", new String[]{":class:"});
        DIRECTIVES.put("csv-table::", new String[]{":class:", ":widths:", ":header-rows:", ":stub-columns:", ":header:", ":file:", ":url:", ":encoding:", ":delim:", ":quote:", ":keepspace:", ":escape:"});
        DIRECTIVES.put("list-table::", new String[]{":class:", ":widths:", ":header-rows:", ":stub-columns:"});
        DIRECTIVES.put("contents::", new String[]{":class:", ":depth:", ":local:", ":backlinks:"});
        DIRECTIVES.put("sectnum::", new String[]{":depth:", ":prefix:", ":suffix:", ":start:"});
        DIRECTIVES.put("section-autonumbering::", new String[]{":depth:", ":prefix:", ":suffix:", ":start:"});
        DIRECTIVES.put("header::", new String[0]);
        DIRECTIVES.put("footer::", new String[0]);
        DIRECTIVES.put("target-notes::", new String[]{"class"});
        DIRECTIVES.put("footnotes::", new String[0]);
        DIRECTIVES.put("citations::", new String[0]);
        DIRECTIVES.put("meta::", new String[0]);
        DIRECTIVES.put("replace::", new String[0]);
        DIRECTIVES.put("unicode::", new String[]{":ltrim:", ":rtrim:", ":trim:"});
        DIRECTIVES.put("date::", new String[0]);
        DIRECTIVES.put("include::", new String[]{":start-line:", ":end-line:", ":start-after:", ":end-before:", ":literal:", ":encoding:", ":tab-width:"});
        DIRECTIVES.put("raw::", new String[]{":file:", ":url:", ":encoding:"});
        DIRECTIVES.put("class::", new String[0]);
        DIRECTIVES.put("role::", new String[]{":class:", ":format:"});
        DIRECTIVES.put("default-role::", new String[0]);
        DIRECTIVES.put("title::", new String[0]);
        DIRECTIVES.put("restructuredtext-test-directive::", new String[0]);
    }
}

