/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.mpp.AbstractCalendarFactory;
import net.sf.mpxj.mpp.MPPUtility;

abstract class AbstractCalendarAndExceptionFactory
extends AbstractCalendarFactory {
    private static final RecurrenceType[] RECURRENCE_TYPES = new RecurrenceType[]{null, RecurrenceType.DAILY, RecurrenceType.YEARLY, RecurrenceType.YEARLY, RecurrenceType.MONTHLY, RecurrenceType.MONTHLY, RecurrenceType.WEEKLY, RecurrenceType.DAILY};
    private static final boolean[] RELATIVE_MAP = new boolean[]{false, false, false, true, false, true};
    private static final int[] DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};

    public AbstractCalendarAndExceptionFactory(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    protected void processCalendarExceptions(byte[] byArray, ProjectCalendar projectCalendar) {
        if (byArray.length > 420) {
            int n = 420;
            int n2 = MPPUtility.getShort(byArray, n);
            if (n2 == 0) {
                n += 4;
            } else {
                n += 4;
                for (int i = 0; i < n2 && n + 92 <= byArray.length; ++i) {
                    int n3;
                    Date date = MPPUtility.getDate(byArray, n);
                    Date date2 = MPPUtility.getDate(byArray, n + 2);
                    ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
                    int n4 = MPPUtility.getShort(byArray, n + 14);
                    if (n4 != 0) {
                        for (n3 = 0; n3 < n4; ++n3) {
                            Date date3 = MPPUtility.getTime(byArray, n + 20 + n3 * 2);
                            long l = MPPUtility.getDuration(byArray, n + 32 + n3 * 4);
                            projectCalendarException.addRange(new DateRange(date3, new Date(date3.getTime() + l)));
                        }
                    }
                    if ((n3 = MPPUtility.getInt(byArray, n + 88)) % 4 != 0) {
                        n3 = (n3 / 4 + 1) * 4;
                    }
                    if (n3 != 0) {
                        projectCalendarException.setName(MPPUtility.getUnicodeString(byArray, n + 92));
                    }
                    RecurringData recurringData = new RecurringData();
                    int n5 = MPPUtility.getShort(byArray, n + 72);
                    recurringData.setStartDate(projectCalendarException.getFromDate());
                    recurringData.setFinishDate(projectCalendarException.getToDate());
                    recurringData.setRecurrenceType(this.getRecurrenceType(n5));
                    recurringData.setRelative(this.getRelative(n5));
                    recurringData.setOccurrences(MPPUtility.getShort(byArray, n + 4));
                    switch (recurringData.getRecurrenceType()) {
                        case DAILY: {
                            int n6 = n5 == 1 ? 1 : MPPUtility.getShort(byArray, n + 76);
                            recurringData.setFrequency(n6);
                            break;
                        }
                        case WEEKLY: {
                            recurringData.setWeeklyDaysFromBitmap(MPPUtility.getByte(byArray, n + 76), DAY_MASKS);
                            recurringData.setFrequency(MPPUtility.getShort(byArray, n + 78));
                            break;
                        }
                        case MONTHLY: {
                            if (recurringData.getRelative()) {
                                recurringData.setDayOfWeek(Day.getInstance(MPPUtility.getByte(byArray, n + 77) - 2));
                                recurringData.setDayNumber(MPPUtility.getByte(byArray, n + 76) + 1);
                                recurringData.setFrequency(MPPUtility.getShort(byArray, n + 78));
                                break;
                            }
                            recurringData.setDayNumber(MPPUtility.getByte(byArray, n + 76));
                            recurringData.setFrequency(MPPUtility.getByte(byArray, n + 78));
                            break;
                        }
                        case YEARLY: {
                            if (recurringData.getRelative()) {
                                recurringData.setDayOfWeek(Day.getInstance(MPPUtility.getByte(byArray, n + 78) - 2));
                                recurringData.setDayNumber(MPPUtility.getByte(byArray, n + 77) + 1);
                            } else {
                                recurringData.setDayNumber(MPPUtility.getByte(byArray, n + 77));
                            }
                            recurringData.setMonthNumber(MPPUtility.getByte(byArray, n + 76) + 1);
                        }
                    }
                    if (recurringData.getRecurrenceType() != RecurrenceType.DAILY || recurringData.getOccurrences() != 1) {
                        projectCalendarException.setRecurring(recurringData);
                    }
                    n += 92 + n3;
                }
            }
            this.processWorkWeeks(byArray, n, projectCalendar);
        }
    }

    private void processWorkWeeks(byte[] byArray, int n, ProjectCalendar projectCalendar) {
        n += 4;
        while (byArray.length >= n + 436) {
            ProjectCalendarWeek projectCalendarWeek = projectCalendar.addWorkWeek();
            for (Day day : Day.values()) {
                this.processWorkWeekDay(byArray, n, projectCalendarWeek, day);
                n += 60;
            }
            Date object = DateHelper.getDayStartDate(MPPUtility.getDate(byArray, n));
            Date date = DateHelper.getDayEndDate(MPPUtility.getDate(byArray, n += 2));
            n += 2;
            int n2 = MPPUtility.getInt(byArray, n += 8);
            if (n2 % 4 != 0) {
                n2 = (n2 / 4 + 1) * 4;
            }
            n += 4;
            if (n2 != 0) {
                String string = MPPUtility.getUnicodeString(byArray, n, n2);
                n += n2;
                projectCalendarWeek.setName(string);
            }
            projectCalendarWeek.setDateRange(new DateRange(object, date));
        }
    }

    private void processWorkWeekDay(byte[] byArray, int n, ProjectCalendarWeek projectCalendarWeek, Day day) {
        int n2 = MPPUtility.getShort(byArray, n + 0);
        if (n2 == 1) {
            projectCalendarWeek.setWorkingDay(day, DayType.DEFAULT);
        } else {
            ProjectCalendarHours projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
            int n3 = MPPUtility.getShort(byArray, n + 2);
            if (n3 == 0) {
                projectCalendarWeek.setWorkingDay(day, DayType.NON_WORKING);
            } else {
                projectCalendarWeek.setWorkingDay(day, DayType.WORKING);
                Calendar calendar = Calendar.getInstance();
                for (int i = 0; i < n3; ++i) {
                    Date date = DateHelper.getCanonicalTime(MPPUtility.getTime(byArray, n + 8 + i * 2));
                    int n4 = MPPUtility.getInt(byArray, n + 20 + i * 4) * 6;
                    calendar.setTime(date);
                    calendar.add(13, n4);
                    Date date2 = DateHelper.getCanonicalTime(calendar.getTime());
                    projectCalendarHours.addRange(new DateRange(date, date2));
                }
            }
        }
    }

    private RecurrenceType getRecurrenceType(int n) {
        RecurrenceType recurrenceType = n < 0 || n >= RECURRENCE_TYPES.length ? null : RECURRENCE_TYPES[n];
        return recurrenceType;
    }

    private boolean getRelative(int n) {
        boolean bl = n < 0 || n >= RELATIVE_MAP.length ? false : RELATIVE_MAP[n];
        return bl;
    }
}

