/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.calendar;

import com.projectlibre1.configuration.CircularDependencyException;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.hierarchy.NodeHierarchy;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.calendar.CalendarDefinition;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.DayDescriptor;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.calendar.InvalidCalendarIntersectionException;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.calendar.WorkDay;
import com.projectlibre1.pm.calendar.WorkRangeException;
import com.projectlibre1.pm.calendar.WorkWeek;
import com.projectlibre1.pm.calendar.WorkingHours;
import com.projectlibre1.pm.key.HasCommonKeyImpl;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.DateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.Closure;

public class WorkingCalendar
implements WorkCalendar,
Serializable,
Comparable {
    static final long serialVersionUID = 27738049223431L;
    private int fixedId = 0;
    public static final WorkingCalendar INVALID_INTERSECTION_CALENDAR = new WorkingCalendar();
    private transient HashSet objectsUsing = null;
    private transient HasCommonKeyImpl hasKey = new HasCommonKeyImpl(true, this);
    private WorkCalendar baseCalendar = null;
    private CalendarDefinition differences = new CalendarDefinition();
    private transient CalendarDefinition concrete = null;
    private static WorkingCalendar standardInstance = null;
    private static WorkingCalendar defaultInstance = null;
    private static WorkingCalendar _24HoursInstance = null;
    private static WorkingCalendar nightShiftInstance = null;
    String serializedName = "";
    private transient boolean dirty;

    public final HashSet getObjectsUsing() {
        if (this.objectsUsing == null) {
            this.objectsUsing = new HashSet();
        }
        return this.objectsUsing;
    }

    public void addObjectUsing(HasCalendar hasCalendar) {
        this.getObjectsUsing().add(hasCalendar);
    }

    public void removeObjectUsing(HasCalendar hasCalendar) {
        this.getObjectsUsing().remove(hasCalendar);
    }

    private WorkingCalendar() {
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public static WorkingCalendar getInstance() {
        return new WorkingCalendar();
    }

    public static WorkingCalendar getInstanceBasedOn(WorkCalendar workCalendar) {
        WorkingCalendar workingCalendar = WorkingCalendar.getInstance();
        try {
            workingCalendar.setBaseCalendar(workCalendar);
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
        }
        return workingCalendar;
    }

    public static WorkingCalendar getStandardBasedInstance() {
        WorkingCalendar workingCalendar = WorkingCalendar.getInstance();
        try {
            workingCalendar.setBaseCalendar(WorkingCalendar.getStandardInstance());
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
        }
        return workingCalendar;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WorkingCalendar workingCalendar = (WorkingCalendar)super.clone();
        workingCalendar.setName(this.getName());
        return workingCalendar;
    }

    public WorkingCalendar makeScratchCopy() {
        WorkingCalendar workingCalendar = null;
        try {
            workingCalendar = new WorkingCalendar();
            workingCalendar.baseCalendar = this.baseCalendar;
            workingCalendar.setName(this.getName());
            workingCalendar.differences = (CalendarDefinition)this.differences.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return workingCalendar;
    }

    public long getId() {
        return this.hasKey.getId();
    }

    public void setId(long l) {
        this.hasKey.setId(l);
    }

    @Override
    public long getUniqueId() {
        return this.hasKey.getUniqueId();
    }

    @Override
    public void setUniqueId(long l) {
        this.hasKey.setUniqueId(l);
    }

    public void assignFrom(WorkingCalendar workingCalendar) {
        this.baseCalendar = workingCalendar.baseCalendar;
        if (!workingCalendar.getName().equals(this.getName())) {
            this.setName(workingCalendar.getName());
        }
        this.differences = workingCalendar.differences;
        this.concrete = null;
    }

    public WorkDay[] getExceptionDays() {
        return this.differences.getExceptions();
    }

    @Override
    public String getName() {
        return this.hasKey.getName();
    }

    @Override
    public void setName(String string) {
        this.hasKey.setName(string);
    }

    public void addOrReplaceException(WorkDay workDay) {
        workDay.initialize();
        this.differences.addOrReplaceException(workDay);
    }

    public void removeException(WorkDay workDay) {
        this.differences.dayExceptions.remove(workDay);
    }

    @Override
    public CalendarDefinition getConcreteInstance() {
        if (this.concrete == null) {
            WorkCalendar workCalendar = this.baseCalendar;
            this.concrete = new CalendarDefinition(workCalendar == null ? null : workCalendar.getConcreteInstance(), this.differences);
        }
        return this.concrete;
    }

    @Override
    public void invalidate() {
        this.concrete = null;
        CalendarService.getInstance().invalidate(this);
    }

    @Override
    public WorkCalendar getBaseCalendar() {
        return this.baseCalendar;
    }

    @Override
    public boolean dependsOn(WorkCalendar workCalendar) {
        if (this == workCalendar) {
            return true;
        }
        WorkCalendar workCalendar2 = this.getBaseCalendar();
        if (workCalendar2 == null) {
            return false;
        }
        return workCalendar2.dependsOn(workCalendar);
    }

    public void setBaseCalendar(WorkCalendar workCalendar) throws CircularDependencyException {
        if (workCalendar != null && workCalendar.dependsOn(this)) {
            throw new CircularDependencyException(Messages.getString("Calendar.ExceptionCircular"));
        }
        this.baseCalendar = workCalendar;
    }

    public void changeBaseCalendar(WorkCalendar workCalendar) throws CircularDependencyException {
        this.setBaseCalendar(workCalendar);
    }

    public WorkDay getWeekDay(int n) {
        return this.differences.week.getWeekDay(n);
    }

    public WorkDay getDerivedWeekDay(int n) {
        WorkDay workDay = this.differences.week.getWeekDay(n);
        if (workDay == null && this.baseCalendar != null) {
            workDay = ((WorkingCalendar)this.baseCalendar).getDerivedWeekDay(n);
        }
        return workDay;
    }

    public void setWeekDay(int n, WorkDay workDay) {
        this.differences.week.setWeekDay(n, workDay);
    }

    public void setWeekDays(WorkDay workDay) {
        this.differences.week.setWeekDays(workDay);
    }

    public void setWeekends(WorkDay workDay) {
        this.differences.week.setWeekends(workDay);
    }

    @Override
    public long add(long l, long l2, boolean bl) {
        return this.getConcreteInstance().add(l, l2, bl);
    }

    @Override
    public long compare(long l, long l2, boolean bl) {
        return this.getConcreteInstance().compare(l, l2, bl);
    }

    @Override
    public long adjustInsideCalendar(long l, boolean bl) {
        return this.getConcreteInstance().adjustInsideCalendar(l, bl);
    }

    @Override
    public String getCategory() {
        return "Calendar";
    }

    public String toString() {
        return this.getName();
    }

    static WorkingCalendar getStandardInstance() {
        if (standardInstance != null) {
            return standardInstance;
        }
        standardInstance = WorkingCalendar.getInstance();
        WorkDay workDay = null;
        WorkDay workDay2 = null;
        workDay = new WorkDay();
        workDay2 = new WorkDay();
        workDay.getWorkingHours().setNonWorking();
        try {
            workDay2.getWorkingHours().setInterval(0, WorkingCalendar.hourTime(8), WorkingCalendar.hourTime(12));
            workDay2.getWorkingHours().setInterval(1, WorkingCalendar.hourTime(13), WorkingCalendar.hourTime(17));
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
        }
        standardInstance.setWeekends(workDay);
        standardInstance.setWeekDays(workDay2);
        standardInstance.setName("default base");
        return standardInstance;
    }

    static WorkingCalendar getDefaultInstance() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        defaultInstance = WorkingCalendar.getStandardBasedInstance();
        defaultInstance.setName(Messages.getString("Calendar.Standard"));
        defaultInstance.setFixedId(1);
        CalendarService.getInstance().add(defaultInstance);
        WorkingCalendar.get24HoursInstance();
        WorkingCalendar.getNightShiftInstance();
        return defaultInstance;
    }

    static WorkingCalendar get24HoursInstance() {
        if (_24HoursInstance != null) {
            return _24HoursInstance;
        }
        _24HoursInstance = WorkingCalendar.getStandardBasedInstance();
        WorkDay workDay = null;
        workDay = new WorkDay();
        try {
            workDay.getWorkingHours().setInterval(0, WorkingCalendar.hourTime(0), WorkingCalendar.hourTime(0));
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
        }
        _24HoursInstance.setWeekends(workDay);
        _24HoursInstance.setWeekDays(workDay);
        _24HoursInstance.setName(Messages.getString("Calendar.24Hours"));
        _24HoursInstance.setFixedId(2);
        CalendarService.getInstance().add(_24HoursInstance);
        return _24HoursInstance;
    }

    static WorkingCalendar getNightShiftInstance() {
        if (nightShiftInstance != null) {
            return nightShiftInstance;
        }
        nightShiftInstance = WorkingCalendar.getStandardBasedInstance();
        WorkDay workDay = null;
        WorkDay workDay2 = null;
        workDay = new WorkDay();
        workDay2 = new WorkDay();
        workDay.getWorkingHours().setNonWorking();
        nightShiftInstance.setWeekDay(0, null);
        WorkDay workDay3 = new WorkDay();
        try {
            workDay3.getWorkingHours().setInterval(0, WorkingCalendar.hourTime(23), WorkingCalendar.hourTime(0));
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
        }
        nightShiftInstance.setWeekDay(1, workDay3);
        try {
            workDay2.getWorkingHours().setInterval(0, WorkingCalendar.hourTime(0), WorkingCalendar.hourTime(3));
            workDay2.getWorkingHours().setInterval(1, WorkingCalendar.hourTime(4), WorkingCalendar.hourTime(8));
            workDay2.getWorkingHours().setInterval(2, WorkingCalendar.hourTime(23), WorkingCalendar.hourTime(0));
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
        }
        nightShiftInstance.setWeekDay(2, workDay2);
        nightShiftInstance.setWeekDay(3, workDay2);
        nightShiftInstance.setWeekDay(4, workDay2);
        nightShiftInstance.setWeekDay(5, workDay2);
        WorkDay workDay4 = new WorkDay();
        try {
            workDay4.getWorkingHours().setInterval(0, WorkingCalendar.hourTime(0), WorkingCalendar.hourTime(3));
            workDay4.getWorkingHours().setInterval(1, WorkingCalendar.hourTime(4), WorkingCalendar.hourTime(8));
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
        }
        nightShiftInstance.setWeekDay(6, workDay4);
        nightShiftInstance.setName(Messages.getString("Calendar.NightShift"));
        nightShiftInstance.setFixedId(3);
        CalendarService.getInstance().add(nightShiftInstance);
        return nightShiftInstance;
    }

    private static long hourTime(int n) {
        return WorkingHours.hourTime(n);
    }

    public String dump() {
        String string = "Calendar " + this.getName() + "\n";
        string = string + "weekdays\n";
        for (int i = 0; i < 7; ++i) {
            string = string + "day[" + i + "]" + String.valueOf(this.getWeekDay(i)) + "\n";
        }
        string = string + "There are " + String.valueOf(this.differences.dayExceptions) + " exceptions\n";
        Iterator iterator = this.differences.dayExceptions.iterator();
        while (iterator.hasNext()) {
            string = string + "exception" + iterator.next().toString();
        }
        return string;
    }

    private static WorkDay getDay(Collection collection, long l) {
        Iterator iterator = collection.iterator();
        Date date = new Date(l);
        WorkDay workDay = null;
        while (iterator.hasNext()) {
            workDay = (WorkDay)iterator.next();
            if (workDay.compareTo(date) != 0) continue;
            return workDay;
        }
        return null;
    }

    DayDescriptor getMonthDayDescriptor(long l) {
        DayDescriptor dayDescriptor = new DayDescriptor();
        int n = CalendarDefinition.getDayOfWeek(l);
        dayDescriptor.workDay = WorkingCalendar.getDay(this.differences.dayExceptions, l);
        boolean bl = dayDescriptor.modified = dayDescriptor.workDay != null;
        if (dayDescriptor.workDay == null) {
            dayDescriptor.workDay = this.differences.week.getWeekDay(n);
        }
        if (dayDescriptor.workDay == null) {
            dayDescriptor.workDay = this.getConcreteInstance().getWorkDay(l);
        }
        if (dayDescriptor.workDay == null) {
            dayDescriptor.workDay = this.getConcreteInstance().week.getWeekDay(CalendarDefinition.getDayOfWeek(l));
        }
        return dayDescriptor;
    }

    DayDescriptor getWeekDayDescriptor(int n) {
        DayDescriptor dayDescriptor = new DayDescriptor();
        dayDescriptor.workDay = this.differences.week.getWeekDay(--n);
        dayDescriptor.modified = dayDescriptor.workDay != null;
        dayDescriptor.workDay = this.getConcreteInstance().week.getWeekDay(n);
        return dayDescriptor;
    }

    void makeDefaultDay(long l) {
        WorkDay workDay = WorkingCalendar.getDay(this.differences.dayExceptions, l);
        if (workDay != null) {
            this.differences.dayExceptions.remove(workDay);
        }
        this.concrete = null;
    }

    void makeDefaultWeekDay(int n) {
        this.differences.week.setWeekDay(--n, null);
        this.concrete = null;
    }

    void setDayNonWorking(long l) {
        WorkDay workDay = new WorkDay(l, l);
        this.addOrReplaceException(workDay);
        this.concrete = null;
    }

    void setWeekDayNonWorking(int n) {
        WorkDay workDay = new WorkDay();
        this.differences.week.setWeekDay(--n, workDay);
        this.concrete = null;
    }

    void setDayWorkingHours(long l, WorkingHours workingHours) throws WorkRangeException {
        workingHours.validate();
        WorkDay workDay = new WorkDay(l, l);
        workDay.setWorkingHours(workingHours);
        this.addOrReplaceException(workDay);
        this.concrete = null;
    }

    void setWeekDayWorkingHours(int n, WorkingHours workingHours) throws WorkRangeException {
        workingHours.validate();
        WorkDay workDay = new WorkDay();
        workDay.setWorkingHours(workingHours);
        this.differences.week.setWeekDay(--n, workDay);
        this.concrete = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.serializedName = this.getName();
        if (this.baseCalendar == CalendarService.getInstance().getStandardInstance()) {
            this.baseCalendar = null;
        }
        objectOutputStream.defaultWriteObject();
        this.hasKey.serialize(objectOutputStream);
        if (this.baseCalendar == null) {
            this.baseCalendar = CalendarService.getInstance().getStandardInstance();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hasKey = HasCommonKeyImpl.deserialize(objectInputStream, this);
        if (this.serializedName == null) {
            this.serializedName = "";
        }
        this.setName(this.serializedName);
        if (this.baseCalendar == null) {
            this.baseCalendar = CalendarService.getInstance().getStandardInstance();
        }
        CalendarService.getInstance().add(this);
    }

    public boolean isBaseCalendar() {
        return this.baseCalendar == WorkingCalendar.getStandardInstance();
    }

    public final int getFixedId() {
        return this.fixedId;
    }

    public final void setFixedId(int n) {
        this.fixedId = n;
    }

    public static ArrayList extractCalendars(Collection collection) {
        ArrayList<WorkingCalendar> arrayList = new ArrayList<WorkingCalendar>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            WorkingCalendar workingCalendar = (WorkingCalendar)((HasCalendar)iterator.next()).getWorkCalendar();
            if (workingCalendar == null) continue;
            arrayList.add(workingCalendar);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ArrayList extractCalendars(NodeHierarchy nodeHierarchy) {
        final ArrayList arrayList = new ArrayList();
        nodeHierarchy.visitAll(new Closure(){

            @Override
            public void execute(Object object) {
                Object object2;
                if (object != null && (object2 = ((Node)object).getImpl()) instanceof HasCalendar) {
                    arrayList.add(object2);
                }
            }
        });
        return WorkingCalendar.extractCalendars(arrayList);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (!(object instanceof WorkingCalendar)) {
            return -1;
        }
        return this.getName().compareTo(((WorkingCalendar)object).getName());
    }

    public void notifyChanged() {
        this.concrete = null;
    }

    @Override
    public boolean isInvalid() {
        return this.concrete == null;
    }

    public WorkingCalendar intersectWith(WorkingCalendar workingCalendar) throws InvalidCalendarIntersectionException {
        WorkDay workDay;
        int n;
        CalendarDefinition calendarDefinition = new CalendarDefinition();
        WorkWeek workWeek = new WorkWeek();
        for (int i = 0; i < 7; ++i) {
            workWeek.workDay[i] = this.getDerivedWeekDay(i).intersectWith(workingCalendar.getDerivedWeekDay(i));
        }
        workWeek.updateWorkingDuration();
        if (workWeek.getDuration() == 0L) {
            throw new InvalidCalendarIntersectionException();
        }
        CalendarDefinition calendarDefinition2 = this.getConcreteInstance();
        CalendarDefinition calendarDefinition3 = workingCalendar.getConcreteInstance();
        for (n = 0; n < calendarDefinition2.exceptions.length; ++n) {
            workDay = calendarDefinition2.exceptions[n];
            calendarDefinition.dayExceptions.add(workDay.intersectWith(calendarDefinition3.getWorkDay(workDay.getStart())));
        }
        for (n = 0; n < calendarDefinition3.exceptions.length; ++n) {
            workDay = calendarDefinition3.exceptions[n];
            calendarDefinition.dayExceptions.add(workDay.intersectWith(calendarDefinition2.getWorkDay(workDay.getStart())));
        }
        calendarDefinition.addSentinelsAndMakeArray();
        calendarDefinition.week = workWeek;
        WorkingCalendar workingCalendar2 = new WorkingCalendar();
        workingCalendar2.concrete = calendarDefinition;
        workingCalendar2.setName("AssignCal: " + this.getName() + "/" + workingCalendar.getName());
        return workingCalendar2;
    }

    public void addCalendarTime(long l, long l2) {
        l = DateTime.dayFloor(l);
        l2 = DateTime.dayFloor(l2);
        long l3 = l;
        while (l3 < l2) {
            WorkDay workDay = new WorkDay(l3, l3);
            WorkingHours workingHours = (WorkingHours)(CalendarOption.getInstance().isAddedCalendarTimeIsNonStop() ? WorkingHours.getNonStop().clone() : WorkingHours.getDefault().clone());
            workDay.setWorkingHours(workingHours);
            this.addOrReplaceException(workDay);
            l3 = DateTime.nextDay(l3);
        }
        this.invalidate();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void removeEmptyDays() {
        int n = 0;
        for (int i = 0; i < 7; ++i) {
            WorkDay workDay = this.getWeekDay(i);
            if (workDay == null) continue;
            if (workDay.getWorkingHours() == null || !workDay.getWorkingHours().hasHours()) {
                this.setWeekDay(i, null);
            }
            if (this.getWeekDay(i) != null) continue;
            ++n;
        }
    }
}

