/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class RichFacesTagFeatureProvider
implements TagFeatureProvider {
    private static final String RICHFACES_RICH_NAMESPACE = "http://richfaces.org/rich";
    private static final String RICHFACES_A4J_NAMESPACE = "http://richfaces.org/a4j";
    private static final String VAR = "var";
    private static final String VALUE = "value";

    public <T extends TagFeature> Collection<T> getFeatures(final Tag tag, Library library, Class<T> clazz) {
        IterableTag iterableTag;
        if (clazz.equals(TagFeature.IterableTagPattern.class) && (iterableTag = this.resolveIterableTag(library, tag)) != null) {
            return Collections.singleton((TagFeature)clazz.cast(new TagFeature.IterableTagPattern(){

                public Attribute getVariable() {
                    return tag.getAttribute(iterableTag.getVariableAttribute());
                }

                public Attribute getItems() {
                    return tag.getAttribute(iterableTag.getItemsAttribute());
                }
            }));
        }
        return Collections.emptyList();
    }

    private IterableTag resolveIterableTag(Library library, Tag tag) {
        String libraryNamespace = library.getNamespace();
        if (libraryNamespace == null) {
            return null;
        }
        for (IterableTag iterableTag : IterableTag.values()) {
            if (!Objects.equals(libraryNamespace, iterableTag.getNamespace()) || !Objects.equals(tag.getName(), iterableTag.getName())) continue;
            return iterableTag;
        }
        return null;
    }

    private static enum IterableTag {
        A4J_REPEAT("http://richfaces.org/a4j", "repeat", "value", "var"),
        RICH_AUTOCOMPLETE("http://richfaces.org/rich", "autocomplete", "autocompleteList", "var"),
        RICH_COLLAPSIBLE_SUB_TABLE("http://richfaces.org/rich", "collapsibleSubTable", "value", "var"),
        RICH_DATAGRID("http://richfaces.org/rich", "dataGrid", "value", "var"),
        RICH_DATA_TABLE("http://richfaces.org/rich", "dataTable", "value", "var"),
        RICH_EXTENDED_DATA_TABLE("http://richfaces.org/rich", "extendedDataTable", "value", "var"),
        RICH_LIST("http://richfaces.org/rich", "list", "value", "var"),
        RICH_ORDERING_LIST("http://richfaces.org/rich", "orderingList", "value", "var"),
        RICH_PICK_LIST("http://richfaces.org/rich", "pickList", "value", "var"),
        RICH_SELECT("http://richfaces.org/rich", "select", "autocompleteList", "var"),
        RICH_TREE("http://richfaces.org/rich", "tree", "value", "var");

        private final String namespace;
        private final String name;
        private final String itemsAttribute;
        private final String variableAttribute;

        private IterableTag(String namespace, String name, String itemsAttribute, String variableAttribute) {
            this.namespace = namespace;
            this.name = name;
            this.itemsAttribute = itemsAttribute;
            this.variableAttribute = variableAttribute;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getItemsAttribute() {
            return this.itemsAttribute;
        }

        public String getVariableAttribute() {
            return this.variableAttribute;
        }
    }
}

