/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import org.netbeans.modules.languages.hcl.ast.HCLExpression;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HCLLiteral
extends HCLExpression {
    public static final Bool TRUE = new Bool(true);
    public static final Bool FALSE = new Bool(false);
    public static final Null NULL = new Null();

    public record Bool(boolean value) implements HCLLiteral
    {
        @Override
        public String asString() {
            return this.value ? "true" : "false";
        }
    }

    public record Null() implements HCLLiteral
    {
        @Override
        public String asString() {
            return "null";
        }
    }

    public record NumericLit(String value) implements HCLLiteral
    {
        @Override
        public String asString() {
            return this.value;
        }
    }

    public record StringLit(String value) implements HCLLiteral
    {
        @Override
        public String asString() {
            return "\"" + this.value + "\"";
        }
    }
}

