/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class HeadObjectRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private String versionId;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).versionId(this.versionId).ifMatch(this.ifMatch).ifNoneMatch(this.ifNoneMatch).opcClientRequestId(this.opcClientRequestId).opcSseCustomerAlgorithm(this.opcSseCustomerAlgorithm).opcSseCustomerKey(this.opcSseCustomerKey).opcSseCustomerKeySha256(this.opcSseCustomerKeySha256);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",versionId=").append(String.valueOf(this.versionId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcSseCustomerAlgorithm=").append(String.valueOf(this.opcSseCustomerAlgorithm));
        sb.append(",opcSseCustomerKey=").append(String.valueOf(this.opcSseCustomerKey));
        sb.append(",opcSseCustomerKeySha256=").append(String.valueOf(this.opcSseCustomerKeySha256));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeadObjectRequest)) {
            return false;
        }
        HeadObjectRequest other = (HeadObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcSseCustomerAlgorithm, other.opcSseCustomerAlgorithm) && Objects.equals(this.opcSseCustomerKey, other.opcSseCustomerKey) && Objects.equals(this.opcSseCustomerKeySha256, other.opcSseCustomerKeySha256);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.versionId == null ? 43 : this.versionId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcSseCustomerAlgorithm == null ? 43 : this.opcSseCustomerAlgorithm.hashCode());
        result = result * 59 + (this.opcSseCustomerKey == null ? 43 : this.opcSseCustomerKey.hashCode());
        result = result * 59 + (this.opcSseCustomerKeySha256 == null ? 43 : this.opcSseCustomerKeySha256.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<HeadObjectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String objectName = null;
        private String versionId = null;
        private String ifMatch = null;
        private String ifNoneMatch = null;
        private String opcClientRequestId = null;
        private String opcSseCustomerAlgorithm = null;
        private String opcSseCustomerKey = null;
        private String opcSseCustomerKeySha256 = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(HeadObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.versionId(o.getVersionId());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public HeadObjectRequest build() {
            HeadObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public HeadObjectRequest buildWithoutInvocationCallback() {
            HeadObjectRequest request = new HeadObjectRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.objectName = this.objectName;
            request.versionId = this.versionId;
            request.ifMatch = this.ifMatch;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcClientRequestId = this.opcClientRequestId;
            request.opcSseCustomerAlgorithm = this.opcSseCustomerAlgorithm;
            request.opcSseCustomerKey = this.opcSseCustomerKey;
            request.opcSseCustomerKeySha256 = this.opcSseCustomerKeySha256;
            return request;
        }
    }
}

