/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.io.IOException;
import java.util.Set;
import org.netbeans.upgrade.PathTransformation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Copy {
    private final FileObject sourceRoot;
    private final FileObject targetRoot;
    private final Set<String> thoseToCopy;
    private final PathTransformation transformation;

    private Copy(FileObject source, FileObject target, Set<String> thoseToCopy, PathTransformation transformation) {
        this.sourceRoot = source;
        this.targetRoot = target;
        this.thoseToCopy = thoseToCopy;
        this.transformation = transformation;
    }

    public static void copyDeep(FileObject source, FileObject target, Set<String> thoseToCopy) throws IOException {
        Copy.copyDeep(source, target, thoseToCopy, null);
    }

    public static void copyDeep(FileObject source, FileObject target, Set<String> thoseToCopy, PathTransformation transformation) throws IOException {
        Copy instance = new Copy(source, target, thoseToCopy, transformation);
        instance.copyFolder(instance.sourceRoot);
    }

    private void copyFolder(FileObject sourceFolder) throws IOException {
        FileObject[] srcChildren = sourceFolder.getChildren();
        for (int i = 0; i < srcChildren.length; ++i) {
            FileObject child = srcChildren[i];
            if (child.isFolder()) {
                this.copyFolder(child);
                if (!this.thoseToCopy.contains(child.getPath()) && !this.thoseToCopy.contains(child.getPath() + "/") || !child.getAttributes().hasMoreElements()) continue;
                this.copyFolderAttributes(child);
                continue;
            }
            if (!this.thoseToCopy.contains(child.getPath())) continue;
            this.copyFile(child);
        }
    }

    private void copyFolderAttributes(FileObject sourceFolder) throws IOException {
        FileObject targetFolder = FileUtil.createFolder((FileObject)this.targetRoot, (String)sourceFolder.getPath());
        if (sourceFolder.getAttributes().hasMoreElements()) {
            FileUtil.copyAttributes((FileObject)sourceFolder, (FileObject)targetFolder);
        }
    }

    private void copyFile(FileObject sourceFile) throws IOException {
        String targetPath = this.transformation != null ? this.transformation.transformPath(sourceFile.getPath()) : sourceFile.getPath();
        boolean isTransformed = !targetPath.equals(sourceFile.getPath());
        FileObject tg = this.targetRoot.getFileObject(targetPath);
        try {
            if (tg == null) {
                String ext;
                String name;
                FileObject targetFolder;
                if (isTransformed) {
                    FileObject targetFile = FileUtil.createData((FileObject)this.targetRoot, (String)targetPath);
                    targetFolder = targetFile.getParent();
                    name = targetFile.getName();
                    ext = targetFile.getExt();
                    targetFile.delete();
                } else {
                    targetFolder = FileUtil.createFolder((FileObject)this.targetRoot, (String)sourceFile.getParent().getPath());
                    name = sourceFile.getName();
                    ext = sourceFile.getExt();
                }
                tg = FileUtil.copyFile((FileObject)sourceFile, (FileObject)targetFolder, (String)name, (String)ext);
            }
        }
        catch (IOException ex) {
            if (sourceFile.getNameExt().endsWith("_hidden")) {
                return;
            }
            throw ex;
        }
        FileUtil.copyAttributes((FileObject)sourceFile, (FileObject)tg);
    }
}

