/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.completion;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.twig.editor.completion.TwigCompletionContextFinder;
import org.netbeans.modules.php.twig.editor.completion.TwigCompletionProposal;
import org.netbeans.modules.php.twig.editor.completion.TwigDocumentationFactory;
import org.netbeans.modules.php.twig.editor.completion.TwigElement;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;

public class TwigCompletionHandler
implements CodeCompletionHandler2 {
    private static final Logger LOGGER = Logger.getLogger(TwigCompletionHandler.class.getName());
    private static URL documentationUrl = null;
    private static final Collection<Character> AUTOPOPUP_STOP_CHARS;
    private static final Set<TwigElement> TAGS;
    private static final Set<TwigElement> FILTERS;
    private static final Set<TwigElement> FUNCTIONS;
    private static final Set<TwigElement> TESTS;
    private static final Set<TwigElement> OPERATORS;

    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        ArrayList<CompletionProposal> completionProposals = new ArrayList<CompletionProposal>();
        ParserResult parserResult = codeCompletionContext.getParserResult();
        if (parserResult instanceof TwigParserResult) {
            int caretOffset;
            TwigParserResult twigParserResult = (TwigParserResult)parserResult;
            TwigCompletionProposal.CompletionRequest request = new TwigCompletionProposal.CompletionRequest();
            request.prefix = codeCompletionContext.getPrefix();
            String properPrefix = this.getPrefix(twigParserResult, caretOffset = codeCompletionContext.getCaretOffset(), true);
            request.anchorOffset = caretOffset - (properPrefix == null ? 0 : properPrefix.length());
            request.parserResult = twigParserResult;
            request.context = TwigCompletionContextFinder.find(request.parserResult, caretOffset);
            this.doCompletion(completionProposals, request);
        }
        return new DefaultCompletionResult(completionProposals, false);
    }

    private void doCompletion(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        switch (request.context) {
            case FILTER: {
                this.completeFilters(completionProposals, request);
                break;
            }
            case BLOCK: {
                this.completeAll(completionProposals, request);
                break;
            }
            case VARIABLE: {
                this.completeFilters(completionProposals, request);
                this.completeFunctions(completionProposals, request);
                this.completeTests(completionProposals, request);
                this.completeOperators(completionProposals, request);
                break;
            }
            case ALL: {
                this.completeAll(completionProposals, request);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                this.completeAll(completionProposals, request);
            }
        }
    }

    private void completeAll(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        this.completeTags(completionProposals, request);
        this.completeFilters(completionProposals, request);
        this.completeFunctions(completionProposals, request);
        this.completeTests(completionProposals, request);
        this.completeOperators(completionProposals, request);
    }

    private void completeTags(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        for (TwigElement tag : TAGS) {
            if (!TwigCompletionHandler.startsWith(tag.getName(), request.prefix)) continue;
            completionProposals.add(new TwigCompletionProposal.TagCompletionProposal(tag, request));
        }
    }

    private void completeFilters(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        for (TwigElement parameterizedItem : FILTERS) {
            if (!TwigCompletionHandler.startsWith(parameterizedItem.getName(), request.prefix)) continue;
            completionProposals.add(new TwigCompletionProposal.FilterCompletionProposal(parameterizedItem, request));
        }
    }

    private void completeFunctions(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        for (TwigElement parameterizedItem : FUNCTIONS) {
            if (!TwigCompletionHandler.startsWith(parameterizedItem.getName(), request.prefix)) continue;
            completionProposals.add(new TwigCompletionProposal.FunctionCompletionProposal(parameterizedItem, request));
        }
    }

    private void completeTests(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        for (TwigElement test : TESTS) {
            if (!TwigCompletionHandler.startsWith(test.getName(), request.prefix)) continue;
            completionProposals.add(new TwigCompletionProposal.TestCompletionProposal(test, request));
        }
    }

    private void completeOperators(List<CompletionProposal> completionProposals, TwigCompletionProposal.CompletionRequest request) {
        for (TwigElement operator : OPERATORS) {
            if (!TwigCompletionHandler.startsWith(operator.getName(), request.prefix)) continue;
            completionProposals.add(new TwigCompletionProposal.OperatorCompletionProposal(operator, request));
        }
    }

    public Documentation documentElement(ParserResult parserResult, ElementHandle elementHandle, Callable<Boolean> cancel) {
        Documentation result = null;
        if (elementHandle instanceof TwigElement) {
            result = Documentation.create((String)((TwigElement)elementHandle).getDocumentation().asText(), (URL)documentationUrl);
        }
        return result;
    }

    public String document(ParserResult pr, ElementHandle eh) {
        return null;
    }

    public ElementHandle resolveLink(String string, ElementHandle eh) {
        return null;
    }

    public String getPrefix(ParserResult info, int offset, boolean upToOffset) {
        return PrefixResolver.create(info, offset, upToOffset).resolve();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        CodeCompletionHandler.QueryType result = CodeCompletionHandler.QueryType.ALL_COMPLETION;
        if (typedText.length() == 0) {
            result = CodeCompletionHandler.QueryType.NONE;
        } else {
            char lastChar = typedText.charAt(typedText.length() - 1);
            if (AUTOPOPUP_STOP_CHARS.contains(Character.valueOf(lastChar))) {
                result = CodeCompletionHandler.QueryType.STOP;
            } else {
                int offset;
                Document document = component.getDocument();
                TokenSequence<? extends TokenId> ts = TwigLexerUtils.getTwigMarkupTokenSequence(document, offset = component.getCaretPosition());
                if (ts == null) {
                    result = CodeCompletionHandler.QueryType.STOP;
                }
            }
        }
        return result;
    }

    public String resolveTemplateVariable(String string, ParserResult pr, int i, String string1, Map map) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document dcmnt, int i, int i1) {
        return null;
    }

    public ParameterInfo parameters(ParserResult pr, int i, CompletionProposal cp) {
        return ParameterInfo.NONE;
    }

    private static boolean startsWith(String theString, String prefix) {
        return prefix.length() == 0 ? true : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    static {
        try {
            documentationUrl = new URL("http://twig.sensiolabs.org/documentation");
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        AUTOPOPUP_STOP_CHARS = new TreeSet<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf(';'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('?'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n')));
        TAGS = new HashSet<TwigElement>();
        TwigDocumentationFactory documentationFactory = TwigDocumentationFactory.TagDocumentationFactory.getInstance();
        TAGS.add(TwigElement.Factory.create("autoescape", documentationFactory));
        TAGS.add(TwigElement.Factory.create("endautoescape", documentationFactory));
        TAGS.add(TwigElement.Factory.create("block", documentationFactory, "block ${name}"));
        TAGS.add(TwigElement.Factory.create("endblock", documentationFactory));
        TAGS.add(TwigElement.Factory.create("do", documentationFactory));
        TAGS.add(TwigElement.Factory.create("embed", documentationFactory, "embed \"${template.twig}\""));
        TAGS.add(TwigElement.Factory.create("endembed", documentationFactory));
        TAGS.add(TwigElement.Factory.create("extends", documentationFactory, "extends \"${template.twig}\""));
        TAGS.add(TwigElement.Factory.create("filter", documentationFactory, "filter ${name}"));
        TAGS.add(TwigElement.Factory.create("endfilter", documentationFactory));
        TAGS.add(TwigElement.Factory.create("flush", documentationFactory));
        TAGS.add(TwigElement.Factory.create("for", documentationFactory, "for ${item} in ${array}"));
        TAGS.add(TwigElement.Factory.create("endfor", documentationFactory));
        TAGS.add(TwigElement.Factory.create("from", documentationFactory));
        TAGS.add(TwigElement.Factory.create("if", documentationFactory, "if ${true}"));
        TAGS.add(TwigElement.Factory.create("else", documentationFactory));
        TAGS.add(TwigElement.Factory.create("elseif", documentationFactory, "elseif ${true}"));
        TAGS.add(TwigElement.Factory.create("endif", documentationFactory));
        TAGS.add(TwigElement.Factory.create("import", documentationFactory, "import '${page.html}' as ${alias}"));
        TAGS.add(TwigElement.Factory.create("include", documentationFactory, "include '${page.html}'"));
        TAGS.add(TwigElement.Factory.create("macro", documentationFactory, "macro ${name}()"));
        TAGS.add(TwigElement.Factory.create("endmacro", documentationFactory));
        TAGS.add(TwigElement.Factory.create("raw", documentationFactory));
        TAGS.add(TwigElement.Factory.create("endraw", documentationFactory));
        TAGS.add(TwigElement.Factory.create("verbatim", documentationFactory));
        TAGS.add(TwigElement.Factory.create("endverbatim", documentationFactory));
        TAGS.add(TwigElement.Factory.create("sandbox", documentationFactory));
        TAGS.add(TwigElement.Factory.create("endsandbox", documentationFactory));
        TAGS.add(TwigElement.Factory.create("set", documentationFactory, "set ${variable}"));
        TAGS.add(TwigElement.Factory.create("endset", documentationFactory));
        TAGS.add(TwigElement.Factory.create("spaceless", documentationFactory));
        TAGS.add(TwigElement.Factory.create("endspaceless", documentationFactory));
        TAGS.add(TwigElement.Factory.create("use", documentationFactory, "use \"${page.html}\""));
        TAGS.add(TwigElement.Factory.create("trans", documentationFactory));
        TAGS.add(TwigElement.Factory.create("endtrans", documentationFactory));
        FILTERS = new HashSet<TwigElement>();
        documentationFactory = TwigDocumentationFactory.FilterDocumentationFactory.getInstance();
        FILTERS.add(TwigElement.Factory.create("abs", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("capitalize", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("convert_encoding", documentationFactory, Arrays.asList(new TwigElement.Parameter("'to'"), new TwigElement.Parameter("'from'"))));
        FILTERS.add(TwigElement.Factory.create("date", documentationFactory, Arrays.asList(new TwigElement.Parameter("'format'"))));
        FILTERS.add(TwigElement.Factory.create("date_modify", documentationFactory, Arrays.asList(new TwigElement.Parameter("'modifier'"))));
        FILTERS.add(TwigElement.Factory.create("default", documentationFactory, Arrays.asList(new TwigElement.Parameter("'value'"))));
        FILTERS.add(TwigElement.Factory.create("escape", documentationFactory, Arrays.asList(new TwigElement.Parameter("'html'"))));
        FILTERS.add(TwigElement.Factory.create("format", documentationFactory, Arrays.asList(new TwigElement.Parameter("var"))));
        FILTERS.add(TwigElement.Factory.create("join", documentationFactory, Arrays.asList(new TwigElement.Parameter("'separator'"))));
        FILTERS.add(TwigElement.Factory.create("json_encode", documentationFactory, Collections.emptyList()));
        FILTERS.add(TwigElement.Factory.create("keys", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("length", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("lower", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("merge", documentationFactory, Arrays.asList(new TwigElement.Parameter("array"))));
        FILTERS.add(TwigElement.Factory.create("nl2br", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("number_format", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("raw", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("replace", documentationFactory, Collections.emptyList()));
        FILTERS.add(TwigElement.Factory.create("reverse", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("slice", documentationFactory, Arrays.asList(new TwigElement.Parameter("start"), new TwigElement.Parameter("length"))));
        FILTERS.add(TwigElement.Factory.create("sort", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("striptags", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("title", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("trim", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("upper", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("url_encode", documentationFactory, Collections.emptyList()));
        FILTERS.add(TwigElement.Factory.create("trans", documentationFactory));
        FILTERS.add(TwigElement.Factory.create("truncate", documentationFactory, Arrays.asList(new TwigElement.Parameter("int"))));
        FILTERS.add(TwigElement.Factory.create("wordwrap", documentationFactory, Arrays.asList(new TwigElement.Parameter("width"), new TwigElement.Parameter("'break'"), new TwigElement.Parameter("cut"))));
        FUNCTIONS = new HashSet<TwigElement>();
        documentationFactory = TwigDocumentationFactory.FunctionDocumentationFactory.getInstance();
        FUNCTIONS.add(TwigElement.Factory.create("attribute", documentationFactory, Arrays.asList(new TwigElement.Parameter("object"), new TwigElement.Parameter("method"), new TwigElement.Parameter("arguments", TwigElement.Parameter.Need.OPTIONAL))));
        FUNCTIONS.add(TwigElement.Factory.create("block", documentationFactory, Arrays.asList(new TwigElement.Parameter("'name'"))));
        FUNCTIONS.add(TwigElement.Factory.create("constant", documentationFactory, Arrays.asList(new TwigElement.Parameter("'name'"))));
        FUNCTIONS.add(TwigElement.Factory.create("cycle", documentationFactory, Arrays.asList(new TwigElement.Parameter("array"), new TwigElement.Parameter("i"))));
        FUNCTIONS.add(TwigElement.Factory.create("date", documentationFactory, Arrays.asList(new TwigElement.Parameter("'date'"), new TwigElement.Parameter("'timezone'", TwigElement.Parameter.Need.OPTIONAL))));
        FUNCTIONS.add(TwigElement.Factory.create("dump", documentationFactory, Arrays.asList(new TwigElement.Parameter("variable", TwigElement.Parameter.Need.OPTIONAL))));
        FUNCTIONS.add(TwigElement.Factory.create("parent", documentationFactory, Collections.emptyList()));
        FUNCTIONS.add(TwigElement.Factory.create("random", documentationFactory, Arrays.asList(new TwigElement.Parameter("'value'"))));
        FUNCTIONS.add(TwigElement.Factory.create("range", documentationFactory, Arrays.asList(new TwigElement.Parameter("start"), new TwigElement.Parameter("end"), new TwigElement.Parameter("step", TwigElement.Parameter.Need.OPTIONAL))));
        TESTS = new HashSet<TwigElement>();
        documentationFactory = TwigDocumentationFactory.TestDocumentationFactory.getInstance();
        TESTS.add(TwigElement.Factory.create("constant", documentationFactory, Arrays.asList(new TwigElement.Parameter("'const'"))));
        TESTS.add(TwigElement.Factory.create("defined", documentationFactory));
        TESTS.add(TwigElement.Factory.create("divisibleby", documentationFactory, Arrays.asList(new TwigElement.Parameter("number"))));
        TESTS.add(TwigElement.Factory.create("empty", documentationFactory));
        TESTS.add(TwigElement.Factory.create("even", documentationFactory));
        TESTS.add(TwigElement.Factory.create("iterable", documentationFactory));
        TESTS.add(TwigElement.Factory.create("null", documentationFactory));
        TESTS.add(TwigElement.Factory.create("odd", documentationFactory));
        TESTS.add(TwigElement.Factory.create("sameas", documentationFactory, Arrays.asList(new TwigElement.Parameter("variable"))));
        OPERATORS = new HashSet<TwigElement>();
        documentationFactory = TwigDocumentationFactory.OperatorDocumentationFactory.getInstance();
        OPERATORS.add(TwigElement.Factory.create("in", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("as", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("is", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("and", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("or", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("not", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("b-and", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("b-or", documentationFactory));
        OPERATORS.add(TwigElement.Factory.create("b-xor", documentationFactory));
    }

    private static final class PrefixResolver {
        private final ParserResult info;
        private final int offset;
        private final boolean upToOffset;
        private String result = "";

        static PrefixResolver create(ParserResult info, int offset, boolean upToOffset) {
            return new PrefixResolver(info, offset, upToOffset);
        }

        private PrefixResolver(ParserResult info, int offset, boolean upToOffset) {
            this.info = info;
            this.offset = offset;
            this.upToOffset = upToOffset;
        }

        String resolve() {
            TokenHierarchy th = this.info.getSnapshot().getTokenHierarchy();
            if (th != null) {
                this.processHierarchy(th);
            }
            return this.result;
        }

        private void processHierarchy(TokenHierarchy<?> th) {
            TokenSequence tts = th.tokenSequence(TwigTopTokenId.language());
            if (tts != null) {
                this.processTopSequence((TokenSequence<TwigTopTokenId>)tts);
            }
        }

        private void processTopSequence(TokenSequence<TwigTopTokenId> tts) {
            tts.move(this.offset);
            if (tts.moveNext() || tts.movePrevious()) {
                TokenSequence ts = tts.embedded(TwigBlockTokenId.language());
                if (ts == null) {
                    ts = tts.embedded(TwigVariableTokenId.language());
                }
                this.processSequence((TokenSequence<? extends TokenId>)ts);
            }
        }

        private void processSequence(TokenSequence<? extends TokenId> ts) {
            if (ts != null) {
                this.processValidSequence(ts);
            }
        }

        private void processValidSequence(TokenSequence<? extends TokenId> ts) {
            ts.move(this.offset);
            if (ts.moveNext() || ts.movePrevious()) {
                this.processToken(ts);
            }
        }

        private void processToken(TokenSequence<? extends TokenId> ts) {
            Token token;
            if (ts.offset() == this.offset) {
                ts.movePrevious();
            }
            if ((token = ts.token()) != null) {
                this.processSelectedToken(ts);
            }
        }

        private void processSelectedToken(TokenSequence<? extends TokenId> ts) {
            TokenId id = ts.token().id();
            if (PrefixResolver.isValidTokenId(id)) {
                this.createResult(ts);
            }
        }

        private void createResult(TokenSequence<? extends TokenId> ts) {
            if (this.upToOffset) {
                String text = ts.token().text().toString();
                this.result = text.substring(0, this.offset - ts.offset());
            }
        }

        private static boolean isValidTokenId(TokenId id) {
            return TwigBlockTokenId.T_TWIG_TAG.equals(id) || TwigBlockTokenId.T_TWIG_NAME.equals(id) || TwigVariableTokenId.T_TWIG_NAME.equals(id);
        }
    }
}

