/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import org.netbeans.modules.netserver.websocket.Utils;
import org.netbeans.modules.netserver.websocket.WebSocketClientImpl;
import org.netbeans.modules.netserver.websocket.WebSocketHandlerClient75;

class WebSocketHandlerClient76
extends WebSocketHandlerClient75 {
    private long MAX = 0xFFFFFFFFL;
    private Random myRandom = new Random(this.hashCode());
    private String myKey1;
    private String myKey2;
    private byte[] myContent;

    WebSocketHandlerClient76(WebSocketClientImpl webSocketClient) {
        super(webSocketClient);
    }

    @Override
    public void sendHandshake() {
        StringBuilder builder = new StringBuilder("GET");
        builder.append(' ');
        builder.append(((WebSocketClientImpl)this.getWebSocketPoint()).getUri().getPath());
        builder.append(' ');
        builder.append("HTTP/1.1");
        builder.append("\r\n");
        builder.append("Host");
        builder.append(": ");
        builder.append(((WebSocketClientImpl)this.getWebSocketPoint()).getUri().getHost());
        builder.append("\r\n");
        builder.append("Connection: Upgrade");
        builder.append("\r\n");
        builder.append("Upgrade: WebSocket");
        builder.append("\r\n");
        builder.append("Origin: ");
        builder.append(Utils.getOrigin(((WebSocketClientImpl)this.getWebSocketPoint()).getUri()));
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Key1");
        builder.append(": ");
        builder.append(this.getKey1());
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Key2");
        builder.append(": ");
        builder.append(this.getKey2());
        builder.append("\r\n");
        builder.append("WebSocket-Protocol");
        builder.append(": chat");
        builder.append("\r\n");
        builder.append("\r\n");
        byte[] bytes = builder.toString().getBytes(Charset.forName("UTF-8"));
        byte[] generated = this.getContent();
        byte[] toSend = new byte[bytes.length + generated.length];
        System.arraycopy(bytes, 0, toSend, 0, bytes.length);
        System.arraycopy(generated, 0, toSend, bytes.length, generated.length);
        ((WebSocketClientImpl)this.getWebSocketPoint()).send(toSend, this.getKey());
    }

    @Override
    protected void readHandshakeResponse(ByteBuffer buffer) throws IOException {
        byte[] md5Challenge = new byte[16];
        Utils.readHttpRequest(((WebSocketClientImpl)this.getWebSocketPoint()).getChannel(), buffer, md5Challenge);
        boolean md5red = false;
        for (byte b : md5Challenge) {
            if (b == 0) continue;
            md5red = true;
            break;
        }
        if (!md5red) {
            md5Challenge = this.readRequestContent(16);
        }
        if (md5Challenge == null) {
            throw new IOException("Invalid handshake. Cannot read handshake content.");
        }
        byte[] challenge = Utils.produceChallenge76(this.getKey1(), this.getKey2(), this.getContent());
        if (!Arrays.equals(md5Challenge, challenge)) {
            throw new IOException("Invalid handshake. Expected challenge :" + Arrays.toString(challenge) + " differs from recieved : " + Arrays.toString(md5Challenge));
        }
    }

    private Random getRandom() {
        return this.myRandom;
    }

    private String getKey1() {
        if (this.myKey1 == null) {
            this.myKey1 = this.generateKey();
        }
        return this.myKey1;
    }

    private String getKey2() {
        if (this.myKey2 == null) {
            this.myKey2 = this.generateKey();
        }
        return this.myKey2;
    }

    private String generateKey() {
        int index;
        int i;
        int spaces = this.getRandom().nextInt(12) + 1;
        int max = (int)(this.MAX / (long)spaces);
        if ((max = Math.abs(max)) == Integer.MIN_VALUE) {
            max = Integer.MAX_VALUE;
        }
        int num = this.getRandom().nextInt(max) + 1;
        long prod = num * spaces;
        StringBuilder key = new StringBuilder();
        key.append(prod);
        int randomCount = this.getRandom().nextInt(12) + 1;
        for (i = 0; i < randomCount; ++i) {
            index = this.getRandom().nextInt(key.length());
            key.insert(index, this.getNoNumberChar());
        }
        for (i = 0; i < spaces; ++i) {
            index = this.getRandom().nextInt(key.length() - 1) + 1;
            key.insert(index, ' ');
        }
        return key.toString();
    }

    private char getNoNumberChar() {
        char ch = (char)(this.getRandom().nextInt(94) + 33);
        if (ch > '/' && ch < ':') {
            return this.getNoNumberChar();
        }
        return ch;
    }

    private byte[] getContent() {
        if (this.myContent == null) {
            this.myContent = new byte[8];
            this.getRandom().nextBytes(this.myContent);
        }
        return this.myContent;
    }
}

