/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JavaEvaluator;
import org.netbeans.modules.debugger.jpda.expr.CompilationInfoHolder;
import org.netbeans.spi.debugger.jpda.Evaluator;

public final class EvaluatorExpression
implements CompilationInfoHolder {
    private final String expression;
    private final Map<Evaluator, AssociatedExpression<?>> associatedExpressions = new HashMap();
    private Object parsedData;

    public EvaluatorExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public Evaluator.Result evaluate(Evaluator<?> e, Evaluator.Context context) throws InvalidExpressionException {
        AssociatedExpression<?> ae = this.associatedExpressions.get(e);
        if (ae == null) {
            ae = new AssociatedExpression(e, this.expression);
            this.associatedExpressions.put(e, ae);
        }
        if (e instanceof JavaEvaluator) {
            return ((JavaEvaluator)e).evaluate(ae.expr, context, this);
        }
        return ae.evaluate(context);
    }

    @Override
    public Object getParsedData() {
        return this.parsedData;
    }

    @Override
    public void setParsedData(Object parsedData) {
        this.parsedData = parsedData;
    }

    private static class AssociatedExpression<PI> {
        private final Evaluator<PI> e;
        private final Evaluator.Expression<PI> expr;

        AssociatedExpression(Evaluator<PI> e, String expression) {
            this.e = e;
            this.expr = new Evaluator.Expression(expression);
        }

        public Evaluator.Result evaluate(Evaluator.Context context) throws InvalidExpressionException {
            return this.e.evaluate(this.expr, context);
        }
    }
}

