/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeProvider;
import org.netbeans.modules.maven.newproject.ChooseWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ChooseArchetypePanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(ChooseArchetypePanel.class.getName(), 5);
    private static final Logger LOG = Logger.getLogger(ChooseArchetypePanel.class.getName());
    private ChooseWizardPanel wizardPanel;
    private final List<Archetype> archetypes = new ArrayList<Archetype>();
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelArchetypes;
    private JLabel labelArtifactId;
    private JLabel labelDesc;
    private JLabel labelFilter;
    private JLabel labelGroupId;
    private JLabel labelRepository;
    private JLabel labelVersion;
    private JList listArtifact;
    private JCheckBox showOld;
    private JTextArea taDescription;
    private JTextField textArtifactId;
    private JTextField textFilter;
    private JTextField textGroupId;
    private JTextField textRepository;
    private JTextField textVersion;

    public ChooseArchetypePanel(ChooseWizardPanel wizPanel) {
        this.initComponents();
        this.wizardPanel = wizPanel;
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChooseArchetypePanel.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChooseArchetypePanel.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChooseArchetypePanel.this.wizardPanel.fireChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChooseArchetypePanel.this.wizardPanel.fireChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ChooseArchetypePanel.this.wizardPanel.fireChangeEvent();
            }
        };
        this.textArtifactId.getDocument().addDocumentListener(dl);
        this.textGroupId.getDocument().addDocumentListener(dl);
        this.textVersion.getDocument().addDocumentListener(dl);
        this.textRepository.getDocument().addDocumentListener(dl);
        this.listArtifact.setCellRenderer(new ArchetypeRenderer());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.archetypes.isEmpty()) {
            this.listArtifact.setCursor(Utilities.createProgressCursor((Component)this.listArtifact));
            RP.post(new Runnable(){

                @Override
                public void run() {
                    for (ArchetypeProvider provider : Lookup.getDefault().lookupAll(ArchetypeProvider.class)) {
                        final List<Archetype> added = provider.getArchetypes();
                        LOG.log(Level.FINE, "{0} -> {1}", new Object[]{provider, added});
                        added.sort(new Comparator<Archetype>(){

                            @Override
                            public int compare(Archetype o1, Archetype o2) {
                                int c = o1.getArtifactId().compareTo(o2.getArtifactId());
                                if (c != 0) {
                                    return c;
                                }
                                String v1 = o1.getVersion();
                                String v2 = o2.getVersion();
                                if (v1 == null && v2 == null) {
                                    return 0;
                                }
                                if (v1 == null) {
                                    return 1;
                                }
                                if (v2 == null) {
                                    return -1;
                                }
                                return new DefaultArtifactVersion(v1).compareTo((ArtifactVersion)new DefaultArtifactVersion(v2)) * -1;
                            }
                        });
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ChooseArchetypePanel.this.archetypes.addAll(added);
                                ChooseArchetypePanel.this.updateList();
                            }
                        });
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChooseArchetypePanel.this.listArtifact.setCursor(null);
                            if (ChooseArchetypePanel.this.listArtifact.getSelectedIndex() == -1 && ChooseArchetypePanel.this.listArtifact.getModel().getSize() > 0) {
                                ChooseArchetypePanel.this.listArtifact.setSelectedIndex(0);
                            }
                        }
                    });
                }
            });
        }
    }

    private void updateList() {
        HashSet<CallSite> ids = new HashSet<CallSite>();
        String filter = this.textFilter.getText();
        ArrayList<Archetype> filtered = new ArrayList<Archetype>();
        for (Archetype a : this.archetypes) {
            if (!this.showOld.isSelected() && !ids.add((CallSite)((Object)(a.getGroupId() + ":" + a.getArtifactId()))) || !filter.isEmpty() && !this.matches(a.getGroupId(), filter) && !this.matches(a.getArtifactId(), filter) && !this.matches(a.getVersion(), filter) && (a.getRepository() == null || !this.matches(a.getRepository(), filter)) && !this.matches(a.getName(), filter) && (a.getDescription() == null || !this.matches(a.getDescription(), filter))) continue;
            filtered.add(a);
        }
        filtered.sort(new Comparator<Archetype>(){

            @Override
            public int compare(Archetype o1, Archetype o2) {
                return o1.getArtifactId().compareTo(o2.getArtifactId());
            }
        });
        DefaultListModel<Archetype> model = new DefaultListModel<Archetype>();
        for (Archetype a : filtered) {
            model.addElement(a);
        }
        this.listArtifact.setModel(model);
    }

    private boolean matches(String field, String filter) {
        return field.toLowerCase(Locale.ENGLISH).contains(filter.toLowerCase(Locale.ENGLISH));
    }

    private void initComponents() {
        this.labelFilter = new JLabel();
        this.textFilter = new JTextField();
        this.showOld = new JCheckBox();
        this.labelArchetypes = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.listArtifact = new JList();
        this.labelGroupId = new JLabel();
        this.textGroupId = new JTextField();
        this.labelArtifactId = new JLabel();
        this.textArtifactId = new JTextField();
        this.labelVersion = new JLabel();
        this.textVersion = new JTextField();
        this.labelRepository = new JLabel();
        this.textRepository = new JTextField();
        this.labelDesc = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.labelFilter.setLabelFor(this.textFilter);
        Mnemonics.setLocalizedText((JLabel)this.labelFilter, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.labelFilter.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.showOld, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.showOld.text"));
        this.showOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseArchetypePanel.this.showOldActionPerformed(evt);
            }
        });
        this.labelArchetypes.setLabelFor(this.listArtifact);
        Mnemonics.setLocalizedText((JLabel)this.labelArchetypes, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.labelArchetypes.text"));
        this.listArtifact.setSelectionMode(0);
        this.listArtifact.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ChooseArchetypePanel.this.listArtifactValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listArtifact);
        this.labelGroupId.setLabelFor(this.textGroupId);
        Mnemonics.setLocalizedText((JLabel)this.labelGroupId, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.labelGroupId.text"));
        this.labelArtifactId.setLabelFor(this.textArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.labelArtifactId, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.labelArtifactId.text"));
        this.labelVersion.setLabelFor(this.textVersion);
        Mnemonics.setLocalizedText((JLabel)this.labelVersion, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.labelVersion.text"));
        this.labelRepository.setLabelFor(this.textRepository);
        Mnemonics.setLocalizedText((JLabel)this.labelRepository, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.labelRepository.text"));
        this.labelDesc.setLabelFor(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.labelDesc, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"LBL_Description"));
        this.taDescription.setEditable(false);
        this.taDescription.setBackground((Color)(UIManager.get("TextArea.background") != null ? UIManager.get("TextArea.background") : new Color(238, 238, 238)));
        this.taDescription.setColumns(20);
        this.taDescription.setLineWrap(true);
        this.taDescription.setRows(5);
        this.taDescription.setText(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ChooseArchetypePanel.taDescription.text"));
        this.taDescription.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taDescription);
        this.taDescription.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ArchetypesPanel.taDescription.accessibledesc"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.labelFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showOld)).addComponent(this.jScrollPane2, -1, 636, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelGroupId).addComponent(this.labelVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textGroupId).addComponent(this.textVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelArtifactId).addComponent(this.labelRepository)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textArtifactId).addComponent(this.textRepository)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelArchetypes).addComponent(this.labelDesc)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFilter).addComponent(this.textFilter, -2, -1, -2).addComponent(this.showOld)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelArchetypes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 178, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelGroupId).addComponent(this.textGroupId, -2, -1, -2).addComponent(this.labelArtifactId).addComponent(this.textArtifactId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelVersion).addComponent(this.labelRepository).addComponent(this.textVersion, -2, -1, -2).addComponent(this.textRepository, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDesc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 117, -2)));
    }

    private void listArtifactValueChanged(ListSelectionEvent evt) {
        Archetype a = (Archetype)this.listArtifact.getSelectedValue();
        if (a != null) {
            this.textGroupId.setText(a.getGroupId());
            this.textArtifactId.setText(a.getArtifactId());
            this.textVersion.setText(a.getVersion());
            this.textRepository.setText(a.getRepository());
            String d = a.getDescription();
            if (d != null) {
                this.taDescription.setText(d.replaceAll("\\s+", " ").replaceAll("^ | $", ""));
            } else {
                this.taDescription.setText(null);
            }
        } else {
            this.textGroupId.setText(null);
            this.textArtifactId.setText(null);
            this.textVersion.setText(null);
            this.textRepository.setText(null);
            this.taDescription.setText(null);
        }
        this.wizardPanel.fireChangeEvent();
    }

    private void showOldActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void store(WizardDescriptor d) {
        if (!this.textGroupId.getText().isEmpty()) {
            Archetype a = new Archetype();
            a.setGroupId(this.textGroupId.getText());
            a.setArtifactId(this.textArtifactId.getText());
            a.setVersion(this.textVersion.getText());
            String r = this.textRepository.getText();
            if (!r.isEmpty()) {
                a.setRepository(r);
            }
            d.putProperty("archetype", (Object)a);
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return !this.textGroupId.getText().isEmpty() && !this.textArtifactId.getText().isEmpty() && !this.textVersion.getText().isEmpty();
    }

    private class ArchetypeRenderer
    extends DefaultListCellRenderer {
        private ArchetypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Archetype) {
                Archetype a = (Archetype)value;
                Object n = a.getName();
                if (ChooseArchetypePanel.this.showOld.isSelected()) {
                    n = (String)n + " (" + a.getVersion() + ")";
                }
                value = n;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

