/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ConfigurationPersistenceUtils {
    public static final String NAMESPACE = "http://www.netbeans.org/ns/maven-config-data/1";
    public static final String ROOT = "config-data";
    public static final String ENABLED = "enabled";
    public static final String ACTIVATED = "activated";
    public static final String CONFIGURATIONS = "configurations";
    public static final String CONFIG = "configuration";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME_ATTR = "name";
    public static final String CONFIG_PROFILES_ATTR = "profiles";
    public static final String CONFIG_ID_ATTR = "id";

    private ConfigurationPersistenceUtils() {
    }

    public static String readActiveConfigurationName(AuxiliaryConfiguration config) throws DOMException {
        NodeList list;
        String active = null;
        Element el = config.getConfigurationFragment(ROOT, NAMESPACE, false);
        if (el != null && (list = el.getElementsByTagNameNS(NAMESPACE, ACTIVATED)).getLength() > 0) {
            Element enEl = (Element)list.item(0);
            active = enEl.getTextContent();
        }
        return active;
    }

    public static SortedSet<M2Configuration> readConfigurations(AuxiliaryConfiguration aux, FileObject projectDirectory, boolean shared) {
        NodeList list;
        Element el = aux.getConfigurationFragment(ROOT, NAMESPACE, shared);
        if (el != null && (list = el.getElementsByTagNameNS(NAMESPACE, CONFIG)).getLength() > 0) {
            TreeSet<M2Configuration> toRet = new TreeSet<M2Configuration>();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Element enEl = (Element)list.item(i);
                M2Configuration c = new M2Configuration(enEl.getAttribute(CONFIG_ID_ATTR), projectDirectory);
                String profs = enEl.getAttribute(CONFIG_PROFILES_ATTR);
                if (profs != null) {
                    String[] s = profs.split(" ");
                    ArrayList<String> prf = new ArrayList<String>();
                    for (String s2 : s) {
                        if (s2.trim().length() <= 0) continue;
                        prf.add(s2.trim());
                    }
                    c.setActivatedProfiles(prf);
                }
                NodeList ps = enEl.getElementsByTagName(PROPERTY);
                for (int y = 0; y < ps.getLength(); ++y) {
                    Element propEl = (Element)ps.item(y);
                    String key = propEl.getAttribute(PROPERTY_NAME_ATTR);
                    String value = propEl.getTextContent();
                    if (key == null || value == null) continue;
                    c.getProperties().put(key, value);
                }
                toRet.add(c);
            }
            return toRet;
        }
        return new TreeSet<M2Configuration>();
    }
}

