/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeListener;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.SteppingGranularity;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.io.InputOutput;
import org.netbeans.modules.lsp.client.debugger.DAPConfigurationAccessor;
import org.netbeans.modules.lsp.client.debugger.DAPDebuggerEngineProvider;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;
import org.netbeans.modules.lsp.client.debugger.DAPStackTraceAnnotationHolder;
import org.netbeans.modules.lsp.client.debugger.DAPThread;
import org.netbeans.modules.lsp.client.debugger.DAPVariable;
import org.netbeans.modules.lsp.client.debugger.LineBreakpointData;
import org.netbeans.modules.lsp.client.debugger.SPIAccessor;
import org.netbeans.modules.lsp.client.debugger.api.DAPConfiguration;
import org.netbeans.modules.lsp.client.debugger.spi.BreakpointConvertor;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.text.Line;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class DAPDebugger
implements IDebugProtocolClient {
    public static final String ENGINE_TYPE_ID = "DAPDebuggerEngine";
    public static final String SESSION_TYPE_ID = "DAPDebuggerSession";
    public static final String DEBUGGER_INFO_TYPE_ID = "DAPDebuggerInfo";
    private static final Logger LOG = Logger.getLogger(DAPDebugger.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor(DAPDebugger.class.getName(), 1, false, false);
    private final DAPDebuggerEngineProvider engineProvider;
    private final Session session;
    private final ContextProvider contextProvider;
    private final DebuggerManagerListener updateBreakpointsListener;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final CompletableFuture<Void> initialized = new CompletableFuture();
    private final CompletableFuture<Void> terminated = new CompletableFuture();
    private final AtomicBoolean suspended = new AtomicBoolean();
    private final Map<Integer, DAPThread> id2Thread = new HashMap<Integer, DAPThread>();
    private final AtomicReference<Runnable> runAfterConfigureDone = new AtomicReference();
    private URIPathConvertor fileConvertor;
    private InputStream in;
    private Future<Void> launched;
    private IDebugProtocolServer server;
    private int currentThreadId = -1;
    private InputOutput console;
    private InputOutput debugeeIO;
    private static final URIPathConvertor DEFAULT_CONVERTOR = new URIPathConvertor(){

        @Override
        public String toPath(URI uri) {
            if ("file".equals(uri.getScheme())) {
                return uri.getPath();
            }
            return null;
        }

        @Override
        public URI toURI(String path) {
            return Utilities.toURI((File)new File(path));
        }
    };

    public DAPDebugger(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.engineProvider = (DAPDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.updateBreakpointsListener = new DebuggerManagerAdapter(){

            public void breakpointAdded(Breakpoint breakpoint) {
                this.updateAfterBreakpointChange(breakpoint);
            }

            public void breakpointRemoved(Breakpoint breakpoint) {
                this.updateAfterBreakpointChange(breakpoint);
            }

            private void updateAfterBreakpointChange(Breakpoint breakpoint) {
                Set modifiedURLs = DAPDebugger.this.convertBreakpoints(breakpoint).stream().map(b -> b.uri()).collect(Collectors.toSet());
                try {
                    DAPDebugger.this.setBreakpoints(d -> modifiedURLs.contains(d.uri()));
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", this.updateBreakpointsListener);
    }

    public CompletableFuture<Void> connect(DAPConfiguration config, Type type) throws Exception {
        CompletableFuture connection;
        this.fileConvertor = DEFAULT_CONVERTOR;
        this.in = DAPConfigurationAccessor.getInstance().getIn(config);
        Launcher serverLauncher = DSPLauncher.createClientLauncher((IDebugProtocolClient)this, (InputStream)this.in, (OutputStream)DAPConfigurationAccessor.getInstance().getOut(config));
        this.launched = serverLauncher.startListening();
        this.server = (IDebugProtocolServer)serverLauncher.getRemoteProxy();
        InitializeRequestArguments initialize = new InitializeRequestArguments();
        initialize.setAdapterID("dap");
        initialize.setLinesStartAt1(Boolean.valueOf(true));
        initialize.setColumnsStartAt1(Boolean.valueOf(true));
        Capabilities cap = (Capabilities)this.server.initialize(initialize).get();
        if (!DAPConfigurationAccessor.getInstance().getDelayLaunch(config)) {
            connection = switch (type) {
                case Type.ATTACH -> this.server.attach(DAPConfigurationAccessor.getInstance().getConfiguration(config));
                case Type.LAUNCH -> this.server.launch(DAPConfigurationAccessor.getInstance().getConfiguration(config));
                default -> throw new UnsupportedOperationException("Unknown type: " + type);
            };
        } else {
            connection = new CompletableFuture();
            this.runAfterConfigureDone.set(() -> (switch (type) {
                case Type.ATTACH -> this.server.attach(DAPConfigurationAccessor.getInstance().getConfiguration(config));
                case Type.LAUNCH -> this.server.launch(DAPConfigurationAccessor.getInstance().getConfiguration(config));
                default -> throw new UnsupportedOperationException("Unknown type: " + type);
            }).handle((r, ex) -> {
                if (ex != null) {
                    connection.completeExceptionally((Throwable)ex);
                } else {
                    connection.complete(r);
                }
                return null;
            }));
        }
        return CompletableFuture.allOf(connection, this.initialized);
    }

    public void initialized() {
        WORKER.post(() -> {
            try {
                this.setBreakpoints(d -> true);
                this.server.configurationDone(new ConfigurationDoneArguments()).get();
                this.initialized.complete(null);
                Runnable r = this.runAfterConfigureDone.get();
                if (r != null) {
                    r.run();
                    this.runAfterConfigureDone.set(null);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.log(Level.FINE, null, ex);
                this.initialized.completeExceptionally(ex);
            }
        });
    }

    private void setBreakpoints(Predicate<LineBreakpointData> filter) throws InterruptedException, ExecutionException {
        HashMap<String, List> url2Breakpoints = new HashMap<String, List>();
        for (LineBreakpointData lineBreakpointData : this.convertBreakpoints(DebuggerManager.getDebuggerManager().getBreakpoints())) {
            if (lineBreakpointData == null || !filter.test(lineBreakpointData)) continue;
            SourceBreakpoint lb = new SourceBreakpoint();
            lb.setLine(lineBreakpointData.lineNumber());
            lb.setCondition(lineBreakpointData.condition());
            String path = this.fileConvertor.toPath(lineBreakpointData.uri());
            if (path == null) continue;
            url2Breakpoints.computeIfAbsent(path, x -> new ArrayList()).add(lb);
        }
        for (Map.Entry entry : url2Breakpoints.entrySet()) {
            Source src = new Source();
            src.setPath((String)entry.getKey());
            SetBreakpointsArguments breakpoints = new SetBreakpointsArguments();
            breakpoints.setSource(src);
            breakpoints.setBreakpoints((SourceBreakpoint[])((List)entry.getValue()).toArray(SourceBreakpoint[]::new));
            this.server.setBreakpoints(breakpoints).get();
        }
    }

    private List<LineBreakpointData> convertBreakpoints(Breakpoint ... breakpoints) {
        ArrayList<LineBreakpointData> lineBreakpoints = new ArrayList<LineBreakpointData>();
        BreakpointConvertor.ConvertedBreakpointConsumer consumer = SPIAccessor.getInstance().createConvertedBreakpointConsumer(lineBreakpoints);
        for (BreakpointConvertor convertor : Lookup.getDefault().lookupAll(BreakpointConvertor.class)) {
            for (Breakpoint b : breakpoints) {
                convertor.convert(b, consumer);
            }
        }
        return lineBreakpoints;
    }

    public void continued(ContinuedEventArguments args) {
        this.continued();
    }

    private void continued() {
        this.suspended.set(false);
        DAPThread prevThread = this.getCurrentThread();
        if (prevThread != null) {
            prevThread.setStack(new DAPFrame[0]);
            prevThread.setStatus(DAPThread.Status.RUNNING);
        }
        this.currentThreadId = -1;
        this.cs.fireChange();
        DAPStackTraceAnnotationHolder.unmarkCurrent();
    }

    public void stopped(StoppedEventArguments args) {
        this.currentThreadId = args.getThreadId();
        this.suspended.set(true);
        DAPThread currentThread = this.getCurrentThread();
        currentThread.setStatus(DAPThread.Status.SUSPENDED);
        DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
        this.cs.fireChange();
        StackTraceArguments sta = new StackTraceArguments();
        sta.setThreadId(args.getThreadId().intValue());
        this.server.stackTrace(sta).thenAccept(resp -> {
            DAPFrame[] frames = (DAPFrame[])Arrays.stream(resp.getStackFrames()).map(frame -> new DAPFrame(this.fileConvertor, currentThread, (StackFrame)frame)).toArray(DAPFrame[]::new);
            currentThread.setStack(frames);
        });
    }

    public void terminated(TerminatedEventArguments args) {
        this.initialized.complete(null);
        this.terminated.complete(null);
        WORKER.post(() -> {
            this.cs.fireChange();
            this.engineProvider.getDestructor().killEngine();
            DAPStackTraceAnnotationHolder.unmarkCurrent();
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", this.updateBreakpointsListener);
            this.launched.cancel(true);
            try {
                this.in.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    public CompletableFuture<Void> getTerminated() {
        return this.terminated;
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public void resume() {
        ContinueArguments args = new ContinueArguments();
        args.setThreadId(this.currentThreadId);
        args.setSingleThread(Boolean.FALSE);
        this.continued();
        this.server.continue_(args);
    }

    public void stepInto() {
        StepInArguments args = new StepInArguments();
        args.setSingleThread(Boolean.valueOf(true));
        args.setThreadId(this.currentThreadId);
        args.setGranularity(SteppingGranularity.LINE);
        this.continued();
        this.server.stepIn(args);
    }

    public void stepOver() {
        NextArguments args = new NextArguments();
        args.setSingleThread(Boolean.valueOf(true));
        args.setThreadId(this.currentThreadId);
        args.setGranularity(SteppingGranularity.LINE);
        this.continued();
        this.server.next(args);
    }

    public void stepOut() {
        StepOutArguments args = new StepOutArguments();
        args.setSingleThread(Boolean.valueOf(true));
        args.setThreadId(this.currentThreadId);
        this.continued();
        this.server.stepOut(args);
    }

    public void pause() {
        this.server.threads().thenAccept(response -> {
            for (Thread t : response.getThreads()) {
                PauseArguments args = new PauseArguments();
                args.setThreadId(t.getId());
                this.server.pause(args);
            }
        });
    }

    public CompletableFuture<DAPVariable> evaluate(DAPFrame frame, String expression) {
        EvaluateArguments args = new EvaluateArguments();
        args.setExpression(expression);
        if (frame != null) {
            args.setFrameId(Integer.valueOf(frame.getId()));
        }
        return this.server.evaluate(args).thenApply(evaluated -> new DAPVariable(this, frame, null, evaluated.getVariablesReference(), expression, evaluated.getType(), evaluated.getResult(), Integer.MAX_VALUE));
    }

    public void finish() {
        DisconnectArguments args = new DisconnectArguments();
        this.server.disconnect(args).handle((result, exc) -> {
            if (!this.terminated.isDone()) {
                this.terminated(null);
            }
            return null;
        });
    }

    public DAPFrame getCurrentFrame() {
        DAPThread currentThread = this.getCurrentThread();
        if (currentThread == null) {
            return null;
        }
        return currentThread.getCurrentFrame();
    }

    public Line getCurrentLine() {
        DAPThread currentThread = this.getCurrentThread();
        if (currentThread == null) {
            return null;
        }
        return currentThread.getCurrentLine();
    }

    public CompletableFuture<List<DAPVariable>> getFrameVariables(DAPFrame frame) {
        ScopesArguments args = new ScopesArguments();
        args.setFrameId(frame.getId());
        return this.server.scopes(args).thenApply(scopesResponse -> Arrays.stream(scopesResponse.getScopes()).map(scope -> new DAPVariable(this, frame, null, scope.getVariablesReference(), scope.getName(), "", "", Integer.MAX_VALUE)).toList());
    }

    public CompletableFuture<List<DAPVariable>> getVariableChildren(DAPFrame frame, DAPVariable parentVariable) {
        VariablesArguments args = new VariablesArguments();
        args.setVariablesReference(parentVariable.getVariableReference());
        return this.server.variables(args).thenApply(variablesResponse -> Arrays.stream(variablesResponse.getVariables()).map(var -> new DAPVariable(this, frame, parentVariable, var.getVariablesReference(), var.getName(), var.getType(), var.getValue(), Integer.MAX_VALUE)).toList());
    }

    public DAPThread getCurrentThread() {
        if (this.currentThreadId == -1) {
            return null;
        }
        return this.getThread(this.currentThreadId);
    }

    public DAPThread[] getThreads() {
        return (DAPThread[])this.id2Thread.values().toArray(DAPThread[]::new);
    }

    public void thread(ThreadEventArguments args) {
        switch (args.getReason()) {
            case "started": {
                this.getThread(args.getThreadId()).setStatus(DAPThread.Status.CREATED);
                break;
            }
            case "exited": {
                this.getThread(args.getThreadId()).setStatus(DAPThread.Status.EXITED);
            }
        }
        this.server.threads().thenAccept(allThreads -> {
            for (Thread t : allThreads.getThreads()) {
                this.getThread(t.getId()).setName(t.getName());
            }
        });
    }

    public void output(OutputEventArguments args) {
        switch (args.getCategory()) {
            case "console": 
            case "important": {
                this.getConsoleIO().getOut().print(args.getOutput());
                break;
            }
            case "stdout": {
                this.getDebugeeIO().getOut().print(args.getOutput());
                break;
            }
            case "stderr": {
                this.getDebugeeIO().getErr().print(args.getOutput());
                break;
            }
        }
    }

    private InputOutput getConsoleIO() {
        if (this.console == null) {
            this.console = InputOutput.get((String)(this.session.getName() + ": Debugger console"), (boolean)false);
        }
        return this.console;
    }

    private InputOutput getDebugeeIO() {
        if (this.debugeeIO == null) {
            this.debugeeIO = InputOutput.get((String)this.session.getName(), (boolean)false);
        }
        return this.debugeeIO;
    }

    private DAPThread getThread(int id) {
        return this.id2Thread.computeIfAbsent(id, _id -> new DAPThread(this, (int)_id));
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public static void startDebugger(final DAPConfiguration config, Type type) throws Exception {
        SessionProvider sessionProvider = new SessionProvider(){

            public String getSessionName() {
                return DAPConfigurationAccessor.getInstance().getSessionName(config);
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return DAPDebugger.SESSION_TYPE_ID;
            }

            public Object[] getServices() {
                return new Object[0];
            }
        };
        ArrayList<Object> allServices = new ArrayList<Object>();
        allServices.add(config);
        allServices.add(sessionProvider);
        DebuggerInfo di = DebuggerInfo.create((String)DEBUGGER_INFO_TYPE_ID, (Object[])allServices.toArray(Object[]::new));
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(di);
        DAPDebugger debugger = (DAPDebugger)es[0].lookupFirst(null, DAPDebugger.class);
        debugger.connect(config, type);
    }

    @JsonRequest
    public CompletableFuture<Object> attachedChildSession(Map<String, Object> args) {
        Map config = (Map)args.get("config");
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        try {
            int port = Integer.parseInt((String)config.get("__jsDebugChildServer"));
            Socket newSocket = new Socket("localhost", port);
            DAPConfiguration.create(newSocket.getInputStream(), newSocket.getOutputStream()).setSessionName((String)config.get("name")).attach();
            result.complete(new HashMap());
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, null, ex);
            result.completeExceptionally(ex);
        }
        return result;
    }

    static interface URIPathConvertor {
        public String toPath(URI var1);

        public URI toURI(String var1);
    }

    public static enum Type {
        LAUNCH,
        ATTACH;

    }
}

