/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.selenium2.java.api.Utils;
import org.netbeans.modules.selenium2.spi.Selenium2SupportImpl;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class Selenium2MavenSupportImpl
extends Selenium2SupportImpl {
    private static final String JUNIT_GROUP_ID = "junit";
    private static final String JUNIT_ARTIFACT_ID = "junit";
    private static final String SELENIUM_GROUP_ID = "org.seleniumhq.selenium";
    private static final String SELENIUM_ARTIFACT_ID = "selenium-java";
    private static final String SELENIUM_REMOTE_DRIVER_ARTIFACT_ID = "selenium-remote-driver";
    private static final String OPERA_GROUP_ID = "com.opera";
    private static final String OPERA_ARTIFACT_ID = "operadriver";

    public boolean isSupportActive(Project p) {
        return this.isMavenProject(p);
    }

    public void configureProject(FileObject targetFolder) {
        final Project p = FileOwnerQuery.getOwner((FileObject)targetFolder);
        if (p == null || this.isProjectReady(p)) {
            return;
        }
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Dependency dep;
                if (!ModelUtils.hasModelDependency((POMModel)model, (String)Selenium2MavenSupportImpl.SELENIUM_GROUP_ID, (String)Selenium2MavenSupportImpl.SELENIUM_ARTIFACT_ID)) {
                    dep = ModelUtils.checkModelDependency((POMModel)model, (String)Selenium2MavenSupportImpl.SELENIUM_GROUP_ID, (String)Selenium2MavenSupportImpl.SELENIUM_ARTIFACT_ID, (boolean)true);
                    dep.setScope("test");
                    dep.setVersion("2.44.0");
                    dep = ModelUtils.checkModelDependency((POMModel)model, (String)Selenium2MavenSupportImpl.OPERA_GROUP_ID, (String)Selenium2MavenSupportImpl.OPERA_ARTIFACT_ID, (boolean)true);
                    dep.setScope("test");
                    dep.setVersion("1.5");
                    Exclusion exclusion = model.getFactory().createExclusion();
                    exclusion.setGroupId(Selenium2MavenSupportImpl.SELENIUM_GROUP_ID);
                    exclusion.setArtifactId(Selenium2MavenSupportImpl.SELENIUM_REMOTE_DRIVER_ARTIFACT_ID);
                    dep.addExclusion(exclusion);
                }
                if (!ModelUtils.hasModelDependency((POMModel)model, (String)"junit", (String)"junit")) {
                    dep = ModelUtils.checkModelDependency((POMModel)model, (String)"junit", (String)"junit", (boolean)true);
                    dep.setScope("test");
                    dep.setVersion("4.11");
                }
            }
        };
        Utilities.performPOMModelOperations((FileObject)this.getPomFile(p), Collections.singletonList(operation));
        RequestProcessor RP = new RequestProcessor("Configure Selenium 2.0 project task", 1, true);
        RP.post(new Runnable(){

            @Override
            public void run() {
                ((NbMavenProject)p.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(true);
            }
        });
    }

    public WizardDescriptor.Panel createTargetChooserPanel(WizardDescriptor wiz) {
        Project project = Templates.getProject((WizardDescriptor)wiz);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
            return Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).create();
        }
        FileObject testDir = this.getTestRoot(project);
        for (SourceGroup selGroup : groups = sources.getSourceGroups("java")) {
            if (!selGroup.getRootFolder().equals(testDir)) continue;
            return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])new SourceGroup[]{selGroup});
        }
        return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups);
    }

    public boolean isSupportEnabled(FileObject[] activatedFOs) {
        return Utils.isSupportEnabled(NbMavenProject.class, (FileObject[])activatedFOs);
    }

    private FileObject getTestRoot(Project project) {
        NbMavenProject nbProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenProject mvp = nbProject.getMavenProject();
        List testRoots = mvp.getTestCompileSourceRoots();
        if (testRoots.isEmpty()) {
            return null;
        }
        File testRoot = new File((String)testRoots.get(0));
        FileObject result = null;
        try {
            result = FileUtil.createFolder((File)testRoot);
        }
        catch (IOException ex) {
            Logger.getLogger(Selenium2MavenSupportImpl.class.getName()).log(Level.SEVERE, "Impossible to create test root file object", ex);
        }
        return result;
    }

    private boolean isProjectReady(Project project) {
        POMModel model = this.getPOMModel(project);
        return ModelUtils.hasModelDependency((POMModel)model, (String)SELENIUM_GROUP_ID, (String)SELENIUM_ARTIFACT_ID);
    }

    private boolean isMavenProject(Project project) {
        return project.getLookup().lookup(NbMavenProject.class) != null;
    }

    private POMModel getPOMModel(Project project) {
        FileObject pom = this.getPomFile(project);
        ModelSource source = Utilities.createModelSource((FileObject)pom);
        return POMModelFactory.getDefault().getModel(source);
    }

    private FileObject getPomFile(Project project) {
        return project.getProjectDirectory().getFileObject("pom.xml");
    }

    public List<Object> getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject refFileObject) {
        return Arrays.asList(Utils.getTestSourceRoots(createdSourceRoots, (FileObject)refFileObject));
    }

    public String[] getSourceAndTestClassNames(FileObject fo, boolean isTestNG, boolean isSelenium) {
        return Utils.getSourceAndTestClassNames((FileObject)fo, (boolean)isTestNG, (boolean)isSelenium);
    }

    public void runTests(FileObject[] activatedFOs, boolean isSelenium) {
        Project project = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
        if (project == null) {
            return;
        }
        FileObject testDir = this.getTestRoot(project);
        RunConfig rc = new Selenium2ActionsProvider().createConfigForDefaultAction("selenium2.test", project, Lookups.singleton((Object)testDir));
        String testParameter = this.getTestParameter(activatedFOs, project, testDir);
        rc.setProperty("test", testParameter);
        ExecutorTask executeMaven = RunUtils.executeMaven((RunConfig)rc);
    }

    private String getTestParameter(FileObject[] activatedFOs, Project project, FileObject testDir) {
        if (activatedFOs.length == 1 && project.getProjectDirectory().equals(activatedFOs[0])) {
            return "**/*IT.java";
        }
        Object testParameter = "";
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup sourceGroup = Selenium2MavenSupportImpl.findGroup(sourceGroups, activatedFOs);
        if (sourceGroup != null) {
            for (FileObject fo : activatedFOs) {
                String relativePath = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fo);
                if (relativePath == null) continue;
                if (!((String)testParameter).isEmpty()) {
                    testParameter = ((String)testParameter).concat(",");
                }
                testParameter = (String)testParameter + relativePath + "/**/*IT.java";
            }
        }
        return testParameter;
    }

    @CheckForNull
    private static SourceGroup findGroup(SourceGroup[] groups, FileObject[] files) {
        SourceGroup selected = null;
        for (FileObject file : files) {
            for (SourceGroup group : groups) {
                FileObject root = group.getRootFolder();
                if (file != root && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                if (selected == null) {
                    selected = group;
                    continue;
                }
                if (selected == group) continue;
                return null;
            }
        }
        return selected;
    }

    public String getTemplateID() {
        return "Templates/SeleniumTests/SeleneseIT.java";
    }

    private class Selenium2ActionsProvider
    extends AbstractMavenActionsProvider {
        private static final String MAPPINGS = "org/netbeans/modules/selenium2/maven/selenium2ActionMappings.xml";

        public boolean isActionEnable(String action, Project project, Lookup lookup) {
            if (action.startsWith("selenium2.")) {
                return true;
            }
            return super.isActionEnable(action, project, lookup);
        }

        protected InputStream getActionDefinitionStream() {
            return Selenium2ActionsProvider.class.getClassLoader().getResourceAsStream(MAPPINGS);
        }
    }
}

